/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.visitors;

import com.amazon.ion.IonString;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazon.ionelement.api.IonElement;
import com.amazon.ionelement.api.IonMeta;
import com.amazon.ionelement.api.IonUtils;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.errors.ErrorCode;
import org.partiql.errors.Property;
import org.partiql.errors.PropertyValueMap;
import org.partiql.lang.ast.StaticTypeMeta;
import org.partiql.lang.ast.passes.SemanticException;
import org.partiql.lang.domains.PartiqlAst;
import org.partiql.lang.domains.UtilKt;
import org.partiql.lang.eval.BindingCase;
import org.partiql.lang.eval.BindingName;
import org.partiql.lang.eval.Bindings;
import org.partiql.lang.eval.BindingsExtensionsKt;
import org.partiql.lang.eval.visitors.StaticTypeVisitorTransform;
import org.partiql.lang.eval.visitors.StaticTypeVisitorTransformConstraints;
import org.partiql.lang.eval.visitors.VisitorTransformBase;
import org.partiql.lang.util.PropertyMapHelpersKt;
import org.partiql.pig.runtime.SymbolPrimitive;
import org.partiql.types.StaticType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005\u0017\u0018\u0019\u001a\u001bB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/partiql/lang/eval/visitors/StaticTypeVisitorTransform;", "Lorg/partiql/lang/eval/visitors/VisitorTransformBase;", "ion", "Lcom/amazon/ion/IonSystem;", "globalBindings", "Lorg/partiql/lang/eval/Bindings;", "Lorg/partiql/types/StaticType;", "constraints", "", "Lorg/partiql/lang/eval/visitors/StaticTypeVisitorTransformConstraints;", "(Lcom/amazon/ion/IonSystem;Lorg/partiql/lang/eval/Bindings;Ljava/util/Set;)V", "globalEnv", "Lorg/partiql/lang/eval/visitors/StaticTypeVisitorTransform$TypeAndDepth;", "preventGlobalsExceptInFrom", "", "preventGlobalsInNestedQueries", "transformStatement", "Lorg/partiql/lang/domains/PartiqlAst$Statement;", "node", "wrapBindings", "bindings", "depth", "", "BindingScope", "ScopeSearchOrder", "TypeAndDepth", "TypeAndScope", "VisitorTransform", "partiql-lang"})
public final class StaticTypeVisitorTransform
extends VisitorTransformBase {
    @NotNull
    private final IonSystem ion;
    @NotNull
    private final Bindings<TypeAndDepth> globalEnv;
    private final boolean preventGlobalsExceptInFrom;
    private final boolean preventGlobalsInNestedQueries;

    public StaticTypeVisitorTransform(@NotNull IonSystem ion, @NotNull Bindings<StaticType> globalBindings, @NotNull Set<? extends StaticTypeVisitorTransformConstraints> constraints) {
        Intrinsics.checkNotNullParameter((Object)ion, (String)"ion");
        Intrinsics.checkNotNullParameter(globalBindings, (String)"globalBindings");
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        this.ion = ion;
        this.globalEnv = this.wrapBindings(globalBindings, 0);
        this.preventGlobalsExceptInFrom = constraints.contains((Object)StaticTypeVisitorTransformConstraints.PREVENT_GLOBALS_EXCEPT_IN_FROM);
        this.preventGlobalsInNestedQueries = constraints.contains((Object)StaticTypeVisitorTransformConstraints.PREVENT_GLOBALS_IN_NESTED_QUERIES);
    }

    public /* synthetic */ StaticTypeVisitorTransform(IonSystem ionSystem, Bindings bindings, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            set2 = SetsKt.emptySet();
        }
        this(ionSystem, bindings, set2);
    }

    @NotNull
    public PartiqlAst.Statement transformStatement(@NotNull PartiqlAst.Statement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return new VisitorTransform(this.wrapBindings(Bindings.Companion.empty(), 1), 0).transformStatement(node);
    }

    private final Bindings<TypeAndDepth> wrapBindings(Bindings<StaticType> bindings, int depth) {
        return Bindings.Companion.over((Function1)new Function1<BindingName, TypeAndDepth>(bindings, depth){
            final /* synthetic */ Bindings<StaticType> $bindings;
            final /* synthetic */ int $depth;
            {
                this.$bindings = $bindings;
                this.$depth = $depth;
                super(1);
            }

            @Nullable
            public final TypeAndDepth invoke(@NotNull BindingName name) {
                TypeAndDepth typeAndDepth;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                StaticType staticType = this.$bindings.get(name);
                if (staticType != null) {
                    StaticType staticType2 = staticType;
                    int n = this.$depth;
                    StaticType bind = staticType2;
                    boolean bl = false;
                    typeAndDepth = new TypeAndDepth(bind, n);
                } else {
                    typeAndDepth = null;
                }
                return typeAndDepth;
            }
        });
    }

    public static final /* synthetic */ IonSystem access$getIon$p(StaticTypeVisitorTransform $this) {
        return $this.ion;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/partiql/lang/eval/visitors/StaticTypeVisitorTransform$TypeAndDepth;", "", "type", "Lorg/partiql/types/StaticType;", "depth", "", "(Lorg/partiql/types/StaticType;I)V", "getDepth", "()I", "getType", "()Lorg/partiql/types/StaticType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "partiql-lang"})
    private static final class TypeAndDepth {
        @NotNull
        private final StaticType type;
        private final int depth;

        public TypeAndDepth(@NotNull StaticType type, int depth) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.type = type;
            this.depth = depth;
        }

        @NotNull
        public final StaticType getType() {
            return this.type;
        }

        public final int getDepth() {
            return this.depth;
        }

        @NotNull
        public final StaticType component1() {
            return this.type;
        }

        public final int component2() {
            return this.depth;
        }

        @NotNull
        public final TypeAndDepth copy(@NotNull StaticType type, int depth) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new TypeAndDepth(type, depth);
        }

        public static /* synthetic */ TypeAndDepth copy$default(TypeAndDepth typeAndDepth, StaticType staticType, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                staticType = typeAndDepth.type;
            }
            if ((n2 & 2) != 0) {
                n = typeAndDepth.depth;
            }
            return typeAndDepth.copy(staticType, n);
        }

        @NotNull
        public String toString() {
            return "TypeAndDepth(type=" + this.type + ", depth=" + this.depth + ')';
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + Integer.hashCode(this.depth);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypeAndDepth)) {
                return false;
            }
            TypeAndDepth typeAndDepth = (TypeAndDepth)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)typeAndDepth.type)) {
                return false;
            }
            return this.depth == typeAndDepth.depth;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/partiql/lang/eval/visitors/StaticTypeVisitorTransform$BindingScope;", "", "(Ljava/lang/String;I)V", "LOCAL", "LEXICAL", "GLOBAL", "partiql-lang"})
    private static final class BindingScope
    extends Enum<BindingScope> {
        public static final /* enum */ BindingScope LOCAL = new BindingScope();
        public static final /* enum */ BindingScope LEXICAL = new BindingScope();
        public static final /* enum */ BindingScope GLOBAL = new BindingScope();
        private static final /* synthetic */ BindingScope[] $VALUES;

        public static BindingScope[] values() {
            return (BindingScope[])$VALUES.clone();
        }

        public static BindingScope valueOf(String value) {
            return Enum.valueOf(BindingScope.class, value);
        }

        static {
            $VALUES = bindingScopeArray = new BindingScope[]{BindingScope.LOCAL, BindingScope.LEXICAL, BindingScope.GLOBAL};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/partiql/lang/eval/visitors/StaticTypeVisitorTransform$TypeAndScope;", "", "type", "Lorg/partiql/types/StaticType;", "scope", "Lorg/partiql/lang/eval/visitors/StaticTypeVisitorTransform$BindingScope;", "(Lorg/partiql/types/StaticType;Lorg/partiql/lang/eval/visitors/StaticTypeVisitorTransform$BindingScope;)V", "getScope", "()Lorg/partiql/lang/eval/visitors/StaticTypeVisitorTransform$BindingScope;", "getType", "()Lorg/partiql/types/StaticType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "partiql-lang"})
    private static final class TypeAndScope {
        @NotNull
        private final StaticType type;
        @NotNull
        private final BindingScope scope;

        public TypeAndScope(@NotNull StaticType type, @NotNull BindingScope scope) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)((Object)scope), (String)"scope");
            this.type = type;
            this.scope = scope;
        }

        @NotNull
        public final StaticType getType() {
            return this.type;
        }

        @NotNull
        public final BindingScope getScope() {
            return this.scope;
        }

        @NotNull
        public final StaticType component1() {
            return this.type;
        }

        @NotNull
        public final BindingScope component2() {
            return this.scope;
        }

        @NotNull
        public final TypeAndScope copy(@NotNull StaticType type, @NotNull BindingScope scope) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)((Object)scope), (String)"scope");
            return new TypeAndScope(type, scope);
        }

        public static /* synthetic */ TypeAndScope copy$default(TypeAndScope typeAndScope, StaticType staticType, BindingScope bindingScope, int n, Object object) {
            if ((n & 1) != 0) {
                staticType = typeAndScope.type;
            }
            if ((n & 2) != 0) {
                bindingScope = typeAndScope.scope;
            }
            return typeAndScope.copy(staticType, bindingScope);
        }

        @NotNull
        public String toString() {
            return "TypeAndScope(type=" + this.type + ", scope=" + (Object)((Object)this.scope) + ')';
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.scope.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypeAndScope)) {
                return false;
            }
            TypeAndScope typeAndScope = (TypeAndScope)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)typeAndScope.type)) {
                return false;
            }
            return this.scope == typeAndScope.scope;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/partiql/lang/eval/visitors/StaticTypeVisitorTransform$ScopeSearchOrder;", "", "(Ljava/lang/String;I)V", "LEXICAL", "GLOBALS_THEN_LEXICAL", "partiql-lang"})
    private static final class ScopeSearchOrder
    extends Enum<ScopeSearchOrder> {
        public static final /* enum */ ScopeSearchOrder LEXICAL = new ScopeSearchOrder();
        public static final /* enum */ ScopeSearchOrder GLOBALS_THEN_LEXICAL = new ScopeSearchOrder();
        private static final /* synthetic */ ScopeSearchOrder[] $VALUES;

        public static ScopeSearchOrder[] values() {
            return (ScopeSearchOrder[])$VALUES.clone();
        }

        public static ScopeSearchOrder valueOf(String value) {
            return Enum.valueOf(ScopeSearchOrder.class, value);
        }

        static {
            $VALUES = scopeSearchOrderArray = new ScopeSearchOrder[]{ScopeSearchOrder.LEXICAL, ScopeSearchOrder.GLOBALS_THEN_LEXICAL};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000f2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001bH\u0002J\f\u0010\u001c\u001a\u00060\u0000R\u00020\u001dH\u0002J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u000e2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001bH\u0002J(\u0010 \u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u000e2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001bH\u0002J0\u0010!\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001bH\u0002J.\u0010$\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u000e2\u001c\b\u0002\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019j\u0004\u0018\u0001`\u001bH\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/H\u0002J(\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020\u000e2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001bH\u0002J\u0010\u00102\u001a\u0002032\u0006\u0010.\u001a\u000204H\u0016J\u0010\u00105\u001a\u0002032\u0006\u0010.\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002082\u0006\u0010.\u001a\u000209H\u0016J\u0010\u0010:\u001a\u0002082\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u0010;\u001a\u0002082\u0006\u0010.\u001a\u00020,H\u0016J\u0010\u0010<\u001a\u0002082\u0006\u0010.\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020?2\u0006\u0010.\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020?2\u0006\u0010.\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u0002082\u0006\u0010.\u001a\u00020BH\u0016J\u0010\u0010D\u001a\u00020?2\u0006\u0010.\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u0002082\u0006\u0010.\u001a\u00020EH\u0016J\u0010\u0010G\u001a\u00020H2\u0006\u0010.\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020J2\u0006\u0010.\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020L2\u0006\u0010.\u001a\u00020MH\u0016J\u001c\u0010N\u001a\u0004\u0018\u00010&*\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010'\u001a\u00020(H\u0002J\f\u0010O\u001a\u00020P*\u00020/H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lorg/partiql/lang/eval/visitors/StaticTypeVisitorTransform$VisitorTransform;", "Lorg/partiql/lang/eval/visitors/VisitorTransformBase;", "parentEnv", "Lorg/partiql/lang/eval/Bindings;", "Lorg/partiql/lang/eval/visitors/StaticTypeVisitorTransform$TypeAndDepth;", "currentScopeDepth", "", "(Lorg/partiql/lang/eval/visitors/StaticTypeVisitorTransform;Lorg/partiql/lang/eval/Bindings;I)V", "containsJoin", "", "currentEnv", "fromVisited", "localsMap", "", "", "Lorg/partiql/types/StaticType;", "localsOnlyEnv", "scopeOrder", "Lorg/partiql/lang/eval/visitors/StaticTypeVisitorTransform$ScopeSearchOrder;", "singleFromSourceName", "addLocal", "", "name", "type", "metas", "", "", "Lcom/amazon/ionelement/api/MetaContainer;", "createTransformerForNestedScope", "Lorg/partiql/lang/eval/visitors/StaticTypeVisitorTransform;", "errAmbiguousName", "", "errIllegalGlobalVariableAccess", "errUnboundName", "case", "Lorg/partiql/lang/domains/PartiqlAst$CaseSensitivity;", "errUnimplementedFeature", "findBind", "Lorg/partiql/lang/eval/visitors/StaticTypeVisitorTransform$TypeAndScope;", "bindingName", "Lorg/partiql/lang/eval/BindingName;", "scopeQualifier", "Lorg/partiql/lang/domains/PartiqlAst$ScopeQualifier;", "makePathIntoFromSource", "Lorg/partiql/lang/domains/PartiqlAst$Expr$Path;", "fromSourceAlias", "node", "Lorg/partiql/lang/domains/PartiqlAst$Expr$Id;", "singleFromSourceRef", "sourceName", "transformDdlOpCreateIndex", "Lorg/partiql/lang/domains/PartiqlAst$DdlOp;", "Lorg/partiql/lang/domains/PartiqlAst$DdlOp$CreateIndex;", "transformDdlOpDropIndex", "Lorg/partiql/lang/domains/PartiqlAst$DdlOp$DropIndex;", "transformExprCallAgg", "Lorg/partiql/lang/domains/PartiqlAst$Expr;", "Lorg/partiql/lang/domains/PartiqlAst$Expr$CallAgg;", "transformExprId", "transformExprPath", "transformExprSelect", "Lorg/partiql/lang/domains/PartiqlAst$Expr$Select;", "transformFromSourceJoin", "Lorg/partiql/lang/domains/PartiqlAst$FromSource;", "Lorg/partiql/lang/domains/PartiqlAst$FromSource$Join;", "transformFromSourceScan", "Lorg/partiql/lang/domains/PartiqlAst$FromSource$Scan;", "transformFromSourceScan_expr", "transformFromSourceUnpivot", "Lorg/partiql/lang/domains/PartiqlAst$FromSource$Unpivot;", "transformFromSourceUnpivot_expr", "transformGroupBy", "Lorg/partiql/lang/domains/PartiqlAst$GroupBy;", "transformLetBinding", "Lorg/partiql/lang/domains/PartiqlAst$LetBinding;", "transformStatementDml", "Lorg/partiql/lang/domains/PartiqlAst$Statement;", "Lorg/partiql/lang/domains/PartiqlAst$Statement$Dml;", "lookupBinding", "toPathExpr", "Lorg/partiql/lang/domains/PartiqlAst$PathStep$PathExpr;", "partiql-lang"})
    private final class VisitorTransform
    extends VisitorTransformBase {
        @NotNull
        private final Bindings<TypeAndDepth> parentEnv;
        private final int currentScopeDepth;
        @NotNull
        private ScopeSearchOrder scopeOrder;
        @NotNull
        private final Map<String, StaticType> localsMap;
        @NotNull
        private Bindings<TypeAndDepth> localsOnlyEnv;
        @NotNull
        private final Bindings<TypeAndDepth> currentEnv;
        private boolean containsJoin;
        private boolean fromVisited;
        @Nullable
        private String singleFromSourceName;

        public VisitorTransform(Bindings<TypeAndDepth> parentEnv, int currentScopeDepth) {
            Intrinsics.checkNotNullParameter(parentEnv, (String)"parentEnv");
            this.parentEnv = parentEnv;
            this.currentScopeDepth = currentScopeDepth;
            this.scopeOrder = ScopeSearchOrder.LEXICAL;
            this.localsMap = new LinkedHashMap();
            this.localsOnlyEnv = StaticTypeVisitorTransform.this.wrapBindings(Bindings.Companion.ofMap(this.localsMap), this.currentScopeDepth);
            this.currentEnv = BindingsExtensionsKt.delegate(Bindings.Companion.over((Function1)new Function1<BindingName, TypeAndDepth>(this){
                final /* synthetic */ VisitorTransform this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final TypeAndDepth invoke(@NotNull BindingName it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (TypeAndDepth)VisitorTransform.access$getLocalsOnlyEnv$p(this.this$0).get(it);
                }
            }), this.parentEnv);
        }

        private final PartiqlAst.Expr.Id singleFromSourceRef(String sourceName, Map<String, ? extends Object> metas) {
            TypeAndDepth typeAndDepth = this.currentEnv.get(new BindingName(sourceName, BindingCase.SENSITIVE));
            if (typeAndDepth == null) {
                throw new IllegalArgumentException("Could not find type for single FROM source variable");
            }
            TypeAndDepth sourceType = typeAndDepth;
            return (PartiqlAst.Expr.Id)PartiqlAst.Companion.build((Function1)new Function1<PartiqlAst.Builder, PartiqlAst.Expr.Id>(sourceName, metas, sourceType){
                final /* synthetic */ String $sourceName;
                final /* synthetic */ Map<String, Object> $metas;
                final /* synthetic */ TypeAndDepth $sourceType;
                {
                    this.$sourceName = $sourceName;
                    this.$metas = $metas;
                    this.$sourceType = $sourceType;
                    super(1);
                }

                @NotNull
                public final PartiqlAst.Expr.Id invoke(@NotNull PartiqlAst.Builder $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"$static_type", (Object)new StaticTypeMeta(this.$sourceType.getType()))};
                    return $this$build.id(this.$sourceName, (PartiqlAst.CaseSensitivity)PartiqlAst.Builder.DefaultImpls.caseSensitive$default((PartiqlAst.Builder)$this$build, null, (int)1, null), (PartiqlAst.ScopeQualifier)PartiqlAst.Builder.DefaultImpls.localsFirst$default((PartiqlAst.Builder)$this$build, null, (int)1, null), MapsKt.plus(this.$metas, (Map)IonMeta.metaContainerOf((Pair[])pairArray)));
                }
            });
        }

        private final PartiqlAst.PathStep.PathExpr toPathExpr(PartiqlAst.Expr.Id $this$toPathExpr) {
            return (PartiqlAst.PathStep.PathExpr)PartiqlAst.Companion.build((Function1)new Function1<PartiqlAst.Builder, PartiqlAst.PathStep.PathExpr>(StaticTypeVisitorTransform.this, $this$toPathExpr){
                final /* synthetic */ StaticTypeVisitorTransform this$0;
                final /* synthetic */ PartiqlAst.Expr.Id $this_toPathExpr;
                {
                    this.this$0 = $receiver;
                    this.$this_toPathExpr = $receiver2;
                    super(1);
                }

                @NotNull
                public final PartiqlAst.PathStep.PathExpr invoke(@NotNull PartiqlAst.Builder $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    IonString ionString = StaticTypeVisitorTransform.access$getIon$p(this.this$0).newString(this.$this_toPathExpr.getName().getText());
                    Intrinsics.checkNotNullExpressionValue((Object)ionString, (String)"ion.newString(name.text)");
                    return $this$build.pathExpr((PartiqlAst.Expr)$this$build.lit((IonElement)IonUtils.toIonElement((IonValue)((IonValue)ionString)), UtilKt.extractSourceLocation((PartiqlAst.PartiqlAstNode)this.$this_toPathExpr)), this.$this_toPathExpr.getCase(), this.$this_toPathExpr.getMetas());
                }
            });
        }

        private final Void errUnboundName(String name, PartiqlAst.CaseSensitivity pairArray, Map<String, ? extends Object> metas) {
            ErrorCode errorCode;
            String string = "No such variable named '" + name + '\'';
            Pair[] pairArray2 = pairArray;
            if (pairArray2 instanceof PartiqlAst.CaseSensitivity.CaseInsensitive) {
                errorCode = ErrorCode.SEMANTIC_UNBOUND_BINDING;
            } else if (pairArray2 instanceof PartiqlAst.CaseSensitivity.CaseSensitive) {
                errorCode = ErrorCode.SEMANTIC_UNBOUND_QUOTED_BINDING;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            pairArray2 = new Pair[]{TuplesKt.to((Object)Property.BINDING_NAME, (Object)name)};
            throw new SemanticException(string, errorCode, UtilKt.addSourceLocation(PropertyMapHelpersKt.propertyValueMapOf(pairArray2), metas), null, 8, null);
        }

        private final Void errIllegalGlobalVariableAccess(String name, Map<String, ? extends Object> metas) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Property.BINDING_NAME, (Object)name)};
            throw new SemanticException("Global variable access is illegal in this context", ErrorCode.SEMANTIC_ILLEGAL_GLOBAL_VARIABLE_ACCESS, UtilKt.addSourceLocation(PropertyMapHelpersKt.propertyValueMapOf(pairArray), metas), null, 8, null);
        }

        private final Void errAmbiguousName(String name, Map<String, ? extends Object> metas) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Property.BINDING_NAME, (Object)name)};
            throw new SemanticException("A variable named '" + name + "' was already defined in this scope", ErrorCode.SEMANTIC_AMBIGUOUS_BINDING, UtilKt.addSourceLocation(PropertyMapHelpersKt.propertyValueMapOf(pairArray), metas), null, 8, null);
        }

        /*
         * WARNING - void declaration
         */
        private final Void errUnimplementedFeature(String name, Map<String, ? extends Object> metas) {
            PropertyValueMap propertyValueMap = new PropertyValueMap[]{TuplesKt.to((Object)Property.FEATURE_NAME, (Object)name)};
            PropertyValueMap propertyValueMap2 = propertyValueMap = PropertyMapHelpersKt.propertyValueMapOf(propertyValueMap);
            ErrorCode errorCode = ErrorCode.UNIMPLEMENTED_FEATURE;
            String string = "Feature not implemented yet";
            boolean bl = false;
            if (metas != null) {
                void it;
                UtilKt.addSourceLocation((PropertyValueMap)it, metas);
            }
            Unit unit = Unit.INSTANCE;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 8;
            Throwable throwable = null;
            PropertyValueMap propertyValueMap3 = propertyValueMap;
            ErrorCode errorCode2 = errorCode;
            String string2 = string;
            throw new SemanticException(string2, errorCode2, propertyValueMap3, throwable, n, defaultConstructorMarker);
        }

        static /* synthetic */ Void errUnimplementedFeature$default(VisitorTransform visitorTransform, String string, Map map2, int n, Object object) {
            if ((n & 2) != 0) {
                map2 = null;
            }
            return visitorTransform.errUnimplementedFeature(string, map2);
        }

        private final void addLocal(String name, StaticType type, Map<String, ? extends Object> metas) {
            TypeAndDepth existing = this.localsOnlyEnv.get(new BindingName(name, BindingCase.INSENSITIVE));
            if (existing != null) {
                this.errAmbiguousName(name, metas);
                throw new KotlinNothingValueException();
            }
            this.localsMap.put(name, type);
            this.localsOnlyEnv = StaticTypeVisitorTransform.this.wrapBindings(Bindings.Companion.ofMap(this.localsMap), this.currentScopeDepth);
        }

        @NotNull
        public PartiqlAst.Expr transformExprCallAgg(@NotNull PartiqlAst.Expr.CallAgg node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return (PartiqlAst.Expr)PartiqlAst.Companion.build((Function1)new Function1<PartiqlAst.Builder, PartiqlAst.Expr.CallAgg>(node, this){
                final /* synthetic */ PartiqlAst.Expr.CallAgg $node;
                final /* synthetic */ VisitorTransform this$0;
                {
                    this.$node = $node;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final PartiqlAst.Expr.CallAgg invoke(@NotNull PartiqlAst.Builder $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.callAgg_(this.$node.getSetq(), this.$node.getFuncName(), this.this$0.transformExpr(this.$node.getArg()), this.this$0.transformMetas(this.$node.getMetas()));
                }
            });
        }

        private final TypeAndScope lookupBinding(Bindings<TypeAndDepth> $this$lookupBinding, BindingName bindingName) {
            TypeAndScope typeAndScope;
            TypeAndDepth match = $this$lookupBinding.get(bindingName);
            if (match != null) {
                BindingScope bindingScope;
                StaticType type = match.component1();
                int depth = match.component2();
                if (depth == 0) {
                    bindingScope = BindingScope.GLOBAL;
                } else if (depth < this.currentScopeDepth) {
                    bindingScope = BindingScope.LEXICAL;
                } else if (depth == this.currentScopeDepth) {
                    bindingScope = BindingScope.LOCAL;
                } else {
                    throw new IllegalStateException("Unexpected: depth should never be > currentScopeDepth".toString());
                }
                BindingScope scope = bindingScope;
                typeAndScope = new TypeAndScope(type, scope);
            } else {
                typeAndScope = null;
            }
            return typeAndScope;
        }

        private final TypeAndScope findBind(BindingName bindingName, PartiqlAst.ScopeQualifier scopeQualifier) {
            List list;
            ScopeSearchOrder scopeSearchOrder;
            PartiqlAst.ScopeQualifier scopeQualifier2 = scopeQualifier;
            if (scopeQualifier2 instanceof PartiqlAst.ScopeQualifier.LocalsFirst) {
                scopeSearchOrder = ScopeSearchOrder.LEXICAL;
            } else if (scopeQualifier2 instanceof PartiqlAst.ScopeQualifier.Unqualified) {
                scopeSearchOrder = this.scopeOrder;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            ScopeSearchOrder overridenScopeSearchOrder = scopeSearchOrder;
            switch (WhenMappings.$EnumSwitchMapping$0[overridenScopeSearchOrder.ordinal()]) {
                case 1: {
                    Object[] objectArray = new Bindings[]{StaticTypeVisitorTransform.this.globalEnv, this.currentEnv};
                    list = CollectionsKt.listOf((Object[])objectArray);
                    break;
                }
                case 2: {
                    Object[] objectArray = new Bindings[]{this.currentEnv, StaticTypeVisitorTransform.this.globalEnv};
                    list = CollectionsKt.listOf((Object[])objectArray);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            List scopes = list;
            return (TypeAndScope)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)scopes), (Function1)((Function1)new Function1<Bindings<TypeAndDepth>, TypeAndScope>(this, bindingName){
                final /* synthetic */ VisitorTransform this$0;
                final /* synthetic */ BindingName $bindingName;
                {
                    this.this$0 = $receiver;
                    this.$bindingName = $bindingName;
                    super(1);
                }

                @Nullable
                public final TypeAndScope invoke(@NotNull Bindings<TypeAndDepth> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return VisitorTransform.access$lookupBinding(this.this$0, it, this.$bindingName);
                }
            })));
        }

        @NotNull
        public PartiqlAst.Expr transformExprId(@NotNull PartiqlAst.Expr.Id node) {
            PartiqlAst.ScopeQualifier scopeQualifier;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            BindingName bindingName = new BindingName(node.getName().getText(), UtilKt.toBindingCase(node.getCase()));
            TypeAndScope found = this.findBind(bindingName, node.getQualifier());
            String singleBinding = this.singleFromSourceName;
            if (found == null) {
                if (singleBinding == null) {
                    this.errUnboundName(node.getName().getText(), node.getCase(), node.getMetas());
                    throw new KotlinNothingValueException();
                }
                return (PartiqlAst.Expr)this.makePathIntoFromSource(singleBinding, node);
            }
            if (found.getScope() == BindingScope.GLOBAL) {
                if (singleBinding != null) {
                    return (PartiqlAst.Expr)this.makePathIntoFromSource(singleBinding, node);
                }
                if (StaticTypeVisitorTransform.this.preventGlobalsExceptInFrom && this.fromVisited) {
                    this.errIllegalGlobalVariableAccess(bindingName.getName(), node.getMetas());
                    throw new KotlinNothingValueException();
                }
                if (StaticTypeVisitorTransform.this.preventGlobalsInNestedQueries && this.currentScopeDepth > 1) {
                    this.errIllegalGlobalVariableAccess(bindingName.getName(), node.getMetas());
                    throw new KotlinNothingValueException();
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$1[found.getScope().ordinal()]) {
                case 1: 
                case 2: {
                    scopeQualifier = (PartiqlAst.ScopeQualifier)PartiqlAst.Companion.build((Function1)transformExprId.newScopeQualifier.1.INSTANCE);
                    break;
                }
                case 3: {
                    scopeQualifier = (PartiqlAst.ScopeQualifier)PartiqlAst.Companion.build((Function1)transformExprId.newScopeQualifier.2.INSTANCE);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            PartiqlAst.ScopeQualifier newScopeQualifier2 = scopeQualifier;
            return (PartiqlAst.Expr)PartiqlAst.Companion.build((Function1)new Function1<PartiqlAst.Builder, PartiqlAst.Expr.Id>(node, newScopeQualifier2, found){
                final /* synthetic */ PartiqlAst.Expr.Id $node;
                final /* synthetic */ PartiqlAst.ScopeQualifier $newScopeQualifier;
                final /* synthetic */ TypeAndScope $found;
                {
                    this.$node = $node;
                    this.$newScopeQualifier = $newScopeQualifier;
                    this.$found = $found;
                    super(1);
                }

                @NotNull
                public final PartiqlAst.Expr.Id invoke(@NotNull PartiqlAst.Builder $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"$static_type", (Object)new StaticTypeMeta(this.$found.getType()))};
                    return $this$build.id_(this.$node.getName(), this.$node.getCase(), this.$newScopeQualifier, MapsKt.plus((Map)this.$node.getMetas(), (Map)IonMeta.metaContainerOf((Pair[])pairArray)));
                }
            });
        }

        private final PartiqlAst.Expr.Path makePathIntoFromSource(String fromSourceAlias, PartiqlAst.Expr.Id node) {
            return (PartiqlAst.Expr.Path)PartiqlAst.Companion.build((Function1)new Function1<PartiqlAst.Builder, PartiqlAst.Expr.Path>(this, fromSourceAlias, node){
                final /* synthetic */ VisitorTransform this$0;
                final /* synthetic */ String $fromSourceAlias;
                final /* synthetic */ PartiqlAst.Expr.Id $node;
                {
                    this.this$0 = $receiver;
                    this.$fromSourceAlias = $fromSourceAlias;
                    this.$node = $node;
                    super(1);
                }

                @NotNull
                public final PartiqlAst.Expr.Path invoke(@NotNull PartiqlAst.Builder $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.path((PartiqlAst.Expr)VisitorTransform.access$singleFromSourceRef(this.this$0, this.$fromSourceAlias, UtilKt.extractSourceLocation((PartiqlAst.PartiqlAstNode)this.$node)), CollectionsKt.listOf((Object)VisitorTransform.access$toPathExpr(this.this$0, this.$node)), UtilKt.extractSourceLocation((PartiqlAst.PartiqlAstNode)this.$node));
                }
            });
        }

        @NotNull
        public PartiqlAst.Expr transformExprPath(@NotNull PartiqlAst.Expr.Path node) {
            PartiqlAst.Expr expr;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.getRoot() instanceof PartiqlAst.Expr.Id) {
                PartiqlAst.Expr it = super.transformExprPath(node);
                boolean bl = false;
                PartiqlAst.Expr.Path cfr_ignored_0 = (PartiqlAst.Expr.Path)it;
                PartiqlAst.Expr root = ((PartiqlAst.Expr.Path)it).getRoot();
                expr = (PartiqlAst.Expr)(root instanceof PartiqlAst.Expr.Path ? (PartiqlAst.Expr.Path)PartiqlAst.Companion.build((Function1)new Function1<PartiqlAst.Builder, PartiqlAst.Expr.Path>(root, it){
                    final /* synthetic */ PartiqlAst.Expr $root;
                    final /* synthetic */ PartiqlAst.Expr $it;
                    {
                        this.$root = $root;
                        this.$it = $it;
                        super(1);
                    }

                    @NotNull
                    public final PartiqlAst.Expr.Path invoke(@NotNull PartiqlAst.Builder $this$build) {
                        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                        return $this$build.path(((PartiqlAst.Expr.Path)this.$root).getRoot(), CollectionsKt.plus((Collection)((PartiqlAst.Expr.Path)this.$root).getSteps(), (Iterable)((PartiqlAst.Expr.Path)this.$it).getSteps()), this.$it.getMetas());
                    }
                }) : (PartiqlAst.Expr.Path)it);
            } else {
                expr = super.transformExprPath(node);
            }
            return expr;
        }

        @NotNull
        public PartiqlAst.FromSource transformFromSourceScan(@NotNull PartiqlAst.FromSource.Scan node) {
            SymbolPrimitive it;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PartiqlAst.FromSource from = super.transformFromSourceScan(node);
            SymbolPrimitive symbolPrimitive = node.getAtAlias();
            if (symbolPrimitive != null) {
                it = symbolPrimitive;
                boolean bl = false;
                this.addLocal(it.getText(), (StaticType)StaticType.ANY, it.getMetas());
            }
            SymbolPrimitive symbolPrimitive2 = node.getByAlias();
            if (symbolPrimitive2 != null) {
                it = symbolPrimitive2;
                boolean bl = false;
                this.addLocal(it.getText(), (StaticType)StaticType.ANY, it.getMetas());
            }
            SymbolPrimitive symbolPrimitive3 = node.getAsAlias();
            if (symbolPrimitive3 == null) {
                throw new IllegalStateException("fromSourceLet.variables.asName is null.  This wouldn't be the case if FromSourceAliasVisitorTransform was executed first.".toString());
            }
            SymbolPrimitive asSymbolicName = symbolPrimitive3;
            this.addLocal(asSymbolicName.getText(), (StaticType)StaticType.ANY, asSymbolicName.getMetas());
            if (!this.containsJoin) {
                this.fromVisited = true;
                if (this.currentScopeDepth == 1) {
                    this.singleFromSourceName = asSymbolicName.getText();
                }
            }
            return from;
        }

        @NotNull
        public PartiqlAst.FromSource transformFromSourceUnpivot(@NotNull PartiqlAst.FromSource.Unpivot node) {
            SymbolPrimitive it;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PartiqlAst.FromSource from = super.transformFromSourceUnpivot(node);
            SymbolPrimitive symbolPrimitive = node.getAtAlias();
            if (symbolPrimitive != null) {
                it = symbolPrimitive;
                boolean bl = false;
                this.addLocal(it.getText(), (StaticType)StaticType.ANY, it.getMetas());
            }
            SymbolPrimitive symbolPrimitive2 = node.getByAlias();
            if (symbolPrimitive2 != null) {
                it = symbolPrimitive2;
                boolean bl = false;
                this.addLocal(it.getText(), (StaticType)StaticType.ANY, it.getMetas());
            }
            SymbolPrimitive symbolPrimitive3 = node.getAsAlias();
            if (symbolPrimitive3 == null) {
                throw new IllegalStateException("fromSourceLet.variables.asName is null.  This wouldn't be the case if FromSourceAliasVisitorTransform was executed first.".toString());
            }
            SymbolPrimitive asSymbolicName = symbolPrimitive3;
            this.addLocal(asSymbolicName.getText(), (StaticType)StaticType.ANY, asSymbolicName.getMetas());
            if (!this.containsJoin) {
                this.fromVisited = true;
                if (this.currentScopeDepth == 1) {
                    this.singleFromSourceName = asSymbolicName.getText();
                }
            }
            return from;
        }

        @NotNull
        public PartiqlAst.LetBinding transformLetBinding(@NotNull PartiqlAst.LetBinding node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            PartiqlAst.LetBinding binding2 = super.transformLetBinding(node);
            this.addLocal(binding2.getName().getText(), (StaticType)StaticType.ANY, binding2.getName().getMetas());
            return binding2;
        }

        @NotNull
        public PartiqlAst.FromSource transformFromSourceJoin(@NotNull PartiqlAst.FromSource.Join node) {
            PartiqlAst.FromSource fromSource;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            boolean outermostJoin = !this.containsJoin;
            this.containsJoin = true;
            PartiqlAst.FromSource it = fromSource = super.transformFromSourceJoin(node);
            boolean bl = false;
            if (outermostJoin) {
                this.fromVisited = true;
                this.singleFromSourceName = null;
            }
            return fromSource;
        }

        @NotNull
        public PartiqlAst.Expr transformFromSourceScan_expr(@NotNull PartiqlAst.FromSource.Scan node) {
            PartiqlAst.Expr expr;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.scopeOrder = ScopeSearchOrder.GLOBALS_THEN_LEXICAL;
            PartiqlAst.Expr it = expr = this.transformExpr(node.getExpr());
            boolean bl = false;
            this.scopeOrder = ScopeSearchOrder.LEXICAL;
            return expr;
        }

        @NotNull
        public PartiqlAst.Expr transformFromSourceUnpivot_expr(@NotNull PartiqlAst.FromSource.Unpivot node) {
            PartiqlAst.Expr expr;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.scopeOrder = ScopeSearchOrder.GLOBALS_THEN_LEXICAL;
            PartiqlAst.Expr it = expr = this.transformExpr(node.getExpr());
            boolean bl = false;
            this.scopeOrder = ScopeSearchOrder.LEXICAL;
            return expr;
        }

        @NotNull
        public PartiqlAst.GroupBy transformGroupBy(@NotNull PartiqlAst.GroupBy node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            VisitorTransform.errUnimplementedFeature$default(this, "GROUP BY", null, 2, null);
            throw new KotlinNothingValueException();
        }

        @NotNull
        public PartiqlAst.Expr transformExprSelect(@NotNull PartiqlAst.Expr.Select node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return this.createTransformerForNestedScope().transformExprSelectEvaluationOrder(node);
        }

        @NotNull
        public PartiqlAst.Statement transformStatementDml(@NotNull PartiqlAst.Statement.Dml node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return this.createTransformerForNestedScope().transformDataManipulationEvaluationOrder(node);
        }

        private final VisitorTransform createTransformerForNestedScope() {
            return new VisitorTransform(this.currentEnv, this.currentScopeDepth + 1);
        }

        @NotNull
        public PartiqlAst.DdlOp transformDdlOpCreateIndex(@NotNull PartiqlAst.DdlOp.CreateIndex node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return (PartiqlAst.DdlOp)PartiqlAst.Companion.build((Function1)new Function1<PartiqlAst.Builder, PartiqlAst.DdlOp.CreateIndex>(node, this){
                final /* synthetic */ PartiqlAst.DdlOp.CreateIndex $node;
                final /* synthetic */ VisitorTransform this$0;
                {
                    this.$node = $node;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final PartiqlAst.DdlOp.CreateIndex invoke(@NotNull PartiqlAst.Builder $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.createIndex(this.$node.getIndexName(), this.$node.getFields(), this.this$0.transformMetas(this.$node.getMetas()));
                }
            });
        }

        @NotNull
        public PartiqlAst.DdlOp transformDdlOpDropIndex(@NotNull PartiqlAst.DdlOp.DropIndex node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return (PartiqlAst.DdlOp)PartiqlAst.Companion.build((Function1)new Function1<PartiqlAst.Builder, PartiqlAst.DdlOp.DropIndex>(node, this){
                final /* synthetic */ PartiqlAst.DdlOp.DropIndex $node;
                final /* synthetic */ VisitorTransform this$0;
                {
                    this.$node = $node;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final PartiqlAst.DdlOp.DropIndex invoke(@NotNull PartiqlAst.Builder $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    return $this$build.dropIndex(this.$node.getTable(), this.$node.getKeys(), this.this$0.transformMetas(this.$node.getMetas()));
                }
            });
        }

        public static final /* synthetic */ TypeAndScope access$lookupBinding(VisitorTransform $this, Bindings $receiver, BindingName bindingName) {
            return $this.lookupBinding($receiver, bindingName);
        }

        public static final /* synthetic */ PartiqlAst.Expr.Id access$singleFromSourceRef(VisitorTransform $this, String sourceName, Map metas) {
            return $this.singleFromSourceRef(sourceName, metas);
        }

        public static final /* synthetic */ PartiqlAst.PathStep.PathExpr access$toPathExpr(VisitorTransform $this, PartiqlAst.Expr.Id $receiver) {
            return $this.toPathExpr($receiver);
        }

        public static final /* synthetic */ Bindings access$getLocalsOnlyEnv$p(VisitorTransform $this) {
            return $this.localsOnlyEnv;
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[ScopeSearchOrder.values().length];
                nArray[ScopeSearchOrder.GLOBALS_THEN_LEXICAL.ordinal()] = 1;
                nArray[ScopeSearchOrder.LEXICAL.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[BindingScope.values().length];
                nArray[BindingScope.LOCAL.ordinal()] = 1;
                nArray[BindingScope.LEXICAL.ordinal()] = 2;
                nArray[BindingScope.GLOBAL.ordinal()] = 3;
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

