/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.graph;

import com.amazon.ion.IonList;
import com.amazon.ion.IonSequence;
import com.amazon.ion.IonSexp;
import com.amazon.ion.IonString;
import com.amazon.ion.IonStruct;
import com.amazon.ion.IonSymbol;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazon.ion.system.IonSystemBuilder;
import com.amazon.ionschema.Authority;
import com.amazon.ionschema.IonSchemaSystem;
import com.amazon.ionschema.IonSchemaSystemBuilder;
import com.amazon.ionschema.Schema;
import com.amazon.ionschema.Type;
import com.amazon.ionschema.Violations;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.graph.GraphIonException;
import org.partiql.lang.graph.GraphReadException;
import org.partiql.lang.graph.GraphValidationException;
import org.partiql.lang.graph.SimpleGraph;
import org.partiql.lang.util.impl.ResourceAuthority;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001%B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\nJ(\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001c0\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/partiql/lang/graph/ExternalGraphReader;", "", "()V", "graphSchema", "Lcom/amazon/ionschema/Schema;", "graphType", "Lcom/amazon/ionschema/Type;", "ion", "Lcom/amazon/ion/IonSystem;", "islGraph", "", "islSchemaFile", "iss", "Lcom/amazon/ionschema/IonSchemaSystem;", "read", "Lorg/partiql/lang/graph/SimpleGraph;", "graphIon", "Lcom/amazon/ion/IonValue;", "graphStr", "readCommon", "Lkotlin/Triple;", "", "Lorg/partiql/lang/eval/ExprValue;", "node", "Lcom/amazon/ion/IonStruct;", "readGraph", "readNode", "Lkotlin/Pair;", "Lorg/partiql/lang/graph/SimpleGraph$Node;", "readNodes", "", "nodesList", "Lcom/amazon/ion/IonList;", "validate", "", "graphFile", "Ljava/io/File;", "EdgeReader", "partiql-lang"})
public final class ExternalGraphReader {
    @NotNull
    public static final ExternalGraphReader INSTANCE = new ExternalGraphReader();
    @NotNull
    private static final String islSchemaFile = "graph.isl";
    @NotNull
    private static final String islGraph = "Graph";
    @NotNull
    private static final IonSystem ion;
    @NotNull
    private static final IonSchemaSystem iss;
    @NotNull
    private static final Schema graphSchema;
    @NotNull
    private static final Type graphType;

    private ExternalGraphReader() {
    }

    public final void validate(@NotNull IonValue graphIon) {
        Intrinsics.checkNotNullParameter((Object)graphIon, (String)"graphIon");
        Violations violations = graphType.validate(graphIon);
        if (!violations.isValid()) {
            throw new GraphValidationException("Ion data did not validate as a graph: \n" + violations);
        }
    }

    public final void validate(@NotNull String graphStr) {
        Intrinsics.checkNotNullParameter((Object)graphStr, (String)"graphStr");
        IonValue graphIon = ion.singleValue(graphStr);
        Intrinsics.checkNotNullExpressionValue((Object)graphIon, (String)"graphIon");
        this.validate(graphIon);
    }

    public final void validate(@NotNull File graphFile) {
        Intrinsics.checkNotNullParameter((Object)graphFile, (String)"graphFile");
        String graphStr = FilesKt.readText$default((File)graphFile, null, (int)1, null);
        this.validate(graphStr);
    }

    @NotNull
    public final SimpleGraph read(@NotNull IonValue graphIon) {
        Intrinsics.checkNotNullParameter((Object)graphIon, (String)"graphIon");
        this.validate(graphIon);
        return this.readGraph(graphIon);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SimpleGraph read(@NotNull String graphStr) {
        Intrinsics.checkNotNullParameter((Object)graphStr, (String)"graphStr");
        IonValue graphIon = null;
        try {
            graphIon = ion.singleValue(graphStr);
        }
        catch (RuntimeException ex) {
            String string;
            StringBuilder stringBuilder;
            block5: {
                block4: {
                    void it;
                    stringBuilder = new StringBuilder().append("Error while reading Ion for the graph");
                    string = ex.getMessage();
                    if (string == null) break block4;
                    String string2 = string;
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl = false;
                    String string3 = ":\n" + (String)it;
                    stringBuilder = stringBuilder2;
                    string = string3;
                    if (string3 != null) break block5;
                }
                string = ".";
            }
            String string4 = stringBuilder.append(string).toString();
            throw new GraphIonException(string4);
        }
        IonValue ionValue = graphIon;
        Intrinsics.checkNotNull((Object)ionValue);
        this.validate(ionValue);
        return this.readGraph(graphIon);
    }

    private final SimpleGraph readGraph(IonValue graphIon) {
        IonStruct g = (IonStruct)graphIon;
        IonValue ionValue = g.get("nodes");
        if (ionValue == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.amazon.ion.IonList");
        }
        IonList nds = (IonList)ionValue;
        IonValue ionValue2 = g.get("edges");
        if (ionValue2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.amazon.ion.IonList");
        }
        IonList eds = (IonList)ionValue2;
        Map<String, SimpleGraph.Node> nodes = this.readNodes(nds);
        Pair<List<Triple<SimpleGraph.Node, SimpleGraph.EdgeDirected, SimpleGraph.Node>>, List<Triple<SimpleGraph.Node, SimpleGraph.EdgeUndir, SimpleGraph.Node>>> pair = new EdgeReader(nodes).readEdges$partiql_lang(eds);
        List directed = (List)pair.component1();
        List undirected = (List)pair.component2();
        return new SimpleGraph(CollectionsKt.toList((Iterable)nodes.values()), directed, undirected);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, SimpleGraph.Node> readNodes(IonList nodesList) {
        void $this$filterValues$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = CollectionsKt.toList((Iterable)((Iterable)nodesList));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            IonValue ionValue = (IonValue)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            if (v0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.amazon.ion.IonStruct");
            }
            collection.add(INSTANCE.readNode((IonStruct)v0));
        }
        List pairs = (List)destination$iv$iv;
        Iterable $this$map$iv2 = pairs;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add((String)it.getFirst());
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            String it = (String)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it;
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv2;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            List it = (List)entry$iv.getValue();
            boolean bl = false;
            if (!(it.size() > 1)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set duplicates = ((Map)result$iv).keySet();
        if (!((Collection)duplicates).isEmpty()) {
            throw new GraphReadException("Identifiers used for more than one node: " + CollectionsKt.joinToString$default((Iterable)duplicates, null, null, null, (int)0, null, null, (int)63, null) + '.');
        }
        return MapsKt.toMap((Iterable)pairs);
    }

    private final Pair<String, SimpleGraph.Node> readNode(IonStruct node) {
        Triple<String, Set<String>, ExprValue> triple = this.readCommon(node);
        String id = (String)triple.component1();
        Set labels = (Set)triple.component2();
        ExprValue payload = (ExprValue)triple.component3();
        return new Pair((Object)id, (Object)new SimpleGraph.Node(labels, payload));
    }

    /*
     * WARNING - void declaration
     */
    private final Triple<String, Set<String>, ExprValue> readCommon(IonStruct node) {
        IonValue pld;
        Set set2;
        IonValue ionValue = node.get("id");
        Intrinsics.checkNotNull((Object)ionValue);
        String id = ((IonSymbol)ionValue).symbolValue().assumeText();
        IonValue lbs = node.get("labels");
        if (lbs == null) {
            set2 = SetsKt.emptySet();
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.toList((Iterable)((Iterable)((IonList)lbs)));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IonValue ionValue2 = (IonValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v2 = it;
                if (v2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.amazon.ion.IonString");
                }
                collection.add(((IonString)v2).stringValue());
            }
            set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
        Set labels = set2;
        IonValue ionValue3 = pld = node.get("payload");
        ExprValue payload = ionValue3 == null ? ExprValue.Companion.getNullValue() : ExprValue.Companion.of(ionValue3);
        return new Triple((Object)id, (Object)labels, (Object)payload);
    }

    static {
        IonSystem ionSystem = IonSystemBuilder.standard().build();
        Intrinsics.checkNotNullExpressionValue((Object)ionSystem, (String)"standard().build()");
        ion = ionSystem;
        iss = IonSchemaSystemBuilder.Companion.standard().addAuthority((Authority)ResourceAuthority.Companion.getResourceAuthority$partiql_lang(ion)).withIonSystem(ion).build();
        graphSchema = iss.loadSchema(islSchemaFile);
        Type type = graphSchema.getType(islGraph);
        if (type == null) {
            throw new IllegalStateException("Definition for type Graph not found in ISL schema graph.isl".toString());
        }
        graphType = type;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ1\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00050\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015Je\u0010\u0016\u001aR\u0012&\u0012$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00050\u0010j\b\u0012\u0004\u0012\u00020\u0019`\u00120\u0018\u0012&\u0012$\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00050\u0010j\b\u0012\u0004\u0012\u00020\u001a`\u00120\u00180\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Lorg/partiql/lang/graph/ExternalGraphReader$EdgeReader;", "", "allNodes", "", "", "Lorg/partiql/lang/graph/SimpleGraph$Node;", "(Ljava/util/Map;)V", "getAllNodes", "()Ljava/util/Map;", "endNode", "seq", "Lcom/amazon/ion/IonSequence;", "idx", "", "endNode$partiql_lang", "readEdge", "Lkotlin/Triple;", "Lorg/partiql/lang/graph/SimpleGraph$Edge;", "Lorg/partiql/lang/graph/EdgeTriple;", "edge", "Lcom/amazon/ion/IonStruct;", "readEdge$partiql_lang", "readEdges", "Lkotlin/Pair;", "", "Lorg/partiql/lang/graph/SimpleGraph$EdgeDirected;", "Lorg/partiql/lang/graph/SimpleGraph$EdgeUndir;", "edgesList", "Lcom/amazon/ion/IonList;", "readEdges$partiql_lang", "partiql-lang"})
    private static final class EdgeReader {
        @NotNull
        private final Map<String, SimpleGraph.Node> allNodes;

        public EdgeReader(@NotNull Map<String, SimpleGraph.Node> allNodes) {
            Intrinsics.checkNotNullParameter(allNodes, (String)"allNodes");
            this.allNodes = allNodes;
        }

        @NotNull
        public final Map<String, SimpleGraph.Node> getAllNodes() {
            return this.allNodes;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<List<Triple<SimpleGraph.Node, SimpleGraph.EdgeDirected, SimpleGraph.Node>>, List<Triple<SimpleGraph.Node, SimpleGraph.EdgeUndir, SimpleGraph.Node>>> readEdges$partiql_lang(@NotNull IonList edgesList) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)edgesList, (String)"edgesList");
            List dirs = new ArrayList();
            List undirs = new ArrayList();
            Iterable $this$map$iv = CollectionsKt.toList((Iterable)((Iterable)edgesList));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IonValue ionValue = (IonValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v0 = it;
                if (v0 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.amazon.ion.IonStruct");
                }
                collection.add(this.readEdge$partiql_lang((IonStruct)v0));
            }
            List triples = (List)destination$iv$iv;
            Iterable $this$forEach$iv = triples;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Triple it = (Triple)element$iv;
                boolean bl = false;
                SimpleGraph.Node n1 = (SimpleGraph.Node)it.component1();
                SimpleGraph.Edge e = (SimpleGraph.Edge)it.component2();
                SimpleGraph.Node n2 = (SimpleGraph.Node)it.component3();
                SimpleGraph.Edge edge = e;
                if (edge instanceof SimpleGraph.EdgeDirected) {
                    ((Collection)dirs).add(new Triple((Object)n1, (Object)e, (Object)n2));
                    continue;
                }
                if (!(edge instanceof SimpleGraph.EdgeUndir)) continue;
                ((Collection)undirs).add(new Triple((Object)n1, (Object)e, (Object)n2));
            }
            return new Pair((Object)CollectionsKt.toList((Iterable)dirs), (Object)CollectionsKt.toList((Iterable)undirs));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final Triple<SimpleGraph.Node, SimpleGraph.Edge, SimpleGraph.Node> readEdge$partiql_lang(@NotNull IonStruct edge) {
            Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
            Triple triple = INSTANCE.readCommon(edge);
            String id = (String)triple.component1();
            Set labels = (Set)triple.component2();
            ExprValue payload = (ExprValue)triple.component3();
            IonValue ionValue = edge.get("ends");
            Intrinsics.checkNotNull((Object)ionValue);
            IonSexp ends = (IonSexp)ionValue;
            SimpleGraph.Node n1 = this.endNode$partiql_lang((IonSequence)ends, 0);
            IonValue ionValue2 = ends.get(1);
            if (ionValue2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.amazon.ion.IonSymbol");
            }
            String marker = ((IonSymbol)ionValue2).symbolValue().assumeText();
            SimpleGraph.Node n2 = this.endNode$partiql_lang((IonSequence)ends, 2);
            String string = marker;
            if (string == null) throw new GraphReadException("BUG: At edge " + id + ", directionality marker not recognized: " + marker);
            int n = -1;
            switch (string.hashCode()) {
                case 1440: {
                    if (string.equals("--")) {
                        n = 1;
                    }
                    break;
                }
                case 1457: {
                    if (string.equals("->")) {
                        n = 2;
                    }
                    break;
                }
                case 1905: {
                    if (string.equals("<-")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    Triple triple2 = new Triple((Object)n1, (Object)new SimpleGraph.EdgeUndir(labels, payload), (Object)n2);
                    return triple2;
                }
                case 2: {
                    Triple triple2 = new Triple((Object)n1, (Object)new SimpleGraph.EdgeDirected(labels, payload), (Object)n2);
                    return triple2;
                }
                case 3: {
                    Triple triple2 = new Triple((Object)n2, (Object)new SimpleGraph.EdgeDirected(labels, payload), (Object)n1);
                    return triple2;
                }
                default: {
                    throw new GraphReadException("BUG: At edge " + id + ", directionality marker not recognized: " + marker);
                }
            }
        }

        @NotNull
        public final SimpleGraph.Node endNode$partiql_lang(@NotNull IonSequence seq2, int idx) {
            Intrinsics.checkNotNullParameter((Object)seq2, (String)"seq");
            IonValue ionValue = seq2.get(idx);
            if (ionValue == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.amazon.ion.IonSymbol");
            }
            String id = ((IonSymbol)ionValue).symbolValue().assumeText();
            Map<String, SimpleGraph.Node> map2 = this.allNodes;
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
            SimpleGraph.Node node = map2.get(id);
            if (node == null) {
                boolean bl = false;
                throw new GraphReadException("Node id " + id + " is used in an edge, but it was not defined as a node");
            }
            return node;
        }
    }
}

