/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.graph.DirSpec;
import org.partiql.lang.graph.EdgeSpec;
import org.partiql.lang.graph.ElemSpec;
import org.partiql.lang.graph.Graph;
import org.partiql.lang.graph.GraphEngine;
import org.partiql.lang.graph.LabelSpec;
import org.partiql.lang.graph.MatchResult;
import org.partiql.lang.graph.MatchSpec;
import org.partiql.lang.graph.NodeSpec;
import org.partiql.lang.graph.StepSpec;
import org.partiql.lang.graph.Stride;
import org.partiql.lang.graph.StrideJoin;
import org.partiql.lang.graph.StrideLeaf;
import org.partiql.lang.graph.StrideResult;
import org.partiql.lang.graph.StrideSpec;
import org.partiql.lang.graph.StrideTree;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nJ\u0014\u0010\u0014\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J(\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fJ*\u0010 \u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\"0!0\u0016*\u00020\u00062\u0006\u0010$\u001a\u00020%\u00a8\u0006&"}, d2={"Lorg/partiql/lang/graph/GraphEngine;", "", "()V", "evaluate", "Lorg/partiql/lang/graph/MatchResult;", "graph", "Lorg/partiql/lang/graph/Graph;", "matchSpec", "Lorg/partiql/lang/graph/MatchSpec;", "evaluateNodeStride", "Lorg/partiql/lang/graph/StrideResult;", "stride", "Lorg/partiql/lang/graph/StrideSpec;", "evaluatePlan", "plan", "Lorg/partiql/lang/graph/StrideTree;", "evaluateStride", "joinAdjacentStrides", "left", "right", "joinStridesOnBinders", "strides", "", "planStride", "restoreStrideSpec", "strideTree", "stridesJoinable", "Lkotlin/Function2;", "Lorg/partiql/lang/graph/Stride;", "", "leftSpec", "rightSpec", "getMatchingSteps", "Lkotlin/Triple;", "Lorg/partiql/lang/graph/Graph$Node;", "Lorg/partiql/lang/graph/Graph$Edge;", "spec", "Lorg/partiql/lang/graph/StepSpec;", "partiql-lang"})
public final class GraphEngine {
    @NotNull
    public static final GraphEngine INSTANCE = new GraphEngine();

    private GraphEngine() {
    }

    @NotNull
    public final List<Triple<Graph.Node, Graph.Edge, Graph.Node>> getMatchingSteps(@NotNull Graph $this$getMatchingSteps, @NotNull StepSpec spec) {
        Intrinsics.checkNotNullParameter((Object)$this$getMatchingSteps, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        DirSpec dirSpec = spec.component1();
        Triple<LabelSpec, LabelSpec, LabelSpec> tripleSpec = spec.component2();
        List result = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)(dirSpec.getWantUndir() ? $this$getMatchingSteps.scanUndir(tripleSpec) : CollectionsKt.emptyList()), (Iterable)(dirSpec.getWantLeft() && dirSpec.getWantRight() ? $this$getMatchingSteps.scanDirectedBlunt(tripleSpec) : CollectionsKt.emptyList())), (Iterable)(!dirSpec.getWantLeft() && dirSpec.getWantRight() ? $this$getMatchingSteps.scanDirectedStraight(tripleSpec) : CollectionsKt.emptyList())), (Iterable)(dirSpec.getWantLeft() && !dirSpec.getWantRight() ? $this$getMatchingSteps.scanDirectedFlipped(tripleSpec) : CollectionsKt.emptyList()));
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MatchResult evaluate(@NotNull Graph graph, @NotNull MatchSpec matchSpec) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)matchSpec, (String)"matchSpec");
        Iterable $this$map$iv = matchSpec.getStrides();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StrideSpec strideSpec = (StrideSpec)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.evaluateStride(graph, (StrideSpec)it));
        }
        List strideResults = (List)destination$iv$iv;
        return this.joinStridesOnBinders(strideResults);
    }

    private final StrideResult evaluateStride(Graph graph, StrideSpec stride) {
        if (stride.getElems().size() == 1) {
            return this.evaluateNodeStride(graph, stride);
        }
        StrideTree plan = this.planStride(stride);
        if (!Intrinsics.areEqual((Object)stride, (Object)this.restoreStrideSpec(plan))) {
            boolean bl = false;
            String string = "Bad stride plan, not equivalent to the original stride.";
            throw new IllegalStateException(string.toString());
        }
        return this.evaluatePlan(graph, plan);
    }

    /*
     * WARNING - void declaration
     */
    private final StrideResult evaluateNodeStride(Graph graph, StrideSpec stride) {
        Collection destination$iv$iv;
        StrideSpec strideSpec;
        if (!(stride.getElems().size() == 1)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        ElemSpec node = stride.getElems().get(0);
        if (node instanceof EdgeSpec) {
            throw new IllegalStateException("Bug: evaluateNodeStride should not be called on an EdgeSpec".toString());
        }
        if (node instanceof NodeSpec) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = CollectionsKt.toSet((Iterable)graph.scanNodes(((NodeSpec)node).getLabel()));
            strideSpec = stride;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Graph.Node node2 = (Graph.Node)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Stride(CollectionsKt.listOf((Object)it)));
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Set set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        StrideSpec strideSpec2 = strideSpec;
        return new StrideResult(strideSpec2, set2);
    }

    private final StrideTree planStride(StrideSpec stride) {
        if (!(stride.getElems().size() >= 3)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return GraphEngine.planStride$planRightLeaning(stride.getElems());
    }

    private final StrideSpec restoreStrideSpec(StrideTree strideTree) {
        return new StrideSpec(GraphEngine.restoreStrideSpec$restore(strideTree));
    }

    /*
     * WARNING - void declaration
     */
    private final StrideResult evaluatePlan(Graph graph, StrideTree plan) {
        StrideResult strideResult;
        StrideTree strideTree = plan;
        if (strideTree instanceof StrideLeaf) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Triple it;
            void $this$filterTo$iv$iv;
            List<ElemSpec> step = ((StrideLeaf)plan).getStride().getElems();
            if (!(step.size() == 3)) {
                boolean $i$a$-check-GraphEngine$evaluatePlan$22 = false;
                String $i$a$-check-GraphEngine$evaluatePlan$22 = "A leaf stride in a StrideTree plan must have exactly 3 elements";
                throw new IllegalStateException($i$a$-check-GraphEngine$evaluatePlan$22.toString());
            }
            NodeSpec lft = (NodeSpec)step.get(0);
            EdgeSpec edg = (EdgeSpec)step.get(1);
            NodeSpec rgt = (NodeSpec)step.get(2);
            StepSpec stepSpec = new StepSpec(edg.getDir(), (Triple<? extends LabelSpec, ? extends LabelSpec, ? extends LabelSpec>)new Triple((Object)lft.getLabel(), (Object)edg.getLabel(), (Object)rgt.getLabel()));
            List<Triple<Graph.Node, Graph.Edge, Graph.Node>> triples = this.getMatchingSteps(graph, stepSpec);
            Function1 bindCheck2 = lft.getBinder() != null && rgt.getBinder() != null && Intrinsics.areEqual((Object)lft.getBinder(), (Object)rgt.getBinder()) ? (Function1)evaluatePlan.bindCheck.1.INSTANCE : (Function1)evaluatePlan.bindCheck.2.INSTANCE;
            Iterable $this$filter$iv = triples;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Triple)element$iv$iv;
                boolean bl = false;
                if (!((Boolean)bindCheck2.invoke((Object)it)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List prunedTriples = (List)destination$iv$iv;
            $this$filter$iv = CollectionsKt.toSet((Iterable)prunedTriples);
            StrideSpec strideSpec = ((StrideLeaf)plan).getStride();
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Triple)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object[] objectArray = new Graph.Elem[]{(Graph.Elem)it.getFirst(), (Graph.Elem)it.getSecond(), (Graph.Elem)it.getThird()};
                collection.add(new Stride(CollectionsKt.listOf((Object[])objectArray)));
            }
            Set set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            StrideSpec strideSpec2 = strideSpec;
            strideResult = new StrideResult(strideSpec2, set2);
        } else if (strideTree instanceof StrideJoin) {
            strideResult = this.joinAdjacentStrides(this.evaluatePlan(graph, ((StrideJoin)plan).getLeft()), this.evaluatePlan(graph, ((StrideJoin)plan).getRight()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return strideResult;
    }

    @NotNull
    public final StrideResult joinAdjacentStrides(@NotNull StrideResult left, @NotNull StrideResult right) {
        List<ElemSpec> list;
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        List<ElemSpec> leftSpec = left.getSpec().getElems();
        List<ElemSpec> rightSpec = right.getSpec().getElems();
        if (!Intrinsics.areEqual((Object)CollectionsKt.last(leftSpec), (Object)CollectionsKt.first(rightSpec))) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(CollectionsKt.first(rightSpec) instanceof NodeSpec)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        Collection collection = leftSpec;
        List<ElemSpec> $this$tail$iv = rightSpec;
        boolean $i$f$getTail = false;
        switch ($this$tail$iv.size()) {
            case 0: 
            case 1: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                list = $this$tail$iv.subList(1, $this$tail$iv.size());
            }
        }
        List joinedSpec = CollectionsKt.plus((Collection)collection, (Iterable)list);
        Function2<Stride, Stride, Boolean> joinCondition = this.stridesJoinable(left.getSpec(), right.getSpec());
        Set joined = new LinkedHashSet();
        for (Stride lft : left.getResult()) {
            for (Stride rgt : right.getResult()) {
                List<Graph.Elem> list2;
                if (!((Boolean)joinCondition.invoke((Object)lft, (Object)rgt)).booleanValue()) continue;
                Collection collection2 = lft.getElems();
                List<Graph.Elem> $this$tail$iv2 = rgt.getElems();
                boolean $i$f$getTail2 = false;
                switch ($this$tail$iv2.size()) {
                    case 0: 
                    case 1: {
                        list2 = CollectionsKt.emptyList();
                        break;
                    }
                    default: {
                        list2 = $this$tail$iv2.subList(1, $this$tail$iv2.size());
                    }
                }
                joined.add(new Stride(CollectionsKt.plus((Collection)collection2, (Iterable)list2)));
            }
        }
        return new StrideResult(new StrideSpec(joinedSpec), CollectionsKt.toSet((Iterable)joined));
    }

    @NotNull
    public final Function2<Stride, Stride, Boolean> stridesJoinable(@NotNull StrideSpec leftSpec, @NotNull StrideSpec rightSpec) {
        Intrinsics.checkNotNullParameter((Object)leftSpec, (String)"leftSpec");
        Intrinsics.checkNotNullParameter((Object)rightSpec, (String)"rightSpec");
        Map joinVars = new LinkedHashMap();
        Iterator<ElemSpec> iterator2 = leftSpec.getElems().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int rgtIdx;
            int n2;
            String lftVar;
            int lftIdx;
            block5: {
                lftIdx = n++;
                ElemSpec lftEltSpec = iterator2.next();
                if (lftEltSpec.getBinder() == null) continue;
                boolean bl = false;
                if (joinVars.keySet().contains(lftVar)) continue;
                List<ElemSpec> $this$indexOfFirst$iv = rightSpec.getElems();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<ElemSpec> iterator3 = $this$indexOfFirst$iv.iterator();
                while (iterator3.hasNext()) {
                    boolean bl2;
                    ElemSpec item$iv;
                    ElemSpec rgtElem = item$iv = iterator3.next();
                    boolean bl3 = false;
                    if (rgtElem.getBinder() != null) {
                        String it;
                        boolean bl4 = false;
                        bl2 = Intrinsics.areEqual((Object)it, (Object)lftVar);
                    } else {
                        bl2 = false;
                    }
                    if (bl2) {
                        n2 = index$iv;
                        break block5;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            if ((rgtIdx = n2) == -1) continue;
            joinVars.put(lftVar, TuplesKt.to((Object)lftIdx, (Object)rgtIdx));
        }
        List joinPoints = CollectionsKt.plus(joinVars.values(), (Object)new Pair((Object)CollectionsKt.getLastIndex(leftSpec.getElems()), (Object)0));
        return (Function2)new Function2<Stride, Stride, Boolean>((List<Pair<Integer, Integer>>)joinPoints){
            final /* synthetic */ List<Pair<Integer, Integer>> $joinPoints;
            {
                this.$joinPoints = $joinPoints;
                super(2);
            }

            @NotNull
            public final Boolean invoke(@NotNull Stride leftStride, @NotNull Stride rightStride) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)leftStride, (String)"leftStride");
                    Intrinsics.checkNotNullParameter((Object)rightStride, (String)"rightStride");
                    Iterable $this$all$iv = this.$joinPoints;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            Pair pair = (Pair)element$iv;
                            boolean bl2 = false;
                            int lft = ((Number)pair.component1()).intValue();
                            int rgt = ((Number)pair.component2()).intValue();
                            if (Intrinsics.areEqual((Object)leftStride.getElems().get(lft), (Object)rightStride.getElems().get(rgt))) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl;
            }
        };
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final MatchResult joinStridesOnBinders(@NotNull List<StrideResult> strides) {
        Intrinsics.checkNotNullParameter(strides, (String)"strides");
        switch (strides.size()) {
            case 0: {
                throw new IllegalStateException("Bug: should not call joinStridesOnBinders on a zero-length list of stride results.".toString());
            }
            case 1: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                StrideResult strideResult = strides.get(0);
                StrideSpec spec = strideResult.component1();
                Set<Stride> res = strideResult.component2();
                Iterable iterable = res;
                List list = CollectionsKt.listOf((Object)spec);
                boolean $i$f$map = false;
                void var7_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (true) {
                    void it;
                    if (!iterator2.hasNext()) {
                        List list2 = (List)destination$iv$iv;
                        List list3 = list;
                        return new MatchResult(list3, list2);
                    }
                    Object item$iv$iv = iterator2.next();
                    Stride stride = (Stride)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(CollectionsKt.listOf((Object)it));
                }
            }
        }
        String string = "Later: non-trivial join of strides on binders (when there is two or more strides).";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private static final StrideLeaf planStride$leafFrom3(List<? extends ElemSpec> elems) {
        if (!(elems.get(0) instanceof NodeSpec)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(elems.get(1) instanceof EdgeSpec)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(elems.get(2) instanceof NodeSpec)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return new StrideLeaf(new StrideSpec(CollectionsKt.take((Iterable)elems, (int)3)));
    }

    private static final StrideTree planStride$planRightLeaning(List<? extends ElemSpec> elems) {
        StrideTree strideTree;
        switch (elems.size()) {
            case 0: 
            case 1: 
            case 2: {
                throw new IllegalStateException("Bug: planRightLeaning should not be called on a spec shorter than 3 ".toString());
            }
            case 3: {
                strideTree = GraphEngine.planStride$leafFrom3(elems);
                break;
            }
            default: {
                strideTree = new StrideJoin(GraphEngine.planStride$leafFrom3(elems), GraphEngine.planStride$planRightLeaning(CollectionsKt.drop((Iterable)elems, (int)2)));
            }
        }
        return strideTree;
    }

    private static final List<ElemSpec> restoreStrideSpec$restore(StrideTree tree) {
        List list;
        StrideTree strideTree = tree;
        if (strideTree instanceof StrideLeaf) {
            list = ((StrideLeaf)tree).getStride().getElems();
        } else if (strideTree instanceof StrideJoin) {
            List<ElemSpec> list2;
            List<ElemSpec> left = GraphEngine.restoreStrideSpec$restore(((StrideJoin)tree).getLeft());
            List<ElemSpec> right = GraphEngine.restoreStrideSpec$restore(((StrideJoin)tree).getRight());
            if (!(CollectionsKt.last(left) instanceof NodeSpec)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (!(CollectionsKt.first(right) instanceof NodeSpec)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (!Intrinsics.areEqual((Object)CollectionsKt.last(left), (Object)CollectionsKt.first(right))) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            Collection collection = left;
            List<ElemSpec> $this$tail$iv = right;
            boolean $i$f$getTail = false;
            switch ($this$tail$iv.size()) {
                case 0: 
                case 1: {
                    list2 = CollectionsKt.emptyList();
                    break;
                }
                default: {
                    list2 = $this$tail$iv.subList(1, $this$tail$iv.size());
                }
            }
            list = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }
}

