/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.syntax.impl;

import com.amazon.ion.IonSymbol;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazon.ion.system.IonSystemBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstNode;
import org.partiql.ast.helpers.ToLegacyAstKt;
import org.partiql.errors.ErrorCode;
import org.partiql.errors.Property;
import org.partiql.errors.PropertyValueMap;
import org.partiql.lang.ast.Meta;
import org.partiql.lang.ast.SourceLocationMeta;
import org.partiql.lang.domains.PartiqlAst;
import org.partiql.lang.domains.UtilKt;
import org.partiql.lang.syntax.Parser;
import org.partiql.lang.syntax.ParserException;
import org.partiql.parser.PartiQLLexerException;
import org.partiql.parser.PartiQLParser;
import org.partiql.parser.PartiQLParserException;
import org.partiql.parser.SourceLocation;
import org.partiql.parser.SourceLocations;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u000fH\u0002J(\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u00130\u0011*\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/partiql/lang/syntax/impl/PartiQLShimParser;", "Lorg/partiql/lang/syntax/Parser;", "delegate", "Lorg/partiql/parser/PartiQLParser;", "(Lorg/partiql/parser/PartiQLParser;)V", "ion", "Lcom/amazon/ion/IonSystem;", "kotlin.jvm.PlatformType", "parseAstStatement", "Lorg/partiql/lang/domains/PartiqlAst$Statement;", "source", "", "shim", "Lorg/partiql/lang/syntax/ParserException;", "Lorg/partiql/parser/PartiQLLexerException;", "Lorg/partiql/parser/PartiQLParserException;", "toMetas", "", "", "Lcom/amazon/ionelement/api/MetaContainer;", "Lorg/partiql/parser/SourceLocations;", "partiql-lang"})
public final class PartiQLShimParser
implements Parser {
    @NotNull
    private final PartiQLParser delegate;
    private final IonSystem ion;

    public PartiQLShimParser(@NotNull PartiQLParser delegate2) {
        Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
        this.delegate = delegate2;
        this.ion = IonSystemBuilder.standard().build();
    }

    @Override
    @NotNull
    public PartiqlAst.Statement parseAstStatement(@NotNull String source) {
        PartiqlAst.PartiqlAstNode partiqlAstNode;
        PartiQLParser.Result result;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            result = this.delegate.parse(source);
        }
        catch (PartiQLLexerException ex) {
            throw this.shim(ex);
        }
        catch (PartiQLParserException ex) {
            throw this.shim(ex);
        }
        PartiQLParser.Result result2 = result;
        try {
            Map<String, Map<String, Object>> metas = this.toMetas(result2.getLocations());
            partiqlAstNode = ToLegacyAstKt.toLegacyAst((AstNode)((AstNode)result2.getRoot()), metas);
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            if (string == null) {
                string = "";
            }
            throw new ParserException(string, ErrorCode.PARSE_INVALID_QUERY, null, ex, 4, null);
        }
        PartiqlAst.PartiqlAstNode statement = partiqlAstNode;
        if (!(statement instanceof PartiqlAst.Statement)) {
            throw new ParserException("Expected statement, got " + Reflection.getOrCreateKotlinClass(statement.getClass()).getQualifiedName(), ErrorCode.PARSE_INVALID_QUERY, null, null, 12, null);
        }
        return (PartiqlAst.Statement)statement;
    }

    private final ParserException shim(PartiQLLexerException $this$shim) {
        PropertyValueMap ctx = new PropertyValueMap(null, 1, null);
        ctx.set(Property.LINE_NUMBER, (long)$this$shim.getLocation().getLine());
        ctx.set(Property.COLUMN_NUMBER, (long)$this$shim.getLocation().getOffset());
        ctx.set(Property.TOKEN_STRING, $this$shim.getToken());
        ctx.set(Property.TOKEN_DESCRIPTION, $this$shim.getTokenType());
        IonSymbol ionSymbol = this.ion.newSymbol($this$shim.getToken());
        Intrinsics.checkNotNullExpressionValue((Object)ionSymbol, (String)"ion.newSymbol(token)");
        ctx.set(Property.TOKEN_VALUE, (IonValue)ionSymbol);
        return new ParserException($this$shim.getMessage(), ErrorCode.PARSE_UNEXPECTED_TOKEN, ctx, $this$shim.getCause());
    }

    private final ParserException shim(PartiQLParserException $this$shim) {
        PropertyValueMap ctx = new PropertyValueMap(null, 1, null);
        ctx.set(Property.LINE_NUMBER, (long)$this$shim.getLocation().getLine());
        ctx.set(Property.COLUMN_NUMBER, (long)$this$shim.getLocation().getOffset());
        ctx.set(Property.TOKEN_DESCRIPTION, $this$shim.getTokenType());
        IonSymbol ionSymbol = this.ion.newSymbol($this$shim.getToken());
        Intrinsics.checkNotNullExpressionValue((Object)ionSymbol, (String)"ion.newSymbol(token)");
        ctx.set(Property.TOKEN_VALUE, (IonValue)ionSymbol);
        return new ParserException($this$shim.getMessage(), ErrorCode.PARSE_UNEXPECTED_TOKEN, ctx, $this$shim.getCause());
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Map<String, Object>> toMetas(SourceLocations $this$toMetas) {
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv = (Map)$this$toMetas;
        boolean $i$f$mapValues = false;
        Map map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Meta[] metaArray = new Meta[]{(Meta)new SourceLocationMeta((long)((SourceLocation)it.getValue()).getLine(), (long)((SourceLocation)it.getValue()).getOffset(), (long)((SourceLocation)it.getValue()).getLengthLegacy())};
            Map<String, Object> map5 = UtilKt.metaContainerOf(metaArray);
            map4.put(k, map5);
        }
        return destination$iv$iv;
    }
}

