/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.util;

import com.amazon.ion.Decimal;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazon.ion.ValueFactory;
import com.amazon.ion.system.IonSystemBuilder;
import com.amazon.ionelement.api.DecimalElement;
import com.amazon.ionelement.api.ElementLoader;
import com.amazon.ionelement.api.Ion;
import com.amazon.ionelement.api.IonElement;
import com.amazon.ionelement.api.IonUtils;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.errors.ErrorCode;
import org.partiql.errors.Property;
import org.partiql.errors.PropertyValueMap;
import org.partiql.lang.syntax.ParserException;
import org.partiql.parser.antlr.PartiQLParser;
import org.partiql.parser.thirdparty.antlr.v4.runtime.Token;
import org.partiql.parser.thirdparty.antlr.v4.runtime.tree.TerminalNode;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a4\u0010\t\u001a\u00020\n*\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u001a4\u0010\t\u001a\u00020\n*\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u001a\f\u0010\u0014\u001a\u00020\f*\u00020\u0015H\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"ion", "Lcom/amazon/ion/IonSystem;", "kotlin.jvm.PlatformType", "getIonElement", "Lcom/amazon/ionelement/api/IonElement;", "token", "Lorg/partiql/parser/thirdparty/antlr/v4/runtime/Token;", "getIonValue", "Lcom/amazon/ion/IonValue;", "error", "Lorg/partiql/lang/syntax/ParserException;", "message", "", "errorCode", "Lorg/partiql/errors/ErrorCode;", "errorContext", "Lorg/partiql/errors/PropertyValueMap;", "cause", "", "Lorg/partiql/parser/thirdparty/antlr/v4/runtime/tree/TerminalNode;", "getAntlrDisplayString", "", "partiql-lang"})
public final class AntlrUtilitiesKt {
    private static final IonSystem ion = IonSystemBuilder.standard().build();

    @NotNull
    public static final ParserException error(@Nullable TerminalNode $this$error, @NotNull String message, @NotNull ErrorCode errorCode, @NotNull PropertyValueMap errorContext, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        Intrinsics.checkNotNullParameter((Object)errorContext, (String)"errorContext");
        return $this$error == null ? new ParserException(null, errorCode, errorContext, cause, 1, null) : AntlrUtilitiesKt.error($this$error.getSymbol(), message, errorCode, errorContext, cause);
    }

    public static /* synthetic */ ParserException error$default(TerminalNode terminalNode, String string, ErrorCode errorCode, PropertyValueMap propertyValueMap, Throwable throwable, int n, Object object) {
        if ((n & 4) != 0) {
            propertyValueMap = new PropertyValueMap(null, 1, null);
        }
        if ((n & 8) != 0) {
            throwable = null;
        }
        return AntlrUtilitiesKt.error(terminalNode, string, errorCode, propertyValueMap, throwable);
    }

    @NotNull
    public static final ParserException error(@Nullable Token $this$error, @NotNull String message, @NotNull ErrorCode errorCode, @NotNull PropertyValueMap errorContext, @Nullable Throwable cause) {
        ParserException parserException;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        Intrinsics.checkNotNullParameter((Object)errorContext, (String)"errorContext");
        if ($this$error == null) {
            parserException = new ParserException(null, errorCode, errorContext, cause, 1, null);
        } else {
            errorContext.set(Property.LINE_NUMBER, (long)$this$error.getLine());
            errorContext.set(Property.COLUMN_NUMBER, (long)$this$error.getCharPositionInLine() + 1L);
            errorContext.set(Property.TOKEN_DESCRIPTION, AntlrUtilitiesKt.getAntlrDisplayString($this$error.getType()));
            errorContext.set(Property.TOKEN_VALUE, AntlrUtilitiesKt.getIonValue($this$error));
            parserException = new ParserException(message, errorCode, errorContext, cause);
        }
        return parserException;
    }

    public static /* synthetic */ ParserException error$default(Token token, String string, ErrorCode errorCode, PropertyValueMap propertyValueMap, Throwable throwable, int n, Object object) {
        if ((n & 4) != 0) {
            propertyValueMap = new PropertyValueMap(null, 1, null);
        }
        if ((n & 8) != 0) {
            throwable = null;
        }
        return AntlrUtilitiesKt.error(token, string, errorCode, propertyValueMap, throwable);
    }

    @NotNull
    public static final IonValue getIonValue(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        IonElement ionElement = AntlrUtilitiesKt.getIonElement(token);
        IonSystem ionSystem = ion;
        Intrinsics.checkNotNullExpressionValue((Object)ionSystem, (String)"ion");
        return IonUtils.toIonValue((IonElement)ionElement, (ValueFactory)((ValueFactory)ionSystem));
    }

    @NotNull
    public static final IonElement getIonElement(@NotNull Token token) {
        IonElement ionElement;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        int type = token.getType();
        String text = token.getText();
        switch (type) {
            case -1: {
                ionElement = (IonElement)Ion.ionSymbol$default((String)"EOF", null, null, (int)6, null);
                break;
            }
            case 309: {
                Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                char[] cArray = new char[]{'`'};
                String string = StringsKt.trimStart((String)text, (char[])cArray);
                cArray = new char[]{'`'};
                ionElement = (IonElement)ElementLoader.loadSingleElement$default((String)StringsKt.trimEnd((String)string, (char[])cArray), null, (int)2, null);
                break;
            }
            case 208: {
                ionElement = (IonElement)Ion.ionBool$default((boolean)true, null, null, (int)6, null);
                break;
            }
            case 88: {
                ionElement = (IonElement)Ion.ionBool$default((boolean)false, null, null, (int)6, null);
                break;
            }
            case 141: {
                ionElement = Ion.ionNull$default(null, null, null, (int)7, null);
                break;
            }
            case 142: {
                ionElement = (IonElement)Ion.ionSymbol$default((String)"nulls", null, null, (int)6, null);
                break;
            }
            case 236: {
                ionElement = Ion.ionNull$default(null, null, null, (int)7, null);
                break;
            }
            case 300: {
                Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                char[] cArray = new char[]{'\''};
                ionElement = (IonElement)Ion.ionString$default((String)StringsKt.replace$default((String)StringsKt.trim((String)text, (char[])cArray), (String)"''", (String)"'", (boolean)false, (int)4, null), null, null, (int)6, null);
                break;
            }
            case 301: {
                ionElement = (IonElement)Ion.ionInt$default((BigInteger)new BigInteger(text, 10), null, null, (int)6, null);
                break;
            }
            case 302: {
                DecimalElement decimalElement;
                try {
                    Decimal decimal = Decimal.valueOf((String)text);
                    Intrinsics.checkNotNullExpressionValue((Object)decimal, (String)"valueOf(text)");
                    decimalElement = Ion.ionDecimal$default((Decimal)decimal, null, null, (int)6, null);
                }
                catch (NumberFormatException e) {
                    String string = e.getLocalizedMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.localizedMessage");
                    throw AntlrUtilitiesKt.error$default(token, string, ErrorCode.PARSE_EXPECTED_NUMBER, null, (Throwable)e, 4, null);
                }
                ionElement = (IonElement)decimalElement;
                break;
            }
            case 304: {
                Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                char[] cArray = new char[]{'\"'};
                ionElement = (IonElement)Ion.ionSymbol$default((String)StringsKt.replace$default((String)StringsKt.trim((String)text, (char[])cArray), (String)"\"\"", (String)"\"", (boolean)false, (int)4, null), null, null, (int)6, null);
                break;
            }
            default: {
                Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                ionElement = (IonElement)Ion.ionSymbol$default((String)text, null, null, (int)6, null);
            }
        }
        return ionElement;
    }

    @NotNull
    public static final String getAntlrDisplayString(int $this$getAntlrDisplayString) {
        String string = PartiQLParser.VOCABULARY.getSymbolicName($this$getAntlrDisplayString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VOCABULARY.getSymbolicName(this)");
        return string;
    }
}

