/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.util;

import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazon.ion.system.IonSystemBuilder;
import com.amazon.ion.system.IonTextWriterBuilder;
import java.math.BigDecimal;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.ExprValueType;
import org.partiql.lang.eval.time.Time;
import org.partiql.lang.graph.Graph;
import org.partiql.lang.util.ExprValueFormatter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0003\f\r\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/partiql/lang/util/ConfigurableExprValueFormatter;", "Lorg/partiql/lang/util/ExprValueFormatter;", "config", "Lorg/partiql/lang/util/ConfigurableExprValueFormatter$Configuration;", "(Lorg/partiql/lang/util/ConfigurableExprValueFormatter$Configuration;)V", "formatTo", "", "value", "Lorg/partiql/lang/eval/ExprValue;", "out", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "Companion", "Configuration", "PrettyFormatter", "partiql-lang"})
public final class ConfigurableExprValueFormatter
implements ExprValueFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Configuration config;
    @NotNull
    private static final ConfigurableExprValueFormatter pretty = new ConfigurableExprValueFormatter(new Configuration("  ", "\n"));
    @NotNull
    private static final ConfigurableExprValueFormatter standard = new ConfigurableExprValueFormatter(new Configuration("", ""));

    public ConfigurableExprValueFormatter(@NotNull Configuration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    @Override
    public void formatTo(@NotNull ExprValue value, @NotNull Appendable out) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        new PrettyFormatter(out, this.config).recursivePrettyPrint(value);
    }

    @Override
    @NotNull
    public String format(@NotNull ExprValue value) {
        return ExprValueFormatter.DefaultImpls.format(this, value);
    }

    @NotNull
    public static final ConfigurableExprValueFormatter getPretty() {
        return Companion.getPretty();
    }

    @NotNull
    public static final ConfigurableExprValueFormatter getStandard() {
        return Companion.getStandard();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/partiql/lang/util/ConfigurableExprValueFormatter$Companion;", "", "()V", "pretty", "Lorg/partiql/lang/util/ConfigurableExprValueFormatter;", "getPretty$annotations", "getPretty", "()Lorg/partiql/lang/util/ConfigurableExprValueFormatter;", "standard", "getStandard$annotations", "getStandard", "partiql-lang"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConfigurableExprValueFormatter getPretty() {
            return pretty;
        }

        @JvmStatic
        public static /* synthetic */ void getPretty$annotations() {
        }

        @NotNull
        public final ConfigurableExprValueFormatter getStandard() {
            return standard;
        }

        @JvmStatic
        public static /* synthetic */ void getStandard$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/partiql/lang/util/ConfigurableExprValueFormatter$Configuration;", "", "indentation", "", "containerValueSeparator", "(Ljava/lang/String;Ljava/lang/String;)V", "getContainerValueSeparator", "()Ljava/lang/String;", "getIndentation", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "partiql-lang"})
    public static final class Configuration {
        @NotNull
        private final String indentation;
        @NotNull
        private final String containerValueSeparator;

        public Configuration(@NotNull String indentation, @NotNull String containerValueSeparator) {
            Intrinsics.checkNotNullParameter((Object)indentation, (String)"indentation");
            Intrinsics.checkNotNullParameter((Object)containerValueSeparator, (String)"containerValueSeparator");
            this.indentation = indentation;
            this.containerValueSeparator = containerValueSeparator;
        }

        @NotNull
        public final String getIndentation() {
            return this.indentation;
        }

        @NotNull
        public final String getContainerValueSeparator() {
            return this.containerValueSeparator;
        }

        @NotNull
        public final String component1() {
            return this.indentation;
        }

        @NotNull
        public final String component2() {
            return this.containerValueSeparator;
        }

        @NotNull
        public final Configuration copy(@NotNull String indentation, @NotNull String containerValueSeparator) {
            Intrinsics.checkNotNullParameter((Object)indentation, (String)"indentation");
            Intrinsics.checkNotNullParameter((Object)containerValueSeparator, (String)"containerValueSeparator");
            return new Configuration(indentation, containerValueSeparator);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = configuration.indentation;
            }
            if ((n & 2) != 0) {
                string2 = configuration.containerValueSeparator;
            }
            return configuration.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Configuration(indentation=" + this.indentation + ", containerValueSeparator=" + this.containerValueSeparator + ')';
        }

        public int hashCode() {
            int result = this.indentation.hashCode();
            result = result * 31 + this.containerValueSeparator.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Configuration)) {
                return false;
            }
            Configuration configuration = (Configuration)other;
            if (!Intrinsics.areEqual((Object)this.indentation, (Object)configuration.indentation)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.containerValueSeparator, (Object)configuration.containerValueSeparator);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J6\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00120\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u001c\u001a\u00020\u0012H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/partiql/lang/util/ConfigurableExprValueFormatter$PrettyFormatter;", "", "out", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "config", "Lorg/partiql/lang/util/ConfigurableExprValueFormatter$Configuration;", "(Ljava/lang/Appendable;Lorg/partiql/lang/util/ConfigurableExprValueFormatter$Configuration;)V", "getConfig", "()Lorg/partiql/lang/util/ConfigurableExprValueFormatter$Configuration;", "currentIndentation", "", "ion", "Lcom/amazon/ion/IonSystem;", "kotlin.jvm.PlatformType", "getOut", "()Ljava/lang/Appendable;", "prettyPrintContainer", "", "value", "Lorg/partiql/lang/eval/ExprValue;", "openingMarker", "", "closingMarker", "prettyPrintElement", "Lkotlin/Function1;", "prettyPrintIonLiteral", "recursivePrettyPrint", "writeIndentation", "partiql-lang"})
    private static final class PrettyFormatter {
        @NotNull
        private final Appendable out;
        @NotNull
        private final Configuration config;
        private final IonSystem ion;
        private int currentIndentation;

        public PrettyFormatter(@NotNull Appendable out, @NotNull Configuration config) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.out = out;
            this.config = config;
            this.ion = IonSystemBuilder.standard().build();
        }

        @NotNull
        public final Appendable getOut() {
            return this.out;
        }

        @NotNull
        public final Configuration getConfig() {
            return this.config;
        }

        public final void recursivePrettyPrint(@NotNull ExprValue value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            switch (WhenMappings.$EnumSwitchMapping$0[value.getType().ordinal()]) {
                case 1: {
                    this.out.append("MISSING");
                    break;
                }
                case 2: {
                    this.out.append("NULL");
                    break;
                }
                case 3: {
                    this.out.append(String.valueOf(value.getScalar().booleanValue()));
                    break;
                }
                case 4: {
                    this.out.append(String.valueOf(value.getScalar().numberValue()));
                    break;
                }
                case 5: {
                    Number number = value.getScalar().numberValue();
                    BigDecimal decimalValue = number instanceof BigDecimal ? (BigDecimal)number : null;
                    this.out.append(String.valueOf(decimalValue));
                    if (decimalValue == null || decimalValue.scale() != 0) break;
                    this.out.append(".");
                    break;
                }
                case 6: {
                    this.out.append('\'' + value.getScalar().stringValue() + '\'');
                    break;
                }
                case 7: {
                    this.out.append("DATE '" + ExprValueExtensionsKt.dateValue(value) + '\'');
                    break;
                }
                case 8: {
                    Time time = ExprValueExtensionsKt.timeValue(value);
                    String prefix = time.getOffsetTime() == null ? "TIME" : "TIME WITH TIME ZONE";
                    this.out.append(prefix + " '" + time + '\'');
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    this.prettyPrintIonLiteral(value);
                    break;
                }
                case 15: {
                    PrettyFormatter.prettyPrintContainer$default(this, value, "[", "]", null, 8, null);
                    break;
                }
                case 16: {
                    PrettyFormatter.prettyPrintContainer$default(this, value, "<<", ">>", null, 8, null);
                    break;
                }
                case 17: {
                    this.prettyPrintContainer(value, "{", "}", (Function1<? super ExprValue, Unit>)((Function1)new Function1<ExprValue, Unit>(this){
                        final /* synthetic */ PrettyFormatter this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull ExprValue v) {
                            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                            ExprValue exprValue2 = ExprValueExtensionsKt.getName(v);
                            Intrinsics.checkNotNull((Object)exprValue2);
                            String fieldName = exprValue2.getScalar().stringValue();
                            this.this$0.getOut().append('\'' + fieldName + "': ");
                            this.this$0.recursivePrettyPrint(v);
                        }
                    }));
                    break;
                }
                case 18: {
                    Graph g = value.getGraphValue();
                    this.out.append("graph{" + g + '}');
                }
            }
        }

        private final void prettyPrintContainer(ExprValue value, String openingMarker, String closingMarker, Function1<? super ExprValue, Unit> prettyPrintElement) {
            Iterator<ExprValue> iterator2 = value.iterator();
            if (iterator2.hasNext()) {
                this.out.append(openingMarker).append(this.config.getContainerValueSeparator());
                ++this.currentIndentation;
                ExprValue firstElement = iterator2.next();
                this.writeIndentation();
                prettyPrintElement.invoke((Object)firstElement);
                Iterator<ExprValue> $this$forEach$iv = iterator2;
                boolean $i$f$forEach = false;
                Iterator<ExprValue> iterator3 = $this$forEach$iv;
                while (iterator3.hasNext()) {
                    ExprValue element$iv;
                    ExprValue v = element$iv = iterator3.next();
                    boolean bl = false;
                    this.out.append(",");
                    if (((CharSequence)this.config.getContainerValueSeparator()).length() == 0) {
                        this.out.append(" ");
                    } else {
                        this.out.append(this.config.getContainerValueSeparator());
                    }
                    this.writeIndentation();
                    prettyPrintElement.invoke((Object)v);
                }
                --this.currentIndentation;
                this.out.append(this.config.getContainerValueSeparator());
                this.writeIndentation();
                this.out.append(closingMarker);
            } else {
                this.out.append(openingMarker).append(closingMarker);
            }
        }

        static /* synthetic */ void prettyPrintContainer$default(PrettyFormatter prettyFormatter, ExprValue exprValue2, String string, String string2, Function1 function1, int n, Object object) {
            if ((n & 8) != 0) {
                function1 = (Function1)new Function1<ExprValue, Unit>(prettyFormatter){
                    final /* synthetic */ PrettyFormatter this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull ExprValue v) {
                        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                        this.this$0.recursivePrettyPrint(v);
                    }
                };
            }
            prettyFormatter.prettyPrintContainer(exprValue2, string, string2, (Function1<? super ExprValue, Unit>)function1);
        }

        private final void prettyPrintIonLiteral(ExprValue value) {
            IonSystem ionSystem = this.ion;
            Intrinsics.checkNotNullExpressionValue((Object)ionSystem, (String)"ion");
            IonValue ionValue = ExprValueExtensionsKt.toIonValue(value, ionSystem);
            this.out.append("`");
            ionValue.writeTo(IonTextWriterBuilder.standard().build(this.out));
            this.out.append("`");
        }

        private final void writeIndentation() {
            if (((CharSequence)this.config.getIndentation()).length() > 0) {
                Iterable $this$forEach$iv = (Iterable)new IntRange(1, this.currentIndentation);
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl = false;
                    this.out.append(this.config.getIndentation());
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ExprValueType.values().length];
                nArray[ExprValueType.MISSING.ordinal()] = 1;
                nArray[ExprValueType.NULL.ordinal()] = 2;
                nArray[ExprValueType.BOOL.ordinal()] = 3;
                nArray[ExprValueType.INT.ordinal()] = 4;
                nArray[ExprValueType.DECIMAL.ordinal()] = 5;
                nArray[ExprValueType.STRING.ordinal()] = 6;
                nArray[ExprValueType.DATE.ordinal()] = 7;
                nArray[ExprValueType.TIME.ordinal()] = 8;
                nArray[ExprValueType.FLOAT.ordinal()] = 9;
                nArray[ExprValueType.TIMESTAMP.ordinal()] = 10;
                nArray[ExprValueType.SYMBOL.ordinal()] = 11;
                nArray[ExprValueType.CLOB.ordinal()] = 12;
                nArray[ExprValueType.BLOB.ordinal()] = 13;
                nArray[ExprValueType.SEXP.ordinal()] = 14;
                nArray[ExprValueType.LIST.ordinal()] = 15;
                nArray[ExprValueType.BAG.ordinal()] = 16;
                nArray[ExprValueType.STRUCT.ordinal()] = 17;
                nArray[ExprValueType.GRAPH.ordinal()] = 18;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

