/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.util;

import com.amazon.ion.Decimal;
import com.amazon.ion.IonDecimal;
import com.amazon.ion.IonFloat;
import com.amazon.ion.IonInt;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.partiql.errors.ErrorCode;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.util.NumberExtensionsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\bH\u0000\u001a\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0011\u001a\u00020\bH\u0000\u001a\"\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004\u001a\u0014\u0010\u0018\u001a\u00020\u0004*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u001a\u0014\u0010\u001b\u001a\u00020\u0004*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u001a\u0014\u0010\u001c\u001a\u00020\u0004*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u001a\u0014\u0010\u001d\u001a\u00020\u0004*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u001a'\u0010\u001e\u001a\u0002H\u001f\"\b\b\u0000\u0010\u001f*\u00020\u0004*\u00020\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0\u0003\u00a2\u0006\u0002\u0010!\u001a\u0015\u0010\"\u001a\u00020#*\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0086\u0002\u001a\u0015\u0010$\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0086\u0002\u001a\u0014\u0010%\u001a\u00020\u000f*\u00020\u000f2\b\b\u0002\u0010&\u001a\u00020\b\u001a\u0014\u0010'\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010&\u001a\u00020\bH\u0002\u001a\u0014\u0010(\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010&\u001a\u00020\bH\u0002\u001a\f\u0010)\u001a\u00020**\u00020\u0004H\u0000\u001a\u001c\u0010+\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010,\u001a\u00020#2\u0006\u0010&\u001a\u00020\bH\u0002\u001a\u0012\u0010-\u001a\u00020.*\u00020\u00042\u0006\u0010/\u001a\u000200\u001a\f\u00101\u001a\u00020\n*\u00020\u0004H\u0000\u001a\u0014\u00102\u001a\u00020\u000f*\u00020\u000f2\b\b\u0002\u0010&\u001a\u00020\b\u001a\u0014\u00103\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010&\u001a\u00020\bH\u0002\u001a\u0015\u00104\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0086\u0002\u001a\u0015\u00105\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0086\u0002\u001a\u001c\u00106\u001a\u00020\u000f*\u00020\u000f2\u0006\u00106\u001a\u00020\u000f2\b\b\u0002\u0010&\u001a\u00020\b\u001a\u0015\u00107\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0086\u0002\u001a\u0014\u00108\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010&\u001a\u00020\bH\u0002\u001a\u0014\u00109\u001a\u00020\u000f*\u00020\u000f2\b\b\u0002\u0010&\u001a\u00020\b\u001a\u0015\u0010:\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0086\u0002\u001a\r\u0010;\u001a\u00020<*\u00020<H\u0086\u0002\u001a\r\u0010;\u001a\u00020\u0004*\u00020\u0004H\u0086\u0002\",\u0010\u0000\u001a \u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"*\u0010\u0005\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00060\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\t\u001a\u00020\n*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\"\u0015\u0010\f\u001a\u00020\n*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000b\"\u0015\u0010\r\u001a\u00020\n*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006="}, d2={"CONVERSION_MAP", "", "", "Ljava/lang/Class;", "", "CONVERTERS", "Lkotlin/Function1;", "MATH_CONTEXT", "Ljava/math/MathContext;", "isNaN", "", "(Ljava/lang/Number;)Z", "isNegInf", "isPosInf", "bigDecimalOf", "Ljava/math/BigDecimal;", "num", "mc", "text", "", "coerceNumbers", "Lkotlin/Pair;", "first", "second", "checkOverflowDivision", "", "other", "checkOverflowMinus", "checkOverflowPlus", "checkOverflowTimes", "coerce", "T", "type", "(Ljava/lang/Number;Ljava/lang/Class;)Ljava/lang/Number;", "compareTo", "", "div", "exp", "mathContext", "expHelper", "expTaylor", "exprValue", "Lorg/partiql/lang/eval/ExprValue;", "intRoot", "root", "ionValue", "Lcom/amazon/ion/IonValue;", "ion", "Lcom/amazon/ion/IonSystem;", "isZero", "ln", "lnNewton", "minus", "plus", "power", "rem", "roundToDigits", "squareRoot", "times", "unaryMinus", "Lcom/amazon/ion/Decimal;", "partiql-lang"})
public final class NumberExtensionsKt {
    @NotNull
    private static final MathContext MATH_CONTEXT = new MathContext(38, RoundingMode.HALF_EVEN);
    @NotNull
    private static final Map<Set<Class<?>>, Class<? extends Number>> CONVERSION_MAP;
    @NotNull
    private static final Map<Class<?>, Function1<Number, Number>> CONVERTERS;

    @NotNull
    public static final BigDecimal bigDecimalOf(@NotNull Number num, @NotNull MathContext mc) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)num, (String)"num");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        Number number = num;
        if (number instanceof Decimal) {
            bigDecimal = (BigDecimal)num;
        } else if (number instanceof Integer) {
            bigDecimal = new BigDecimal(num.intValue(), mc);
        } else if (number instanceof Long) {
            bigDecimal = new BigDecimal(num.longValue(), mc);
        } else if (number instanceof Double) {
            bigDecimal = new BigDecimal(num.doubleValue(), mc);
        } else if (number instanceof BigDecimal) {
            bigDecimal = (BigDecimal)num;
        } else if (Intrinsics.areEqual((Object)number, (Object)Decimal.NEGATIVE_ZERO)) {
            bigDecimal = (BigDecimal)((Decimal)num);
        } else {
            throw new IllegalArgumentException("Unsupported number type: " + num + ", " + num.getClass());
        }
        return bigDecimal;
    }

    public static /* synthetic */ BigDecimal bigDecimalOf$default(Number number, MathContext mathContext, int n, Object object) {
        if ((n & 2) != 0) {
            mathContext = MATH_CONTEXT;
        }
        return NumberExtensionsKt.bigDecimalOf(number, mathContext);
    }

    @NotNull
    public static final BigDecimal bigDecimalOf(@NotNull String text, @NotNull MathContext mc) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        return new BigDecimal(((Object)StringsKt.trim((CharSequence)text)).toString(), mc);
    }

    public static /* synthetic */ BigDecimal bigDecimalOf$default(String string, MathContext mathContext, int n, Object object) {
        if ((n & 2) != 0) {
            mathContext = MATH_CONTEXT;
        }
        return NumberExtensionsKt.bigDecimalOf(string, mathContext);
    }

    public static final boolean isZero(@NotNull Number $this$isZero) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isZero, (String)"<this>");
        Number number = $this$isZero;
        if (number instanceof Long) {
            bl = Intrinsics.areEqual((Object)$this$isZero, (Object)0L);
        } else if (number instanceof Double) {
            bl = $this$isZero.doubleValue() == 0.0 || $this$isZero.doubleValue() == -0.0;
        } else if (number instanceof BigDecimal) {
            bl = BigDecimal.ZERO.compareTo((BigDecimal)$this$isZero) == 0;
        } else {
            throw new IllegalStateException();
        }
        return bl;
    }

    @NotNull
    public static final <T extends Number> T coerce(@NotNull Number $this$coerce, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter((Object)$this$coerce, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Function1<Number, Number> function1 = CONVERTERS.get(type);
        if (function1 == null) {
            throw new IllegalArgumentException("No converter for " + type);
        }
        Function1<Number, Number> conv = function1;
        return (T)((Number)conv.invoke((Object)$this$coerce));
    }

    @NotNull
    public static final Pair<Number, Number> coerceNumbers(@NotNull Number first, @NotNull Number second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        Object[] objectArray = new Class[]{NumberExtensionsKt.coerceNumbers$typeFor(first), NumberExtensionsKt.coerceNumbers$typeFor(second)};
        Class<? extends Number> clazz = CONVERSION_MAP.get(SetsKt.setOf((Object[])objectArray));
        if (clazz == null) {
            throw new IllegalArgumentException("No coercion support for " + NumberExtensionsKt.coerceNumbers$typeFor(first) + " to " + NumberExtensionsKt.coerceNumbers$typeFor(second));
        }
        Class<? extends Number> type = clazz;
        return new Pair((Object)NumberExtensionsKt.coerce(first, type), (Object)NumberExtensionsKt.coerce(second, type));
    }

    @NotNull
    public static final IonValue ionValue(@NotNull Number $this$ionValue, @NotNull IonSystem ion) {
        IonValue ionValue;
        Intrinsics.checkNotNullParameter((Object)$this$ionValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ion, (String)"ion");
        Number number = $this$ionValue;
        if (number instanceof Long) {
            IonInt ionInt = ion.newInt($this$ionValue.longValue());
            Intrinsics.checkNotNullExpressionValue((Object)ionInt, (String)"ion.newInt(this)");
            ionValue = (IonValue)ionInt;
        } else if (number instanceof BigInteger) {
            IonInt ionInt = ion.newInt($this$ionValue);
            Intrinsics.checkNotNullExpressionValue((Object)ionInt, (String)"ion.newInt(this)");
            ionValue = (IonValue)ionInt;
        } else if (number instanceof Double) {
            IonFloat ionFloat = ion.newFloat($this$ionValue.doubleValue());
            Intrinsics.checkNotNullExpressionValue((Object)ionFloat, (String)"ion.newFloat(this)");
            ionValue = (IonValue)ionFloat;
        } else if (number instanceof BigDecimal) {
            IonDecimal ionDecimal = ion.newDecimal((BigDecimal)$this$ionValue);
            Intrinsics.checkNotNullExpressionValue((Object)ionDecimal, (String)"ion.newDecimal(this)");
            ionValue = (IonValue)ionDecimal;
        } else {
            throw new IllegalArgumentException("Cannot convert to IonValue: " + $this$ionValue);
        }
        return ionValue;
    }

    @NotNull
    public static final ExprValue exprValue(@NotNull Number $this$exprValue) {
        ExprValue exprValue2;
        Intrinsics.checkNotNullParameter((Object)$this$exprValue, (String)"<this>");
        Number number = $this$exprValue;
        if (number instanceof Integer) {
            exprValue2 = ExprValue.Companion.newInt($this$exprValue.intValue());
        } else if (number instanceof Long) {
            exprValue2 = ExprValue.Companion.newInt($this$exprValue.longValue());
        } else if (number instanceof Double) {
            exprValue2 = ExprValue.Companion.newFloat($this$exprValue.doubleValue());
        } else if (number instanceof BigDecimal) {
            exprValue2 = ExprValue.Companion.newDecimal((BigDecimal)$this$exprValue);
        } else {
            ExceptionsKt.errNoContext("Cannot convert number to expression value: " + $this$exprValue, ErrorCode.EVALUATOR_INVALID_CONVERSION, true);
            throw new KotlinNothingValueException();
        }
        return exprValue2;
    }

    @NotNull
    public static final Decimal unaryMinus(@NotNull Decimal $this$unaryMinus) {
        Decimal decimal;
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        if (NumberExtensionsKt.isZero((Number)$this$unaryMinus)) {
            Decimal decimal2 = Decimal.negativeZero((int)$this$unaryMinus.scale());
            decimal = decimal2;
            Intrinsics.checkNotNullExpressionValue((Object)decimal2, (String)"negativeZero(this.scale())");
        } else {
            Decimal decimal3 = Decimal.valueOf((BigDecimal)$this$unaryMinus.negate());
            decimal = decimal3;
            Intrinsics.checkNotNullExpressionValue((Object)decimal3, (String)"valueOf(negate())");
        }
        return decimal;
    }

    @NotNull
    public static final Number unaryMinus(@NotNull Number $this$unaryMinus) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        Number number2 = $this$unaryMinus;
        if (number2 instanceof Long) {
            Number number3 = Intrinsics.areEqual((Object)$this$unaryMinus, (Object)Long.MIN_VALUE) ? BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE) : Long.valueOf(-$this$unaryMinus.longValue());
            Intrinsics.checkNotNullExpressionValue((Object)number3, (String)"if (this == Long.MIN_VAL\u2026igInteger.ONE) else -this");
            number = number3;
        } else if (number2 instanceof BigInteger) {
            BigInteger bigInteger = ((BigInteger)$this$unaryMinus).negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.negate()");
            number = bigInteger;
        } else if (number2 instanceof Double) {
            number = -$this$unaryMinus.doubleValue();
        } else if (number2 instanceof BigDecimal) {
            BigDecimal bigDecimal = NumberExtensionsKt.isZero($this$unaryMinus) ? (BigDecimal)Decimal.negativeZero((int)((BigDecimal)$this$unaryMinus).scale()) : ((BigDecimal)$this$unaryMinus).negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"if (this.isZero()) {\n   \u2026  this.negate()\n        }");
            number = bigDecimal;
        } else {
            throw new IllegalStateException();
        }
        return number;
    }

    private static final Number checkOverflowPlus(long $this$checkOverflowPlus, long other) {
        long result;
        boolean overflows = ($this$checkOverflowPlus ^ other) >= 0L & ($this$checkOverflowPlus ^ (result = $this$checkOverflowPlus + other)) < 0L;
        if (overflows) {
            ExceptionsKt.errIntOverflow$default(8, null, 2, null);
            throw new KotlinNothingValueException();
        }
        return result;
    }

    private static final Number checkOverflowMinus(long $this$checkOverflowMinus, long other) {
        long result;
        boolean overflows = ($this$checkOverflowMinus ^ other) < 0L & ($this$checkOverflowMinus ^ (result = $this$checkOverflowMinus - other)) < 0L;
        if (overflows) {
            ExceptionsKt.errIntOverflow$default(8, null, 2, null);
            throw new KotlinNothingValueException();
        }
        return result;
    }

    private static final Number checkOverflowTimes(long $this$checkOverflowTimes, long other) {
        int leadingZeros = NumberExtensionsKt.checkOverflowTimes$numberOfLeadingZeros($this$checkOverflowTimes) + NumberExtensionsKt.checkOverflowTimes$numberOfLeadingZeros($this$checkOverflowTimes ^ 0xFFFFFFFFFFFFFFFFL) + NumberExtensionsKt.checkOverflowTimes$numberOfLeadingZeros(other) + NumberExtensionsKt.checkOverflowTimes$numberOfLeadingZeros(other ^ 0xFFFFFFFFFFFFFFFFL);
        long result = $this$checkOverflowTimes * other;
        int longSize = 64;
        if (leadingZeros >= longSize && $this$checkOverflowTimes >= 0L | other != Long.MIN_VALUE && ($this$checkOverflowTimes == 0L || result / $this$checkOverflowTimes == other)) {
            return result;
        }
        ExceptionsKt.errIntOverflow$default(8, null, 2, null);
        throw new KotlinNothingValueException();
    }

    private static final Number checkOverflowDivision(long $this$checkOverflowDivision, long other) {
        if ($this$checkOverflowDivision == Long.MIN_VALUE && other == -1L) {
            ExceptionsKt.errIntOverflow$default(8, null, 2, null);
            throw new KotlinNothingValueException();
        }
        return $this$checkOverflowDivision / other;
    }

    @NotNull
    public static final Number plus(@NotNull Number $this$plus, @NotNull Number other) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Pair<Number, Number> pair = NumberExtensionsKt.coerceNumbers($this$plus, other);
        Number first = (Number)pair.component1();
        Number second = (Number)pair.component2();
        Number number2 = first;
        if (number2 instanceof Long) {
            number = NumberExtensionsKt.checkOverflowPlus(first.longValue(), (Long)second);
        } else if (number2 instanceof Double) {
            number = first.doubleValue() + (Double)second;
        } else if (number2 instanceof BigDecimal) {
            BigDecimal bigDecimal = ((BigDecimal)first).add((BigDecimal)second, MATH_CONTEXT);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"first.add(second as BigDecimal, MATH_CONTEXT)");
            number = bigDecimal;
        } else {
            throw new IllegalStateException();
        }
        return number;
    }

    @NotNull
    public static final Number minus(@NotNull Number $this$minus, @NotNull Number other) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Pair<Number, Number> pair = NumberExtensionsKt.coerceNumbers($this$minus, other);
        Number first = (Number)pair.component1();
        Number second = (Number)pair.component2();
        Number number2 = first;
        if (number2 instanceof Long) {
            number = NumberExtensionsKt.checkOverflowMinus(first.longValue(), (Long)second);
        } else if (number2 instanceof Double) {
            number = first.doubleValue() - (Double)second;
        } else if (number2 instanceof BigDecimal) {
            BigDecimal bigDecimal = ((BigDecimal)first).subtract((BigDecimal)second, MATH_CONTEXT);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"first.subtract(second as BigDecimal, MATH_CONTEXT)");
            number = bigDecimal;
        } else {
            throw new IllegalStateException();
        }
        return number;
    }

    @NotNull
    public static final Number times(@NotNull Number $this$times, @NotNull Number other) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Pair<Number, Number> pair = NumberExtensionsKt.coerceNumbers($this$times, other);
        Number first = (Number)pair.component1();
        Number second = (Number)pair.component2();
        Number number2 = first;
        if (number2 instanceof Long) {
            number = NumberExtensionsKt.checkOverflowTimes(first.longValue(), (Long)second);
        } else if (number2 instanceof Double) {
            number = first.doubleValue() * (Double)second;
        } else if (number2 instanceof BigDecimal) {
            BigDecimal bigDecimal = ((BigDecimal)first).multiply((BigDecimal)second, MATH_CONTEXT);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"first.multiply(second as BigDecimal, MATH_CONTEXT)");
            number = bigDecimal;
        } else {
            throw new IllegalStateException();
        }
        return number;
    }

    @NotNull
    public static final Number div(@NotNull Number $this$div, @NotNull Number other) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)$this$div, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Pair<Number, Number> pair = NumberExtensionsKt.coerceNumbers($this$div, other);
        Number first = (Number)pair.component1();
        Number second = (Number)pair.component2();
        Number number2 = first;
        if (number2 instanceof Long) {
            number = NumberExtensionsKt.checkOverflowDivision(first.longValue(), (Long)second);
        } else if (number2 instanceof Double) {
            number = first.doubleValue() / (Double)second;
        } else if (number2 instanceof BigDecimal) {
            BigDecimal bigDecimal = ((BigDecimal)first).divide((BigDecimal)second, MATH_CONTEXT);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"first.divide(second as BigDecimal, MATH_CONTEXT)");
            number = bigDecimal;
        } else {
            throw new IllegalStateException();
        }
        return number;
    }

    @NotNull
    public static final Number rem(@NotNull Number $this$rem, @NotNull Number other) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)$this$rem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Pair<Number, Number> pair = NumberExtensionsKt.coerceNumbers($this$rem, other);
        Number first = (Number)pair.component1();
        Number second = (Number)pair.component2();
        Number number2 = first;
        if (number2 instanceof Long) {
            number = first.longValue() % (Long)second;
        } else if (number2 instanceof Double) {
            number = first.doubleValue() % (Double)second;
        } else if (number2 instanceof BigDecimal) {
            BigDecimal bigDecimal = ((BigDecimal)first).remainder((BigDecimal)second, MATH_CONTEXT);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"first.remainder(second a\u2026BigDecimal, MATH_CONTEXT)");
            number = bigDecimal;
        } else {
            throw new IllegalStateException();
        }
        return number;
    }

    public static final int compareTo(@NotNull Number $this$compareTo, @NotNull Number other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$compareTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Pair<Number, Number> pair = NumberExtensionsKt.coerceNumbers($this$compareTo, other);
        Number first = (Number)pair.component1();
        Number second = (Number)pair.component2();
        Number number = first;
        if (number instanceof Long) {
            n = Intrinsics.compare((long)first.longValue(), (long)((Long)second));
        } else if (number instanceof Double) {
            n = Double.compare(first.doubleValue(), (Double)second);
        } else if (number instanceof BigDecimal) {
            n = ((BigDecimal)first).compareTo((BigDecimal)second);
        } else {
            throw new IllegalStateException();
        }
        return n;
    }

    public static final boolean isNaN(@NotNull Number $this$isNaN) {
        Intrinsics.checkNotNullParameter((Object)$this$isNaN, (String)"<this>");
        return $this$isNaN instanceof Double ? Double.isNaN($this$isNaN.doubleValue()) : false;
    }

    public static final boolean isNegInf(@NotNull Number $this$isNegInf) {
        Intrinsics.checkNotNullParameter((Object)$this$isNegInf, (String)"<this>");
        return $this$isNegInf instanceof Double ? Double.isInfinite($this$isNegInf.doubleValue()) && $this$isNegInf.doubleValue() < 0.0 : false;
    }

    public static final boolean isPosInf(@NotNull Number $this$isPosInf) {
        Intrinsics.checkNotNullParameter((Object)$this$isPosInf, (String)"<this>");
        return $this$isPosInf instanceof Double ? Double.isInfinite($this$isPosInf.doubleValue()) && $this$isPosInf.doubleValue() > 0.0 : false;
    }

    private static final BigDecimal roundToDigits(BigDecimal $this$roundToDigits, MathContext mathContext) {
        BigDecimal bigDecimal;
        int scale;
        BigDecimal stripped = $this$roundToDigits.stripTrailingZeros();
        BigDecimal mantissa = stripped.scaleByPowerOfTen(scale = stripped.scale() - stripped.precision() + 1);
        if (mantissa.precision() != mathContext.getPrecision()) {
            BigDecimal bigDecimal2 = mantissa.round(mathContext).setScale(mathContext.getPrecision() - 1).scaleByPowerOfTen(-scale);
            bigDecimal = bigDecimal2;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"{\n        mantissa.round\u2026yPowerOfTen(-scale)\n    }");
        } else {
            BigDecimal bigDecimal3 = stripped.round(mathContext);
            bigDecimal = bigDecimal3;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"{\n        stripped.round(mathContext)\n    }");
        }
        return bigDecimal;
    }

    private static final BigDecimal intRoot(BigDecimal $this$intRoot, int root, MathContext mathContext) {
        BigDecimal denominator;
        BigDecimal numerator;
        if ($this$intRoot.signum() < 0) {
            throw new ArithmeticException("Cannot take root of a negative number");
        }
        MathContext operationMC = new MathContext(mathContext.getPrecision() + 2 < 0 ? Integer.MAX_VALUE : mathContext.getPrecision() + 2, mathContext.getRoundingMode());
        BigDecimal bigDecimal = BigDecimal.valueOf(5L).movePointLeft(mathContext.getPrecision() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(5L).movePointLef\u2026athContext.precision + 1)");
        BigDecimal tolerance = bigDecimal;
        BigDecimal n = BigDecimal.valueOf(root);
        BigDecimal nMinusOne = BigDecimal.valueOf((long)root - 1L);
        BigDecimal res = $this$intRoot.divide(n, mathContext);
        BigDecimal resPrev = null;
        do {
            BigDecimal xToNMinusOne = res.pow(root - 1, operationMC);
            BigDecimal xToN = res.multiply(xToNMinusOne, operationMC);
            numerator = $this$intRoot.add(nMinusOne.multiply(xToN, operationMC), operationMC);
            denominator = n.multiply(xToNMinusOne, operationMC);
            Intrinsics.checkNotNullExpressionValue((Object)res, (String)"res");
        } while ((res = numerator.divide(denominator, operationMC)).round(mathContext).subtract(resPrev.round(mathContext)).abs().compareTo(tolerance) > 0);
        BigDecimal bigDecimal2 = res;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"res");
        return bigDecimal2;
    }

    @NotNull
    public static final BigDecimal squareRoot(@NotNull BigDecimal $this$squareRoot, @NotNull MathContext mathContext) {
        Intrinsics.checkNotNullParameter((Object)$this$squareRoot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mathContext, (String)"mathContext");
        if ($this$squareRoot.signum() < 0) {
            throw new ArithmeticException("Cannot take root of a negative number");
        }
        if ($this$squareRoot.signum() == 0) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
            return NumberExtensionsKt.roundToDigits(bigDecimal, mathContext);
        }
        BigDecimal stripped = $this$squareRoot.stripTrailingZeros();
        int scale = stripped.scale() - stripped.precision() + 1;
        int scaleAdj = scale % 2 == 0 ? scale : scale - 1;
        BigDecimal mantissa = stripped.scaleByPowerOfTen(scaleAdj);
        BigDecimal guess = BigDecimal.valueOf(Math.sqrt(mantissa.doubleValue()));
        int guessPrecision = 10;
        int targetPrecision = mathContext.getPrecision();
        int normalizedPrecision = mantissa.precision();
        BigDecimal approx = guess;
        BigDecimal zeroPointFive = BigDecimal.ONE.divide(BigDecimal.valueOf(2L));
        do {
            int operatingPrecision = Math.max(Math.max(guessPrecision, targetPrecision + 2), normalizedPrecision);
            MathContext tempMC = new MathContext(operatingPrecision, RoundingMode.HALF_EVEN);
            approx = zeroPointFive.multiply(approx.add(mantissa.divide(approx, tempMC), tempMC));
        } while ((guessPrecision = 2 * guessPrecision + 2) < targetPrecision + 2);
        BigDecimal unModifiedRes = approx.scaleByPowerOfTen(-scaleAdj / 2).round(mathContext);
        Intrinsics.checkNotNullExpressionValue((Object)unModifiedRes, (String)"unModifiedRes");
        return NumberExtensionsKt.roundToDigits(unModifiedRes, mathContext);
    }

    public static /* synthetic */ BigDecimal squareRoot$default(BigDecimal bigDecimal, MathContext mathContext, int n, Object object) {
        if ((n & 1) != 0) {
            mathContext = MATH_CONTEXT;
        }
        return NumberExtensionsKt.squareRoot(bigDecimal, mathContext);
    }

    @NotNull
    public static final BigDecimal exp(@NotNull BigDecimal $this$exp, @NotNull MathContext mathContext) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)$this$exp, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mathContext, (String)"mathContext");
        MathContext operationMC = new MathContext(10 + mathContext.getPrecision() < 0 ? Integer.MAX_VALUE : 10 + mathContext.getPrecision(), mathContext.getRoundingMode());
        if ($this$exp.signum() == 0) {
            BigDecimal bigDecimal2 = BigDecimal.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"ONE");
            bigDecimal = NumberExtensionsKt.roundToDigits(bigDecimal2, mathContext);
        } else if ($this$exp.signum() == -1) {
            BigDecimal bigDecimal3 = $this$exp.negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"this.negate()");
            BigDecimal reciprocal = NumberExtensionsKt.expHelper(bigDecimal3, operationMC);
            BigDecimal bigDecimal4 = BigDecimal.valueOf(1L).divide(reciprocal, operationMC);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"valueOf(1)\n            .\u2026operationMC\n            )");
            bigDecimal = NumberExtensionsKt.roundToDigits(bigDecimal4, mathContext);
        } else {
            bigDecimal = NumberExtensionsKt.roundToDigits(NumberExtensionsKt.expHelper($this$exp, operationMC), mathContext);
        }
        return bigDecimal;
    }

    public static /* synthetic */ BigDecimal exp$default(BigDecimal bigDecimal, MathContext mathContext, int n, Object object) {
        if ((n & 1) != 0) {
            mathContext = MATH_CONTEXT;
        }
        return NumberExtensionsKt.exp(bigDecimal, mathContext);
    }

    private static final BigDecimal expHelper(BigDecimal $this$expHelper, MathContext mathContext) {
        BigDecimal intPart = $this$expHelper.setScale(0, RoundingMode.DOWN);
        if (intPart.signum() == 0) {
            return NumberExtensionsKt.expTaylor($this$expHelper, mathContext);
        }
        BigDecimal fractionPart = $this$expHelper.subtract(intPart);
        BigDecimal expInner = BigDecimal.ONE.add(fractionPart.divide(intPart, mathContext));
        Intrinsics.checkNotNullExpressionValue((Object)expInner, (String)"expInner");
        BigDecimal etoExpInner = NumberExtensionsKt.expTaylor(expInner, mathContext);
        BigDecimal maxInt = BigDecimal.valueOf(999999999L);
        BigDecimal result = BigDecimal.ONE;
        while (intPart.compareTo(maxInt) >= 0) {
            result = result.multiply(etoExpInner.pow(999999999, mathContext));
            intPart = intPart.subtract(maxInt);
        }
        BigDecimal bigDecimal = result.multiply(etoExpInner.pow(intPart.intValue(), mathContext), mathContext);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"result.multiply(etoExpIn\u2026athContext), mathContext)");
        return bigDecimal;
    }

    private static final BigDecimal expTaylor(BigDecimal $this$expTaylor, MathContext mathContext) {
        BigDecimal factorial = BigDecimal.ONE;
        BigDecimal xToN = $this$expTaylor;
        BigDecimal sumPrev = null;
        BigDecimal sum = $this$expTaylor.add(BigDecimal.ONE);
        int i = 2;
        do {
            Intrinsics.checkNotNullExpressionValue((Object)xToN.multiply($this$expTaylor, mathContext), (String)"xToN.multiply(this, mathContext)");
            factorial = factorial.multiply(BigDecimal.valueOf(i), mathContext);
            BigDecimal term = xToN.divide(factorial, mathContext);
            sumPrev = sum.round(mathContext);
            sum = sum.add(term, mathContext);
            ++i;
        } while (!Intrinsics.areEqual((Object)sum, (Object)sumPrev));
        BigDecimal bigDecimal = sum;
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"sum");
        return bigDecimal;
    }

    @NotNull
    public static final BigDecimal ln(@NotNull BigDecimal $this$ln, @NotNull MathContext mathContext) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)$this$ln, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mathContext, (String)"mathContext");
        if ($this$ln.signum() <= 0) {
            throw new ArithmeticException("Cannot take natural log of a non-positive number");
        }
        if ($this$ln.compareTo(BigDecimal.ONE) == 0) {
            BigDecimal bigDecimal2 = BigDecimal.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"ZERO");
            return NumberExtensionsKt.roundToDigits(bigDecimal2, MATH_CONTEXT);
        }
        BigDecimal intPart = $this$ln.setScale(0, RoundingMode.DOWN);
        int intPartLength = intPart.precision();
        MathContext operationMC = new MathContext(10 + mathContext.getPrecision() < 0 ? Integer.MAX_VALUE : 10 + mathContext.getPrecision(), mathContext.getRoundingMode());
        if (intPartLength < 3) {
            bigDecimal = NumberExtensionsKt.roundToDigits(NumberExtensionsKt.lnNewton($this$ln, operationMC), mathContext);
        } else {
            BigDecimal root = NumberExtensionsKt.intRoot($this$ln, intPartLength, operationMC);
            BigDecimal lnRoot = NumberExtensionsKt.lnNewton(root, operationMC);
            BigDecimal unModifiedRes = BigDecimal.valueOf(intPartLength).multiply(lnRoot, operationMC);
            Intrinsics.checkNotNullExpressionValue((Object)unModifiedRes, (String)"unModifiedRes");
            bigDecimal = NumberExtensionsKt.roundToDigits(unModifiedRes, mathContext);
        }
        return bigDecimal;
    }

    public static /* synthetic */ BigDecimal ln$default(BigDecimal bigDecimal, MathContext mathContext, int n, Object object) {
        if ((n & 1) != 0) {
            mathContext = MATH_CONTEXT;
        }
        return NumberExtensionsKt.ln(bigDecimal, mathContext);
    }

    private static final BigDecimal lnNewton(BigDecimal $this$lnNewton, MathContext mathContext) {
        MathContext operationMC = new MathContext(mathContext.getPrecision() + 2 < 0 ? Integer.MAX_VALUE : mathContext.getPrecision() + 2, mathContext.getRoundingMode());
        BigDecimal bigDecimal = BigDecimal.valueOf(5L).movePointLeft(mathContext.getPrecision() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(5L).movePointLef\u2026athContext.precision + 1)");
        BigDecimal tolerance = bigDecimal;
        BigDecimal x = $this$lnNewton;
        BigDecimal n = $this$lnNewton;
        BigDecimal term = null;
        do {
            BigDecimal eToX = NumberExtensionsKt.expHelper(x, operationMC);
            Intrinsics.checkNotNullExpressionValue((Object)eToX.subtract(n).divide(eToX, operationMC), (String)"eToX.subtract(n)\n       \u2026divide(eToX, operationMC)");
            Intrinsics.checkNotNullExpressionValue((Object)x.subtract(term), (String)"x.subtract(term)");
        } while (term.compareTo(tolerance) > 0);
        return x;
    }

    @NotNull
    public static final BigDecimal power(@NotNull BigDecimal $this$power, @NotNull BigDecimal power, @NotNull MathContext mathContext) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)$this$power, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)power, (String)"power");
        Intrinsics.checkNotNullParameter((Object)mathContext, (String)"mathContext");
        MathContext operationMC = new MathContext(10 + mathContext.getPrecision() < 0 ? Integer.MAX_VALUE : 10 + mathContext.getPrecision(), mathContext.getRoundingMode());
        BigDecimal intPart = power.setScale(0, RoundingMode.DOWN);
        BigDecimal fractionPart = power.subtract(intPart);
        if (fractionPart.compareTo(BigDecimal.ZERO) != 0 && $this$power.compareTo(BigDecimal.ZERO) < 0) {
            throw new ArithmeticException("a negative number raised to a non-integer power yields a complex result");
        }
        BigDecimal maxInt = BigDecimal.valueOf(999999999L);
        BigDecimal result = BigDecimal.ONE;
        while (intPart.compareTo(maxInt) >= 0) {
            result = result.multiply($this$power.pow(999999999, operationMC), operationMC);
            intPart = intPart.subtract(maxInt);
        }
        result = result.multiply($this$power.pow(intPart.intValue(), operationMC), operationMC);
        if (fractionPart.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal lnX = NumberExtensionsKt.ln($this$power, operationMC);
            BigDecimal bigDecimal2 = fractionPart.multiply(lnX, operationMC);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"fractionPart.multiply(lnX, operationMC)");
            BigDecimal fTimesLnX = bigDecimal2;
            BigDecimal xToF = NumberExtensionsKt.exp(fTimesLnX, operationMC);
            BigDecimal bigDecimal3 = result.multiply(xToF, operationMC);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"result.multiply(xToF, operationMC)");
            bigDecimal = NumberExtensionsKt.roundToDigits(bigDecimal3, mathContext);
        } else {
            BigDecimal bigDecimal4 = result;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"result");
            bigDecimal = NumberExtensionsKt.roundToDigits(bigDecimal4, mathContext);
        }
        return bigDecimal;
    }

    public static /* synthetic */ BigDecimal power$default(BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext, int n, Object object) {
        if ((n & 2) != 0) {
            mathContext = MATH_CONTEXT;
        }
        return NumberExtensionsKt.power(bigDecimal, bigDecimal2, mathContext);
    }

    private static final Class<?> coerceNumbers$typeFor(Number n) {
        return n instanceof Decimal ? BigDecimal.class : n.getClass();
    }

    private static final int checkOverflowTimes$numberOfLeadingZeros(long $this$checkOverflowTimes_u24numberOfLeadingZeros) {
        return Long.numberOfLeadingZeros($this$checkOverflowTimes_u24numberOfLeadingZeros);
    }

    static {
        Pair[] pairArray = new Pair[6];
        Object[] objectArray = new Class[]{Long.class, Long.class};
        pairArray[0] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Long.class);
        objectArray = new Class[]{Long.class, Double.class};
        pairArray[1] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Long.class, BigDecimal.class};
        pairArray[2] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        objectArray = new Class[]{Double.class, Double.class};
        pairArray[3] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Double.class, BigDecimal.class};
        pairArray[4] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        objectArray = new Class[]{BigDecimal.class, BigDecimal.class};
        pairArray[5] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        CONVERSION_MAP = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to(Long.class, (Object)((Object)CONVERTERS.1.INSTANCE)), TuplesKt.to(Double.class, (Object)((Object)CONVERTERS.2.INSTANCE)), TuplesKt.to(BigDecimal.class, (Object)((Object)CONVERTERS.3.INSTANCE))};
        CONVERTERS = MapsKt.mapOf((Pair[])pairArray);
    }
}

