/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan;

import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operator;

public interface Operand
extends Iterable<Operator> {
    public static Operand single(Operator operator) {
        return new Single(operator);
    }

    public static Operand vararg(List<? extends Operator> operators) {
        return new Variadic(operators);
    }

    public static class Variadic
    implements Operand {
        @NotNull
        public final List<Operator> operators;

        private Variadic(@NotNull List<Operator> operators) {
            this.operators = operators;
        }

        @Override
        @NotNull
        public Iterator<Operator> iterator() {
            return this.operators.iterator();
        }
    }

    public static class Single
    implements Operand {
        @NotNull
        public final Operator operator;

        private Single(@NotNull Operator operator) {
            this.operator = operator;
        }

        @Override
        @NotNull
        public Iterator<Operator> iterator() {
            return List.of(this.operator).iterator();
        }
    }
}

