/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rel;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rel.Rel;
import org.partiql.plan.rel.RelBase;
import org.partiql.plan.rel.RelType;
import org.partiql.plan.rex.Rex;
import org.partiql.spi.function.Agg;

public abstract class RelAggregate
extends RelBase {
    @NotNull
    public static RelAggregate create(@NotNull Rel input, @NotNull List<Measure> measures, @NotNull List<Rex> groups) {
        return new Impl(input, measures, groups);
    }

    @NotNull
    public static Measure measure(@NotNull Agg agg, @NotNull List<Rex> args, boolean distinct) {
        return new Measure(agg, args, distinct);
    }

    @NotNull
    public abstract Rel getInput();

    @NotNull
    public abstract List<Measure> getMeasures();

    @NotNull
    public abstract List<Rex> getGroups();

    @Override
    @NotNull
    protected final RelType type() {
        throw new UnsupportedOperationException("Derive type is not implemented");
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.single(this.getInput());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(@NotNull OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitAggregate(this, ctx);
    }

    @NotNull
    public abstract RelAggregate copy(@NotNull Rel var1);

    @NotNull
    public abstract RelAggregate copy(@NotNull Rel var1, @NotNull List<Measure> var2, @NotNull List<Rex> var3);

    private static class Impl
    extends RelAggregate {
        private final Rel input;
        private final List<Measure> measures;
        private final List<Rex> groups;

        private Impl(Rel input, List<Measure> measures, List<Rex> groups) {
            this.input = input;
            this.measures = measures;
            this.groups = groups;
        }

        @Override
        @NotNull
        public Rel getInput() {
            return this.input;
        }

        @Override
        @NotNull
        public List<Measure> getMeasures() {
            return this.measures;
        }

        @Override
        @NotNull
        public List<Rex> getGroups() {
            return this.groups;
        }

        @Override
        @NotNull
        public RelAggregate copy(@NotNull Rel input) {
            return new Impl(input, this.measures, this.groups);
        }

        @Override
        @NotNull
        public RelAggregate copy(@NotNull Rel input, @NotNull List<Measure> measures, @NotNull List<Rex> groups) {
            return new Impl(input, measures, groups);
        }
    }

    public static class Measure {
        private final Agg agg;
        private final List<Rex> args;
        private final boolean distinct;

        private Measure(Agg agg, List<Rex> args, boolean distinct) {
            this.agg = agg;
            this.args = args;
            this.distinct = distinct;
        }

        @NotNull
        public Agg getAgg() {
            return this.agg;
        }

        @NotNull
        public List<Rex> getArgs() {
            return this.args;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        @NotNull
        public Measure copy(@NotNull List<Rex> args) {
            return new Measure(this.agg, args, this.distinct);
        }
    }
}

