/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rel;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.JoinType;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rel.Rel;
import org.partiql.plan.rel.RelBase;
import org.partiql.plan.rel.RelType;

public abstract class RelCorrelate
extends RelBase {
    @NotNull
    public static RelCorrelate create(@NotNull Rel left, @NotNull Rel right, @NotNull JoinType joinType) {
        return new Impl(left, right, joinType);
    }

    @NotNull
    public abstract Rel getLeft();

    @NotNull
    public abstract Rel getRight();

    @NotNull
    public abstract JoinType getJoinType();

    @Override
    @NotNull
    protected final RelType type() {
        throw new UnsupportedOperationException("Derive type is not implemented");
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.single(this.getLeft());
        Operand c1 = Operand.single(this.getRight());
        return List.of(c0, c1);
    }

    @Override
    public <R, C> R accept(@NotNull OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitCorrelate(this, ctx);
    }

    @NotNull
    public abstract RelCorrelate copy(@NotNull Rel var1, @NotNull Rel var2);

    @NotNull
    public abstract RelCorrelate copy(@NotNull Rel var1, @NotNull Rel var2, @NotNull JoinType var3);

    private static class Impl
    extends RelCorrelate {
        private final Rel left;
        private final Rel right;
        private final JoinType joinType;

        private Impl(Rel left, Rel right, JoinType joinType) {
            this.left = left;
            this.right = right;
            this.joinType = joinType;
        }

        @Override
        @NotNull
        public Rel getLeft() {
            return this.left;
        }

        @Override
        @NotNull
        public Rel getRight() {
            return this.right;
        }

        @Override
        @NotNull
        public JoinType getJoinType() {
            return this.joinType;
        }

        @Override
        @NotNull
        public RelCorrelate copy(@NotNull Rel left, @NotNull Rel right) {
            return new Impl(left, right, this.joinType);
        }

        @Override
        @NotNull
        public RelCorrelate copy(@NotNull Rel left, @NotNull Rel right, @NotNull JoinType joinType) {
            return new Impl(left, right, joinType);
        }
    }
}

