/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rel;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rel.Rel;
import org.partiql.plan.rel.RelBase;
import org.partiql.plan.rel.RelType;

public abstract class RelExcept
extends RelBase {
    @NotNull
    public static RelExcept create(@NotNull Rel left, @NotNull Rel right, boolean all) {
        return new Impl(left, right, all);
    }

    @NotNull
    public abstract Rel getLeft();

    @NotNull
    public abstract Rel getRight();

    public abstract boolean isAll();

    @Override
    @NotNull
    protected final RelType type() {
        throw new UnsupportedOperationException("Derive type is not implemented");
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.single(this.getLeft());
        Operand c1 = Operand.single(this.getRight());
        return List.of(c0, c1);
    }

    @Override
    public <R, C> R accept(@NotNull OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitExcept(this, ctx);
    }

    @NotNull
    public abstract RelExcept copy(@NotNull Rel var1, @NotNull Rel var2);

    @NotNull
    public abstract RelExcept copy(@NotNull Rel var1, @NotNull Rel var2, boolean var3);

    private static class Impl
    extends RelExcept {
        private final Rel left;
        private final Rel right;
        private final boolean all;

        private Impl(Rel left, Rel right, boolean all) {
            this.left = left;
            this.right = right;
            this.all = all;
        }

        @Override
        @NotNull
        public Rel getLeft() {
            return this.left;
        }

        @Override
        @NotNull
        public Rel getRight() {
            return this.right;
        }

        @Override
        public boolean isAll() {
            return this.all;
        }

        @Override
        @NotNull
        public RelExcept copy(@NotNull Rel left, @NotNull Rel right) {
            return new Impl(left, right, this.all);
        }

        @Override
        @NotNull
        public RelExcept copy(@NotNull Rel left, @NotNull Rel right, boolean all) {
            return new Impl(left, right, all);
        }
    }
}

