/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rel;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Exclusion;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rel.Rel;
import org.partiql.plan.rel.RelBase;
import org.partiql.plan.rel.RelType;

public abstract class RelExclude
extends RelBase {
    @NotNull
    public static RelExclude create(@NotNull Rel input, @NotNull List<Exclusion> exclusions) {
        return new Impl(input, exclusions);
    }

    @NotNull
    public abstract Rel getInput();

    @NotNull
    public abstract List<Exclusion> getExclusions();

    @Override
    @NotNull
    protected final RelType type() {
        throw new UnsupportedOperationException("Derive type is not implemented");
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.single(this.getInput());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(@NotNull OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitExclude(this, ctx);
    }

    @NotNull
    public abstract RelExclude copy(@NotNull Rel var1);

    @NotNull
    public abstract RelExclude copy(@NotNull Rel var1, @NotNull List<Exclusion> var2);

    private static class Impl
    extends RelExclude {
        private final Rel input;
        private final List<Exclusion> exclusions;

        private Impl(Rel input, List<Exclusion> exclusions) {
            this.input = input;
            this.exclusions = exclusions;
        }

        @Override
        @NotNull
        public Rel getInput() {
            return this.input;
        }

        @Override
        @NotNull
        public List<Exclusion> getExclusions() {
            return this.exclusions;
        }

        @Override
        @NotNull
        public RelExclude copy(@NotNull Rel input) {
            return new Impl(input, this.exclusions);
        }

        @Override
        @NotNull
        public RelExclude copy(@NotNull Rel input, @NotNull List<Exclusion> exclusions) {
            return new Impl(input, exclusions);
        }
    }
}

