/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rel;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rel.Rel;
import org.partiql.plan.rel.RelBase;
import org.partiql.plan.rel.RelType;
import org.partiql.plan.rex.Rex;

public abstract class RelFilter
extends RelBase {
    @NotNull
    public static RelFilter create(@NotNull Rel input, @NotNull Rex predicate) {
        return new Impl(input, predicate);
    }

    @NotNull
    public abstract Rel getInput();

    @NotNull
    public abstract Rex getPredicate();

    @Override
    @NotNull
    protected final RelType type() {
        throw new UnsupportedOperationException("Derive type is not implemented");
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.single(this.getInput());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(@NotNull OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitFilter(this, ctx);
    }

    @NotNull
    public abstract RelFilter copy(@NotNull Rel var1);

    @NotNull
    public abstract RelFilter copy(@NotNull Rel var1, @NotNull Rex var2);

    private static class Impl
    extends RelFilter {
        private final Rel input;
        private final Rex predicate;

        private Impl(Rel input, Rex predicate) {
            this.input = input;
            this.predicate = predicate;
        }

        @Override
        @NotNull
        public Rel getInput() {
            return this.input;
        }

        @Override
        @NotNull
        public Rex getPredicate() {
            return this.predicate;
        }

        @Override
        @NotNull
        public RelFilter copy(@NotNull Rel input) {
            return new Impl(input, this.predicate);
        }

        @Override
        @NotNull
        public RelFilter copy(@NotNull Rel input, @NotNull Rex predicate) {
            return new Impl(input, predicate);
        }
    }
}

