/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rel;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.JoinType;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rel.Rel;
import org.partiql.plan.rel.RelBase;
import org.partiql.plan.rel.RelType;
import org.partiql.plan.rex.Rex;

public abstract class RelJoin
extends RelBase {
    @NotNull
    public static RelJoin create(@NotNull Rel left, @NotNull Rel right, @NotNull Rex condition, @NotNull JoinType joinType) {
        return new Impl(left, right, condition, joinType);
    }

    @NotNull
    public abstract Rel getLeft();

    @NotNull
    public abstract Rel getRight();

    @NotNull
    public abstract JoinType getJoinType();

    @NotNull
    public abstract Rex getCondition();

    @Override
    @NotNull
    protected RelType type() {
        throw new UnsupportedOperationException("compute join type");
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.single(this.getLeft());
        Operand c1 = Operand.single(this.getRight());
        return List.of(c0, c1);
    }

    @Override
    public <R, C> R accept(@NotNull OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitJoin(this, ctx);
    }

    @NotNull
    public abstract RelJoin copy(@NotNull Rel var1, @NotNull Rel var2);

    @NotNull
    public abstract RelJoin copy(@NotNull Rel var1, @NotNull Rel var2, @NotNull Rex var3, @NotNull JoinType var4);

    private static class Impl
    extends RelJoin {
        private final Rel left;
        private final Rel right;
        private final Rex condition;
        private final JoinType joinType;

        private Impl(Rel left, Rel right, Rex condition, JoinType joinType) {
            this.left = left;
            this.right = right;
            this.condition = condition;
            this.joinType = joinType;
        }

        @Override
        @NotNull
        public Rel getLeft() {
            return this.left;
        }

        @Override
        @NotNull
        public Rel getRight() {
            return this.right;
        }

        @Override
        @NotNull
        public Rex getCondition() {
            return this.condition;
        }

        @Override
        @NotNull
        public JoinType getJoinType() {
            return this.joinType;
        }

        @Override
        @NotNull
        public RelJoin copy(@NotNull Rel left, @NotNull Rel right) {
            return new Impl(left, right, this.condition, this.joinType);
        }

        @Override
        @NotNull
        public RelJoin copy(@NotNull Rel left, @NotNull Rel right, @NotNull Rex condition, @NotNull JoinType joinType) {
            return new Impl(left, right, condition, joinType);
        }
    }
}

