/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rel;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rel.Rel;
import org.partiql.plan.rel.RelBase;
import org.partiql.plan.rel.RelType;
import org.partiql.plan.rex.Rex;

public abstract class RelLimit
extends RelBase {
    @NotNull
    public static RelLimit create(@NotNull Rel input, @NotNull Rex limit) {
        return new Impl(input, limit);
    }

    @NotNull
    public abstract Rel getInput();

    @NotNull
    public abstract Rex getLimit();

    @Override
    @NotNull
    protected final RelType type() {
        return this.getInput().getType();
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.single(this.getInput());
        Operand c1 = Operand.single(this.getLimit());
        return List.of(c0, c1);
    }

    @Override
    public <R, C> R accept(@NotNull OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitLimit(this, ctx);
    }

    @NotNull
    public abstract RelLimit copy(@NotNull Rel var1);

    @NotNull
    public abstract RelLimit copy(@NotNull Rel var1, @NotNull Rex var2);

    private static class Impl
    extends RelLimit {
        private final Rel input;
        private final Rex limit;

        private Impl(Rel input, Rex limit) {
            this.input = input;
            this.limit = limit;
        }

        @Override
        @NotNull
        public Rel getInput() {
            return this.input;
        }

        @Override
        @NotNull
        public Rex getLimit() {
            return this.limit;
        }

        @Override
        @NotNull
        public RelLimit copy(@NotNull Rel input) {
            return new Impl(input, this.limit);
        }

        @Override
        @NotNull
        public RelLimit copy(@NotNull Rel input, @NotNull Rex limit) {
            return new Impl(input, limit);
        }
    }
}

