/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rel;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rel.Rel;
import org.partiql.plan.rel.RelBase;
import org.partiql.plan.rel.RelType;
import org.partiql.plan.rex.Rex;

public abstract class RelOffset
extends RelBase {
    @NotNull
    public static RelOffset create(@NotNull Rel input, @NotNull Rex offset) {
        return new Impl(input, offset);
    }

    @NotNull
    public abstract Rel getInput();

    @NotNull
    public abstract Rex getOffset();

    @Override
    @NotNull
    protected final RelType type() {
        return this.getInput().getType();
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.single(this.getInput());
        Operand c1 = Operand.single(this.getOffset());
        return List.of(c0, c1);
    }

    @Override
    public <R, C> R accept(@NotNull OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitOffset(this, ctx);
    }

    @NotNull
    public abstract RelOffset copy(@NotNull Rel var1);

    @NotNull
    public abstract RelOffset copy(@NotNull Rel var1, @NotNull Rex var2);

    private static class Impl
    extends RelOffset {
        private final Rel input;
        private final Rex offset;

        private Impl(Rel input, Rex offset) {
            this.input = input;
            this.offset = offset;
        }

        @Override
        @NotNull
        public Rel getInput() {
            return this.input;
        }

        @Override
        @NotNull
        public Rex getOffset() {
            return this.offset;
        }

        @Override
        @NotNull
        public RelOffset copy(@NotNull Rel input) {
            return new Impl(input, this.offset);
        }

        @Override
        @NotNull
        public RelOffset copy(@NotNull Rel input, @NotNull Rex offset) {
            return new Impl(input, offset);
        }
    }
}

