/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rel;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rel.Rel;
import org.partiql.plan.rel.RelBase;
import org.partiql.plan.rel.RelType;
import org.partiql.plan.rex.Rex;

public abstract class RelProject
extends RelBase {
    @NotNull
    public static RelProject create(Rel input, List<Rex> projections) {
        return new Impl(input, projections);
    }

    @NotNull
    public abstract Rel getInput();

    @NotNull
    public abstract List<Rex> getProjections();

    @Override
    @NotNull
    protected final RelType type() {
        throw new UnsupportedOperationException("Derive type is not implemented");
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.single(this.getInput());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(@NotNull OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitProject(this, ctx);
    }

    @NotNull
    public abstract RelProject copy(@NotNull Rel var1);

    @NotNull
    public abstract RelProject copy(@NotNull Rel var1, @NotNull List<Rex> var2);

    private static class Impl
    extends RelProject {
        private final Rel input;
        private final List<Rex> projections;

        private Impl(Rel input, List<Rex> projections) {
            this.input = input;
            this.projections = projections;
        }

        @Override
        @NotNull
        public Rel getInput() {
            return this.input;
        }

        @Override
        @NotNull
        public List<Rex> getProjections() {
            return this.projections;
        }

        @Override
        @NotNull
        public RelProject copy(@NotNull Rel input) {
            return new Impl(input, this.projections);
        }

        @Override
        @NotNull
        public RelProject copy(@NotNull Rel input, @NotNull List<Rex> projections) {
            return new Impl(input, projections);
        }
    }
}

