/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rel;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Collation;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rel.Rel;
import org.partiql.plan.rel.RelBase;
import org.partiql.plan.rel.RelType;

public abstract class RelSort
extends RelBase {
    @NotNull
    public static RelSort create(@NotNull Rel input, @NotNull List<Collation> collations) {
        return new Impl(input, collations);
    }

    @NotNull
    public abstract Rel getInput();

    @NotNull
    public abstract List<Collation> getCollations();

    @Override
    @NotNull
    protected final RelType type() {
        return this.getInput().getType();
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.single(this.getInput());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(@NotNull OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitSort(this, ctx);
    }

    @NotNull
    public abstract RelSort copy(@NotNull Rel var1);

    @NotNull
    public abstract RelSort copy(@NotNull Rel var1, @NotNull List<Collation> var2);

    private static class Impl
    extends RelSort {
        private final Rel input;
        private final List<Collation> collations;

        private Impl(Rel input, List<Collation> collations) {
            this.input = input;
            this.collations = collations;
        }

        @Override
        @NotNull
        public Rel getInput() {
            return this.input;
        }

        @Override
        @NotNull
        public List<Collation> getCollations() {
            return this.collations;
        }

        @Override
        @NotNull
        public RelSort copy(@NotNull Rel input) {
            return new Impl(input, this.collations);
        }

        @Override
        @NotNull
        public RelSort copy(@NotNull Rel input, @NotNull List<Collation> collations) {
            return new Impl(input, collations);
        }
    }
}

