/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rel;

import org.jetbrains.annotations.NotNull;
import org.partiql.spi.types.PTypeField;

public final class RelType {
    public static final int ORDERED = 1;
    private final PTypeField[] fields;
    private final boolean ordered;

    private RelType(PTypeField[] fields, boolean ordered) {
        this.fields = fields;
        this.ordered = ordered;
    }

    @NotNull
    public static RelType of(PTypeField ... fields) {
        return RelType.of(fields, 0);
    }

    @NotNull
    public static RelType of(PTypeField[] fields, int properties) {
        boolean ordered = (properties & 1) != 0;
        return new RelType(fields, ordered);
    }

    public int getDegree() {
        return this.fields.length;
    }

    @NotNull
    public PTypeField[] getFields() {
        return this.fields;
    }

    @NotNull
    public PTypeField getField(int index) {
        if (index < 0 || index >= this.fields.length) {
            throw new IllegalArgumentException("field index out of bounds: " + index);
        }
        return this.fields[index];
    }

    @NotNull
    public PTypeField getField(String name) {
        for (PTypeField field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        throw new IllegalArgumentException("field name not found: " + name);
    }

    public boolean isOrdered() {
        return this.ordered;
    }
}

