/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rex.Rex;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;
import org.partiql.spi.types.PType;

public abstract class RexArray
extends RexBase {
    @NotNull
    public static RexArray create(@NotNull List<Rex> values) {
        return new Impl(values);
    }

    @NotNull
    public abstract List<Rex> getValues();

    @Override
    @NotNull
    protected final RexType type() {
        return RexType.of(PType.array());
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.vararg(this.getValues());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(@NotNull OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitArray(this, ctx);
    }

    private static class Impl
    extends RexArray {
        private final List<Rex> values;

        private Impl(List<Rex> values) {
            this.values = values;
        }

        @Override
        @NotNull
        public List<Rex> getValues() {
            return this.values;
        }
    }
}

