/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rex.Rex;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;
import org.partiql.spi.types.PType;

public abstract class RexBag
extends RexBase {
    @NotNull
    public static RexBag create(@NotNull Collection<Rex> values) {
        return new Impl(values);
    }

    @NotNull
    public abstract Collection<Rex> getValues();

    @Override
    @NotNull
    protected final RexType type() {
        return RexType.of(PType.bag());
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        ArrayList<Rex> values = new ArrayList<Rex>(this.getValues());
        Operand c0 = Operand.vararg(values);
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(@NotNull OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitBag(this, ctx);
    }

    private static class Impl
    extends RexBag {
        private final Collection<Rex> values;

        private Impl(Collection<Rex> values) {
            this.values = values;
        }

        @Override
        @NotNull
        public Collection<Rex> getValues() {
            return this.values;
        }
    }
}

