/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rex.Rex;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;
import org.partiql.spi.function.Fn;

public abstract class RexCall
extends RexBase {
    @NotNull
    public static RexCall create(@NotNull Fn function, @NotNull List<Rex> args) {
        return new Impl(function, args);
    }

    @NotNull
    public abstract Fn getFunction();

    @NotNull
    public abstract List<Rex> getArgs();

    @Override
    @NotNull
    protected RexType type() {
        return RexType.of(this.getFunction().getSignature().getReturns());
    }

    @Override
    @NotNull
    protected List<Operand> operands() {
        Operand c0 = Operand.vararg(this.getArgs());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitCall(this, ctx);
    }

    private static class Impl
    extends RexCall {
        private final Fn function;
        private final List<Rex> args;

        private Impl(Fn function, List<Rex> args) {
            this.function = function;
            this.args = args;
        }

        @Override
        @NotNull
        public Fn getFunction() {
            return this.function;
        }

        @Override
        @NotNull
        public List<Rex> getArgs() {
            return this.args;
        }
    }
}

