/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rex.Rex;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;

public abstract class RexCase
extends RexBase {
    @NotNull
    public static RexCase create(@Nullable Rex match, @NotNull List<Branch> branches, @Nullable Rex def) {
        return new Impl(match, branches, def);
    }

    @NotNull
    public static Branch branch(@NotNull Rex condition, @NotNull Rex result) {
        return new Branch(condition, result);
    }

    @Nullable
    public abstract Rex getMatch();

    @NotNull
    public abstract List<Branch> getBranches();

    @Nullable
    public abstract Rex getDefault();

    @Override
    @NotNull
    protected final RexType type() {
        throw new UnsupportedOperationException("Derive type is not implemented");
    }

    @Override
    @NotNull
    protected List<Operand> operands() {
        Rex match = this.getMatch();
        if (match == null) {
            return List.of();
        }
        Operand c0 = Operand.single(match);
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitCase(this, ctx);
    }

    private static class Impl
    extends RexCase {
        private final Rex match;
        private final List<Branch> branches;
        private final Rex def;

        private Impl(Rex match, List<Branch> branches, Rex def) {
            this.match = match;
            this.branches = branches;
            this.def = def;
        }

        @Override
        @Nullable
        public Rex getMatch() {
            return this.match;
        }

        @Override
        @NotNull
        public List<Branch> getBranches() {
            return this.branches;
        }

        @Override
        @Nullable
        public Rex getDefault() {
            return this.def;
        }
    }

    public static class Branch {
        @NotNull
        private final Rex condition;
        @NotNull
        private final Rex result;

        private Branch(@NotNull Rex condition, @NotNull Rex result) {
            this.condition = condition;
            this.result = result;
        }

        @NotNull
        public Rex getCondition() {
            return this.condition;
        }

        @NotNull
        public Rex getResult() {
            return this.result;
        }
    }
}

