/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rex.Rex;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;
import org.partiql.spi.types.PType;

public abstract class RexCast
extends RexBase {
    @NotNull
    public static RexCast create(@NotNull Rex operand, @NotNull PType target) {
        return new Impl(operand, target);
    }

    @NotNull
    public abstract Rex getOperand();

    @NotNull
    public abstract PType getTarget();

    @Override
    @NotNull
    protected final RexType type() {
        return RexType.of(this.getTarget());
    }

    @Override
    @NotNull
    protected List<Operand> operands() {
        Operand c0 = Operand.single(this.getOperand());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitCast(this, ctx);
    }

    private static class Impl
    extends RexCast {
        private final Rex operand;
        private final PType target;

        private Impl(@NotNull Rex operand, @NotNull PType target) {
            this.operand = operand;
            this.target = target;
        }

        @Override
        @NotNull
        public Rex getOperand() {
            return this.operand;
        }

        @Override
        @NotNull
        public PType getTarget() {
            return this.target;
        }
    }
}

