/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rex.Rex;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;
import org.partiql.spi.function.FnOverload;
import org.partiql.spi.types.PType;

public abstract class RexDispatch
extends RexBase {
    @NotNull
    public static RexDispatch create(String name, List<FnOverload> functions, List<Rex> args) {
        return new Impl(name, functions, args);
    }

    public abstract String getName();

    public abstract List<FnOverload> getFunctions();

    public abstract List<Rex> getArgs();

    @Override
    @NotNull
    protected final RexType type() {
        return RexType.of(PType.dynamic());
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.vararg(this.getArgs());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitDispatch(this, ctx);
    }

    private static class Impl
    extends RexDispatch {
        private final String name;
        private final List<FnOverload> functions;
        private final List<Rex> args;

        private Impl(String name, List<FnOverload> functions, List<Rex> args) {
            this.name = name;
            this.functions = functions;
            this.args = args;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<FnOverload> getFunctions() {
            return this.functions;
        }

        @Override
        public List<Rex> getArgs() {
            return this.args;
        }
    }
}

