/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rex.Rex;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;

public abstract class RexPathIndex
extends RexBase {
    @NotNull
    public static RexPathIndex create(@NotNull Rex operand, @NotNull Rex index) {
        return new Impl(operand, index);
    }

    @NotNull
    public abstract Rex getOperand();

    @NotNull
    public abstract Rex getIndex();

    @Override
    @NotNull
    protected final RexType type() {
        throw new UnsupportedOperationException("Derive type is not implemented");
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.single(this.getOperand());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitPathIndex(this, ctx);
    }

    private static class Impl
    extends RexPathIndex {
        private final Rex operand;
        private final Rex index;

        private Impl(@NotNull Rex operand, @NotNull Rex index) {
            this.operand = operand;
            this.index = index;
        }

        @Override
        @NotNull
        public Rex getOperand() {
            return this.operand;
        }

        @Override
        @NotNull
        public Rex getIndex() {
            return this.index;
        }
    }
}

