/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rex.Rex;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;

public abstract class RexPathKey
extends RexBase {
    @NotNull
    public static RexPathKey create(@NotNull Rex operand, @NotNull Rex key) {
        return new Impl(operand, key);
    }

    @NotNull
    public abstract Rex getOperand();

    @NotNull
    public abstract Rex getKey();

    @Override
    @NotNull
    protected final RexType type() {
        throw new UnsupportedOperationException("Derive type is not implemented");
    }

    @Override
    @NotNull
    protected List<Operand> operands() {
        Operand c0 = Operand.single(this.getOperand());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitPathKey(this, ctx);
    }

    private static class Impl
    extends RexPathKey {
        private final Rex operand;
        private final Rex key;

        private Impl(@NotNull Rex operand, @NotNull Rex key) {
            this.operand = operand;
            this.key = key;
        }

        @Override
        @NotNull
        public Rex getOperand() {
            return this.operand;
        }

        @Override
        @NotNull
        public Rex getKey() {
            return this.key;
        }
    }
}

