/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rex.Rex;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;

public abstract class RexPathSymbol
extends RexBase {
    @NotNull
    public static RexPathSymbol create(@NotNull Rex operand, @NotNull String symbol) {
        return new Impl(operand, symbol);
    }

    @NotNull
    public abstract Rex getOperand();

    @NotNull
    public abstract String getSymbol();

    @Override
    @NotNull
    protected final RexType type() {
        throw new UnsupportedOperationException("Derive type is not implemented");
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.single(this.getOperand());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitPathSymbol(this, ctx);
    }

    private static class Impl
    extends RexPathSymbol {
        private final Rex operand;
        private final String symbol;

        private Impl(@NotNull Rex operand, @NotNull String symbol) {
            this.operand = operand;
            this.symbol = symbol;
        }

        @Override
        @NotNull
        public Rex getOperand() {
            return this.operand;
        }

        @Override
        @NotNull
        public String getSymbol() {
            return this.symbol;
        }
    }
}

