/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rel.Rel;
import org.partiql.plan.rex.Rex;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;
import org.partiql.spi.types.PType;

public abstract class RexPivot
extends RexBase {
    @NotNull
    public static RexPivot create(@NotNull Rel input, @NotNull Rex key, @NotNull Rex value) {
        return new Impl(input, key, value);
    }

    @NotNull
    public abstract Rel getInput();

    @NotNull
    public abstract Rex getKey();

    @NotNull
    public abstract Rex getValue();

    @Override
    @NotNull
    protected final RexType type() {
        return RexType.of(PType.struct());
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.single(this.getInput());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitPivot(this, ctx);
    }

    private static class Impl
    extends RexPivot {
        private final Rel input;
        private final Rex key;
        private final Rex value;

        private Impl(Rel input, Rex key, Rex value) {
            this.input = input;
            this.key = key;
            this.value = value;
        }

        @Override
        @NotNull
        public Rel getInput() {
            return this.input;
        }

        @Override
        @NotNull
        public Rex getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public Rex getValue() {
            return this.value;
        }
    }
}

