/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rel.Rel;
import org.partiql.plan.rex.Rex;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;
import org.partiql.spi.types.PType;

public abstract class RexSelect
extends RexBase {
    @NotNull
    public static RexSelect create(@NotNull Rel input, @NotNull Rex constructor) {
        return new Impl(input, constructor);
    }

    @NotNull
    public abstract Rel getInput();

    public abstract Rex getConstructor();

    @Override
    @NotNull
    protected final RexType type() {
        return RexType.of(PType.bag());
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.single(this.getInput());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitSelect(this, ctx);
    }

    private static class Impl
    extends RexSelect {
        private final Rel input;
        private final Rex constructor;

        private Impl(Rel input, Rex constructor) {
            this.input = input;
            this.constructor = constructor;
        }

        @Override
        @NotNull
        public Rel getInput() {
            return this.input;
        }

        @Override
        @NotNull
        public Rex getConstructor() {
            return this.constructor;
        }
    }
}

