/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rex.Rex;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;
import org.partiql.spi.types.PType;

public abstract class RexStruct
extends RexBase {
    @NotNull
    public static RexStruct create(@NotNull List<Field> fields) {
        return new Impl(fields);
    }

    @NotNull
    public static Field field(Rex key, Rex value) {
        return new Field(key, value);
    }

    @NotNull
    public abstract List<Field> getFields();

    @Override
    @NotNull
    protected final RexType type() {
        return RexType.of(PType.struct());
    }

    @Override
    @NotNull
    protected List<Operand> operands() {
        return List.of();
    }

    @Override
    public <R, C> R accept(OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitStruct(this, ctx);
    }

    private static class Impl
    extends RexStruct {
        @NotNull
        private final List<Field> fields;

        private Impl(@NotNull List<Field> fields) {
            this.fields = fields;
        }

        @Override
        @NotNull
        public List<Field> getFields() {
            return this.fields;
        }
    }

    public static class Field {
        private final Rex key;
        private final Rex value;

        private Field(Rex key, Rex value) {
            this.key = key;
            this.value = value;
        }

        public Rex getKey() {
            return this.key;
        }

        public Rex getValue() {
            return this.value;
        }
    }
}

