/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rel.Rel;
import org.partiql.plan.rex.Rex;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;

public abstract class RexSubquery
extends RexBase {
    @NotNull
    public static RexSubquery create(@NotNull Rel input, @NotNull Rex constructor, boolean scalar) {
        return new Impl(input, constructor, scalar);
    }

    @NotNull
    public abstract Rel getInput();

    @NotNull
    public abstract Rex getConstructor();

    public abstract boolean isScalar();

    @Override
    @NotNull
    protected final RexType type() {
        throw new UnsupportedOperationException("Derive type is not implemented");
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.single(this.getInput());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitSubquery(this, ctx);
    }

    private static class Impl
    extends RexSubquery {
        private final Rel input;
        private final Rex constructor;
        private final boolean scalar;

        private Impl(Rel input, Rex constructor, boolean scalar) {
            this.input = input;
            this.constructor = constructor;
            this.scalar = scalar;
        }

        @Override
        @NotNull
        public Rel getInput() {
            return this.input;
        }

        @Override
        @NotNull
        public Rex getConstructor() {
            return this.constructor;
        }

        @Override
        public boolean isScalar() {
            return this.scalar;
        }
    }
}

