/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rel.Rel;
import org.partiql.plan.rex.Rex;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;
import org.partiql.spi.Enum;
import org.partiql.spi.UnsupportedCodeException;
import org.partiql.spi.types.PType;

public abstract class RexSubqueryComp
extends RexBase {
    @NotNull
    public static RexSubqueryComp create(@NotNull Rel input, @NotNull List<Rex> args, @NotNull Comparison comparison, @NotNull Quantifier quantifier) {
        return new Impl(input, args, comparison, quantifier);
    }

    @NotNull
    public abstract Rel getInput();

    @NotNull
    public abstract List<Rex> getArgs();

    @NotNull
    public abstract Comparison getComparison();

    @NotNull
    public abstract Quantifier getQuantifier();

    @Override
    @NotNull
    protected final RexType type() {
        return RexType.of(PType.bool());
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.single(this.getInput());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitSubqueryComp(this, ctx);
    }

    private static class Impl
    extends RexSubqueryComp {
        private final Rel input;
        private final List<Rex> args;
        private final Comparison comparison;
        private final Quantifier quantifier;

        private Impl(Rel input, List<Rex> args, Comparison comparison, Quantifier quantifier) {
            this.input = input;
            this.args = args;
            this.comparison = comparison;
            this.quantifier = quantifier;
        }

        @Override
        @NotNull
        public Rel getInput() {
            return this.input;
        }

        @Override
        @NotNull
        public List<Rex> getArgs() {
            return this.args;
        }

        @Override
        @NotNull
        public Comparison getComparison() {
            return this.comparison;
        }

        @Override
        @NotNull
        public Quantifier getQuantifier() {
            return this.quantifier;
        }
    }

    public static class Quantifier
    extends Enum {
        public static final int ANY = 1;
        public static final int ALL = 2;
        public static final int SOME = 3;

        private Quantifier(int code) {
            super(code);
        }

        @NotNull
        public String name() throws UnsupportedCodeException {
            int code = this.code();
            switch (code) {
                case 1: {
                    return "ANY";
                }
                case 2: {
                    return "ALL";
                }
                case 3: {
                    return "SOME";
                }
            }
            throw new UnsupportedCodeException(code);
        }

        @NotNull
        public static Quantifier ANY() {
            return new Quantifier(1);
        }

        @NotNull
        public static Quantifier ALL() {
            return new Quantifier(2);
        }

        @NotNull
        public static Quantifier SOME() {
            return new Quantifier(3);
        }
    }

    public static class Comparison
    extends Enum {
        public static final int EQ = 1;
        public static final int NE = 2;
        public static final int LT = 3;
        public static final int LE = 4;
        public static final int GT = 5;
        public static final int GE = 6;

        private Comparison(int code) {
            super(code);
        }

        @NotNull
        public String name() throws UnsupportedCodeException {
            int code = this.code();
            switch (code) {
                case 1: {
                    return "EQ";
                }
                case 2: {
                    return "NE";
                }
                case 3: {
                    return "LT";
                }
                case 4: {
                    return "LE";
                }
                case 5: {
                    return "GT";
                }
                case 6: {
                    return "GE";
                }
            }
            throw new UnsupportedCodeException(code);
        }

        @NotNull
        public static Comparison EQ() {
            return new Comparison(1);
        }

        @NotNull
        public static Comparison NE() {
            return new Comparison(2);
        }

        @NotNull
        public static Comparison LT() {
            return new Comparison(3);
        }

        @NotNull
        public static Comparison LE() {
            return new Comparison(4);
        }

        @NotNull
        public static Comparison GT() {
            return new Comparison(5);
        }

        @NotNull
        public static Comparison GE() {
            return new Comparison(6);
        }
    }
}

