/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rel.Rel;
import org.partiql.plan.rex.Rex;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;
import org.partiql.spi.types.PType;

public abstract class RexSubqueryIn
extends RexBase {
    @NotNull
    public static RexSubqueryIn create(@NotNull Rel input, @NotNull List<Rex> args) {
        return new Impl(input, args);
    }

    @NotNull
    public abstract Rel getInput();

    @NotNull
    public abstract List<Rex> getArgs();

    @Override
    @NotNull
    protected final RexType type() {
        return RexType.of(PType.bool());
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        Operand c0 = Operand.single(this.getInput());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitSubqueryIn(this, ctx);
    }

    private static class Impl
    extends RexSubqueryIn {
        private final Rel input;
        private final List<Rex> args;

        private Impl(Rel input, List<Rex> args) {
            this.input = input;
            this.args = args;
        }

        @Override
        @NotNull
        public Rel getInput() {
            return this.input;
        }

        @Override
        @NotNull
        public List<Rex> getArgs() {
            return this.args;
        }
    }
}

