/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rel.Rel;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;
import org.partiql.spi.Enum;
import org.partiql.spi.UnsupportedCodeException;
import org.partiql.spi.types.PType;

public abstract class RexSubqueryTest
extends RexBase {
    @NotNull
    public static RexSubqueryTest create(@NotNull Rel input, @NotNull Test test) {
        return new Impl(input, test);
    }

    @NotNull
    public abstract Rel getInput();

    @NotNull
    public abstract Test getTest();

    @Override
    @NotNull
    protected final RexType type() {
        return RexType.of(PType.bool());
    }

    @Override
    @NotNull
    protected List<Operand> operands() {
        Operand c0 = Operand.single(this.getInput());
        return List.of(c0);
    }

    @Override
    public <R, C> R accept(OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitSubqueryTest(this, ctx);
    }

    private static class Impl
    extends RexSubqueryTest {
        private final Rel input;
        private final Test test;

        private Impl(Rel input, Test test) {
            this.input = input;
            this.test = test;
        }

        @Override
        @NotNull
        public Rel getInput() {
            return this.input;
        }

        @Override
        @NotNull
        public Test getTest() {
            return this.test;
        }
    }

    public static class Test
    extends Enum {
        public static final int EXISTS = 1;
        public static final int UNIQUE = 2;

        private Test(int code) {
            super(code);
        }

        @NotNull
        public String name() throws UnsupportedCodeException {
            int code = this.code();
            switch (code) {
                case 1: {
                    return "EXISTS";
                }
                case 2: {
                    return "UNIQUE";
                }
            }
            throw new UnsupportedCodeException(code);
        }

        @NotNull
        public static Test EXISTS() {
            return new Test(1);
        }

        @NotNull
        public static Test UNIQUE() {
            return new Test(2);
        }
    }
}

