/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;
import org.partiql.spi.catalog.Table;

public abstract class RexTable
extends RexBase {
    @NotNull
    public static RexTable create(@NotNull Table table) {
        return new Impl(table);
    }

    public abstract Table getTable();

    @Override
    @NotNull
    protected final RexType type() {
        return RexType.of(this.getTable().getSchema());
    }

    @Override
    @NotNull
    protected final List<Operand> operands() {
        return List.of();
    }

    @Override
    public <R, C> R accept(OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitTable(this, ctx);
    }

    private static class Impl
    extends RexTable {
        private final Table table;

        private Impl(Table table) {
            this.table = table;
        }

        @Override
        public Table getTable() {
            return this.table;
        }
    }
}

