/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.plan.rex;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Operand;
import org.partiql.plan.OperatorVisitor;
import org.partiql.plan.rex.RexBase;
import org.partiql.plan.rex.RexType;
import org.partiql.spi.types.PType;

public abstract class RexVar
extends RexBase {
    @NotNull
    public static RexVar create(int scope, int offset, PType type) {
        return new Impl(scope, offset, type);
    }

    public abstract int getScope();

    public abstract int getOffset();

    @Override
    @NotNull
    protected final List<Operand> operands() {
        return List.of();
    }

    @Override
    public <R, C> R accept(OperatorVisitor<R, C> visitor, C ctx) {
        return visitor.visitVar(this, ctx);
    }

    private static class Impl
    extends RexVar {
        private final int scope;
        private final int offset;
        private final PType type;

        private Impl(int scope, int offset, PType type) {
            this.scope = scope;
            this.offset = offset;
            this.type = type;
        }

        @Override
        @NotNull
        protected RexType type() {
            return RexType.of(this.type);
        }

        @Override
        public int getScope() {
            return this.scope;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }
    }
}

