/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.planner.internal.transforms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstNode;
import org.partiql.ast.Exclude;
import org.partiql.ast.Expr;
import org.partiql.ast.From;
import org.partiql.ast.GroupBy;
import org.partiql.ast.Identifier;
import org.partiql.ast.OrderBy;
import org.partiql.ast.Select;
import org.partiql.ast.SetOp;
import org.partiql.ast.SetQuantifier;
import org.partiql.ast.Sort;
import org.partiql.ast.builder.AstBuilder;
import org.partiql.ast.builder.AstBuilderKt;
import org.partiql.ast.builder.IdentifierSymbolBuilder;
import org.partiql.ast.helpers.ToBinderKt;
import org.partiql.ast.util.AstRewriter;
import org.partiql.ast.visitor.AstBaseVisitor;
import org.partiql.ast.visitor.AstVisitor;
import org.partiql.planner.internal.Env;
import org.partiql.planner.internal.ir.Agg;
import org.partiql.planner.internal.ir.Identifier;
import org.partiql.planner.internal.ir.Plan;
import org.partiql.planner.internal.ir.Rel;
import org.partiql.planner.internal.ir.Rex;
import org.partiql.planner.internal.transforms.AstToPlan;
import org.partiql.planner.internal.transforms.RexConverter;
import org.partiql.types.CollectionType;
import org.partiql.types.StaticType;
import org.partiql.types.StructType;
import org.partiql.value.PartiQL;
import org.partiql.value.PartiQLValue;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\u00020\b*\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/partiql/planner/internal/transforms/RelConverter;", "", "()V", "nil", "Lorg/partiql/planner/internal/ir/Rel;", "getNil$partiql_planner", "()Lorg/partiql/planner/internal/ir/Rel;", "apply", "Lorg/partiql/planner/internal/ir/Rex;", "sfw", "Lorg/partiql/ast/Expr$SFW;", "env", "Lorg/partiql/planner/internal/Env;", "apply$partiql_planner", "syntheticAgg", "", "i", "", "toRex", "Lorg/partiql/ast/Expr;", "AggregationTransform", "ToRel", "partiql-planner"})
public final class RelConverter {
    @NotNull
    public static final RelConverter INSTANCE = new RelConverter();
    @NotNull
    private static final Rel nil = Plan.rel(Plan.relType(CollectionsKt.emptyList(), SetsKt.emptySet()), Plan.relOpErr("nil"));

    private RelConverter() {
    }

    @NotNull
    public final Rel getNil$partiql_planner() {
        return nil;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Rex apply$partiql_planner(@NotNull Expr.SFW sfw, @NotNull Env env) {
        Rex rex2;
        StructType type22;
        Intrinsics.checkNotNullParameter((Object)sfw, (String)"sfw");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Rel rel2 = (Rel)sfw.accept((AstVisitor)new ToRel(env), (Object)nil);
        Select projection = sfw.select;
        if (projection instanceof Select.Pivot) {
            Rex key = this.toRex(((Select.Pivot)projection).key, env);
            Rex value = this.toRex(((Select.Pivot)projection).value, env);
            type22 = StaticType.STRUCT;
            Rex.Op.Pivot op = Plan.rexOpPivot(key, value, rel2);
            rex2 = Plan.rex((StaticType)type22, op);
        } else if (projection instanceof Select.Value) {
            boolean key;
            boolean bl = key = rel2.type.schema.size() == 1;
            if (_Assertions.ENABLED && !key) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                boolean $i$a$-assert-RelConverter$apply$rex$22 = false;
                Iterable type22 = rel2.type.schema;
                StringBuilder stringBuilder = new StringBuilder().append("Expected SELECT VALUE's input to have a single binding. However, it contained: ");
                boolean $i$f$map = false;
                void var11_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Rel.Binding binding = (Rel.Binding)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.name);
                }
                String $i$a$-assert-RelConverter$apply$rex$22 = stringBuilder.append((List)destination$iv$iv).append('.').toString();
                throw new AssertionError((Object)$i$a$-assert-RelConverter$apply$rex$22);
            }
            Rex constructor = Plan.rex((StaticType)StaticType.ANY, Plan.rexOpVarResolved(0));
            Rex.Op.Select op = Plan.rexOpSelect(constructor, rel2);
            type22 = rel2.type.props.contains((Object)Rel.Prop.ORDERED) ? (CollectionType)StaticType.LIST : (CollectionType)StaticType.BAG;
            rex2 = Plan.rex((StaticType)type22, op);
        } else {
            if (projection instanceof Select.Star) {
                throw new IllegalArgumentException("AST not normalized");
            }
            if (projection instanceof Select.Project) {
                throw new IllegalArgumentException("AST not normalized");
            }
            throw new NoWhenBranchMatchedException();
        }
        Rex rex3 = rex2;
        return rex3;
    }

    private final Rex toRex(Expr $this$toRex, Env env) {
        return RexConverter.INSTANCE.apply$partiql_planner($this$toRex, env);
    }

    private final String syntheticAgg(int i) {
        return "$agg_" + i;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J.\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u0018\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u001b\u001a\u0004\u0018\u00010\u0019H\u0002J\u001a\u0010\u001c\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u001d\u001a\u0004\u0018\u00010\u0019H\u0002J\u001a\u0010\u001e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0\u00072\u0006\u0010$\u001a\u00020%H\u0002J\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0\u00072\u0006\u0010$\u001a\u00020'H\u0002J\u001c\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0\u00072\u0006\u0010$\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\"H\u0002J \u0010-\u001a\u00020\u00022\u0006\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\"2\u0006\u0010.\u001a\u00020\"H\u0002J\u001a\u0010/\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\b\u00100\u001a\u0004\u0018\u000101H\u0002J \u00102\u001a\u00020\u00022\u0006\u0010+\u001a\u00020#2\u0006\u00103\u001a\u00020\"2\u0006\u00104\u001a\u00020\"H\u0002J\u001a\u00105\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\u0019H\u0002J\u0018\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u0002082\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u00109\u001a\u00020\u00022\u0006\u00107\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0002H\u0016J\u0018\u0010<\u001a\u00020\u00022\u0006\u00107\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010=\u001a\u00020\u00022\u0006\u00107\u001a\u00020>2\u0006\u0010?\u001a\u00020\u0002H\u0016J\u0018\u0010@\u001a\u00020\u00022\u0006\u00107\u001a\u00020A2\u0006\u0010?\u001a\u00020\u0002H\u0016J\u0018\u0010B\u001a\u00020\u00022\u0006\u00107\u001a\u00020C2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010D\u001a\u00020\u00022\u0006\u00107\u001a\u00020E2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001a\u0010F\u001a\u00020\u00022\b\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010\t\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lorg/partiql/planner/internal/transforms/RelConverter$ToRel;", "Lorg/partiql/ast/visitor/AstBaseVisitor;", "Lorg/partiql/planner/internal/ir/Rel;", "env", "Lorg/partiql/planner/internal/Env;", "(Lorg/partiql/planner/internal/Env;)V", "convertAgg", "Lkotlin/Pair;", "Lorg/partiql/ast/Expr$SFW;", "input", "select", "groupBy", "Lorg/partiql/ast/GroupBy;", "convertExclude", "exclude", "Lorg/partiql/ast/Exclude;", "convertExcludeItem", "Lorg/partiql/planner/internal/ir/Rel$Op$Exclude$Item;", "expr", "Lorg/partiql/ast/Exclude$Item;", "convertExcludeStep", "Lorg/partiql/planner/internal/ir/Rel$Op$Exclude$Step;", "step", "Lorg/partiql/ast/Exclude$Step;", "convertHaving", "Lorg/partiql/ast/Expr;", "convertLimit", "limit", "convertOffset", "offset", "convertOrderBy", "orderBy", "Lorg/partiql/ast/OrderBy;", "convertProjectItemAll", "Lorg/partiql/planner/internal/ir/Rel$Binding;", "Lorg/partiql/planner/internal/ir/Rex;", "item", "Lorg/partiql/ast/Select$Project$Item$All;", "convertProjectItemRex", "Lorg/partiql/ast/Select$Project$Item$Expression;", "convertProjectionItem", "Lorg/partiql/ast/Select$Project$Item;", "convertScan", "rex", "binding", "convertScanIndexed", "index", "convertSetOp", "setOp", "Lorg/partiql/ast/Expr$SFW$SetOp;", "convertUnpivot", "k", "v", "convertWhere", "defaultReturn", "node", "Lorg/partiql/ast/AstNode;", "visitExprBagOp", "Lorg/partiql/ast/Expr$BagOp;", "ctx", "visitExprSFW", "visitFromJoin", "Lorg/partiql/ast/From$Join;", "nil", "visitFromValue", "Lorg/partiql/ast/From$Value;", "visitSelectProject", "Lorg/partiql/ast/Select$Project;", "visitSelectValue", "Lorg/partiql/ast/Select$Value;", "visitSetQuantifier", "setQuantifier", "Lorg/partiql/ast/SetQuantifier;", "partiql-planner"})
    public static final class ToRel
    extends AstBaseVisitor<Rel, Rel> {
        @NotNull
        private final Env env;

        public ToRel(@NotNull Env env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            this.env = env;
        }

        @NotNull
        public Rel defaultReturn(@NotNull AstNode node, @NotNull Rel input) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            throw new IllegalArgumentException("unsupported rel " + node);
        }

        @NotNull
        public Rel visitExprSFW(@NotNull Expr.SFW node, @NotNull Rel input) {
            Rel rel2;
            Rel project;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Expr.SFW sel = node;
            Rel rel3 = (Rel)this.visitFrom(sel.from, INSTANCE.getNil$partiql_planner());
            rel3 = this.convertWhere(rel3, sel.where);
            Pair<Expr.SFW, Rel> pair = this.convertAgg(rel3, sel, sel.groupBy);
            Expr.SFW _sel = (Expr.SFW)pair.component1();
            Rel _rel = (Rel)pair.component2();
            sel = _sel;
            rel3 = _rel;
            rel3 = this.convertHaving(rel3, sel.having);
            rel3 = this.convertSetOp(rel3, sel.setOp);
            rel3 = this.convertOrderBy(rel3, sel.orderBy);
            rel3 = this.convertLimit(rel3, sel.limit);
            rel3 = this.convertOffset(rel3, sel.offset);
            rel3 = this.convertExclude(rel3, sel.exclude);
            Select projection = sel.select;
            if (projection instanceof Select.Project) {
                project = this.visitSelectProject((Select.Project)projection, rel3);
                rel2 = this.visitSetQuantifier(((Select.Project)projection).setq, project);
            } else if (projection instanceof Select.Value) {
                project = this.visitSelectValue((Select.Value)projection, rel3);
                rel2 = this.visitSetQuantifier(((Select.Value)projection).setq, project);
            } else {
                if (projection instanceof Select.Star) {
                    throw new IllegalStateException("AST not normalized, found project star".toString());
                }
                if (projection instanceof Select.Pivot) {
                    rel2 = rel3;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            rel3 = rel2;
            return rel3;
        }

        @NotNull
        public Rel visitExprBagOp(@NotNull Expr.BagOp node, @NotNull Rel ctx) {
            Rel.Op op;
            org.partiql.planner.internal.ir.SetQuantifier setQuantifier;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            boolean bl2 = bl = node.lhs instanceof Expr.SFW || node.lhs instanceof Expr.BagOp;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-RelConverter$ToRel$visitExprBagOp$32 = false;
                String $i$a$-assert-RelConverter$ToRel$visitExprBagOp$32 = "Expect LHS of bag op to be a Expr.SFW or a Expr.BagOp. However, it is " + node.lhs + '.';
                throw new AssertionError((Object)$i$a$-assert-RelConverter$ToRel$visitExprBagOp$32);
            }
            boolean bl3 = bl = node.rhs instanceof Expr.SFW || node.rhs instanceof Expr.BagOp;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-RelConverter$ToRel$visitExprBagOp$42 = false;
                String $i$a$-assert-RelConverter$ToRel$visitExprBagOp$42 = "Expect RHS of bag op to be a Expr.SFW or a Expr.BagOp. However, it is " + node.lhs + '.';
                throw new AssertionError((Object)$i$a$-assert-RelConverter$ToRel$visitExprBagOp$42);
            }
            SetQuantifier setQuantifier2 = node.type.setq;
            switch (setQuantifier2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[setQuantifier2.ordinal()]) {
                case 1: {
                    setQuantifier = org.partiql.planner.internal.ir.SetQuantifier.ALL;
                    break;
                }
                case -1: 
                case 2: {
                    setQuantifier = org.partiql.planner.internal.ir.SetQuantifier.DISTINCT;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            org.partiql.planner.internal.ir.SetQuantifier setq = setQuantifier;
            Rel lhsRel = (Rel)this.visitExpr(node.lhs, ctx);
            Rel rhsRel = (Rel)this.visitExpr(node.rhs, ctx);
            switch (WhenMappings.$EnumSwitchMapping$1[node.type.type.ordinal()]) {
                case 1: {
                    op = new Rel.Op.Union(setq, lhsRel, rhsRel);
                    break;
                }
                case 2: {
                    op = new Rel.Op.Except(setq, lhsRel, rhsRel);
                    break;
                }
                case 3: {
                    op = new Rel.Op.Intersect(setq, lhsRel, rhsRel);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Rel.Op op2 = op;
            return new Rel(RelConverter.INSTANCE.getNil$partiql_planner().type, op2);
        }

        private final Rel visitSetQuantifier(SetQuantifier setQuantifier, Rel input) {
            Rel rel2;
            SetQuantifier setQuantifier2 = setQuantifier;
            switch (setQuantifier2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[setQuantifier2.ordinal()]) {
                case 2: {
                    rel2 = Plan.rel(input.type, Plan.relOpDistinct(input));
                    break;
                }
                case -1: 
                case 1: {
                    rel2 = input;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return rel2;
        }

        @NotNull
        public Rel visitSelectProject(@NotNull Select.Project node, @NotNull Rel input) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            List schema = new ArrayList();
            Set<Rel.Prop> props = input.type.props;
            List projections = new ArrayList();
            Iterable $this$forEach$iv = node.items;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Select.Project.Item it = (Select.Project.Item)element$iv;
                boolean bl = false;
                Pair<Rel.Binding, Rex> pair = this.convertProjectionItem(it);
                Rel.Binding binding = (Rel.Binding)pair.component1();
                Rex projection = (Rex)pair.component2();
                schema.add(binding);
                projections.add(projection);
            }
            Rel.Type type2 = Plan.relType(schema, props);
            Rel.Op.Project op = Plan.relOpProject(input, projections);
            return Plan.rel(type2, op);
        }

        @NotNull
        public Rel visitSelectValue(@NotNull Select.Value node, @NotNull Rel input) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            String name = ToBinderKt.toBinder((Expr)node.constructor, (int)1).symbol;
            Rex rex2 = RexConverter.INSTANCE.apply$partiql_planner(node.constructor, this.env);
            List schema = CollectionsKt.listOf((Object)Plan.relBinding(name, rex2.type));
            Set<Rel.Prop> props = input.type.props;
            Rel.Type type2 = Plan.relType(schema, props);
            Rel.Op.Project op = Plan.relOpProject(input, CollectionsKt.listOf((Object)rex2));
            return Plan.rel(type2, op);
        }

        @NotNull
        public Rel visitFromValue(@NotNull From.Value node, @NotNull Rel nil) {
            Rel rel2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)nil, (String)"nil");
            Rex rex2 = RexConverter.INSTANCE.apply$partiql_planner(node.expr, this.env);
            Identifier.Symbol a = node.asAlias;
            if (a == null) {
                throw new IllegalStateException(("AST not normalized, missing AS alias on " + node).toString());
            }
            Rel.Binding binding = Plan.relBinding(a.symbol, rex2.type);
            switch (WhenMappings.$EnumSwitchMapping$2[node.type.ordinal()]) {
                case 1: {
                    Identifier.Symbol i = node.atAlias;
                    if (i == null) {
                        rel2 = this.convertScan(rex2, binding);
                        break;
                    }
                    Rel.Binding index = Plan.relBinding(i.symbol, (StaticType)StaticType.INT);
                    rel2 = this.convertScanIndexed(rex2, binding, index);
                    break;
                }
                case 2: {
                    Identifier.Symbol at = node.atAlias;
                    if (at == null) {
                        throw new IllegalStateException(("AST not normalized, missing AT alias on UNPIVOT " + node).toString());
                    }
                    Rel.Binding atAlias = Plan.relBinding(at.symbol, (StaticType)StaticType.STRING);
                    rel2 = this.convertUnpivot(rex2, atAlias, binding);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return rel2;
        }

        @NotNull
        public Rel visitFromJoin(@NotNull From.Join node, @NotNull Rel nil) {
            Rel.Op.Join.Type type2;
            Object object;
            Set props;
            List schema;
            Rel rhs;
            Rel lhs;
            block10: {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)nil, (String)"nil");
                    lhs = (Rel)this.visitFrom(node.lhs, nil);
                    rhs = (Rel)this.visitFrom(node.rhs, nil);
                    schema = CollectionsKt.emptyList();
                    props = SetsKt.emptySet();
                    object = node.condition;
                    if (object == null) break block9;
                    Expr it = object;
                    boolean bl = false;
                    Rex rex2 = RexConverter.INSTANCE.apply$partiql_planner(it, this.env);
                    object = rex2;
                    if (rex2 != null) break block10;
                }
                object = Plan.rex((StaticType)StaticType.BOOL, Plan.rexOpLit((PartiQLValue)PartiQL.boolValue$default((Boolean)true, null, (int)2, null)));
            }
            Object condition = object;
            From.Join.Type type3 = node.type;
            switch (type3 == null ? -1 : WhenMappings.$EnumSwitchMapping$3[type3.ordinal()]) {
                case 1: 
                case 2: {
                    type2 = Rel.Op.Join.Type.LEFT;
                    break;
                }
                case 3: 
                case 4: {
                    type2 = Rel.Op.Join.Type.RIGHT;
                    break;
                }
                case 5: 
                case 6: {
                    type2 = Rel.Op.Join.Type.FULL;
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    type2 = Rel.Op.Join.Type.INNER;
                    break;
                }
                case -1: {
                    type2 = Rel.Op.Join.Type.INNER;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Rel.Op.Join.Type joinType = type2;
            Rel.Type type4 = Plan.relType(schema, props);
            Rel.Op.Join op = Plan.relOpJoin(lhs, rhs, (Rex)condition, joinType);
            return Plan.rel(type4, op);
        }

        private final Rel convertScan(Rex rex2, Rel.Binding binding) {
            List schema = CollectionsKt.listOf((Object)binding);
            Set props = SetsKt.emptySet();
            Rel.Type type2 = Plan.relType(schema, props);
            Rel.Op.Scan op = Plan.relOpScan(rex2);
            return Plan.rel(type2, op);
        }

        private final Rel convertScanIndexed(Rex rex2, Rel.Binding binding, Rel.Binding index) {
            Object[] objectArray = new Rel.Binding[]{binding, index};
            List schema = CollectionsKt.listOf((Object[])objectArray);
            Set props = SetsKt.emptySet();
            Rel.Type type2 = Plan.relType(schema, props);
            Rel.Op.ScanIndexed op = Plan.relOpScanIndexed(rex2);
            return Plan.rel(type2, op);
        }

        private final Rel convertUnpivot(Rex rex2, Rel.Binding k, Rel.Binding v) {
            Object[] objectArray = new Rel.Binding[]{k, v};
            List schema = CollectionsKt.listOf((Object[])objectArray);
            Set props = SetsKt.emptySet();
            Rel.Type type2 = Plan.relType(schema, props);
            Rel.Op.Unpivot op = Plan.relOpUnpivot(rex2);
            return Plan.rel(type2, op);
        }

        private final Pair<Rel.Binding, Rex> convertProjectionItem(Select.Project.Item item) {
            Pair<Rel.Binding, Rex> pair;
            Select.Project.Item item2 = item;
            if (item2 instanceof Select.Project.Item.All) {
                pair = this.convertProjectItemAll((Select.Project.Item.All)item);
            } else if (item2 instanceof Select.Project.Item.Expression) {
                pair = this.convertProjectItemRex((Select.Project.Item.Expression)item);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return pair;
        }

        private final Pair<Rel.Binding, Rex> convertProjectItemAll(Select.Project.Item.All item) {
            throw new IllegalArgumentException("AST not normalized");
        }

        private final Pair<Rel.Binding, Rex> convertProjectItemRex(Select.Project.Item.Expression item) {
            Identifier.Symbol a = item.asAlias;
            if (a == null) {
                throw new IllegalStateException(("AST not normalized, missing AS alias on projection item " + item).toString());
            }
            String name = a.symbol;
            Rex rex2 = RexConverter.INSTANCE.apply$partiql_planner(item.expr, this.env);
            Rel.Binding binding = Plan.relBinding(name, rex2.type);
            return TuplesKt.to((Object)binding, (Object)rex2);
        }

        private final Rel convertWhere(Rel input, Expr expr) {
            if (expr == null) {
                return input;
            }
            Rel.Type type2 = input.type;
            Rex predicate = INSTANCE.toRex(expr, this.env);
            Rel.Op.Filter op = Plan.relOpFilter(input, predicate);
            return Plan.rel(type2, op);
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Expr.SFW, Rel> convertAgg(Rel input, Expr.SFW select, GroupBy groupBy) {
            Collection collection;
            void $this$mapIndexedTo$iv$iv;
            Pair<Expr.SFW, List<Expr.Agg>> pair = AggregationTransform.INSTANCE.apply(select);
            Expr.SFW sel = (Expr.SFW)pair.component1();
            List aggregations = (List)pair.component2();
            if (aggregations.isEmpty()) {
                if (groupBy != null) {
                    throw new IllegalStateException("GROUP BY with no aggregations in SELECT clause".toString());
                }
                return new Pair((Object)select, (Object)input);
            }
            List schema = new ArrayList();
            Set props = SetsKt.emptySet();
            Rel.Op.Aggregate.Strategy strategy = Rel.Op.Aggregate.Strategy.FULL;
            Iterable $this$mapIndexed$iv = aggregations;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void $this$mapTo$iv$iv;
                void expr;
                void i;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Expr.Agg agg = (Expr.Agg)item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv;
                boolean bl = false;
                Rel.Binding binding = Plan.relBinding(INSTANCE.syntheticAgg((int)i), (StaticType)StaticType.ANY);
                schema.add(binding);
                Iterable $this$map$iv = expr.args;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    void arg;
                    Expr expr2 = (Expr)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(INSTANCE.toRex((Expr)arg, this.env));
                }
                List args = (List)destination$iv$iv2;
                Identifier id2 = AstToPlan.INSTANCE.convert(expr.function);
                Agg.Unresolved fn = Plan.aggUnresolved(id2);
                collection.add(Plan.relOpAggregateCall(fn, args));
            }
            List calls = (List)destination$iv$iv;
            List groups = CollectionsKt.emptyList();
            if (groupBy != null) {
                Rel.Op.Aggregate.Strategy strategy2;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = groupBy.keys;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    GroupBy.Key key = (GroupBy.Key)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl = false;
                    if (it.asAlias == null) {
                        throw new IllegalStateException(("not normalized, group key " + it + " missing unique name").toString());
                    }
                    Identifier.Symbol symbol = it.asAlias;
                    Intrinsics.checkNotNull((Object)symbol);
                    Rel.Binding binding = Plan.relBinding(symbol.symbol, (StaticType)StaticType.ANY);
                    schema.add(binding);
                    collection.add(INSTANCE.toRex(it.expr, this.env));
                }
                groups = (List)destination$iv$iv3;
                switch (WhenMappings.$EnumSwitchMapping$4[groupBy.strategy.ordinal()]) {
                    case 1: {
                        strategy2 = Rel.Op.Aggregate.Strategy.FULL;
                        break;
                    }
                    case 2: {
                        strategy2 = Rel.Op.Aggregate.Strategy.PARTIAL;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                strategy = strategy2;
            }
            Rel.Type type2 = Plan.relType(schema, props);
            Rel.Op.Aggregate op = Plan.relOpAggregate(input, strategy, calls, groups);
            Rel rel2 = Plan.rel(type2, op);
            return new Pair((Object)sel, (Object)rel2);
        }

        private final Rel convertHaving(Rel input, Expr expr) {
            if (expr == null) {
                return input;
            }
            Rel.Type type2 = input.type;
            Rex predicate = INSTANCE.toRex(expr, this.env);
            Rel.Op.Filter op = Plan.relOpFilter(input, predicate);
            return Plan.rel(type2, op);
        }

        private final Rel convertSetOp(Rel input, Expr.SFW.SetOp setOp) {
            Rel.Op op;
            org.partiql.planner.internal.ir.SetQuantifier setQuantifier;
            if (setOp == null) {
                return input;
            }
            Rel.Type type2 = Rel.Type.copy$default(input.type, null, SetsKt.emptySet(), 1, null);
            Rel lhs = input;
            Rel rhs = this.visitExprSFW(setOp.operand, INSTANCE.getNil$partiql_planner());
            SetQuantifier setQuantifier2 = setOp.type.setq;
            switch (setQuantifier2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[setQuantifier2.ordinal()]) {
                case 1: {
                    setQuantifier = org.partiql.planner.internal.ir.SetQuantifier.ALL;
                    break;
                }
                case -1: 
                case 2: {
                    setQuantifier = org.partiql.planner.internal.ir.SetQuantifier.DISTINCT;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            org.partiql.planner.internal.ir.SetQuantifier quantifier = setQuantifier;
            switch (WhenMappings.$EnumSwitchMapping$1[setOp.type.type.ordinal()]) {
                case 1: {
                    op = new Rel.Op.Union(quantifier, lhs, rhs);
                    break;
                }
                case 2: {
                    op = new Rel.Op.Except(quantifier, lhs, rhs);
                    break;
                }
                case 3: {
                    op = new Rel.Op.Intersect(quantifier, lhs, rhs);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Rel.Op op2 = op;
            return Plan.rel(type2, op2);
        }

        /*
         * WARNING - void declaration
         */
        private final Rel convertOrderBy(Rel input, OrderBy orderBy) {
            void $this$mapTo$iv$iv;
            if (orderBy == null) {
                return input;
            }
            Rel.Type type2 = Rel.Type.copy$default(input.type, null, SetsKt.setOf((Object)((Object)Rel.Prop.ORDERED)), 1, null);
            Iterable $this$map$iv = orderBy.sorts;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Rel.Op.Sort.Order order;
                void it;
                Sort sort = (Sort)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Rex rex2 = INSTANCE.toRex(it.expr, this.env);
                Sort.Dir dir = it.dir;
                if ((dir == null ? -1 : WhenMappings.$EnumSwitchMapping$6[dir.ordinal()]) == 1) {
                    Sort.Nulls nulls = it.nulls;
                    order = (nulls == null ? -1 : WhenMappings.$EnumSwitchMapping$5[nulls.ordinal()]) == 1 ? Rel.Op.Sort.Order.DESC_NULLS_LAST : Rel.Op.Sort.Order.DESC_NULLS_FIRST;
                } else {
                    Sort.Nulls nulls = it.nulls;
                    order = (nulls == null ? -1 : WhenMappings.$EnumSwitchMapping$5[nulls.ordinal()]) == 2 ? Rel.Op.Sort.Order.ASC_NULLS_FIRST : Rel.Op.Sort.Order.ASC_NULLS_LAST;
                }
                Rel.Op.Sort.Order order2 = order;
                collection.add(Plan.relOpSortSpec(rex2, order2));
            }
            List specs = (List)destination$iv$iv;
            Rel.Op.Sort op = Plan.relOpSort(input, specs);
            return Plan.rel(type2, op);
        }

        private final Rel convertLimit(Rel input, Expr limit) {
            if (limit == null) {
                return input;
            }
            Rel.Type type2 = input.type;
            Rex rex2 = RexConverter.INSTANCE.apply$partiql_planner(limit, this.env);
            Rel.Op.Limit op = Plan.relOpLimit(input, rex2);
            return Plan.rel(type2, op);
        }

        private final Rel convertOffset(Rel input, Expr offset) {
            if (offset == null) {
                return input;
            }
            Rel.Type type2 = input.type;
            Rex rex2 = RexConverter.INSTANCE.apply$partiql_planner(offset, this.env);
            Rel.Op.Offset op = Plan.relOpOffset(input, rex2);
            return Plan.rel(type2, op);
        }

        /*
         * WARNING - void declaration
         */
        private final Rel convertExclude(Rel input, Exclude exclude) {
            void $this$mapTo$iv$iv;
            if (exclude == null) {
                return input;
            }
            Rel.Type type2 = input.type;
            Iterable $this$map$iv = exclude.items;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Exclude.Item item = (Exclude.Item)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.convertExcludeItem((Exclude.Item)it));
            }
            List items = (List)destination$iv$iv;
            Rel.Op.Exclude op = Plan.relOpExclude(input, items);
            return Plan.rel(type2, op);
        }

        /*
         * WARNING - void declaration
         */
        private final Rel.Op.Exclude.Item convertExcludeItem(Exclude.Item expr) {
            void $this$mapTo$iv$iv;
            Rex.Op.Var root = (Rex.Op.Var)((RelConverter)RelConverter.INSTANCE).toRex((Expr)((Expr)expr.root), (Env)this.env).op;
            Iterable $this$map$iv = expr.steps;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Exclude.Step step = (Exclude.Step)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.convertExcludeStep((Exclude.Step)it));
            }
            List steps = (List)destination$iv$iv;
            return Plan.relOpExcludeItem(root, steps);
        }

        private final Rel.Op.Exclude.Step convertExcludeStep(Exclude.Step step) {
            Rel.Op.Exclude.Step step2;
            Exclude.Step step3 = step;
            if (step3 instanceof Exclude.Step.StructField) {
                step2 = Plan.relOpExcludeStepStructField(AstToPlan.INSTANCE.convert(((Exclude.Step.StructField)step).symbol));
            } else if (step3 instanceof Exclude.Step.CollIndex) {
                step2 = Plan.relOpExcludeStepCollIndex(((Exclude.Step.CollIndex)step).index);
            } else if (step3 instanceof Exclude.Step.StructWildcard) {
                step2 = Plan.relOpExcludeStepStructWildcard();
            } else if (step3 instanceof Exclude.Step.CollWildcard) {
                step2 = Plan.relOpExcludeStepCollWildcard();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return step2;
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;
            public static final /* synthetic */ int[] $EnumSwitchMapping$3;
            public static final /* synthetic */ int[] $EnumSwitchMapping$4;
            public static final /* synthetic */ int[] $EnumSwitchMapping$5;
            public static final /* synthetic */ int[] $EnumSwitchMapping$6;

            static {
                int[] nArray = new int[SetQuantifier.values().length];
                nArray[SetQuantifier.ALL.ordinal()] = 1;
                nArray[SetQuantifier.DISTINCT.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[SetOp.Type.values().length];
                nArray[SetOp.Type.UNION.ordinal()] = 1;
                nArray[SetOp.Type.EXCEPT.ordinal()] = 2;
                nArray[SetOp.Type.INTERSECT.ordinal()] = 3;
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[From.Value.Type.values().length];
                nArray[From.Value.Type.SCAN.ordinal()] = 1;
                nArray[From.Value.Type.UNPIVOT.ordinal()] = 2;
                $EnumSwitchMapping$2 = nArray;
                nArray = new int[From.Join.Type.values().length];
                nArray[From.Join.Type.LEFT_OUTER.ordinal()] = 1;
                nArray[From.Join.Type.LEFT.ordinal()] = 2;
                nArray[From.Join.Type.RIGHT_OUTER.ordinal()] = 3;
                nArray[From.Join.Type.RIGHT.ordinal()] = 4;
                nArray[From.Join.Type.FULL_OUTER.ordinal()] = 5;
                nArray[From.Join.Type.FULL.ordinal()] = 6;
                nArray[From.Join.Type.COMMA.ordinal()] = 7;
                nArray[From.Join.Type.INNER.ordinal()] = 8;
                nArray[From.Join.Type.CROSS.ordinal()] = 9;
                $EnumSwitchMapping$3 = nArray;
                nArray = new int[GroupBy.Strategy.values().length];
                nArray[GroupBy.Strategy.FULL.ordinal()] = 1;
                nArray[GroupBy.Strategy.PARTIAL.ordinal()] = 2;
                $EnumSwitchMapping$4 = nArray;
                nArray = new int[Sort.Nulls.values().length];
                nArray[Sort.Nulls.LAST.ordinal()] = 1;
                nArray[Sort.Nulls.FIRST.ordinal()] = 2;
                $EnumSwitchMapping$5 = nArray;
                nArray = new int[Sort.Dir.values().length];
                nArray[Sort.Dir.DESC.ordinal()] = 1;
                $EnumSwitchMapping$6 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u00062\u0006\u0010\t\u001a\u00020\u0007J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/partiql/planner/internal/transforms/RelConverter$AggregationTransform;", "Lorg/partiql/ast/util/AstRewriter;", "", "Lorg/partiql/ast/Expr$Agg;", "()V", "apply", "Lkotlin/Pair;", "Lorg/partiql/ast/Expr$SFW;", "", "node", "visitExprAgg", "Lorg/partiql/ast/Expr$Var;", "ctx", "visitExprSFW", "Lorg/partiql/ast/AstNode;", "partiql-planner"})
    private static final class AggregationTransform
    extends AstRewriter<List<Expr.Agg>> {
        @NotNull
        public static final AggregationTransform INSTANCE = new AggregationTransform();

        private AggregationTransform() {
        }

        @NotNull
        public final Pair<Expr.SFW, List<Expr.Agg>> apply(@NotNull Expr.SFW node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            List aggs = new ArrayList();
            Expr.SFW select = (Expr.SFW)super.visitExprSFW(node, (Object)aggs);
            return new Pair((Object)select, (Object)aggs);
        }

        @NotNull
        public AstNode visitExprSFW(@NotNull Expr.SFW node, @NotNull List<Expr.Agg> ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            return (AstNode)node;
        }

        @NotNull
        public Expr.Var visitExprAgg(@NotNull Expr.Agg node, @NotNull List<Expr.Agg> ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            return (Expr.Var)AstBuilderKt.ast((Function1)((Function1)new Function1<AstBuilder, Expr.Var>(ctx, node){
                final /* synthetic */ List<Expr.Agg> $ctx;
                final /* synthetic */ Expr.Agg $node;
                {
                    this.$ctx = $ctx;
                    this.$node = $node;
                    super(1);
                }

                @NotNull
                public final Expr.Var invoke(@NotNull AstBuilder $this$ast) {
                    Intrinsics.checkNotNullParameter((Object)$this$ast, (String)"$this$ast");
                    Identifier.Symbol id2 = AstBuilder.identifierSymbol$default((AstBuilder)$this$ast, null, null, (Function1)((Function1)new Function1<IdentifierSymbolBuilder, Unit>(this.$ctx){
                        final /* synthetic */ List<Expr.Agg> $ctx;
                        {
                            this.$ctx = $ctx;
                            super(1);
                        }

                        public final void invoke(@NotNull IdentifierSymbolBuilder $this$identifierSymbol) {
                            Intrinsics.checkNotNullParameter((Object)$this$identifierSymbol, (String)"$this$identifierSymbol");
                            $this$identifierSymbol.setSymbol(RelConverter.access$syntheticAgg(RelConverter.INSTANCE, this.$ctx.size()));
                            $this$identifierSymbol.setCaseSensitivity(Identifier.CaseSensitivity.INSENSITIVE);
                        }
                    }), (int)3, null);
                    ((Collection)this.$ctx).add(this.$node);
                    return AstBuilder.exprVar$default((AstBuilder)$this$ast, (org.partiql.ast.Identifier)((org.partiql.ast.Identifier)id2), (Expr.Var.Scope)Expr.Var.Scope.DEFAULT, null, (int)4, null);
                }
            }));
        }
    }
}

