/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.planner.internal.transforms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstNode;
import org.partiql.ast.DatetimeField;
import org.partiql.ast.Expr;
import org.partiql.ast.SetOp;
import org.partiql.ast.SetQuantifier;
import org.partiql.ast.Type;
import org.partiql.ast.visitor.AstBaseVisitor;
import org.partiql.ast.visitor.AstVisitor;
import org.partiql.planner.internal.Env;
import org.partiql.planner.internal.ir.Fn;
import org.partiql.planner.internal.ir.Identifier;
import org.partiql.planner.internal.ir.Plan;
import org.partiql.planner.internal.ir.Rel;
import org.partiql.planner.internal.ir.Rex;
import org.partiql.planner.internal.ir.builder.PlanBuilder;
import org.partiql.planner.internal.ir.builder.PlanBuilderKt;
import org.partiql.planner.internal.transforms.AstToPlan;
import org.partiql.planner.internal.transforms.RelConverter;
import org.partiql.planner.internal.typer.TypeUtilsKt;
import org.partiql.types.AnyType;
import org.partiql.types.BoolType;
import org.partiql.types.CollectionType;
import org.partiql.types.StaticType;
import org.partiql.types.StructType;
import org.partiql.types.TimeType;
import org.partiql.types.TimestampType;
import org.partiql.value.PartiQL;
import org.partiql.value.PartiQLValue;
import org.partiql.value.StringValue;
import org.partiql.value.io.PartiQLValueIonReaderBuilder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lorg/partiql/planner/internal/transforms/RexConverter;", "", "()V", "apply", "Lorg/partiql/planner/internal/ir/Rex;", "expr", "Lorg/partiql/ast/Expr;", "context", "Lorg/partiql/planner/internal/Env;", "apply$partiql_planner", "ToRex", "partiql-planner"})
public final class RexConverter {
    @NotNull
    public static final RexConverter INSTANCE = new RexConverter();

    private RexConverter() {
    }

    @NotNull
    public final Rex apply$partiql_planner(@NotNull Expr expr, @NotNull Env context) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (Rex)expr.accept((AstVisitor)ToRex.INSTANCE, (Object)context);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J)\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\r\"\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u000eJ)\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\r\"\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010)\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010+\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020,2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0018\u0010-\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020.2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010/\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u0002002\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\"\u00101\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u0002022\u0006\u0010\u001f\u001a\u00020\u00032\b\b\u0002\u00103\u001a\u000204H\u0002J\u0018\u00105\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u0002062\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0018\u00107\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u0002082\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u00109\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020:2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010;\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020<2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010=\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020>2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010?\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020@2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010A\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020B2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010C\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020D2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010E\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020F2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0018\u0010G\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020H2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010I\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020J2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010K\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020L2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0018\u0010M\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020N2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010O\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020P2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0018\u0010Q\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020R2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010S\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020T2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0018\u0010U\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020V2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010W\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020X2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0018\u0010Y\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020Z2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0018\u0010[\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\\2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0013\u0010]\u001a\u00020\u0002*\u0004\u0018\u00010^H\u0002\u00a2\u0006\u0002\u0010_\u00a8\u0006`"}, d2={"Lorg/partiql/planner/internal/transforms/RexConverter$ToRex;", "Lorg/partiql/ast/visitor/AstBaseVisitor;", "Lorg/partiql/planner/internal/ir/Rex;", "Lorg/partiql/planner/internal/Env;", "()V", "bool", "v", "", "call", "Lorg/partiql/planner/internal/ir/Rex$Op$Call$Static;", "name", "", "args", "", "(Ljava/lang/String;[Lorg/partiql/planner/internal/ir/Rex;)Lorg/partiql/planner/internal/ir/Rex$Op$Call$Static;", "callNonHidden", "defaultReturn", "node", "Lorg/partiql/ast/AstNode;", "context", "mergeIdentifiers", "Lorg/partiql/planner/internal/ir/Identifier;", "root", "steps", "", "negate", "Lorg/partiql/planner/internal/ir/Rex$Op$Call;", "rexString", "str", "visitExprBagOp", "Lorg/partiql/ast/Expr$BagOp;", "ctx", "visitExprBetween", "Lorg/partiql/ast/Expr$Between;", "visitExprBinary", "Lorg/partiql/ast/Expr$Binary;", "visitExprCall", "Lorg/partiql/ast/Expr$Call;", "visitExprCallTupleUnion", "visitExprCanCast", "Lorg/partiql/ast/Expr$CanCast;", "visitExprCanLosslessCast", "Lorg/partiql/ast/Expr$CanLosslessCast;", "visitExprCase", "Lorg/partiql/ast/Expr$Case;", "visitExprCast", "Lorg/partiql/ast/Expr$Cast;", "visitExprCoalesce", "Lorg/partiql/ast/Expr$Coalesce;", "visitExprCoerce", "Lorg/partiql/ast/Expr;", "coercion", "Lorg/partiql/planner/internal/ir/Rex$Op$Subquery$Coercion;", "visitExprCollection", "Lorg/partiql/ast/Expr$Collection;", "visitExprDateAdd", "Lorg/partiql/ast/Expr$DateAdd;", "visitExprDateDiff", "Lorg/partiql/ast/Expr$DateDiff;", "visitExprExtract", "Lorg/partiql/ast/Expr$Extract;", "visitExprInCollection", "Lorg/partiql/ast/Expr$InCollection;", "visitExprIon", "Lorg/partiql/ast/Expr$Ion;", "visitExprIsType", "Lorg/partiql/ast/Expr$IsType;", "visitExprLike", "Lorg/partiql/ast/Expr$Like;", "visitExprLit", "Lorg/partiql/ast/Expr$Lit;", "visitExprNullIf", "Lorg/partiql/ast/Expr$NullIf;", "visitExprOverlay", "Lorg/partiql/ast/Expr$Overlay;", "visitExprPath", "Lorg/partiql/ast/Expr$Path;", "visitExprPosition", "Lorg/partiql/ast/Expr$Position;", "visitExprSFW", "Lorg/partiql/ast/Expr$SFW;", "visitExprSessionAttribute", "Lorg/partiql/ast/Expr$SessionAttribute;", "visitExprStruct", "Lorg/partiql/ast/Expr$Struct;", "visitExprSubstring", "Lorg/partiql/ast/Expr$Substring;", "visitExprTrim", "Lorg/partiql/ast/Expr$Trim;", "visitExprUnary", "Lorg/partiql/ast/Expr$Unary;", "visitExprVar", "Lorg/partiql/ast/Expr$Var;", "toRex", "", "(Ljava/lang/Integer;)Lorg/partiql/planner/internal/ir/Rex;", "partiql-planner"})
    private static final class ToRex
    extends AstBaseVisitor<Rex, Env> {
        @NotNull
        public static final ToRex INSTANCE = new ToRex();

        private ToRex() {
        }

        @NotNull
        public Rex defaultReturn(@NotNull AstNode node, @NotNull Env context) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            throw new IllegalArgumentException("unsupported rex " + node);
        }

        @NotNull
        public Rex visitExprLit(@NotNull Expr.Lit node, @NotNull Env context) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            StaticType type2 = node.value.isNull() ? TypeUtilsKt.toStaticType(node.value.getType()) : TypeUtilsKt.toNonNullStaticType(node.value.getType());
            Rex.Op.Lit op = Plan.rexOpLit(node.value);
            return Plan.rex(type2, op);
        }

        @NotNull
        public Rex visitExprIon(@NotNull Expr.Ion node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            PartiQLValue value = PartiQLValueIonReaderBuilder.Companion.standard().build(node.value).read();
            StaticType type2 = value.isNull() ? TypeUtilsKt.toStaticType(value.getType()) : TypeUtilsKt.toNonNullStaticType(value.getType());
            return Plan.rex(type2, Plan.rexOpLit(value));
        }

        private final Rex visitExprCoerce(Expr node, Env ctx, Rex.Op.Subquery.Coercion coercion) {
            Rex rex2 = (Rex)super.visitExpr(node, (Object)ctx);
            return rex2.op instanceof Rex.Op.Select ? Plan.rex((StaticType)StaticType.ANY, Plan.rexOpSubquery((Rex.Op.Select)rex2.op, coercion)) : rex2;
        }

        static /* synthetic */ Rex visitExprCoerce$default(ToRex toRex, Expr expr, Env env, Rex.Op.Subquery.Coercion coercion, int n, Object object) {
            if ((n & 4) != 0) {
                coercion = Rex.Op.Subquery.Coercion.SCALAR;
            }
            return toRex.visitExprCoerce(expr, env, coercion);
        }

        @NotNull
        public Rex visitExprVar(@NotNull Expr.Var node, @NotNull Env context) {
            Rex.Op.Var.Scope scope;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            AnyType type2 = StaticType.ANY;
            Identifier identifier = AstToPlan.INSTANCE.convert(node.identifier);
            switch (WhenMappings.$EnumSwitchMapping$0[node.scope.ordinal()]) {
                case 1: {
                    scope = Rex.Op.Var.Scope.DEFAULT;
                    break;
                }
                case 2: {
                    scope = Rex.Op.Var.Scope.LOCAL;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Rex.Op.Var.Scope scope2 = scope;
            Rex.Op.Var.Unresolved op = Plan.rexOpVarUnresolved(identifier, scope2);
            return Plan.rex((StaticType)type2, op);
        }

        @NotNull
        public Rex visitExprUnary(@NotNull Expr.Unary node, @NotNull Env context) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            AnyType type2 = StaticType.ANY;
            Rex arg = ToRex.visitExprCoerce$default(this, node.expr, context, null, 4, null);
            List args = CollectionsKt.listOf((Object)arg);
            String string = node.op.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            Identifier.Symbol id2 = Plan.identifierSymbol(string, Identifier.CaseSensitivity.SENSITIVE);
            Fn.Unresolved fn = Plan.fnUnresolved(id2, true);
            Rex.Op.Call.Static op = Plan.rexOpCallStatic(fn, args);
            return Plan.rex((StaticType)type2, op);
        }

        @NotNull
        public Rex visitExprBinary(@NotNull Expr.Binary node, @NotNull Env context) {
            Rex rex2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            AnyType type2 = StaticType.ANY;
            Rex lhs = ToRex.visitExprCoerce$default(this, node.lhs, context, null, 4, null);
            Rex rhs = ToRex.visitExprCoerce$default(this, node.rhs, context, null, 4, null);
            Object[] objectArray = new Rex[]{lhs, rhs};
            List args = CollectionsKt.listOf((Object[])objectArray);
            if (WhenMappings.$EnumSwitchMapping$1[node.op.ordinal()] == 1) {
                Rex[] rexArray = new Rex[]{lhs, rhs};
                Rex.Op.Call.Static op = this.negate(this.call("eq", rexArray));
                rex2 = Plan.rex((StaticType)type2, op);
            } else {
                String string = node.op.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                Identifier.Symbol id2 = Plan.identifierSymbol(string, Identifier.CaseSensitivity.SENSITIVE);
                Fn.Unresolved fn = Plan.fnUnresolved(id2, true);
                Rex.Op.Call.Static op = Plan.rexOpCallStatic(fn, args);
                rex2 = Plan.rex((StaticType)type2, op);
            }
            return rex2;
        }

        /*
         * WARNING - void declaration
         */
        private final Identifier mergeIdentifiers(Identifier root, List<? extends Identifier> steps) {
            void $this$flatMapTo$iv$iv;
            Pair pair;
            if (steps.isEmpty()) {
                return root;
            }
            Identifier identifier = root;
            if (identifier instanceof Identifier.Symbol) {
                pair = TuplesKt.to((Object)root, (Object)CollectionsKt.emptyList());
            } else if (identifier instanceof Identifier.Qualified) {
                pair = TuplesKt.to((Object)((Identifier.Qualified)root).root, ((Identifier.Qualified)root).steps);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Pair pair2 = pair;
            Identifier.Symbol newRoot = (Identifier.Symbol)pair2.component1();
            List firstSteps = (List)pair2.component2();
            Iterable $this$flatMap$iv = steps;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List list;
                Identifier step = (Identifier)element$iv$iv;
                boolean bl = false;
                Identifier identifier2 = step;
                if (identifier2 instanceof Identifier.Symbol) {
                    list = CollectionsKt.listOf((Object)step);
                } else if (identifier2 instanceof Identifier.Qualified) {
                    list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((Identifier.Qualified)step).root), (Iterable)((Identifier.Qualified)step).steps);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List followingSteps = (List)destination$iv$iv;
            return Plan.identifierQualified(newRoot, CollectionsKt.plus((Collection)firstSteps, (Iterable)followingSteps));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public Rex visitExprPath(@NotNull Expr.Path node, @NotNull Env context) {
            Rex rex2;
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Rex root = ToRex.visitExprCoerce$default(this, node.root, context, null, 4, null);
            Rex.Op op = root.op;
            if (op instanceof Rex.Op.Var.Unresolved) {
                List identifierSteps = new ArrayList();
                ToRex $this$visitExprPath_u24lambda_u2d2 = this;
                boolean bl = false;
                Iterable $this$forEach$iv = node.steps;
                boolean $i$f$forEach = false;
                for (Object t : $this$forEach$iv) {
                    Expr.Path.Step step = (Expr.Path.Step)t;
                    boolean bl2 = false;
                    if (!(step instanceof Expr.Path.Step.Symbol)) break;
                    identifierSteps.add(AstToPlan.INSTANCE.convert(((Expr.Path.Step.Symbol)step).symbol));
                }
                if (identifierSteps.size() == 0) {
                    pair = TuplesKt.to((Object)root, (Object)node.steps);
                } else {
                    Rex newRoot = Plan.rex((StaticType)StaticType.ANY, Plan.rexOpVarUnresolved(this.mergeIdentifiers(((Rex.Op.Var.Unresolved)op).identifier, identifierSteps), ((Rex.Op.Var.Unresolved)op).scope));
                    List newSteps = node.steps.subList(identifierSteps.size(), node.steps.size());
                    pair = TuplesKt.to((Object)newRoot, newSteps);
                }
            } else {
                pair = TuplesKt.to((Object)root, (Object)node.steps);
            }
            Pair pair2 = pair;
            Rex newRoot = (Rex)pair2.component1();
            List newSteps = (List)pair2.component2();
            boolean bl = newSteps.isEmpty();
            if (bl) {
                rex2 = newRoot;
                return rex2;
            }
            if (bl) throw new NoWhenBranchMatchedException();
            Iterable $this$fold$iv = newSteps;
            boolean $i$f$fold = false;
            Rex accumulator$iv = newRoot;
            for (Object element$iv : $this$fold$iv) {
                Rex.Op.Path path;
                block19: {
                    Expr.Path.Step step;
                    block20: {
                        Rex current;
                        Expr.Path.Step step2;
                        block18: {
                            step2 = (Expr.Path.Step)element$iv;
                            current = accumulator$iv;
                            boolean bl3 = false;
                            step = step2;
                            if (!(step instanceof Expr.Path.Step.Index)) break block18;
                            Rex key = ToRex.visitExprCoerce$default(INSTANCE, ((Expr.Path.Step.Index)step2).key, context, null, 4, null);
                            Expr astKey = ((Expr.Path.Step.Index)step2).key;
                            if (astKey instanceof Expr.Lit) {
                                path = ((Expr.Lit)astKey).value instanceof StringValue ? (Rex.Op.Path)Plan.rexOpPathKey(current, key) : (Rex.Op.Path)Plan.rexOpPathIndex(current, key);
                            } else if (astKey instanceof Expr.Cast) {
                                boolean bl4 = ((Expr.Cast)astKey).asType instanceof Type.String;
                                if (bl4) {
                                    path = Plan.rexOpPathKey(current, key);
                                } else {
                                    if (bl4) throw new NoWhenBranchMatchedException();
                                    path = Plan.rexOpPathIndex(current, key);
                                }
                            } else {
                                path = Plan.rexOpPathIndex(current, key);
                            }
                            break block19;
                        }
                        if (!(step instanceof Expr.Path.Step.Symbol)) break block20;
                        Identifier.Symbol identifier = AstToPlan.INSTANCE.convert(((Expr.Path.Step.Symbol)step2).symbol);
                        switch (WhenMappings.$EnumSwitchMapping$2[identifier.caseSensitivity.ordinal()]) {
                            case 1: {
                                path = Plan.rexOpPathKey(current, INSTANCE.rexString(identifier.symbol));
                                break block19;
                            }
                            case 2: {
                                path = Plan.rexOpPathSymbol(current, identifier.symbol);
                                break block19;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    if (step instanceof Expr.Path.Step.Unpivot) {
                        throw new IllegalStateException("Unpivot path not supported yet".toString());
                    }
                    if (!(step instanceof Expr.Path.Step.Wildcard)) throw new NoWhenBranchMatchedException();
                    throw new IllegalStateException("Wildcard path not supported yet".toString());
                }
                Rex.Op.Path path2 = path;
                accumulator$iv = Plan.rex((StaticType)StaticType.ANY, path2);
            }
            rex2 = accumulator$iv;
            return rex2;
        }

        private final Rex rexString(String str) {
            return Plan.rex((StaticType)StaticType.STRING, Plan.rexOpLit((PartiQLValue)PartiQL.stringValue$default((String)str, null, (int)2, null)));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Rex visitExprCall(@NotNull Expr.Call node, @NotNull Env context) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            AnyType type2 = StaticType.ANY;
            Identifier id2 = AstToPlan.INSTANCE.convert(node.function);
            if (id2 instanceof Identifier.Symbol && StringsKt.equals((String)((Identifier.Symbol)id2).symbol, (String)"TUPLEUNION", (boolean)true)) {
                return this.visitExprCallTupleUnion(node, context);
            }
            Fn.Unresolved fn = Plan.fnUnresolved(id2, false);
            Iterable $this$map$iv = node.args;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Expr expr = (Expr)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ToRex.visitExprCoerce$default(INSTANCE, (Expr)it, context, null, 4, null));
            }
            List args = (List)destination$iv$iv;
            Rex.Op.Call.Static op = Plan.rexOpCallStatic(fn, args);
            return Plan.rex((StaticType)type2, op);
        }

        /*
         * WARNING - void declaration
         */
        private final Rex visitExprCallTupleUnion(Expr.Call node, Env context) {
            void $this$mapTo$iv$iv;
            StructType type2 = StaticType.STRUCT;
            Iterable $this$map$iv = node.args;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Expr expr = (Expr)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ToRex.visitExprCoerce$default(INSTANCE, (Expr)it, context, null, 4, null));
            }
            List args = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            Rex.Op.TupleUnion op = Plan.rexOpTupleUnion(args);
            return Plan.rex((StaticType)type2, op);
        }

        @NotNull
        public Rex visitExprCase(@NotNull Expr.Case node, @NotNull Env context) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return (Rex)PlanBuilderKt.plan((Function1)new Function1<PlanBuilder, Rex>(node, context){
                final /* synthetic */ Expr.Case $node;
                final /* synthetic */ Env $context;
                {
                    this.$node = $node;
                    this.$context = $context;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Rex invoke(@NotNull PlanBuilder $this$plan) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Rex rex2;
                    Intrinsics.checkNotNullParameter((Object)$this$plan, (String)"$this$plan");
                    AnyType type2 = StaticType.ANY;
                    if (this.$node.expr != null) {
                        Expr expr = this.$node.expr;
                        Intrinsics.checkNotNull((Object)expr);
                        rex2 = ToRex.visitExprCoerce$default(ToRex.INSTANCE, expr, this.$context, null, 4, null);
                    } else {
                        rex2 = null;
                    }
                    Rex rex3 = rex2;
                    String string = Expr.Binary.Op.EQ.name().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    Identifier.Symbol id2 = PlanBuilder.identifierSymbol$partiql_planner$default($this$plan, string, Identifier.CaseSensitivity.SENSITIVE, null, 4, null);
                    Fn.Unresolved fn = PlanBuilder.fnUnresolved$partiql_planner$default($this$plan, id2, true, null, 4, null);
                    Function2 createBranch2 = (Function2)new Function2<Rex, Rex, Rex.Op.Case.Branch>(rex3, $this$plan, type2, fn){
                        final /* synthetic */ Rex $rex;
                        final /* synthetic */ PlanBuilder $this_plan;
                        final /* synthetic */ AnyType $type;
                        final /* synthetic */ Fn.Unresolved $fn;
                        {
                            this.$rex = $rex;
                            this.$this_plan = $this_plan;
                            this.$type = $type;
                            this.$fn = $fn;
                            super(2);
                        }

                        @NotNull
                        public final Rex.Op.Case.Branch invoke(@NotNull Rex condition, @NotNull Rex result) {
                            Rex rex2;
                            Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
                            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                            if (this.$rex == null) {
                                rex2 = condition;
                            } else {
                                Object[] objectArray = new Rex[]{this.$rex, condition};
                                rex2 = PlanBuilder.rex$partiql_planner$default(this.$this_plan, (StaticType)this.$type, Plan.rexOpCallStatic(Fn.Unresolved.copy$default(this.$fn, null, false, 3, null), CollectionsKt.listOf((Object[])objectArray)), null, 4, null);
                            }
                            Rex updatedCondition = rex2;
                            return PlanBuilder.rexOpCaseBranch$partiql_planner$default(this.$this_plan, updatedCondition, result, null, 4, null);
                        }
                    };
                    Iterable iterable = this.$node.branches;
                    Env env = this.$context;
                    boolean $i$f$map = false;
                    void var11_10 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Expr.Case.Branch branch = (Expr.Case.Branch)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        Rex branchCondition = ToRex.visitExprCoerce$default(ToRex.INSTANCE, it.condition, env, null, 4, null);
                        Rex branchRex = ToRex.visitExprCoerce$default(ToRex.INSTANCE, it.expr, env, null, 4, null);
                        collection.add((Rex.Op.Case.Branch)createBranch2.invoke((Object)branchCondition, (Object)branchRex));
                    }
                    List branches = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                    Expr expr = this.$node.default;
                    Rex defaultRex = expr == null ? PlanBuilder.rex$partiql_planner$default($this$plan, (StaticType)StaticType.NULL, PlanBuilder.rexOpLit$partiql_planner$default($this$plan, (PartiQLValue)PartiQL.nullValue$default(null, (int)1, null), null, 2, null), null, 4, null) : ToRex.visitExprCoerce$default(ToRex.INSTANCE, expr, this.$context, null, 4, null);
                    Rex.Op.Case op = PlanBuilder.rexOpCase$partiql_planner$default($this$plan, branches, defaultRex, null, 4, null);
                    return PlanBuilder.rex$partiql_planner$default($this$plan, (StaticType)type2, op, null, 4, null);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Rex visitExprCollection(@NotNull Expr.Collection node, @NotNull Env context) {
            void $this$mapTo$iv$iv;
            CollectionType collectionType;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            switch (WhenMappings.$EnumSwitchMapping$3[node.type.ordinal()]) {
                case 1: {
                    collectionType = (CollectionType)StaticType.BAG;
                    break;
                }
                case 2: {
                    collectionType = (CollectionType)StaticType.LIST;
                    break;
                }
                case 3: {
                    collectionType = (CollectionType)StaticType.LIST;
                    break;
                }
                case 4: {
                    collectionType = (CollectionType)StaticType.LIST;
                    break;
                }
                case 5: {
                    collectionType = (CollectionType)StaticType.SEXP;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            CollectionType type2 = collectionType;
            Iterable $this$map$iv = node.values;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Expr expr = (Expr)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ToRex.visitExprCoerce$default(INSTANCE, (Expr)it, context, null, 4, null));
            }
            List values = (List)destination$iv$iv;
            Rex.Op.Collection op = Plan.rexOpCollection(values);
            return Plan.rex((StaticType)type2, op);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Rex visitExprStruct(@NotNull Expr.Struct node, @NotNull Env context) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            StructType type2 = StaticType.STRUCT;
            Iterable $this$map$iv = node.fields;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Expr.Struct.Field field = (Expr.Struct.Field)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Rex k = ToRex.visitExprCoerce$default(INSTANCE, it.name, context, null, 4, null);
                Rex v = ToRex.visitExprCoerce$default(INSTANCE, it.value, context, null, 4, null);
                collection.add(Plan.rexOpStructField(k, v));
            }
            List fields = (List)destination$iv$iv;
            Rex.Op.Struct op = Plan.rexOpStruct(fields);
            return Plan.rex((StaticType)type2, op);
        }

        @NotNull
        public Rex visitExprLike(@NotNull Expr.Like node, @NotNull Env ctx) {
            Rex.Op.Call.Static call;
            Rex.Op.Call.Static static_;
            Rex[] rexArray;
            Rex arg2;
            Rex rex2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            BoolType type2 = StaticType.BOOL;
            Rex arg0 = ToRex.visitExprCoerce$default(this, node.value, ctx, null, 4, null);
            Rex arg1 = ToRex.visitExprCoerce$default(this, node.pattern, ctx, null, 4, null);
            Expr expr = node.escape;
            if (expr != null) {
                Expr it = expr;
                boolean bl = false;
                rex2 = ToRex.visitExprCoerce$default(INSTANCE, it, ctx, null, 4, null);
            } else {
                rex2 = arg2 = null;
            }
            if (arg2 == null) {
                rexArray = new Rex[]{arg0, arg1};
                static_ = this.call("like", rexArray);
            } else {
                rexArray = new Rex[]{arg0, arg1, arg2};
                static_ = call = this.call("like_escape", rexArray);
            }
            if (Intrinsics.areEqual((Object)node.not, (Object)true)) {
                call = this.negate(call);
            }
            return Plan.rex((StaticType)type2, call);
        }

        @NotNull
        public Rex visitExprBetween(@NotNull Expr.Between node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return (Rex)PlanBuilderKt.plan((Function1)new Function1<PlanBuilder, Rex>(node, ctx){
                final /* synthetic */ Expr.Between $node;
                final /* synthetic */ Env $ctx;
                {
                    this.$node = $node;
                    this.$ctx = $ctx;
                    super(1);
                }

                @NotNull
                public final Rex invoke(@NotNull PlanBuilder $this$plan) {
                    Intrinsics.checkNotNullParameter((Object)$this$plan, (String)"$this$plan");
                    BoolType type2 = StaticType.BOOL;
                    Rex arg0 = ToRex.visitExprCoerce$default(ToRex.INSTANCE, this.$node.value, this.$ctx, null, 4, null);
                    Rex arg1 = ToRex.visitExprCoerce$default(ToRex.INSTANCE, this.$node.from, this.$ctx, null, 4, null);
                    Rex arg2 = ToRex.visitExprCoerce$default(ToRex.INSTANCE, this.$node.to, this.$ctx, null, 4, null);
                    Rex[] rexArray = new Rex[]{arg0, arg1, arg2};
                    Rex.Op.Call.Static call = ToRex.access$call(ToRex.INSTANCE, "between", rexArray);
                    if (Intrinsics.areEqual((Object)this.$node.not, (Object)true)) {
                        call = ToRex.access$negate(ToRex.INSTANCE, call);
                    }
                    return PlanBuilder.rex$partiql_planner$default($this$plan, (StaticType)type2, call, null, 4, null);
                }
            });
        }

        @NotNull
        public Rex visitExprInCollection(@NotNull Expr.InCollection node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            BoolType type2 = StaticType.BOOL;
            Rex arg0 = ToRex.visitExprCoerce$default(this, node.lhs, ctx, null, 4, null);
            Rex arg1 = (Rex)this.visitExpr(node.rhs, ctx);
            Rex[] rexArray = new Rex[]{arg0, arg1};
            Rex.Op.Call.Static call = this.call("in_collection", rexArray);
            if (Intrinsics.areEqual((Object)node.not, (Object)true)) {
                call = this.negate(call);
            }
            return Plan.rex((StaticType)type2, call);
        }

        @NotNull
        public Rex visitExprIsType(@NotNull Expr.IsType node, @NotNull Env ctx) {
            Rex.Op.Call.Static static_;
            Rex[] rexArray;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            BoolType type2 = StaticType.BOOL;
            Rex arg0 = ToRex.visitExprCoerce$default(this, node.value, ctx, null, 4, null);
            Type targetType = node.type;
            if (targetType instanceof Type.NullType) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_null", rexArray);
            } else if (targetType instanceof Type.Missing) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_missing", rexArray);
            } else if (targetType instanceof Type.Bool) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_bool", rexArray);
            } else if (targetType instanceof Type.Tinyint) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_int8", rexArray);
            } else if (targetType instanceof Type.Smallint ? true : targetType instanceof Type.Int2) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_int16", rexArray);
            } else if (targetType instanceof Type.Int4) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_int32", rexArray);
            } else if (targetType instanceof Type.Bigint ? true : targetType instanceof Type.Int8) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_int64", rexArray);
            } else if (targetType instanceof Type.Int) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_int", rexArray);
            } else if (targetType instanceof Type.Real) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_real", rexArray);
            } else if (targetType instanceof Type.Float32) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_float32", rexArray);
            } else if (targetType instanceof Type.Float64) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_float64", rexArray);
            } else if (targetType instanceof Type.Decimal) {
                rexArray = new Rex[]{this.toRex(((Type.Decimal)targetType).precision), this.toRex(((Type.Decimal)targetType).scale), arg0};
                static_ = this.call("is_decimal", rexArray);
            } else if (targetType instanceof Type.Numeric) {
                rexArray = new Rex[]{this.toRex(((Type.Numeric)targetType).precision), this.toRex(((Type.Numeric)targetType).scale), arg0};
                static_ = this.call("is_numeric", rexArray);
            } else if (targetType instanceof Type.Char) {
                rexArray = new Rex[]{this.toRex(((Type.Char)targetType).length), arg0};
                static_ = this.call("is_char", rexArray);
            } else if (targetType instanceof Type.Varchar) {
                rexArray = new Rex[]{this.toRex(((Type.Varchar)targetType).length), arg0};
                static_ = this.call("is_varchar", rexArray);
            } else if (targetType instanceof Type.String) {
                rexArray = new Rex[]{this.toRex(((Type.String)targetType).length), arg0};
                static_ = this.call("is_string", rexArray);
            } else if (targetType instanceof Type.Symbol) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_symbol", rexArray);
            } else if (targetType instanceof Type.Bit) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_bit", rexArray);
            } else if (targetType instanceof Type.BitVarying) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_bitVarying", rexArray);
            } else if (targetType instanceof Type.ByteString) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_byteString", rexArray);
            } else if (targetType instanceof Type.Blob) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_blob", rexArray);
            } else if (targetType instanceof Type.Clob) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_clob", rexArray);
            } else if (targetType instanceof Type.Date) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_date", rexArray);
            } else if (targetType instanceof Type.Time) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_time", rexArray);
            } else if (targetType instanceof Type.TimeWithTz) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_timeWithTz", rexArray);
            } else if (targetType instanceof Type.Timestamp) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_timestamp", rexArray);
            } else if (targetType instanceof Type.TimestampWithTz) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_timestampWithTz", rexArray);
            } else if (targetType instanceof Type.Interval) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_interval", rexArray);
            } else if (targetType instanceof Type.Bag) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_bag", rexArray);
            } else if (targetType instanceof Type.List) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_list", rexArray);
            } else if (targetType instanceof Type.Sexp) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_sexp", rexArray);
            } else if (targetType instanceof Type.Tuple) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_tuple", rexArray);
            } else if (targetType instanceof Type.Struct) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_struct", rexArray);
            } else if (targetType instanceof Type.Any) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_any", rexArray);
            } else if (targetType instanceof Type.Custom) {
                rexArray = new Rex[]{arg0};
                static_ = this.call("is_custom", rexArray);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Rex.Op.Call.Static call = static_;
            if (Intrinsics.areEqual((Object)node.not, (Object)true)) {
                call = this.negate(call);
            }
            return Plan.rex((StaticType)type2, call);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Rex visitExprCoalesce(@NotNull Expr.Coalesce node, @NotNull Env ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            AnyType type2 = StaticType.ANY;
            Iterable $this$map$iv = node.args;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void arg;
                Expr expr = (Expr)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ToRex.visitExprCoerce$default(INSTANCE, (Expr)arg, ctx, null, 4, null));
            }
            List args = (List)destination$iv$iv;
            Rex.Op.Coalesce op = Plan.rexOpCoalesce(args);
            return Plan.rex((StaticType)type2, op);
        }

        @NotNull
        public Rex visitExprNullIf(@NotNull Expr.NullIf node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            AnyType type2 = StaticType.ANY;
            Rex value = ToRex.visitExprCoerce$default(this, node.value, ctx, null, 4, null);
            Rex nullifier = ToRex.visitExprCoerce$default(this, node.nullifier, ctx, null, 4, null);
            Rex.Op.Nullif op = Plan.rexOpNullif(value, nullifier);
            return Plan.rex((StaticType)type2, op);
        }

        @NotNull
        public Rex visitExprSubstring(@NotNull Expr.Substring node, @NotNull Env ctx) {
            Rex.Op.Call.Static static_;
            Rex[] rexArray;
            Rex arg2;
            Rex rex2;
            Expr it;
            Object object;
            Rex arg0;
            AnyType type2;
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    type2 = StaticType.ANY;
                    arg0 = ToRex.visitExprCoerce$default(this, node.value, ctx, null, 4, null);
                    object = node.start;
                    if (object == null) break block7;
                    it = object;
                    boolean bl = false;
                    Rex rex3 = ToRex.visitExprCoerce$default(INSTANCE, it, ctx, null, 4, null);
                    object = rex3;
                    if (rex3 != null) break block8;
                }
                object = Plan.rex((StaticType)StaticType.INT, Plan.rexOpLit((PartiQLValue)PartiQL.int64Value$default((Long)1L, null, (int)2, null)));
            }
            Object arg1 = object;
            Expr expr = node.length;
            if (expr != null) {
                it = expr;
                boolean bl = false;
                rex2 = ToRex.visitExprCoerce$default(INSTANCE, it, ctx, null, 4, null);
            } else {
                rex2 = arg2 = null;
            }
            if (arg2 == null) {
                rexArray = new Rex[]{arg0, arg1};
                static_ = this.call("substring", rexArray);
            } else {
                rexArray = new Rex[]{arg0, arg1, arg2};
                static_ = this.call("substring_length", rexArray);
            }
            Rex.Op.Call.Static call = static_;
            return Plan.rex((StaticType)type2, call);
        }

        @NotNull
        public Rex visitExprPosition(@NotNull Expr.Position node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            AnyType type2 = StaticType.ANY;
            Rex arg0 = ToRex.visitExprCoerce$default(this, node.lhs, ctx, null, 4, null);
            Rex arg1 = ToRex.visitExprCoerce$default(this, node.rhs, ctx, null, 4, null);
            Rex[] rexArray = new Rex[]{arg0, arg1};
            Rex.Op.Call.Static call = this.call("position", rexArray);
            return Plan.rex((StaticType)type2, call);
        }

        @NotNull
        public Rex visitExprTrim(@NotNull Expr.Trim node, @NotNull Env ctx) {
            Rex.Op.Call.Static static_;
            Rex rex2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            StaticType type2 = StaticType.TEXT;
            Rex arg0 = ToRex.visitExprCoerce$default(this, node.value, ctx, null, 4, null);
            Expr expr = node.chars;
            if (expr != null) {
                Expr it = expr;
                boolean bl = false;
                rex2 = ToRex.visitExprCoerce$default(INSTANCE, it, ctx, null, 4, null);
            } else {
                rex2 = null;
            }
            Rex arg1 = rex2;
            Expr.Trim.Spec spec = node.spec;
            switch (spec == null ? -1 : WhenMappings.$EnumSwitchMapping$4[spec.ordinal()]) {
                case 1: {
                    Rex[] rexArray;
                    if (arg1 == null) {
                        rexArray = new Rex[]{arg0};
                        static_ = this.call("trim_leading", rexArray);
                        break;
                    }
                    rexArray = new Rex[]{arg0, arg1};
                    static_ = this.call("trim_leading_chars", rexArray);
                    break;
                }
                case 2: {
                    Rex[] rexArray;
                    if (arg1 == null) {
                        rexArray = new Rex[]{arg0};
                        static_ = this.call("trim_trailing", rexArray);
                        break;
                    }
                    rexArray = new Rex[]{arg0, arg1};
                    static_ = this.call("trim_trailing_chars", rexArray);
                    break;
                }
                default: {
                    Rex[] rexArray;
                    if (arg1 == null) {
                        rexArray = new Rex[]{arg0};
                        static_ = this.callNonHidden("trim", rexArray);
                        break;
                    }
                    rexArray = new Rex[]{arg0, arg1};
                    static_ = this.call("trim_chars", rexArray);
                }
            }
            Rex.Op.Call.Static call = static_;
            return Plan.rex(type2, call);
        }

        @NotNull
        public Rex visitExprOverlay(@NotNull Expr.Overlay node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            String string = "SQL Special Form OVERLAY";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @NotNull
        public Rex visitExprExtract(@NotNull Expr.Extract node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            String string = "SQL Special Form EXTRACT";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @NotNull
        public Rex visitExprCast(@NotNull Expr.Cast node, @NotNull Env ctx) {
            Rex rex2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Type type2 = node.asType;
            Rex arg0 = ToRex.visitExprCoerce$default(this, node.value, ctx, null, 4, null);
            Type type3 = type2;
            if (type3 instanceof Type.NullType) {
                Rex[] rexArray = new Rex[]{arg0};
                rex2 = Plan.rex((StaticType)StaticType.NULL, this.call("cast_null", rexArray));
            } else if (type3 instanceof Type.Missing) {
                Rex[] rexArray = new Rex[]{arg0};
                rex2 = Plan.rex((StaticType)StaticType.MISSING, this.call("cast_missing", rexArray));
            } else if (type3 instanceof Type.Bool) {
                Rex[] rexArray = new Rex[]{arg0};
                rex2 = Plan.rex((StaticType)StaticType.BOOL, this.call("cast_bool", rexArray));
            } else {
                if (type3 instanceof Type.Tinyint) {
                    String string = "Static Type does not have TINYINT type";
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                if (type3 instanceof Type.Smallint ? true : type3 instanceof Type.Int2) {
                    Rex[] rexArray = new Rex[]{arg0};
                    rex2 = Plan.rex((StaticType)StaticType.INT2, this.call("cast_int16", rexArray));
                } else if (type3 instanceof Type.Int4) {
                    Rex[] rexArray = new Rex[]{arg0};
                    rex2 = Plan.rex((StaticType)StaticType.INT4, this.call("cast_int32", rexArray));
                } else if (type3 instanceof Type.Bigint ? true : type3 instanceof Type.Int8) {
                    Rex[] rexArray = new Rex[]{arg0};
                    rex2 = Plan.rex((StaticType)StaticType.INT8, this.call("cast_int64", rexArray));
                } else if (type3 instanceof Type.Int) {
                    Rex[] rexArray = new Rex[]{arg0};
                    rex2 = Plan.rex((StaticType)StaticType.INT, this.call("cast_int", rexArray));
                } else {
                    if (type3 instanceof Type.Real) {
                        String string = "Static Type does not have REAL type";
                        throw new NotImplementedError("An operation is not implemented: " + string);
                    }
                    if (type3 instanceof Type.Float32) {
                        String string = "Static Type does not have FLOAT32 type";
                        throw new NotImplementedError("An operation is not implemented: " + string);
                    }
                    if (type3 instanceof Type.Float64) {
                        Rex[] rexArray = new Rex[]{arg0};
                        rex2 = Plan.rex((StaticType)StaticType.FLOAT, this.call("cast_float64", rexArray));
                    } else if (type3 instanceof Type.Decimal) {
                        if (((Type.Decimal)type2).precision != null) {
                            Rex p = Plan.rex((StaticType)StaticType.INT4, Plan.rexOpLit((PartiQLValue)PartiQL.int32Value$default((Integer)((Type.Decimal)type2).precision, null, (int)2, null)));
                            Integer n = ((Type.Decimal)type2).scale;
                            Rex s = Plan.rex((StaticType)StaticType.INT4, Plan.rexOpLit((PartiQLValue)PartiQL.int32Value$default((Integer)(n != null ? n : 0), null, (int)2, null)));
                            Rex[] rexArray = new Rex[]{arg0, p, s};
                            rex2 = Plan.rex((StaticType)StaticType.DECIMAL, this.call("cast_decimal", rexArray));
                        } else {
                            Rex[] rexArray = new Rex[]{arg0};
                            rex2 = Plan.rex((StaticType)StaticType.DECIMAL, this.call("cast_decimal", rexArray));
                        }
                    } else if (type3 instanceof Type.Numeric) {
                        Rex[] rexArray = new Rex[]{arg0};
                        rex2 = Plan.rex((StaticType)StaticType.DECIMAL, this.call("cast_numeric", rexArray));
                    } else if (type3 instanceof Type.Char) {
                        Rex[] rexArray = new Rex[]{arg0};
                        rex2 = Plan.rex(StaticType.CHAR, this.call("cast_char", rexArray));
                    } else if (type3 instanceof Type.Varchar) {
                        Rex[] rexArray = new Rex[]{arg0};
                        rex2 = Plan.rex((StaticType)StaticType.STRING, this.call("cast_varchar", rexArray));
                    } else if (type3 instanceof Type.String) {
                        Rex[] rexArray = new Rex[]{arg0};
                        rex2 = Plan.rex((StaticType)StaticType.STRING, this.call("cast_string", rexArray));
                    } else if (type3 instanceof Type.Symbol) {
                        Rex[] rexArray = new Rex[]{arg0};
                        rex2 = Plan.rex((StaticType)StaticType.SYMBOL, this.call("cast_symbol", rexArray));
                    } else {
                        if (type3 instanceof Type.Bit) {
                            String string = "Static Type does not have Bit type";
                            throw new NotImplementedError("An operation is not implemented: " + string);
                        }
                        if (type3 instanceof Type.BitVarying) {
                            String string = "Static Type does not have BitVarying type";
                            throw new NotImplementedError("An operation is not implemented: " + string);
                        }
                        if (type3 instanceof Type.ByteString) {
                            String string = "Static Type does not have ByteString type";
                            throw new NotImplementedError("An operation is not implemented: " + string);
                        }
                        if (type3 instanceof Type.Blob) {
                            Rex[] rexArray = new Rex[]{arg0};
                            rex2 = Plan.rex((StaticType)StaticType.BLOB, this.call("cast_blob", rexArray));
                        } else if (type3 instanceof Type.Clob) {
                            Rex[] rexArray = new Rex[]{arg0};
                            rex2 = Plan.rex((StaticType)StaticType.CLOB, this.call("cast_clob", rexArray));
                        } else if (type3 instanceof Type.Date) {
                            Rex[] rexArray = new Rex[]{arg0};
                            rex2 = Plan.rex((StaticType)StaticType.DATE, this.call("cast_date", rexArray));
                        } else if (type3 instanceof Type.Time) {
                            Rex[] rexArray = new Rex[]{arg0};
                            rex2 = Plan.rex((StaticType)StaticType.TIME, this.call("cast_time", rexArray));
                        } else if (type3 instanceof Type.TimeWithTz) {
                            Rex[] rexArray = new Rex[]{arg0};
                            rex2 = Plan.rex((StaticType)new TimeType(null, true, null, 4, null), this.call("cast_timeWithTz", rexArray));
                        } else {
                            if (type3 instanceof Type.Timestamp) {
                                String string = "Need to rebase main";
                                throw new NotImplementedError("An operation is not implemented: " + string);
                            }
                            if (type3 instanceof Type.TimestampWithTz) {
                                Rex[] rexArray = new Rex[]{arg0};
                                rex2 = Plan.rex((StaticType)StaticType.TIMESTAMP, this.call("cast_timeWithTz", rexArray));
                            } else {
                                if (type3 instanceof Type.Interval) {
                                    String string = "Static Type does not have Interval type";
                                    throw new NotImplementedError("An operation is not implemented: " + string);
                                }
                                if (type3 instanceof Type.Bag) {
                                    Rex[] rexArray = new Rex[]{arg0};
                                    rex2 = Plan.rex((StaticType)StaticType.BAG, this.call("cast_bag", rexArray));
                                } else if (type3 instanceof Type.List) {
                                    Rex[] rexArray = new Rex[]{arg0};
                                    rex2 = Plan.rex((StaticType)StaticType.LIST, this.call("cast_list", rexArray));
                                } else if (type3 instanceof Type.Sexp) {
                                    Rex[] rexArray = new Rex[]{arg0};
                                    rex2 = Plan.rex((StaticType)StaticType.SEXP, this.call("cast_sexp", rexArray));
                                } else if (type3 instanceof Type.Tuple) {
                                    Rex[] rexArray = new Rex[]{arg0};
                                    rex2 = Plan.rex((StaticType)StaticType.STRUCT, this.call("cast_tuple", rexArray));
                                } else if (type3 instanceof Type.Struct) {
                                    Rex[] rexArray = new Rex[]{arg0};
                                    rex2 = Plan.rex((StaticType)StaticType.STRUCT, this.call("cast_struct", rexArray));
                                } else if (type3 instanceof Type.Any) {
                                    Rex[] rexArray = new Rex[]{arg0};
                                    rex2 = Plan.rex((StaticType)StaticType.ANY, this.call("cast_any", rexArray));
                                } else {
                                    if (type3 instanceof Type.Custom) {
                                        String string = "Custom type not supported ";
                                        throw new NotImplementedError("An operation is not implemented: " + string);
                                    }
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                        }
                    }
                }
            }
            return rex2;
        }

        @NotNull
        public Rex visitExprCanCast(@NotNull Expr.CanCast node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            String string = "PartiQL Special Form CAN_CAST";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @NotNull
        public Rex visitExprCanLosslessCast(@NotNull Expr.CanLosslessCast node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            String string = "PartiQL Special Form CAN_LOSSLESS_CAST";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @NotNull
        public Rex visitExprDateAdd(@NotNull Expr.DateAdd node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            TimestampType type2 = StaticType.TIMESTAMP;
            Rex arg0 = ToRex.visitExprCoerce$default(this, node.lhs, ctx, null, 4, null);
            Rex arg1 = ToRex.visitExprCoerce$default(this, node.rhs, ctx, null, 4, null);
            switch (WhenMappings.$EnumSwitchMapping$5[node.field.ordinal()]) {
                case 1: {
                    throw new IllegalStateException("Invalid call DATE_ADD(TIMEZONE_HOUR, ...)".toString());
                }
                case 2: {
                    throw new IllegalStateException("Invalid call DATE_ADD(TIMEZONE_MINUTE, ...)".toString());
                }
            }
            StringBuilder stringBuilder = new StringBuilder().append("date_add_");
            String string = node.field.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            Rex[] rexArray = new Rex[]{arg0, arg1};
            Rex.Op.Call.Static call = this.call(stringBuilder.append(string).toString(), rexArray);
            return Plan.rex((StaticType)type2, call);
        }

        @NotNull
        public Rex visitExprDateDiff(@NotNull Expr.DateDiff node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            TimestampType type2 = StaticType.TIMESTAMP;
            Rex arg0 = ToRex.visitExprCoerce$default(this, node.lhs, ctx, null, 4, null);
            Rex arg1 = ToRex.visitExprCoerce$default(this, node.rhs, ctx, null, 4, null);
            switch (WhenMappings.$EnumSwitchMapping$5[node.field.ordinal()]) {
                case 1: {
                    throw new IllegalStateException("Invalid call DATE_DIFF(TIMEZONE_HOUR, ...)".toString());
                }
                case 2: {
                    throw new IllegalStateException("Invalid call DATE_DIFF(TIMEZONE_MINUTE, ...)".toString());
                }
            }
            StringBuilder stringBuilder = new StringBuilder().append("date_diff_");
            String string = node.field.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            Rex[] rexArray = new Rex[]{arg0, arg1};
            Rex.Op.Call.Static call = this.call(stringBuilder.append(string).toString(), rexArray);
            return Plan.rex((StaticType)type2, call);
        }

        @NotNull
        public Rex visitExprSessionAttribute(@NotNull Expr.SessionAttribute node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            AnyType type2 = StaticType.ANY;
            String string = node.attribute.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String fn = string;
            Rex.Op.Call.Static call = this.call(fn, new Rex[0]);
            return Plan.rex((StaticType)type2, call);
        }

        @NotNull
        public Rex visitExprSFW(@NotNull Expr.SFW node, @NotNull Env context) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return RelConverter.INSTANCE.apply$partiql_planner(node, context);
        }

        @NotNull
        public Rex visitExprBagOp(@NotNull Expr.BagOp node, @NotNull Env ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (Intrinsics.areEqual((Object)node.outer, (Object)true)) {
                Rex.Op op;
                org.partiql.planner.internal.ir.SetQuantifier setQuantifier;
                Rex lhs = (Rex)this.visitExpr(node.lhs, ctx);
                Rex rhs = (Rex)this.visitExpr(node.rhs, ctx);
                SetQuantifier setQuantifier2 = node.type.setq;
                switch (setQuantifier2 == null ? -1 : WhenMappings.$EnumSwitchMapping$6[setQuantifier2.ordinal()]) {
                    case 1: {
                        setQuantifier = org.partiql.planner.internal.ir.SetQuantifier.ALL;
                        break;
                    }
                    case -1: 
                    case 2: {
                        setQuantifier = org.partiql.planner.internal.ir.SetQuantifier.DISTINCT;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                org.partiql.planner.internal.ir.SetQuantifier setq = setQuantifier;
                switch (WhenMappings.$EnumSwitchMapping$7[node.type.type.ordinal()]) {
                    case 1: {
                        op = new Rex.Op.Union(setq, lhs, rhs);
                        break;
                    }
                    case 2: {
                        op = new Rex.Op.Except(setq, lhs, rhs);
                        break;
                    }
                    case 3: {
                        op = new Rex.Op.Intersect(setq, lhs, rhs);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Rex.Op op2 = op;
                return new Rex((StaticType)StaticType.ANY, op2);
            }
            Rel rel2 = (Rel)node.accept((AstVisitor)new RelConverter.ToRel(ctx), (Object)RelConverter.INSTANCE.getNil$partiql_planner());
            return new Rex((StaticType)StaticType.ANY, new Rex.Op.Select(new Rex((StaticType)StaticType.ANY, Plan.rexOpVarResolved(0)), rel2));
        }

        private final Rex bool(boolean v) {
            BoolType type2 = StaticType.BOOL;
            Rex.Op.Lit op = Plan.rexOpLit((PartiQLValue)PartiQL.boolValue$default((Boolean)v, null, (int)2, null));
            return Plan.rex((StaticType)type2, op);
        }

        private final Rex.Op.Call.Static negate(Rex.Op.Call call) {
            String name = Expr.Unary.Op.NOT.name();
            String string = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            Identifier.Symbol id2 = Plan.identifierSymbol(string, Identifier.CaseSensitivity.SENSITIVE);
            Fn.Unresolved fn = Plan.fnUnresolved(id2, true);
            Rex arg = Plan.rex((StaticType)StaticType.BOOL, call);
            return Plan.rexOpCallStatic(fn, CollectionsKt.listOf((Object)arg));
        }

        private final Rex.Op.Call.Static call(String name, Rex ... args) {
            Identifier.Symbol id2 = Plan.identifierSymbol(name, Identifier.CaseSensitivity.SENSITIVE);
            Fn.Unresolved fn = Plan.fnUnresolved(id2, true);
            return Plan.rexOpCallStatic(fn, ArraysKt.toList((Object[])args));
        }

        private final Rex.Op.Call.Static callNonHidden(String name, Rex ... args) {
            Identifier.Symbol id2 = Plan.identifierSymbol(name, Identifier.CaseSensitivity.SENSITIVE);
            Fn.Unresolved fn = Plan.fnUnresolved(id2, false);
            return Plan.rexOpCallStatic(fn, ArraysKt.toList((Object[])args));
        }

        private final Rex toRex(Integer $this$toRex) {
            return Plan.rex((StaticType)StaticType.INT4, Plan.rexOpLit((PartiQLValue)PartiQL.int32Value$default((Integer)$this$toRex, null, (int)2, null)));
        }

        public static final /* synthetic */ Rex.Op.Call.Static access$call(ToRex $this, String name, Rex ... args) {
            return $this.call(name, args);
        }

        public static final /* synthetic */ Rex.Op.Call.Static access$negate(ToRex $this, Rex.Op.Call call) {
            return $this.negate(call);
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;
            public static final /* synthetic */ int[] $EnumSwitchMapping$3;
            public static final /* synthetic */ int[] $EnumSwitchMapping$4;
            public static final /* synthetic */ int[] $EnumSwitchMapping$5;
            public static final /* synthetic */ int[] $EnumSwitchMapping$6;
            public static final /* synthetic */ int[] $EnumSwitchMapping$7;

            static {
                int[] nArray = new int[Expr.Var.Scope.values().length];
                nArray[Expr.Var.Scope.DEFAULT.ordinal()] = 1;
                nArray[Expr.Var.Scope.LOCAL.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[Expr.Binary.Op.values().length];
                nArray[Expr.Binary.Op.NE.ordinal()] = 1;
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[Identifier.CaseSensitivity.values().length];
                nArray[Identifier.CaseSensitivity.SENSITIVE.ordinal()] = 1;
                nArray[Identifier.CaseSensitivity.INSENSITIVE.ordinal()] = 2;
                $EnumSwitchMapping$2 = nArray;
                nArray = new int[Expr.Collection.Type.values().length];
                nArray[Expr.Collection.Type.BAG.ordinal()] = 1;
                nArray[Expr.Collection.Type.ARRAY.ordinal()] = 2;
                nArray[Expr.Collection.Type.VALUES.ordinal()] = 3;
                nArray[Expr.Collection.Type.LIST.ordinal()] = 4;
                nArray[Expr.Collection.Type.SEXP.ordinal()] = 5;
                $EnumSwitchMapping$3 = nArray;
                nArray = new int[Expr.Trim.Spec.values().length];
                nArray[Expr.Trim.Spec.LEADING.ordinal()] = 1;
                nArray[Expr.Trim.Spec.TRAILING.ordinal()] = 2;
                $EnumSwitchMapping$4 = nArray;
                nArray = new int[DatetimeField.values().length];
                nArray[DatetimeField.TIMEZONE_HOUR.ordinal()] = 1;
                nArray[DatetimeField.TIMEZONE_MINUTE.ordinal()] = 2;
                $EnumSwitchMapping$5 = nArray;
                nArray = new int[SetQuantifier.values().length];
                nArray[SetQuantifier.ALL.ordinal()] = 1;
                nArray[SetQuantifier.DISTINCT.ordinal()] = 2;
                $EnumSwitchMapping$6 = nArray;
                nArray = new int[SetOp.Type.values().length];
                nArray[SetOp.Type.UNION.ordinal()] = 1;
                nArray[SetOp.Type.EXCEPT.ordinal()] = 2;
                nArray[SetOp.Type.INTERSECT.ordinal()] = 3;
                $EnumSwitchMapping$7 = nArray;
            }
        }
    }
}

