/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.planner.internal.typer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.errors.Problem;
import org.partiql.errors.ProblemDetails;
import org.partiql.errors.ProblemKt;
import org.partiql.errors.ProblemLocation;
import org.partiql.plan.Identifier;
import org.partiql.planner.PlanningProblemDetails;
import org.partiql.planner.internal.Env;
import org.partiql.planner.internal.ResolutionStrategy;
import org.partiql.planner.internal.ir.Agg;
import org.partiql.planner.internal.ir.Catalog;
import org.partiql.planner.internal.ir.Fn;
import org.partiql.planner.internal.ir.Identifier;
import org.partiql.planner.internal.ir.Plan;
import org.partiql.planner.internal.ir.PlanNode;
import org.partiql.planner.internal.ir.Rel;
import org.partiql.planner.internal.ir.Rex;
import org.partiql.planner.internal.ir.Statement;
import org.partiql.planner.internal.ir.util.PlanRewriter;
import org.partiql.planner.internal.transforms.PlanTransform;
import org.partiql.planner.internal.typer.DynamicTyper;
import org.partiql.planner.internal.typer.FnMatch;
import org.partiql.planner.internal.typer.RexReplacer;
import org.partiql.planner.internal.typer.TypeEnv;
import org.partiql.planner.internal.typer.TypeUtilsKt;
import org.partiql.spi.BindingCase;
import org.partiql.spi.BindingName;
import org.partiql.spi.BindingPath;
import org.partiql.types.AnyOfType;
import org.partiql.types.AnyType;
import org.partiql.types.BagType;
import org.partiql.types.BoolType;
import org.partiql.types.CollectionType;
import org.partiql.types.DecimalType;
import org.partiql.types.IntType;
import org.partiql.types.ListType;
import org.partiql.types.MissingType;
import org.partiql.types.NullType;
import org.partiql.types.SexpType;
import org.partiql.types.SingleType;
import org.partiql.types.StaticType;
import org.partiql.types.StringType;
import org.partiql.types.StructType;
import org.partiql.types.TupleConstraint;
import org.partiql.types.function.FunctionSignature;
import org.partiql.value.BoolValue;
import org.partiql.value.Int32Value;
import org.partiql.value.PartiQL;
import org.partiql.value.PartiQLValue;
import org.partiql.value.PartiQLValueType;
import org.partiql.value.TextValue;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002HIB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\b\u0010\u0015\u001a\u00020\u0007H\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u001e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u001bH\u0002J\u0014\u0010 \u001a\u00020\u00072\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0002J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0019H\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&J,\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u000e2\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010+0\u000e2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020)0\u000eH\u0002J\u0010\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020\u001cH\u0002J\u001a\u0010/\u001a\u000200*\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0002J\u0014\u00102\u001a\u000203*\u0002042\u0006\u00105\u001a\u00020\u001cH\u0002J\f\u00106\u001a\u000203*\u000207H\u0002J\f\u00108\u001a\u000203*\u000209H\u0002J\f\u0010:\u001a\u000203*\u000207H\u0002J\f\u0010;\u001a\u00020\u001c*\u00020\u0019H\u0002J\u0018\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\f\u0010=\u001a\u00020>*\u000204H\u0002J\f\u0010?\u001a\u00020@*\u00020\u0019H\u0002J\f\u0010?\u001a\u00020@*\u00020AH\u0002J\u0012\u0010B\u001a\u00020\f*\b\u0012\u0004\u0012\u00020)0\u000eH\u0002J\u001e\u0010\u000b\u001a\u000209*\u0002092\u0006\u0010\u001a\u001a\u00020C2\b\b\u0002\u0010D\u001a\u00020EH\u0002J\u001e\u0010\u000b\u001a\u00020)*\u00020)2\u0006\u0010\u001a\u001a\u00020C2\b\b\u0002\u0010D\u001a\u00020EH\u0002J\f\u0010F\u001a\u00020G*\u00020GH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lorg/partiql/planner/internal/typer/PlanTyper;", "", "env", "Lorg/partiql/planner/internal/Env;", "onProblem", "Lkotlin/Function1;", "Lorg/partiql/errors/Problem;", "", "Lorg/partiql/errors/ProblemCallback;", "(Lorg/partiql/planner/internal/Env;Lkotlin/jvm/functions/Function1;)V", "assertAsInt", "type", "Lorg/partiql/types/StaticType;", "excludeBindings", "", "Lorg/partiql/planner/internal/ir/Rel$Binding;", "input", "item", "Lorg/partiql/planner/internal/ir/Rel$Op$Exclude$Item;", "getElementTypeForFromSource", "fromSourceType", "handleAlwaysMissing", "handleUndefinedVariable", "Lorg/partiql/planner/PlanningProblemDetails$UndefinedVariable;", "name", "Lorg/partiql/planner/internal/ir/Identifier;", "locals", "", "", "handleUnexpectedType", "actual", "expected", "handleUnknownFunction", "match", "Lorg/partiql/planner/internal/typer/FnMatch$Error;", "handleUnresolvedExcludeRoot", "root", "resolve", "Lorg/partiql/planner/internal/ir/Statement;", "statement", "rewriteFnArgs", "Lorg/partiql/planner/internal/ir/Rex;", "mapping", "Lorg/partiql/types/function/FunctionSignature$Scalar;", "args", "rexErr", "message", "copyWithSchema", "Lorg/partiql/planner/internal/ir/Rel$Type;", "types", "isEquivalentTo", "", "Lorg/partiql/planner/internal/ir/Identifier$Symbol;", "other", "isNotMissable", "Lorg/partiql/planner/internal/ir/Fn$Unresolved;", "isOrdered", "Lorg/partiql/planner/internal/ir/Rel;", "isTypeAssertion", "normalize", "pad", "toBindingName", "Lorg/partiql/spi/BindingName;", "toBindingPath", "Lorg/partiql/spi/BindingPath;", "Lorg/partiql/planner/internal/ir/Identifier$Qualified;", "toUnionType", "Lorg/partiql/planner/internal/typer/TypeEnv;", "strategy", "Lorg/partiql/planner/internal/ResolutionStrategy;", "withNullableFields", "Lorg/partiql/types/StructType;", "RelTyper", "RexTyper", "partiql-planner"})
public final class PlanTyper {
    @NotNull
    private final Env env;
    @NotNull
    private final Function1<Problem, Unit> onProblem;

    public PlanTyper(@NotNull Env env, @NotNull Function1<? super Problem, Unit> onProblem) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter(onProblem, (String)"onProblem");
        this.env = env;
        this.onProblem = onProblem;
    }

    @NotNull
    public final Statement resolve(@NotNull Statement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        if (!(statement instanceof Statement.Query)) {
            throw new IllegalArgumentException("PartiQLPlanner only supports Query statements");
        }
        TypeEnv typeEnv = new TypeEnv(CollectionsKt.emptyList());
        Rex root = PlanTyper.type$default(this, ((Statement.Query)statement).root, typeEnv, null, 2, null);
        return Plan.statementQuery(root);
    }

    private final Rel type(Rel $this$type, TypeEnv locals, ResolutionStrategy strategy) {
        return new RelTyper(locals, strategy).visitRel($this$type, null);
    }

    static /* synthetic */ Rel type$default(PlanTyper planTyper, Rel rel2, TypeEnv typeEnv, ResolutionStrategy resolutionStrategy, int n, Object object) {
        if ((n & 2) != 0) {
            resolutionStrategy = ResolutionStrategy.LOCAL;
        }
        return planTyper.type(rel2, typeEnv, resolutionStrategy);
    }

    private final Rex type(Rex $this$type, TypeEnv locals, ResolutionStrategy strategy) {
        return new RexTyper(locals, strategy).visitRex($this$type, $this$type.type);
    }

    static /* synthetic */ Rex type$default(PlanTyper planTyper, Rex rex2, TypeEnv typeEnv, ResolutionStrategy resolutionStrategy, int n, Object object) {
        if ((n & 2) != 0) {
            resolutionStrategy = ResolutionStrategy.LOCAL;
        }
        return planTyper.type(rex2, typeEnv, resolutionStrategy);
    }

    private final Rex rexErr(String message) {
        return Plan.rex((StaticType)StaticType.MISSING, Plan.rexOpErr(message));
    }

    /*
     * WARNING - void declaration
     */
    private final Rel.Type copyWithSchema(Rel.Type $this$copyWithSchema, List<? extends StaticType> types2) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        boolean bl;
        boolean bl2 = bl = types2.size() == $this$copyWithSchema.schema.size();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-PlanTyper$copyWithSchema$22 = false;
            String $i$a$-assert-PlanTyper$copyWithSchema$22 = "Illegal copy, types size does not matching bindings list size";
            throw new AssertionError((Object)$i$a$-assert-PlanTyper$copyWithSchema$22);
        }
        Iterable iterable = $this$copyWithSchema.schema;
        Rel.Type type2 = $this$copyWithSchema;
        boolean $i$f$mapIndexed = false;
        void var5_9 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void binding;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Rel.Binding binding2 = (Rel.Binding)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(Rel.Binding.copy$default((Rel.Binding)binding, null, types2.get((int)i), 1, null));
        }
        return Rel.Type.copy$default(type2, (List)destination$iv$iv, null, 2, null);
    }

    private final BindingPath toBindingPath(org.partiql.planner.internal.ir.Identifier $this$toBindingPath) {
        BindingPath bindingPath;
        org.partiql.planner.internal.ir.Identifier identifier = $this$toBindingPath;
        if (identifier instanceof Identifier.Qualified) {
            bindingPath = this.toBindingPath((Identifier.Qualified)$this$toBindingPath);
        } else if (identifier instanceof Identifier.Symbol) {
            bindingPath = new BindingPath(CollectionsKt.listOf((Object)this.toBindingName((Identifier.Symbol)$this$toBindingPath)));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bindingPath;
    }

    /*
     * WARNING - void declaration
     */
    private final BindingPath toBindingPath(Identifier.Qualified $this$toBindingPath) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $this$toBindingPath.steps;
        Collection collection = CollectionsKt.listOf((Object)this.toBindingName($this$toBindingPath.root));
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Identifier.Symbol symbol = (Identifier.Symbol)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.toBindingName((Identifier.Symbol)it));
        }
        List list = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        return new BindingPath(list);
    }

    private final BindingName toBindingName(Identifier.Symbol $this$toBindingName) {
        BindingCase bindingCase;
        String string = $this$toBindingName.symbol;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toBindingName.caseSensitivity.ordinal()]) {
            case 1: {
                bindingCase = BindingCase.SENSITIVE;
                break;
            }
            case 2: {
                bindingCase = BindingCase.INSENSITIVE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return new BindingName(string, bindingCase);
    }

    private final boolean isOrdered(Rel $this$isOrdered) {
        return $this$isOrdered.type.props.contains((Object)Rel.Prop.ORDERED);
    }

    /*
     * WARNING - void declaration
     */
    private final StaticType toUnionType(List<Rex> $this$toUnionType) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toUnionType;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Rex rex2 = (Rex)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.type);
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        Map map = null;
        Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return new AnyOfType(set, map, n, defaultConstructorMarker).flatten();
    }

    /*
     * WARNING - void declaration
     */
    private final StaticType getElementTypeForFromSource(StaticType fromSourceType) {
        StaticType staticType;
        StaticType staticType2 = fromSourceType;
        if (staticType2 instanceof BagType) {
            staticType = ((BagType)fromSourceType).getElementType();
        } else if (staticType2 instanceof ListType) {
            staticType = ((ListType)fromSourceType).getElementType();
        } else if (staticType2 instanceof AnyType) {
            staticType = (StaticType)StaticType.ANY;
        } else if (staticType2 instanceof AnyOfType) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((AnyOfType)fromSourceType).getTypes();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StaticType staticType3 = (StaticType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.getElementTypeForFromSource((StaticType)it));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            Map map = null;
            Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            staticType = (StaticType)new AnyOfType(set, map, n, defaultConstructorMarker);
        } else {
            staticType = fromSourceType;
        }
        return staticType;
    }

    private final List<Rex> rewriteFnArgs(List<FunctionSignature.Scalar> mapping, List<Rex> args) {
        if (mapping.size() != args.size()) {
            throw new IllegalStateException("Fatal, malformed function mapping".toString());
        }
        List newArgs = new ArrayList();
        int n = mapping.size();
        for (int i = 0; i < n; ++i) {
            Rex a = args.get(i);
            FunctionSignature.Scalar m = mapping.get(i);
            if (m != null) {
                StaticType type2 = TypeUtilsKt.toNonNullStaticType(m.returns);
                Rex.Op.Call.Static cast = Plan.rexOpCallStatic(Plan.fnResolved(m), CollectionsKt.listOf((Object)a));
                a = Plan.rex(type2, cast);
            }
            newArgs.add(a);
        }
        return newArgs;
    }

    private final void assertAsInt(StaticType type2) {
        boolean bl;
        block4: {
            Iterable $this$any$iv = type2.flatten().getAllTypes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    StaticType variant = (StaticType)element$iv;
                    boolean bl2 = false;
                    if (!(variant instanceof IntType)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (!bl) {
            this.handleUnexpectedType(type2, SetsKt.setOf((Object)StaticType.INT));
        }
    }

    private final PlanningProblemDetails.UndefinedVariable handleUndefinedVariable(org.partiql.planner.internal.ir.Identifier name, Set<String> locals) {
        Identifier planName = PlanTransform.INSTANCE.visitIdentifier(name, this.onProblem);
        PlanningProblemDetails.UndefinedVariable details = new PlanningProblemDetails.UndefinedVariable(planName, locals);
        this.onProblem.invoke((Object)new Problem(ProblemKt.getUNKNOWN_PROBLEM_LOCATION(), (ProblemDetails)details));
        return details;
    }

    private final void handleUnexpectedType(StaticType actual, Set<? extends StaticType> expected) {
        this.onProblem.invoke((Object)new Problem(ProblemKt.getUNKNOWN_PROBLEM_LOCATION(), (ProblemDetails)new PlanningProblemDetails.UnexpectedType(actual, expected)));
    }

    /*
     * WARNING - void declaration
     */
    private final void handleUnknownFunction(FnMatch.Error<?> match) {
        Collection<StaticType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = match.getArgs();
        String string = this.normalize(match.getIdentifier());
        ProblemLocation problemLocation = ProblemKt.getUNKNOWN_PROBLEM_LOCATION();
        Function1<Problem, Unit> function1 = this.onProblem;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void a;
            Rex rex2 = (Rex)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(a.type);
        }
        Collection<StaticType> collection2 = collection = (List)destination$iv$iv;
        String string2 = string;
        ProblemDetails problemDetails = new PlanningProblemDetails.UnknownFunction(string2, (List<? extends StaticType>)collection2);
        ProblemLocation problemLocation2 = problemLocation;
        function1.invoke((Object)new Problem(problemLocation2, problemDetails));
    }

    private final void handleAlwaysMissing() {
        this.onProblem.invoke((Object)new Problem(ProblemKt.getUNKNOWN_PROBLEM_LOCATION(), (ProblemDetails)PlanningProblemDetails.ExpressionAlwaysReturnsNullOrMissing.INSTANCE));
    }

    private final void handleUnresolvedExcludeRoot(org.partiql.planner.internal.ir.Identifier root) {
        String string;
        ProblemLocation problemLocation = ProblemKt.getUNKNOWN_PROBLEM_LOCATION();
        org.partiql.planner.internal.ir.Identifier identifier = root;
        if (identifier instanceof Identifier.Symbol) {
            string = ((Identifier.Symbol)root).symbol;
        } else if (identifier instanceof Identifier.Qualified) {
            string = root.toString();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.onProblem.invoke((Object)new Problem(problemLocation, (ProblemDetails)new PlanningProblemDetails.UnresolvedExcludeExprRoot(string)));
    }

    /*
     * WARNING - void declaration
     */
    private final String normalize(org.partiql.planner.internal.ir.Identifier $this$normalize) {
        String string;
        block6: {
            block7: {
                org.partiql.planner.internal.ir.Identifier identifier;
                block5: {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    identifier = $this$normalize;
                    if (!(identifier instanceof Identifier.Qualified)) break block5;
                    Iterable iterable = ((Identifier.Qualified)$this$normalize).steps;
                    Collection collection = CollectionsKt.listOf((Object)this.normalize(((Identifier.Qualified)$this$normalize).root));
                    boolean $i$f$map = false;
                    void var5_6 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Identifier.Symbol symbol = (Identifier.Symbol)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl = false;
                        collection2.add(this.normalize((org.partiql.planner.internal.ir.Identifier)it));
                    }
                    string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv)), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                    break block6;
                }
                if (!(identifier instanceof Identifier.Symbol)) break block7;
                switch (WhenMappings.$EnumSwitchMapping$0[((Identifier.Symbol)$this$normalize).caseSensitivity.ordinal()]) {
                    case 1: {
                        string = ((Identifier.Symbol)$this$normalize).symbol;
                        break block6;
                    }
                    case 2: {
                        String string2 = ((Identifier.Symbol)$this$normalize).symbol.toLowerCase(Locale.ROOT);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final boolean isNotMissable(Fn.Unresolved $this$isNotMissable) {
        boolean bl;
        block23: {
            block24: {
                org.partiql.planner.internal.ir.Identifier identifier;
                block22: {
                    identifier = $this$isNotMissable.identifier;
                    if (!(identifier instanceof Identifier.Qualified)) break block22;
                    bl = false;
                    break block23;
                }
                if (!(identifier instanceof Identifier.Symbol)) break block24;
                switch (((Identifier.Symbol)$this$isNotMissable.identifier).symbol) {
                    case "and": {
                        bl = true;
                        break;
                    }
                    case "or": {
                        bl = true;
                        break;
                    }
                    case "not": {
                        bl = true;
                        break;
                    }
                    case "eq": {
                        bl = true;
                        break;
                    }
                    case "is_null": {
                        bl = true;
                        break;
                    }
                    case "is_missing": {
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                        break;
                    }
                }
                break block23;
            }
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private final boolean isTypeAssertion(Fn.Unresolved $this$isTypeAssertion) {
        return $this$isTypeAssertion.identifier instanceof Identifier.Symbol && StringsKt.startsWith$default((String)((Identifier.Symbol)$this$isTypeAssertion.identifier).symbol, (String)"is", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Rel.Binding> pad(List<Rel.Binding> $this$pad) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$pad;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Rel.Binding binding = (Rel.Binding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            StaticType t = it.type;
            StaticType type2 = t instanceof StructType ? (StaticType)this.withNullableFields((StructType)t) : t.asNullable();
            collection.add(Plan.relBinding(it.name, type2));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final StructType withNullableFields(StructType $this$withNullableFields) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $this$withNullableFields.getFields();
        StructType structType = $this$withNullableFields;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StructType.Field field = (StructType.Field)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StructType.Field.copy$default((StructType.Field)it, null, (StaticType)it.getValue().asNullable(), (int)1, null));
        }
        return StructType.copy$default((StructType)structType, (List)((List)destination$iv$iv), (boolean)false, null, null, null, (int)30, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<Rel.Binding> excludeBindings(List<Rel.Binding> input, Rel.Op.Exclude.Item item) {
        void $this$mapTo$iv$iv;
        boolean matchedRoot = false;
        Iterable $this$map$iv = input;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Rel.Binding binding;
            void it;
            Rel.Binding binding2 = (Rel.Binding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Rex.Op.Var root = item.root;
            if (root instanceof Rex.Op.Var.Unresolved) {
                org.partiql.planner.internal.ir.Identifier id2 = ((Rex.Op.Var.Unresolved)root).identifier;
                if (id2 instanceof Identifier.Symbol) {
                    if (this.isEquivalentTo((Identifier.Symbol)id2, it.name)) {
                        matchedRoot = true;
                        StaticType type2 = TypeUtilsKt.exclude(it.type, item.steps, false);
                        binding = Rel.Binding.copy$default((Rel.Binding)it, null, type2, 1, null);
                    } else {
                        binding = it;
                    }
                } else {
                    if (!(id2 instanceof Identifier.Qualified)) throw new NoWhenBranchMatchedException();
                    binding = it;
                }
            } else {
                if (!(root instanceof Rex.Op.Var.Resolved)) throw new NoWhenBranchMatchedException();
                binding = it;
            }
            collection.add(binding);
        }
        List output = (List)destination$iv$iv;
        if (matchedRoot || !(item.root instanceof Rex.Op.Var.Unresolved)) return output;
        this.handleUnresolvedExcludeRoot(((Rex.Op.Var.Unresolved)item.root).identifier);
        return output;
    }

    private final boolean isEquivalentTo(Identifier.Symbol $this$isEquivalentTo, String other) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$isEquivalentTo.caseSensitivity.ordinal()]) {
            case 1: {
                bl = $this$isEquivalentTo.symbol.equals(other);
                break;
            }
            case 2: {
                bl = StringsKt.equals((String)$this$isEquivalentTo.symbol, (String)other, (boolean)true);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static final /* synthetic */ BindingName access$toBindingName(PlanTyper $this, Identifier.Symbol $receiver) {
        return $this.toBindingName($receiver);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u001a\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u001c2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u001e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020 2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010!\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\"2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010#\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020$2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010%\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020&2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010'\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020(2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010)\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020*2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010+\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020,2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010-\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020.2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010/\u001a\u00020\t2\u0006\u0010\u0011\u001a\u0002002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00101\u001a\u00020\t2\u0006\u0010\u0011\u001a\u0002022\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/partiql/planner/internal/typer/PlanTyper$RelTyper;", "Lorg/partiql/planner/internal/ir/util/PlanRewriter;", "Lorg/partiql/planner/internal/ir/Rel$Type;", "outer", "Lorg/partiql/planner/internal/typer/TypeEnv;", "strategy", "Lorg/partiql/planner/internal/ResolutionStrategy;", "(Lorg/partiql/planner/internal/typer/PlanTyper;Lorg/partiql/planner/internal/typer/TypeEnv;Lorg/partiql/planner/internal/ResolutionStrategy;)V", "createRelErrForSetOpMismatchSizes", "Lorg/partiql/planner/internal/ir/Rel;", "createRelErrForSetOpMismatchTypes", "setOpSchemaSizesMatch", "", "lhs", "rhs", "setOpSchemaTypesMatch", "visitRel", "node", "ctx", "visitRelOpAggregate", "Lorg/partiql/planner/internal/ir/Rel$Op$Aggregate;", "visitRelOpDistinct", "Lorg/partiql/planner/internal/ir/Rel$Op$Distinct;", "visitRelOpErr", "Lorg/partiql/planner/internal/ir/Rel$Op$Err;", "visitRelOpExcept", "Lorg/partiql/planner/internal/ir/Rel$Op$Except;", "visitRelOpExclude", "Lorg/partiql/planner/internal/ir/Rel$Op$Exclude;", "visitRelOpFilter", "Lorg/partiql/planner/internal/ir/Rel$Op$Filter;", "visitRelOpIntersect", "Lorg/partiql/planner/internal/ir/Rel$Op$Intersect;", "visitRelOpJoin", "Lorg/partiql/planner/internal/ir/Rel$Op$Join;", "visitRelOpLimit", "Lorg/partiql/planner/internal/ir/Rel$Op$Limit;", "visitRelOpOffset", "Lorg/partiql/planner/internal/ir/Rel$Op$Offset;", "visitRelOpProject", "Lorg/partiql/planner/internal/ir/Rel$Op$Project;", "visitRelOpScan", "Lorg/partiql/planner/internal/ir/Rel$Op$Scan;", "visitRelOpScanIndexed", "Lorg/partiql/planner/internal/ir/Rel$Op$ScanIndexed;", "visitRelOpSort", "Lorg/partiql/planner/internal/ir/Rel$Op$Sort;", "visitRelOpUnion", "Lorg/partiql/planner/internal/ir/Rel$Op$Union;", "visitRelOpUnpivot", "Lorg/partiql/planner/internal/ir/Rel$Op$Unpivot;", "partiql-planner"})
    private final class RelTyper
    extends PlanRewriter<Rel.Type> {
        @NotNull
        private final TypeEnv outer;
        @NotNull
        private final ResolutionStrategy strategy;

        public RelTyper(@NotNull TypeEnv outer, ResolutionStrategy strategy) {
            Intrinsics.checkNotNullParameter((Object)outer, (String)"outer");
            Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"strategy");
            this.outer = outer;
            this.strategy = strategy;
        }

        @Override
        @NotNull
        public Rel visitRel(@NotNull Rel node, @Nullable Rel.Type ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return (Rel)this.visitRelOp(node.op, node.type);
        }

        @Override
        @NotNull
        public Rel visitRelOpScan(@NotNull Rel.Op.Scan node, @Nullable Rel.Type ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rex rex2 = PlanTyper.this.type(node.rex, this.outer, ResolutionStrategy.GLOBAL);
            StaticType valueT = PlanTyper.this.getElementTypeForFromSource(rex2.type);
            Rel.Type type2 = ctx;
            Intrinsics.checkNotNull((Object)type2);
            Rel.Type type3 = PlanTyper.this.copyWithSchema(type2, CollectionsKt.listOf((Object)valueT));
            Rel.Op.Scan op = Plan.relOpScan(rex2);
            return Plan.rel(type3, op);
        }

        @Override
        @NotNull
        public Rel visitRelOpErr(@NotNull Rel.Op.Err node, @Nullable Rel.Type ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rel.Type type2 = ctx;
            if (type2 == null) {
                type2 = Plan.relType(CollectionsKt.emptyList(), SetsKt.emptySet());
            }
            Rel.Type type3 = type2;
            return Plan.rel(type3, node);
        }

        @Override
        @NotNull
        public Rel visitRelOpScanIndexed(@NotNull Rel.Op.ScanIndexed node, @Nullable Rel.Type ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rex rex2 = PlanTyper.this.type(node.rex, this.outer, ResolutionStrategy.GLOBAL);
            StaticType valueT = PlanTyper.this.getElementTypeForFromSource(rex2.type);
            IntType indexT = StaticType.INT8;
            Rel.Type type2 = ctx;
            Intrinsics.checkNotNull((Object)type2);
            Object[] objectArray = new StaticType[]{valueT, (StaticType)indexT};
            Rel.Type type3 = PlanTyper.this.copyWithSchema(type2, CollectionsKt.listOf((Object[])objectArray));
            Rel.Op.ScanIndexed op = Plan.relOpScanIndexed(rex2);
            return Plan.rel(type3, op);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Rel visitRelOpUnpivot(@NotNull Rel.Op.Unpivot node, @Nullable Rel.Type ctx) {
            StaticType staticType;
            Object[] destination$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rex rex2 = PlanTyper.this.type(node.rex, this.outer, ResolutionStrategy.GLOBAL);
            if (!(rex2.type instanceof StructType)) {
                PlanTyper.this.handleUnexpectedType(rex2.type, SetsKt.setOf((Object)StaticType.STRUCT));
                Rel.Type type2 = ctx;
                Intrinsics.checkNotNull((Object)type2);
                return Plan.rel(type2, Plan.relOpErr("UNPIVOT on non-STRUCT type " + rex2.type));
            }
            StaticType t = rex2.type;
            if (((StructType)t).getContentClosed()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = ((StructType)t).getFields();
                StaticType.Companion companion = StaticType.Companion;
                boolean $i$f$map = false;
                void var8_9 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    StructType.Field field = (StructType.Field)item$iv$iv;
                    Object[] objectArray = destination$iv$iv;
                    boolean bl = false;
                    objectArray.add(it.getValue());
                }
                staticType = StaticType.Companion.unionOf$default((StaticType.Companion)companion, (Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), null, (int)2, null).flatten();
            } else {
                staticType = (StaticType)StaticType.ANY;
            }
            StaticType e = staticType;
            StringType kType = StaticType.STRING;
            StaticType vType = e;
            Rel.Type type3 = ctx;
            Intrinsics.checkNotNull((Object)type3);
            destination$iv$iv = new StaticType[]{(StaticType)kType, vType};
            Rel.Type type4 = PlanTyper.this.copyWithSchema(type3, CollectionsKt.listOf((Object[])destination$iv$iv));
            Rel.Op.Unpivot op = Plan.relOpUnpivot(rex2);
            return Plan.rel(type4, op);
        }

        @Override
        @NotNull
        public Rel visitRelOpDistinct(@NotNull Rel.Op.Distinct node, @Nullable Rel.Type ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rel input = this.visitRel(node.input, ctx);
            return Plan.rel(input.type, Plan.relOpDistinct(input));
        }

        @Override
        @NotNull
        public Rel visitRelOpFilter(@NotNull Rel.Op.Filter node, @Nullable Rel.Type ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rel input = this.visitRel(node.input, ctx);
            TypeEnv typeEnv = new TypeEnv(input.type.schema);
            Rex predicate = PlanTyper.type$default(PlanTyper.this, node.predicate, typeEnv, null, 2, null);
            Rel.Type type2 = input.type;
            Rel.Op.Filter op = Plan.relOpFilter(input, predicate);
            return Plan.rel(type2, op);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Rel visitRelOpSort(@NotNull Rel.Op.Sort node, @Nullable Rel.Type ctx) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rel input = this.visitRel(node.input, ctx);
            TypeEnv typeEnv = new TypeEnv(input.type.schema);
            Iterable iterable = node.specs;
            PlanTyper planTyper = PlanTyper.this;
            boolean $i$f$map = false;
            void var9_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rel.Op.Sort.Spec spec = (Rel.Op.Sort.Spec)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Rex rex2 = PlanTyper.type$default(planTyper, it.rex, typeEnv, null, 2, null);
                collection.add(Rel.Op.Sort.Spec.copy$default((Rel.Op.Sort.Spec)it, rex2, null, 2, null));
            }
            List specs = (List)destination$iv$iv;
            Rel.Type type2 = Rel.Type.copy$default(input.type, null, SetsKt.setOf((Object)((Object)Rel.Prop.ORDERED)), 1, null);
            Rel.Op.Sort op = Plan.relOpSort(input, specs);
            return Plan.rel(type2, op);
        }

        @Override
        @NotNull
        public Rel visitRelOpExcept(@NotNull Rel.Op.Except node, @Nullable Rel.Type ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rel lhs = this.visitRel(node.lhs, node.lhs.type);
            Rel rhs = this.visitRel(node.rhs, node.rhs.type);
            if (!this.setOpSchemaSizesMatch(lhs, rhs)) {
                return this.createRelErrForSetOpMismatchSizes();
            }
            if (!this.setOpSchemaTypesMatch(lhs, rhs)) {
                return this.createRelErrForSetOpMismatchTypes();
            }
            Rel.Type type2 = new Rel.Type(lhs.type.schema, SetsKt.emptySet());
            return new Rel(type2, Rel.Op.Except.copy$default(node, null, lhs, rhs, 1, null));
        }

        @Override
        @NotNull
        public Rel visitRelOpIntersect(@NotNull Rel.Op.Intersect node, @Nullable Rel.Type ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rel lhs = this.visitRel(node.lhs, node.lhs.type);
            Rel rhs = this.visitRel(node.rhs, node.rhs.type);
            if (!this.setOpSchemaSizesMatch(lhs, rhs)) {
                return this.createRelErrForSetOpMismatchSizes();
            }
            if (!this.setOpSchemaTypesMatch(lhs, rhs)) {
                return this.createRelErrForSetOpMismatchTypes();
            }
            Rel.Type type2 = new Rel.Type(lhs.type.schema, SetsKt.emptySet());
            return new Rel(type2, Rel.Op.Intersect.copy$default(node, null, lhs, rhs, 1, null));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Rel visitRelOpUnion(@NotNull Rel.Op.Union node, @Nullable Rel.Type ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rel lhs = this.visitRel(node.lhs, node.lhs.type);
            Rel rhs = this.visitRel(node.rhs, node.rhs.type);
            if (!this.setOpSchemaSizesMatch(lhs, rhs)) {
                return this.createRelErrForSetOpMismatchSizes();
            }
            if (!this.setOpSchemaTypesMatch(lhs, rhs)) {
                return this.createRelErrForSetOpMismatchTypes();
            }
            int size = Math.max(lhs.type.schema.size(), rhs.type.schema.size());
            ArrayList<Rel.Binding> arrayList = new ArrayList<Rel.Binding>(size);
            for (int i = 0; i < size; ++i) {
                String string;
                boolean bl;
                Rel.Binding rhsBinding;
                Rel.Binding binding;
                Rel.Binding lhsBinding;
                void it;
                int n;
                int n2 = n = i;
                ArrayList<Rel.Binding> arrayList2 = arrayList;
                boolean bl2 = false;
                Rel.Binding binding2 = (Rel.Binding)CollectionsKt.getOrNull(lhs.type.schema, (int)it);
                if (binding2 == null) {
                    binding2 = lhsBinding = new Rel.Binding("" + '_' + (int)it, (StaticType)StaticType.MISSING);
                }
                if ((binding = (Rel.Binding)CollectionsKt.getOrNull(rhs.type.schema, (int)it)) == null) {
                    binding = rhsBinding = new Rel.Binding("" + '_' + (int)it, (StaticType)StaticType.MISSING);
                }
                if (bl = Intrinsics.areEqual((Object)lhsBinding.name, (Object)rhsBinding.name)) {
                    string = lhsBinding.name;
                } else if (!bl) {
                    string = "" + '_' + (int)it;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String bindingName = string;
                StaticType[] staticTypeArray = new StaticType[]{lhsBinding.type, rhsBinding.type};
                arrayList2.add(new Rel.Binding(bindingName, StaticType.Companion.unionOf$default((StaticType.Companion)StaticType.Companion, (StaticType[])staticTypeArray, null, (int)2, null).flatten()));
            }
            List schema = arrayList;
            Rel.Type type2 = new Rel.Type(schema, SetsKt.emptySet());
            return new Rel(type2, Rel.Op.Union.copy$default(node, null, lhs, rhs, 1, null));
        }

        private final boolean setOpSchemaTypesMatch(Rel lhs, Rel rhs) {
            return true;
        }

        private final boolean setOpSchemaSizesMatch(Rel lhs, Rel rhs) {
            return lhs.type.schema.size() == rhs.type.schema.size();
        }

        private final Rel createRelErrForSetOpMismatchSizes() {
            return new Rel(new Rel.Type(CollectionsKt.emptyList(), SetsKt.emptySet()), new Rel.Op.Err("LHS and RHS of SET OP do not have the same number of bindings."));
        }

        private final Rel createRelErrForSetOpMismatchTypes() {
            return new Rel(new Rel.Type(CollectionsKt.emptyList(), SetsKt.emptySet()), new Rel.Op.Err("LHS and RHS of SET OP do not have the same type."));
        }

        @Override
        @NotNull
        public Rel visitRelOpLimit(@NotNull Rel.Op.Limit node, @Nullable Rel.Type ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rel input = this.visitRel(node.input, ctx);
            Rex limit = PlanTyper.this.type(node.limit, this.outer, ResolutionStrategy.GLOBAL);
            PlanTyper.this.assertAsInt(limit.type);
            Rel.Type type2 = input.type;
            Rel.Op.Limit op = Plan.relOpLimit(input, limit);
            return Plan.rel(type2, op);
        }

        @Override
        @NotNull
        public Rel visitRelOpOffset(@NotNull Rel.Op.Offset node, @Nullable Rel.Type ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rel input = this.visitRel(node.input, ctx);
            Rex offset = PlanTyper.this.type(node.offset, this.outer, ResolutionStrategy.GLOBAL);
            PlanTyper.this.assertAsInt(offset.type);
            Rel.Type type2 = input.type;
            Rel.Op.Offset op = Plan.relOpOffset(input, offset);
            return Plan.rel(type2, op);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Rel visitRelOpProject(@NotNull Rel.Op.Project node, @Nullable Rel.Type ctx) {
            Rex it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rel input = this.visitRel(node.input, ctx);
            TypeEnv typeEnv = new TypeEnv(input.type.schema);
            Iterable iterable = node.projections;
            PlanTyper planTyper = PlanTyper.this;
            boolean $i$f$map = false;
            void var9_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Rex rex2 = (Rex)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(PlanTyper.type$default(planTyper, it, typeEnv, null, 2, null));
            }
            List projections = (List)destination$iv$iv;
            Iterable $this$map$iv2 = projections;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Rex)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.type);
            }
            List schema = (List)destination$iv$iv;
            Rel.Type type2 = ctx;
            Intrinsics.checkNotNull((Object)type2);
            Rel.Type type3 = PlanTyper.this.copyWithSchema(type2, schema);
            Rel.Op.Project op = Plan.relOpProject(input, projections);
            return Plan.rel(type3, op);
        }

        @Override
        @NotNull
        public Rel visitRelOpJoin(@NotNull Rel.Op.Join node, @Nullable Rel.Type ctx) {
            List list;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rel lhs = this.visitRel(node.lhs, ctx);
            Rel rhs = this.visitRel(node.rhs, ctx);
            List<Rel.Binding> l = lhs.type.schema;
            List<Rel.Binding> r = rhs.type.schema;
            switch (WhenMappings.$EnumSwitchMapping$0[node.type.ordinal()]) {
                case 1: {
                    list = CollectionsKt.plus((Collection)l, (Iterable)r);
                    break;
                }
                case 2: {
                    list = CollectionsKt.plus((Collection)l, (Iterable)PlanTyper.this.pad(r));
                    break;
                }
                case 3: {
                    list = CollectionsKt.plus((Collection)PlanTyper.this.pad(l), (Iterable)r);
                    break;
                }
                case 4: {
                    list = CollectionsKt.plus((Collection)PlanTyper.this.pad(l), (Iterable)PlanTyper.this.pad(r));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            List schema = list;
            Rel.Type type2 = ctx;
            Intrinsics.checkNotNull((Object)type2);
            Rel.Type type3 = Plan.relType(schema, type2.props);
            Rex condition = PlanTyper.type$default(PlanTyper.this, node.rex, new TypeEnv(type3.schema), null, 2, null);
            Rel.Op.Join op = Plan.relOpJoin(lhs, rhs, condition, node.type);
            return Plan.rel(type3, op);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Rel visitRelOpExclude(@NotNull Rel.Op.Exclude node, @Nullable Rel.Type ctx) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object element$iv2;
            void $this$fold$iv;
            Rel.Op.Exclude.Item it;
            Collection collection;
            PlanTyper $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rel input = this.visitRel(node.input, ctx);
            Iterable $this$map$iv2 = input.type.schema;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv = iterator.next();
                Rel.Binding binding = (Rel.Binding)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Rel.Binding.copy$default((Rel.Binding)((Object)it), null, null, 3, null));
            }
            List init = (List)destination$iv$iv;
            Iterable $i$f$map22 = node.items;
            $this$mapTo$iv$iv2 = PlanTyper.this;
            boolean $i$f$fold22 = false;
            List accumulator$iv = init;
            for (Object element$iv2 : $this$fold$iv) {
                void item;
                it = (Rel.Op.Exclude.Item)element$iv2;
                List bindings = accumulator$iv;
                boolean bl = false;
                accumulator$iv = $this$mapTo$iv$iv2.excludeBindings(bindings, (Rel.Op.Exclude.Item)item);
            }
            List schema = accumulator$iv;
            Rel.Type type2 = ctx;
            Intrinsics.checkNotNull((Object)type2);
            Rel.Type type3 = Rel.Type.copy$default(type2, schema, null, 2, null);
            Iterable $i$f$fold22 = node.items;
            PlanTyper planTyper = PlanTyper.this;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Rex.Op.Var var;
                void item;
                Rel.Op.Exclude.Item item2 = (Rel.Op.Exclude.Item)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                Rex.Op.Var root = item.root;
                if (root instanceof Rex.Op.Var.Unresolved) {
                    TypeEnv locals = new TypeEnv(input.type.schema);
                    BindingPath path = planTyper.toBindingPath(((Rex.Op.Var.Unresolved)root).identifier);
                    Rex resolved = locals.resolve(path);
                    if (resolved == null) {
                        planTyper.handleUnresolvedExcludeRoot(((Rex.Op.Var.Unresolved)root).identifier);
                        var = root;
                    } else {
                        var = (Rex.Op.Var)resolved.op;
                    }
                } else if (root instanceof Rex.Op.Var.Resolved) {
                    var = root;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Rex.Op.Var resolvedRoot = var;
                List<Rel.Op.Exclude.Step> steps = item.steps;
                collection.add(Plan.relOpExcludeItem(resolvedRoot, steps));
            }
            List newItems = (List)destination$iv$iv2;
            Rel.Op.Exclude op = Plan.relOpExclude(input, newItems);
            return Plan.rel(type3, op);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Rel visitRelOpAggregate(@NotNull Rel.Op.Aggregate node, @Nullable Rel.Type ctx) {
            Collection<Rel.Op.Aggregate.Call> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $this$mapTo$iv$iv2;
            void $this$mapTo$iv$iv3;
            Object object;
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rel input = this.visitRel(node.input, ctx);
            RexTyper typer = new RexTyper(new TypeEnv(input.type.schema), ResolutionStrategy.LOCAL);
            Iterable $this$mapIndexed$iv = node.calls;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                Pair pair;
                void call;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Rel.Op.Aggregate.Call call2 = (Rel.Op.Aggregate.Call)item$iv$iv;
                int n2 = n;
                object = destination$iv$iv;
                boolean bl = false;
                Agg agg = call.agg;
                if (agg instanceof Agg.Resolved) {
                    void i;
                    Rel.Type type2 = ctx;
                    Intrinsics.checkNotNull((Object)type2);
                    pair = TuplesKt.to((Object)call, (Object)type2.schema.get((int)i).type);
                } else if (agg instanceof Agg.Unresolved) {
                    pair = typer.resolveAgg((Agg.Unresolved)agg, call.args);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                object.add(pair);
            }
            List calls = (List)destination$iv$iv;
            Iterable $this$map$iv2 = node.groups;
            boolean $i$f$map22 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                Rex rex2 = (Rex)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.add(typer.visitRex((Rex)it, null));
            }
            List groups = (List)destination$iv$iv2;
            List schema = new ArrayList();
            Collection $i$f$map22 = schema;
            Iterable $this$map$iv3 = calls;
            boolean $i$f$map = false;
            Iterable $i$f$mapTo22 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Pair i = (Pair)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl = false;
                object.add((StaticType)it.getSecond());
            }
            $this$map$iv3 = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)$i$f$map22, (Iterable)$this$map$iv3);
            $i$f$map22 = schema;
            $this$map$iv3 = groups;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv3;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Rex it = (Rex)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl = false;
                object.add(it.type);
            }
            $this$map$iv3 = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)$i$f$map22, (Iterable)$this$map$iv3);
            Rel.Type type3 = ctx;
            Intrinsics.checkNotNull((Object)type3);
            Rel.Type type4 = PlanTyper.this.copyWithSchema(type3, schema);
            Iterable $i$f$map3 = calls;
            Rel.Op.Aggregate.Strategy strategy = node.strategy;
            object = input;
            boolean $i$f$map4 = false;
            destination$iv$iv3 = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair bl = (Pair)item$iv$iv;
                collection = destination$iv$iv4;
                boolean bl2 = false;
                collection.add((Rel.Op.Aggregate.Call)it.getFirst());
            }
            collection = (List)destination$iv$iv4;
            Rel.Op.Aggregate op = Plan.relOpAggregate((Rel)object, strategy, (List<Rel.Op.Aggregate.Call>)collection, groups);
            return Plan.rel(type4, op);
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Rel.Op.Join.Type.values().length];
                nArray[Rel.Op.Join.Type.INNER.ordinal()] = 1;
                nArray[Rel.Op.Join.Type.LEFT.ordinal()] = 2;
                nArray[Rel.Op.Join.Type.RIGHT.ordinal()] = 3;
                nArray[Rel.Op.Join.Type.FULL.ordinal()] = 4;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ6\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0002J\"\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0002J\u0016\u0010\u0012\u001a\u00020\u00022\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001eH\u0002J(\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00020\u001d2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00180\u000fJ\u0010\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020)H\u0002J,\u0010+\u001a\u00020\u00182\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\u0006\u0010/\u001a\u00020\tH\u0002J\u001a\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u00182\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00103\u001a\u00020\u00182\u0006\u00101\u001a\u0002042\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00105\u001a\u00020\u00182\u0006\u00101\u001a\u0002062\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00107\u001a\u00020\u00182\u0006\u00101\u001a\u0002082\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u00109\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u00162\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010:\u001a\u00020\u00182\u0006\u00101\u001a\u00020;2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010<\u001a\u00020\u00182\u0006\u00101\u001a\u00020=2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010>\u001a\u00020?2\u0006\u00101\u001a\u00020@2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010A\u001a\u00020\u00182\u0006\u00101\u001a\u00020B2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010C\u001a\u00020\u00182\u0006\u00101\u001a\u00020D2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010E\u001a\u00020\u00182\u0006\u00101\u001a\u00020F2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010G\u001a\u00020\u00182\u0006\u00101\u001a\u00020H2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010I\u001a\u00020\u00182\u0006\u00101\u001a\u00020J2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010K\u001a\u00020\u00182\u0006\u00101\u001a\u00020L2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010M\u001a\u00020\u00182\u0006\u00101\u001a\u00020N2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010O\u001a\u00020\u00182\u0006\u00101\u001a\u00020P2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010Q\u001a\u00020\u00182\u0006\u00101\u001a\u00020R2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010S\u001a\u00020\u00182\u0006\u00101\u001a\u00020T2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010U\u001a\u00020\u00182\u0006\u00101\u001a\u00020V2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010W\u001a\u00020\u00182\u0006\u00101\u001a\u00020X2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010Y\u001a\u00020\u00182\u0006\u00101\u001a\u00020Z2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u0018\u0010[\u001a\u00020\u00182\u0006\u0010\\\u001a\u00020Z2\u0006\u0010]\u001a\u00020\u0002H\u0002J\u0018\u0010^\u001a\u00020\u00182\u0006\u0010\\\u001a\u00020Z2\u0006\u0010]\u001a\u00020\u0002H\u0002J\u001a\u0010_\u001a\u00020\u00182\u0006\u00101\u001a\u00020`2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010a\u001a\u00020\u00182\u0006\u00101\u001a\u00020b2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010c\u001a\u00020\u00182\u0006\u00101\u001a\u00020d2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010e\u001a\u00020\u00182\u0006\u00101\u001a\u00020f2\b\u00102\u001a\u0004\u0018\u00010\u0002H\u0016J\f\u0010g\u001a\u00020\u0002*\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006h"}, d2={"Lorg/partiql/planner/internal/typer/PlanTyper$RexTyper;", "Lorg/partiql/planner/internal/ir/util/PlanRewriter;", "Lorg/partiql/types/StaticType;", "locals", "Lorg/partiql/planner/internal/typer/TypeEnv;", "strategy", "Lorg/partiql/planner/internal/ResolutionStrategy;", "(Lorg/partiql/planner/internal/typer/PlanTyper;Lorg/partiql/planner/internal/typer/TypeEnv;Lorg/partiql/planner/internal/ResolutionStrategy;)V", "boolOrNull", "", "op", "Lorg/partiql/planner/internal/ir/Rex$Op;", "(Lorg/partiql/planner/internal/ir/Rex$Op;)Ljava/lang/Boolean;", "buildArgumentPermutations", "Lkotlin/sequences/Sequence;", "", "args", "accumulator", "calculateTupleUnionOutputType", "canBeBoolean", "type", "foldCaseBranch", "Lorg/partiql/planner/internal/ir/Rex$Op$Case$Branch;", "condition", "Lorg/partiql/planner/internal/ir/Rex;", "result", "getIntOrErr", "", "inferStructLookup", "Lkotlin/Pair;", "Lorg/partiql/planner/internal/ir/Identifier$Symbol;", "struct", "Lorg/partiql/types/StructType;", "key", "resolveAgg", "Lorg/partiql/planner/internal/ir/Rel$Op$Aggregate$Call;", "agg", "Lorg/partiql/planner/internal/ir/Agg$Unresolved;", "arguments", "rexString", "str", "", "sensitive", "toRexCall", "match", "Lorg/partiql/planner/internal/typer/FnMatch$Ok;", "Lorg/partiql/types/function/FunctionSignature$Scalar;", "isNotMissable", "visitRex", "node", "ctx", "visitRexOpCallDynamic", "Lorg/partiql/planner/internal/ir/Rex$Op$Call$Dynamic;", "visitRexOpCallStatic", "Lorg/partiql/planner/internal/ir/Rex$Op$Call$Static;", "visitRexOpCase", "Lorg/partiql/planner/internal/ir/Rex$Op$Case;", "visitRexOpCaseBranch", "visitRexOpCoalesce", "Lorg/partiql/planner/internal/ir/Rex$Op$Coalesce;", "visitRexOpCollection", "Lorg/partiql/planner/internal/ir/Rex$Op$Collection;", "visitRexOpErr", "Lorg/partiql/planner/internal/ir/PlanNode;", "Lorg/partiql/planner/internal/ir/Rex$Op$Err;", "visitRexOpExcept", "Lorg/partiql/planner/internal/ir/Rex$Op$Except;", "visitRexOpGlobal", "Lorg/partiql/planner/internal/ir/Rex$Op$Global;", "visitRexOpIntersect", "Lorg/partiql/planner/internal/ir/Rex$Op$Intersect;", "visitRexOpLit", "Lorg/partiql/planner/internal/ir/Rex$Op$Lit;", "visitRexOpNullif", "Lorg/partiql/planner/internal/ir/Rex$Op$Nullif;", "visitRexOpPath", "Lorg/partiql/planner/internal/ir/Rex$Op$Path;", "visitRexOpPathIndex", "Lorg/partiql/planner/internal/ir/Rex$Op$Path$Index;", "visitRexOpPathKey", "Lorg/partiql/planner/internal/ir/Rex$Op$Path$Key;", "visitRexOpPathSymbol", "Lorg/partiql/planner/internal/ir/Rex$Op$Path$Symbol;", "visitRexOpPivot", "Lorg/partiql/planner/internal/ir/Rex$Op$Pivot;", "visitRexOpSelect", "Lorg/partiql/planner/internal/ir/Rex$Op$Select;", "visitRexOpStruct", "Lorg/partiql/planner/internal/ir/Rex$Op$Struct;", "visitRexOpSubquery", "Lorg/partiql/planner/internal/ir/Rex$Op$Subquery;", "visitRexOpSubqueryRow", "subquery", "cons", "visitRexOpSubqueryScalar", "visitRexOpTupleUnion", "Lorg/partiql/planner/internal/ir/Rex$Op$TupleUnion;", "visitRexOpUnion", "Lorg/partiql/planner/internal/ir/Rex$Op$Union;", "visitRexOpVarResolved", "Lorg/partiql/planner/internal/ir/Rex$Op$Var$Resolved;", "visitRexOpVarUnresolved", "Lorg/partiql/planner/internal/ir/Rex$Op$Var$Unresolved;", "swallowAny", "partiql-planner"})
    private final class RexTyper
    extends PlanRewriter<StaticType> {
        @NotNull
        private final TypeEnv locals;
        @NotNull
        private final ResolutionStrategy strategy;

        public RexTyper(@NotNull TypeEnv locals, ResolutionStrategy strategy) {
            Intrinsics.checkNotNullParameter((Object)locals, (String)"locals");
            Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"strategy");
            this.locals = locals;
            this.strategy = strategy;
        }

        @Override
        @NotNull
        public Rex visitRex(@NotNull Rex node, @Nullable StaticType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return (Rex)this.visitRexOp(node.op, node.type);
        }

        @Override
        @NotNull
        public Rex visitRexOpUnion(@NotNull Rex.Op.Union node, @Nullable StaticType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rex lhs = this.visitRex(node.lhs, node.lhs.type);
            Rex rhs = this.visitRex(node.rhs, node.rhs.type);
            StaticType[] staticTypeArray = new StaticType[]{lhs.type, rhs.type};
            StaticType type2 = StaticType.Companion.unionOf$default((StaticType.Companion)StaticType.Companion, (StaticType[])staticTypeArray, null, (int)2, null).flatten();
            return new Rex(type2, Rex.Op.Union.copy$default(node, null, lhs, rhs, 1, null));
        }

        @Override
        @NotNull
        public Rex visitRexOpExcept(@NotNull Rex.Op.Except node, @Nullable StaticType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rex lhs = this.visitRex(node.lhs, node.lhs.type);
            Rex rhs = this.visitRex(node.rhs, node.rhs.type);
            StaticType[] staticTypeArray = new StaticType[]{lhs.type, rhs.type};
            StaticType type2 = StaticType.Companion.unionOf$default((StaticType.Companion)StaticType.Companion, (StaticType[])staticTypeArray, null, (int)2, null).flatten();
            return new Rex(type2, Rex.Op.Except.copy$default(node, null, lhs, rhs, 1, null));
        }

        @Override
        @NotNull
        public Rex visitRexOpIntersect(@NotNull Rex.Op.Intersect node, @Nullable StaticType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rex lhs = this.visitRex(node.lhs, node.lhs.type);
            Rex rhs = this.visitRex(node.rhs, node.rhs.type);
            StaticType[] staticTypeArray = new StaticType[]{lhs.type, rhs.type};
            StaticType type2 = StaticType.Companion.unionOf$default((StaticType.Companion)StaticType.Companion, (StaticType[])staticTypeArray, null, (int)2, null).flatten();
            return new Rex(type2, Rex.Op.Intersect.copy$default(node, null, lhs, rhs, 1, null));
        }

        @Override
        @NotNull
        public Rex visitRexOpLit(@NotNull Rex.Op.Lit node, @Nullable StaticType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            StaticType staticType = ctx;
            Intrinsics.checkNotNull((Object)staticType);
            return Plan.rex(staticType, node);
        }

        @Override
        @NotNull
        public Rex visitRexOpVarResolved(@NotNull Rex.Op.Var.Resolved node, @Nullable StaticType ctx) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            boolean bl2 = bl = node.ref < this.locals.getSchema().size();
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Invalid resolved variable (var " + node.ref + ") for " + this.locals;
                throw new AssertionError((Object)string);
            }
            StaticType type2 = this.locals.getSchema().get((int)node.ref).type;
            return Plan.rex(type2, node);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Rex visitRexOpVarUnresolved(@NotNull Rex.Op.Var.Unresolved node, @Nullable StaticType ctx) {
            ResolutionStrategy resolutionStrategy;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            BindingPath path = PlanTyper.this.toBindingPath(node.identifier);
            switch (WhenMappings.$EnumSwitchMapping$0[node.scope.ordinal()]) {
                case 1: {
                    resolutionStrategy = this.strategy;
                    break;
                }
                case 2: {
                    resolutionStrategy = ResolutionStrategy.LOCAL;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            ResolutionStrategy strategy = resolutionStrategy;
            Rex resolvedVar = PlanTyper.this.env.resolve(path, this.locals, strategy);
            if (resolvedVar == null) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.locals.getSchema();
                org.partiql.planner.internal.ir.Identifier identifier = node.identifier;
                PlanTyper planTyper = PlanTyper.this;
                boolean $i$f$map = false;
                void var9_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Rel.Binding binding = (Rel.Binding)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.name);
                }
                collection = (List)destination$iv$iv;
                PlanningProblemDetails.UndefinedVariable details = planTyper.handleUndefinedVariable(identifier, CollectionsKt.toSet((Iterable)collection));
                return Plan.rex((StaticType)StaticType.ANY, Plan.rexOpErr(details.getMessage()));
            }
            return this.visitRex(resolvedVar, null);
        }

        @Override
        @NotNull
        public Rex visitRexOpGlobal(@NotNull Rex.Op.Global node, @Nullable StaticType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Catalog catalog2 = PlanTyper.this.env.getCatalogs().get(node.ref.catalog);
            StaticType type2 = catalog2.symbols.get((int)node.ref.symbol).type;
            return Plan.rex(type2, node);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Rex visitRexOpPathIndex(@NotNull Rex.Op.Path.Index node, @Nullable StaticType ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rex root = this.visitRex(node.root, node.root.type);
            Rex key = this.visitRex(node.key, node.key.type);
            if (!(key.type instanceof IntType)) {
                PlanTyper.this.handleAlwaysMissing();
                return Plan.rex((StaticType)StaticType.MISSING, Plan.rexOpErr("Collections must be indexed with integers, found " + key.type));
            }
            Iterable $this$map$iv = root.type.getAllTypes();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CollectionType rootType;
                void type2;
                StaticType staticType = (StaticType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                CollectionType collectionType = type2 instanceof CollectionType ? (CollectionType)type2 : null;
                collection.add(collectionType == null ? (StaticType)StaticType.MISSING : (!((rootType = collectionType) instanceof ListType) && !(rootType instanceof SexpType) ? (StaticType)StaticType.MISSING : rootType.getElementType()));
            }
            Set elementTypes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            StaticType finalType = StaticType.Companion.unionOf$default((StaticType.Companion)StaticType.Companion, (Set)elementTypes, null, (int)2, null).flatten();
            return Plan.rex(this.swallowAny(finalType), Plan.rexOpPathIndex(root, key));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public Rex visitRexOpPathKey(@NotNull Rex.Op.Path.Key node, @Nullable StaticType ctx) {
            Iterator $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rex root = this.visitRex(node.root, node.root.type);
            Rex key = this.visitRex(node.key, node.key.type);
            Iterable $this$mapNotNull$iv = key.type.getAllTypes();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection collection = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SingleType it$iv$iv;
                Object t;
                Object element$iv$iv = t = iterator.next();
                boolean bl = false;
                StaticType keyType = (StaticType)element$iv$iv;
                boolean bl2 = false;
                StaticType staticType = keyType;
                if ((staticType instanceof StringType ? null : (staticType instanceof NullType ? (SingleType)StaticType.NULL : (SingleType)StaticType.MISSING)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                collection.add(it$iv$iv);
            }
            List toAddTypes = (List)collection;
            if (toAddTypes.size() == key.type.getAllTypes().size()) {
                boolean bl;
                block11: {
                    Iterable $this$all$iv = toAddTypes;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object t : $this$all$iv) {
                            SingleType it = (SingleType)t;
                            boolean bl4 = false;
                            if (it instanceof MissingType) continue;
                            bl = false;
                            break block11;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    PlanTyper.this.handleAlwaysMissing();
                    return Plan.rex((StaticType)StaticType.MISSING, Plan.rexOpErr("Expected string but found: " + key.type));
                }
            }
            Iterable $this$map$iv = root.type.getAllTypes();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : iterable2) {
                StaticType staticType;
                StaticType staticType2 = (StaticType)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                if ((staticType2 instanceof StructType ? (StructType)staticType2 : null) == null) {
                    staticType = (StaticType)StaticType.MISSING;
                } else {
                    StructType struct;
                    struct = struct;
                    if (key.op instanceof Rex.Op.Lit) {
                        PartiQLValue lit = ((Rex.Op.Lit)key.op).value;
                        if (!(lit instanceof TextValue) || lit.isNull()) throw new IllegalStateException(("Expected text literal, but got " + lit).toString());
                        String string = ((TextValue)lit).getString();
                        Intrinsics.checkNotNull((Object)string);
                        Identifier.Symbol id2 = Plan.identifierSymbol(string, Identifier.CaseSensitivity.SENSITIVE);
                        staticType = (StaticType)this.inferStructLookup(struct, id2).getFirst();
                    } else {
                        staticType = (StaticType)StaticType.ANY;
                    }
                }
                collection2.add(staticType);
            }
            Set pathTypes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            StaticType finalType = StaticType.Companion.unionOf$default((StaticType.Companion)StaticType.Companion, (Set)SetsKt.plus((Set)pathTypes, (Iterable)toAddTypes), null, (int)2, null).flatten();
            return Plan.rex(this.swallowAny(finalType), Plan.rexOpPathKey(root, key));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Rex visitRexOpPathSymbol(@NotNull Rex.Op.Path.Symbol node, @Nullable StaticType ctx) {
            Rex.Op op;
            boolean bl;
            Rex.Op firstPathOp;
            StaticType type2;
            Rex root;
            block16: {
                boolean bl2;
                void $this$all$iv;
                void $this$mapTo$iv$iv;
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                Object pathType;
                Collection collection;
                Object item$iv$iv2;
                void $this$mapTo$iv$iv3;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                root = this.visitRex(node.root, node.root.type);
                Iterable $this$map$iv2 = root.type.getAllTypes();
                boolean $i$f$map22 = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                    Rex rex2;
                    void type3;
                    StaticType staticType = (StaticType)item$iv$iv2;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    if ((type3 instanceof StructType ? (StructType)type3 : null) == null) {
                        rex2 = Plan.rex((StaticType)StaticType.MISSING, Plan.rexOpLit((PartiQLValue)PartiQL.missingValue$default(null, (int)1, null)));
                    } else {
                        StructType struct;
                        struct = struct;
                        Pair<StaticType, Identifier.Symbol> pair = this.inferStructLookup(struct, Plan.identifierSymbol(node.key, Identifier.CaseSensitivity.INSENSITIVE));
                        pathType = (StaticType)pair.component1();
                        Identifier.Symbol replacementId = (Identifier.Symbol)pair.component2();
                        switch (WhenMappings.$EnumSwitchMapping$1[replacementId.caseSensitivity.ordinal()]) {
                            case 1: {
                                rex2 = Plan.rex(pathType, Plan.rexOpPathSymbol(root, replacementId.symbol));
                                break;
                            }
                            case 2: {
                                rex2 = Plan.rex(pathType, Plan.rexOpPathKey(root, this.rexString(replacementId.symbol)));
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                    collection.add(rex2);
                }
                List paths = (List)destination$iv$iv;
                Iterable $i$f$map22 = paths;
                collection = StaticType.Companion;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
                    void it;
                    Rex bl3 = (Rex)item$iv$iv3;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl4 = false;
                    collection2.add(it.type);
                }
                type2 = StaticType.Companion.unionOf$default((StaticType.Companion)collection, (Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)), null, (int)2, null).flatten();
                firstPathOp = ((Rex)CollectionsKt.first((List)paths)).op;
                Iterable $this$map$iv3 = paths;
                boolean $i$f$map3 = false;
                item$iv$iv2 = $this$map$iv3;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv4 : $this$mapTo$iv$iv) {
                    void it;
                    pathType = (Rex)item$iv$iv4;
                    collection = destination$iv$iv3;
                    boolean bl5 = false;
                    collection.add(it.op);
                }
                $this$map$iv3 = (List)destination$iv$iv3;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Rex.Op it = (Rex.Op)element$iv;
                        boolean bl6 = false;
                        if (Intrinsics.areEqual((Object)it, (Object)firstPathOp)) continue;
                        bl2 = false;
                        break block16;
                    }
                    bl2 = bl = true;
                }
            }
            if (bl) {
                op = firstPathOp;
            } else if (!bl) {
                op = Plan.rexOpPathSymbol(root, node.key);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Rex.Op replacementOp = op;
            return Plan.rex(this.swallowAny(type2), replacementOp);
        }

        private final StaticType swallowAny(StaticType $this$swallowAny) {
            StaticType staticType;
            boolean bl;
            StaticType flattened;
            block7: {
                boolean bl2;
                flattened = $this$swallowAny.flatten();
                Iterable $this$any$iv = flattened.getAllTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        StaticType it = (StaticType)element$iv;
                        boolean bl3 = false;
                        if (!(it instanceof AnyType)) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = bl = false;
                }
            }
            if (bl) {
                staticType = (StaticType)StaticType.ANY;
            } else if (!bl) {
                staticType = flattened;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return staticType;
        }

        private final Rex rexString(String str) {
            return Plan.rex((StaticType)StaticType.STRING, Plan.rexOpLit((PartiQLValue)PartiQL.stringValue$default((String)str, null, (int)2, null)));
        }

        @Override
        @NotNull
        public Rex visitRexOpPath(@NotNull Rex.Op.Path node, @Nullable StaticType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rex path = (Rex)super.visitRexOpPath(node, ctx);
            if (Intrinsics.areEqual((Object)path.type, (Object)StaticType.MISSING)) {
                PlanTyper.this.handleAlwaysMissing();
                return PlanTyper.this.rexErr("Path always returns missing " + node);
            }
            return path;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Rex visitRexOpCallStatic(@NotNull Rex.Op.Call.Static node, @Nullable StaticType ctx) {
            Rex rex2;
            Collection collection;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.fn instanceof Fn.Resolved) {
                StaticType staticType = ctx;
                Intrinsics.checkNotNull((Object)staticType);
                return Plan.rex(staticType, node);
            }
            Fn.Unresolved fn = (Fn.Unresolved)node.fn;
            boolean isNotMissable = PlanTyper.this.isNotMissable(fn);
            Iterable $this$map$iv = node.args;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rex rex3 = (Rex)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.visitRex((Rex)it, null));
            }
            List args = (List)destination$iv$iv;
            FnMatch<FunctionSignature.Scalar> match = PlanTyper.this.env.resolveFn$partiql_planner(fn, args);
            if (match instanceof FnMatch.Ok) {
                rex2 = this.toRexCall((FnMatch.Ok)match, args, isNotMissable);
            } else if (match instanceof FnMatch.Dynamic) {
                void $this$mapTo$iv$iv2;
                Set types2 = new LinkedHashSet();
                if (((FnMatch.Dynamic)match).isMissable() && !isNotMissable) {
                    types2.add(StaticType.MISSING);
                }
                Iterable $this$map$iv2 = ((FnMatch.Dynamic)match).getCandidates();
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void $this$mapTo$iv$iv3;
                    Fn.Resolved resolvedFn;
                    Rex.Op.Call.Static staticCall;
                    void candidate;
                    FnMatch.Ok ok = (FnMatch.Ok)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    Rex rex4 = this.toRexCall((FnMatch.Ok<FunctionSignature.Scalar>)candidate, args, isNotMissable);
                    Rex.Op op = rex4.op;
                    if ((op instanceof Rex.Op.Call.Static ? (Rex.Op.Call.Static)op : null) == null) {
                        throw new IllegalStateException("ToRexCall should always return a static call.".toString());
                    }
                    staticCall = staticCall;
                    Fn fn2 = staticCall.fn;
                    if ((fn2 instanceof Fn.Resolved ? (Fn.Resolved)fn2 : null) == null) {
                        throw new IllegalStateException("This should have been resolved".toString());
                    }
                    resolvedFn = resolvedFn;
                    types2.add(rex4.type);
                    Iterable $this$map$iv3 = candidate.getMapping();
                    boolean $i$f$map3 = false;
                    Iterable iterable3 = $this$map$iv3;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                        Fn.Resolved resolved;
                        void it;
                        FunctionSignature.Scalar scalar = (FunctionSignature.Scalar)item$iv$iv2;
                        Collection collection2 = destination$iv$iv3;
                        boolean bl2 = false;
                        if (it != null) {
                            void it2;
                            boolean bl3 = false;
                            resolved = Plan.fnResolved((FunctionSignature.Scalar)it2);
                        } else {
                            resolved = null;
                        }
                        collection2.add(resolved);
                    }
                    List coercions = (List)destination$iv$iv3;
                    collection.add(Plan.rexOpCallDynamicCandidate(resolvedFn, coercions));
                }
                List candidates = (List)destination$iv$iv2;
                Rex.Op.Call.Dynamic op = Plan.rexOpCallDynamic(args, candidates);
                rex2 = Plan.rex(StaticType.Companion.unionOf$default((StaticType.Companion)StaticType.Companion, (Set)types2, null, (int)2, null).flatten(), op);
            } else if (match instanceof FnMatch.Error) {
                PlanTyper.this.handleUnknownFunction((FnMatch.Error)match);
                rex2 = PlanTyper.this.rexErr("Unknown scalar function " + fn);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return rex2;
        }

        @Override
        @NotNull
        public Rex visitRexOpCallDynamic(@NotNull Rex.Op.Call.Dynamic node, @Nullable StaticType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return Plan.rex((StaticType)StaticType.ANY, Plan.rexOpErr("Direct dynamic calls are not supported. This should have been a static call."));
        }

        /*
         * WARNING - void declaration
         */
        private final Rex toRexCall(FnMatch.Ok<FunctionSignature.Scalar> match, List<Rex> args, boolean isNotMissable) {
            StaticType type2;
            void $this$forEach$iv;
            Fn.Resolved newFn = Plan.fnResolved(match.getSignature());
            List newArgs = PlanTyper.this.rewriteFnArgs(match.getMapping(), args);
            PartiQLValueType returns = newFn.signature.returns;
            Iterable iterable = newArgs;
            PlanTyper planTyper = PlanTyper.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Rex it = (Rex)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.type, (Object)MissingType.INSTANCE) || isNotMissable) continue;
                planTyper.handleAlwaysMissing();
                return Plan.rex((StaticType)StaticType.MISSING, Plan.rexOpCallStatic(newFn, newArgs));
            }
            boolean isMissing = false;
            boolean isMissable = false;
            if (isNotMissable) {
                boolean bl;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block20: {
                    $this$any$iv = newArgs;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Rex it = (Rex)element$iv;
                            boolean bl2 = false;
                            if (!(it.type instanceof MissingType)) continue;
                            bl = true;
                            break block20;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    isMissing = true;
                } else {
                    boolean bl3;
                    block21: {
                        $this$any$iv = newArgs;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Rex it = (Rex)element$iv;
                                boolean bl4 = false;
                                if (!it.type.isMissable()) continue;
                                bl3 = true;
                                break block21;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        isMissable = true;
                    }
                }
            }
            boolean isNull = false;
            boolean isNullable = false;
            if (newFn.signature.isNullCall) {
                if (isMissing) {
                    isNull = true;
                } else if (isMissable) {
                    isNullable = true;
                } else {
                    for (StaticType[] arg : newArgs) {
                        if (arg.type instanceof NullType) {
                            isNull = true;
                            break;
                        }
                        if (!arg.type.isNullable()) continue;
                        isNullable = true;
                        break;
                    }
                }
            }
            isNullable = isNullable || newFn.signature.isNullable;
            StaticType staticType = isNull ? (StaticType)StaticType.NULL : (type2 = isNullable ? TypeUtilsKt.toStaticType(returns) : TypeUtilsKt.toNonNullStaticType(returns));
            if (match.isMissable() && !isNotMissable) {
                StaticType[] arg;
                arg = new StaticType[]{type2, (StaticType)StaticType.MISSING};
                type2 = StaticType.Companion.unionOf$default((StaticType.Companion)StaticType.Companion, (StaticType[])arg, null, (int)2, null);
            }
            if (Intrinsics.areEqual((Object)newFn.signature.name, (Object)"cast_decimal") && newFn.signature.parameters.size() == 3) {
                int p = this.getIntOrErr(((Rex)newArgs.get((int)1)).op);
                int s = this.getIntOrErr(((Rex)newArgs.get((int)2)).op);
                DecimalType returns2 = new DecimalType((DecimalType.PrecisionScaleConstraint)new DecimalType.PrecisionScaleConstraint.Constrained(p, s), null, 2, null);
                Rex.Op.Call.Static op = Plan.rexOpCallStatic(newFn, newArgs);
                return Plan.rex((StaticType)returns2, op);
            }
            Rex.Op.Call.Static op = Plan.rexOpCallStatic(newFn, newArgs);
            return Plan.rex(type2.flatten(), op);
        }

        private final int getIntOrErr(Rex.Op op) {
            if (!(op instanceof Rex.Op.Lit)) {
                throw new IllegalStateException(("Unrecoverable, expected Rex.Op.Lit found " + Reflection.getOrCreateKotlinClass(op.getClass()) + ". This should be unreachable.").toString());
            }
            if (!(((Rex.Op.Lit)op).value instanceof Int32Value)) {
                throw new IllegalStateException(("Unrecoverable, expected Int32Value found " + Reflection.getOrCreateKotlinClass(((Rex.Op.Lit)op).value.getClass()) + ". This should be unreachable.").toString());
            }
            if (((Int32Value)((Rex.Op.Lit)op).value).getValue() == null) {
                throw new IllegalStateException("Int32Value cannot be null. This should be unreachable.".toString());
            }
            Object object = ((Int32Value)((Rex.Op.Lit)op).value).getValue();
            Intrinsics.checkNotNull((Object)object);
            return ((Number)object).intValue();
        }

        @Override
        @NotNull
        public Rex visitRexOpCase(@NotNull Rex.Op.Case node, @Nullable StaticType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Collection $this$toTypedArray$iv = node.branches;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Rex.Op.Case.Branch[] branchArray = thisCollection$iv.toArray(new Rex.Op.Case.Branch[0]);
            if (branchArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            Rex.Op.Case.Branch[] oldBranches = branchArray;
            List newBranches = new ArrayList();
            DynamicTyper typer = new DynamicTyper();
            for (Rex.Op.Case.Branch branch : oldBranches) {
                branch = this.visitRexOpCaseBranch(branch, branch.rex.type);
                if (Intrinsics.areEqual((Object)this.boolOrNull(branch.condition.op), (Object)false)) continue;
                if (!this.canBeBoolean(branch.condition.type)) {
                    PlanTyper.this.onProblem.invoke((Object)new Problem(ProblemKt.getUNKNOWN_PROBLEM_LOCATION(), (ProblemDetails)new PlanningProblemDetails.IncompatibleTypesForOp(branch.condition.type.getAllTypes(), "CASE_WHEN")));
                    continue;
                }
                typer.accumulate(branch.rex.type);
                newBranches.add(branch);
            }
            Rex newDefault = this.visitRex(node.default, null);
            if (newBranches.isEmpty()) {
                return newDefault;
            }
            typer.accumulate(newDefault.type);
            Pair<StaticType, List<Pair<PartiQLValueType, PartiQLValueType>>> pair = typer.mapping();
            StaticType type2 = (StaticType)pair.component1();
            List mapping = (List)pair.component2();
            if (mapping != null) {
                PartiQLValueType target;
                int bsize;
                boolean bl;
                int msize = mapping.size();
                boolean bl2 = bl = msize == (bsize = newBranches.size() + 1);
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-PlanTyper$RexTyper$visitRexOpCase$22 = false;
                    String $i$a$-assert-PlanTyper$RexTyper$visitRexOpCase$22 = "Coercion mappings `len " + msize + "` did not match the number of CASE-WHEN branches `len " + bsize + '`';
                    throw new AssertionError((Object)$i$a$-assert-PlanTyper$RexTyper$visitRexOpCase$22);
                }
                int $i$a$-assert-PlanTyper$RexTyper$visitRexOpCase$22 = newBranches.size();
                for (int i = 0; i < $i$a$-assert-PlanTyper$RexTyper$visitRexOpCase$22; ++i) {
                    PartiQLValueType target2;
                    Pair pair2 = (Pair)mapping.get(i);
                    PartiQLValueType operand = (PartiQLValueType)pair2.component1();
                    if (operand == (target2 = (PartiQLValueType)pair2.component2())) continue;
                    FunctionSignature.Scalar cast = PlanTyper.this.env.getFnResolver().cast$partiql_planner(operand, target2);
                    Rex.Op.Case.Branch branch = (Rex.Op.Case.Branch)newBranches.get(i);
                    Rex rex2 = Plan.rex(type2, Plan.rexOpCallStatic(Plan.fnResolved(cast), CollectionsKt.listOf((Object)branch.rex)));
                    newBranches.set(i, Rex.Op.Case.Branch.copy$default(branch, null, rex2, 1, null));
                }
                Pair pair3 = (Pair)CollectionsKt.last((List)mapping);
                PartiQLValueType operand = (PartiQLValueType)pair3.component1();
                if (operand != (target = (PartiQLValueType)pair3.component2())) {
                    FunctionSignature.Scalar cast = PlanTyper.this.env.getFnResolver().cast$partiql_planner(operand, target);
                    newDefault = Plan.rex(type2, Plan.rexOpCallStatic(Plan.fnResolved(cast), CollectionsKt.listOf((Object)newDefault)));
                }
            }
            if (Intrinsics.areEqual((Object)this.boolOrNull(((Rex.Op.Case.Branch)newBranches.get((int)0)).condition.op), (Object)true)) {
                return ((Rex.Op.Case.Branch)newBranches.get((int)0)).rex;
            }
            Rex.Op.Case op = new Rex.Op.Case(newBranches, newDefault);
            return Plan.rex(type2, op);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Rex visitRexOpCoalesce(@NotNull Rex.Op.Coalesce node, @Nullable StaticType ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Iterable $this$map$iv = node.args;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rex rex2 = (Rex)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.visitRex((Rex)it, it.type));
            }
            List args = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            DynamicTyper typer = new DynamicTyper();
            Iterable $this$forEach$iv = args;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Rex v = (Rex)element$iv;
                boolean bl = false;
                typer.accumulate(v.type);
            }
            Pair<StaticType, List<Pair<PartiQLValueType, PartiQLValueType>>> pair = typer.mapping();
            StaticType type2 = (StaticType)pair.component1();
            List mapping = (List)pair.component2();
            if (mapping != null) {
                boolean element$iv;
                boolean bl = element$iv = mapping.size() == args.size();
                if (_Assertions.ENABLED && !element$iv) {
                    boolean bl2 = false;
                    String string = "Coercion mappings `len " + mapping.size() + "` did not match the number of COALESCE arguments `len " + args.size() + '`';
                    throw new AssertionError((Object)string);
                }
                int n = args.size();
                for (int i = 0; i < n; ++i) {
                    PartiQLValueType target;
                    Pair pair2 = (Pair)mapping.get(i);
                    PartiQLValueType operand = (PartiQLValueType)pair2.component1();
                    if (operand == (target = (PartiQLValueType)pair2.component2())) continue;
                    FunctionSignature.Scalar cast = PlanTyper.this.env.getFnResolver().cast$partiql_planner(operand, target);
                    Rex rex3 = Plan.rex(type2, Plan.rexOpCallStatic(Plan.fnResolved(cast), CollectionsKt.listOf(args.get(i))));
                    args.set(i, rex3);
                }
            }
            Rex.Op.Coalesce op = Plan.rexOpCoalesce(args);
            return Plan.rex(type2, op);
        }

        @Override
        @NotNull
        public Rex visitRexOpNullif(@NotNull Rex.Op.Nullif node, @Nullable StaticType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rex value = this.visitRex(node.value, node.value.type);
            Rex nullifier = this.visitRex(node.nullifier, node.nullifier.type);
            DynamicTyper typer = new DynamicTyper();
            typer.accumulate((StaticType)StaticType.NULL);
            typer.accumulate(value.type);
            StaticType type2 = (StaticType)typer.mapping().component1();
            Rex.Op.Nullif op = Plan.rexOpNullif(value, nullifier);
            return Plan.rex(type2, op);
        }

        private final boolean canBeBoolean(StaticType type2) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = type2.flatten().getAllTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        StaticType it = (StaticType)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof BoolType || it instanceof NullType || it instanceof MissingType)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final Boolean boolOrNull(Rex.Op op) {
            return op instanceof Rex.Op.Lit && ((Rex.Op.Lit)op).value instanceof BoolValue ? (Boolean)((BoolValue)((Rex.Op.Lit)op).value).getValue() : null;
        }

        @Override
        @NotNull
        public Rex.Op.Case.Branch visitRexOpCaseBranch(@NotNull Rex.Op.Case.Branch node, @Nullable StaticType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rex visitedCondition = this.visitRex(node.condition, node.condition.type);
            Rex visitedReturn = this.visitRex(node.rex, node.rex.type);
            return this.foldCaseBranch(visitedCondition, visitedReturn);
        }

        /*
         * WARNING - void declaration
         */
        private final Rex.Op.Case.Branch foldCaseBranch(Rex condition, Rex result) {
            Rex.Op op = condition.op;
            Rex.Op.Call call = op instanceof Rex.Op.Call ? (Rex.Op.Call)op : null;
            if (call == null) {
                return Plan.rexOpCaseBranch(condition, result);
            }
            Rex.Op.Call call2 = call;
            Rex.Op.Call call3 = call2;
            if (call3 instanceof Rex.Op.Call.Dynamic) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = ((Rex.Op.Call.Dynamic)call2).candidates;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Rex rex2;
                    void $this$filterIsInstanceTo$iv$iv;
                    Rex ref;
                    Fn.Resolved fn;
                    void candidate;
                    Rex.Op.Call.Dynamic.Candidate candidate2 = (Rex.Op.Call.Dynamic.Candidate)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Fn fn2 = candidate.fn;
                    if ((fn2 instanceof Fn.Resolved ? (Fn.Resolved)fn2 : null) == null) {
                        return Plan.rexOpCaseBranch(condition, result);
                    }
                    fn = fn;
                    if (!StringsKt.equals((String)fn.signature.name, (String)"is_struct", (boolean)true)) {
                        return Plan.rexOpCaseBranch(condition, result);
                    }
                    if ((Rex)CollectionsKt.getOrNull(((Rex.Op.Call.Dynamic)call2).args, (int)0) == null) {
                        throw new IllegalStateException("IS STRUCT requires an argument.".toString());
                    }
                    Iterable $this$filterIsInstance$iv = ref.type.getAllTypes();
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable2 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof StructType)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 2;
                    Map map = null;
                    Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                    AnyOfType type2 = new AnyOfType(set, map, n, defaultConstructorMarker);
                    Rex replacementVal = Rex.copy$default(ref, (StaticType)type2, null, 2, null);
                    boolean bl2 = ref.op instanceof Rex.Op.Var.Resolved;
                    if (bl2) {
                        rex2 = RexReplacer.INSTANCE.replace$partiql_planner(result, ref, replacementVal);
                    } else if (!bl2) {
                        rex2 = result;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    collection.add(rex2);
                }
                List rex3 = (List)destination$iv$iv;
                StaticType type3 = PlanTyper.this.toUnionType(rex3).flatten();
                return Plan.rexOpCaseBranch(condition, Rex.copy$default(result, type3, null, 2, null));
            }
            if (call3 instanceof Rex.Op.Call.Static) {
                Rex rex4;
                void $this$filterIsInstanceTo$iv$iv;
                Rex rex5;
                StaticType it;
                Object element$iv2;
                boolean bl;
                Rex ref;
                block28: {
                    Fn $i$f$map = ((Rex.Op.Call.Static)call2).fn;
                    Fn.Resolved resolved = $i$f$map instanceof Fn.Resolved ? (Fn.Resolved)$i$f$map : null;
                    if (resolved == null) {
                        return Plan.rexOpCaseBranch(condition, result);
                    }
                    Fn.Resolved fn = resolved;
                    if (!StringsKt.equals((String)fn.signature.name, (String)"is_struct", (boolean)true)) {
                        return Plan.rexOpCaseBranch(condition, result);
                    }
                    Rex rex6 = (Rex)CollectionsKt.getOrNull(((Rex.Op.Call.Static)call2).args, (int)0);
                    if (rex6 == null) {
                        throw new IllegalStateException("IS STRUCT requires an argument.".toString());
                    }
                    ref = rex6;
                    Iterable $this$all$iv = ref.type.getAllTypes();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            it = (StaticType)element$iv2;
                            boolean bl3 = false;
                            if (it instanceof StructType) continue;
                            bl = false;
                            break block28;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    rex5 = Plan.rex((StaticType)StaticType.BOOL, Plan.rexOpLit((PartiQLValue)PartiQL.boolValue$default((Boolean)true, null, (int)2, null)));
                } else {
                    boolean bl4;
                    block29: {
                        Iterable $this$none$iv = ref.type.getAllTypes();
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl4 = true;
                        } else {
                            for (Object element$iv2 : $this$none$iv) {
                                it = (StaticType)element$iv2;
                                boolean bl5 = false;
                                if (!(it instanceof StructType)) continue;
                                bl4 = false;
                                break block29;
                            }
                            bl4 = true;
                        }
                    }
                    rex5 = bl4 ? Plan.rex((StaticType)StaticType.BOOL, Plan.rexOpLit((PartiQLValue)PartiQL.boolValue$default((Boolean)false, null, (int)2, null))) : condition;
                }
                Rex simplifiedCondition = rex5;
                Iterable $this$filterIsInstance$iv = ref.type.getAllTypes();
                boolean $i$f$filterIsInstance = false;
                element$iv2 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof StructType)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 2;
                Map map = null;
                Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                StaticType type4 = new AnyOfType(set, map, n, defaultConstructorMarker).flatten();
                Rex replacementVal = Rex.copy$default(ref, type4, null, 2, null);
                boolean bl6 = ref.op instanceof Rex.Op.Var.Resolved;
                if (bl6) {
                    rex4 = RexReplacer.INSTANCE.replace$partiql_planner(result, ref, replacementVal);
                } else if (!bl6) {
                    rex4 = result;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Rex rex7 = rex4;
                return Plan.rexOpCaseBranch(simplifiedCondition, rex7);
            }
            throw new NoWhenBranchMatchedException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Rex visitRexOpCollection(@NotNull Rex.Op.Collection node, @Nullable StaticType ctx) {
            CollectionType collectionType;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            StaticType staticType = ctx;
            Intrinsics.checkNotNull((Object)staticType);
            if (!(staticType instanceof CollectionType)) {
                Object[] objectArray = new CollectionType[]{(CollectionType)StaticType.LIST, (CollectionType)StaticType.BAG, (CollectionType)StaticType.SEXP};
                PlanTyper.this.handleUnexpectedType(ctx, SetsKt.setOf((Object[])objectArray));
                return Plan.rex(StaticType.NULL_OR_MISSING, Plan.rexOpErr("Expected collection type"));
            }
            Iterable $this$map$iv = node.values;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rex rex2 = (Rex)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.visitRex((Rex)it, it.type));
            }
            List values = (List)destination$iv$iv;
            StaticType t = values.size() == 0 ? (StaticType)StaticType.ANY : PlanTyper.this.toUnionType(values);
            iterable = (CollectionType)ctx;
            if (iterable instanceof BagType) {
                collectionType = (CollectionType)new BagType(t, null, null, 6, null);
            } else if (iterable instanceof ListType) {
                collectionType = (CollectionType)new ListType(t, null, null, 6, null);
            } else if (iterable instanceof SexpType) {
                collectionType = (CollectionType)new SexpType(t, null, null, 6, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            CollectionType type2 = collectionType;
            return Plan.rex((StaticType)type2, Plan.rexOpCollection(values));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Rex visitRexOpStruct(@NotNull Rex.Op.Struct node, @Nullable StaticType ctx) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Iterable $this$map$iv = node.fields;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rex.Op.Struct.Field field = (Rex.Op.Struct.Field)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Rex k = this.visitRex(it.k, it.k.type);
                Rex v = this.visitRex(it.v, it.v.type);
                collection.add(Plan.rexOpStructField(k, v));
            }
            List fields = (List)destination$iv$iv;
            boolean structIsClosed = true;
            List structTypeFields = new ArrayList();
            Set structKeysSeent = new LinkedHashSet();
            for (Rex.Op.Struct.Field field : fields) {
                boolean bl;
                block6: {
                    if (field.k.op instanceof Rex.Op.Lit) {
                        String name;
                        Rex.Op key = field.k.op;
                        if (!(((Rex.Op.Lit)key).value instanceof TextValue)) continue;
                        Intrinsics.checkNotNull((Object)((TextValue)((Rex.Op.Lit)key).value).getString());
                        StaticType type2 = field.v.type;
                        structKeysSeent.add(name);
                        structTypeFields.add(new StructType.Field(name, type2));
                        continue;
                    }
                    Iterable $this$any$iv = field.k.type.getAllTypes();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            StaticType it = (StaticType)element$iv;
                            boolean bl2 = false;
                            if (!TypeUtilsKt.isText(it)) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                structIsClosed = false;
            }
            Object[] objectArray = new TupleConstraint[]{(TupleConstraint)new TupleConstraint.Open(!structIsClosed), (TupleConstraint)new TupleConstraint.UniqueAttrs(structKeysSeent.size() == fields.size())};
            StructType type3 = new StructType(structTypeFields, structIsClosed, null, SetsKt.setOf((Object[])objectArray), null, 20, null);
            return Plan.rex((StaticType)type3, Plan.rexOpStruct(fields));
        }

        @Override
        @NotNull
        public Rex visitRexOpPivot(@NotNull Rex.Op.Pivot node, @Nullable StaticType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rel rel2 = PlanTyper.type$default(PlanTyper.this, node.rel, this.locals, null, 2, null);
            TypeEnv typeEnv = new TypeEnv(rel2.type.schema);
            Rex key = PlanTyper.type$default(PlanTyper.this, node.key, typeEnv, null, 2, null);
            Rex value = PlanTyper.type$default(PlanTyper.this, node.value, typeEnv, null, 2, null);
            StructType type2 = new StructType(null, false, null, SetsKt.setOf((Object)new TupleConstraint.Open(true)), null, 21, null);
            Rex.Op.Pivot op = Plan.rexOpPivot(key, value, rel2);
            return Plan.rex((StaticType)type2, op);
        }

        @Override
        @NotNull
        public Rex visitRexOpSubquery(@NotNull Rex.Op.Subquery node, @Nullable StaticType ctx) {
            Rex rex2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rex.Op.Select select = (Rex.Op.Select)this.visitRexOpSelect((Rex.Op.Select)node.select, (StaticType)ctx).op;
            Rex.Op.Subquery subquery = Rex.Op.Subquery.copy$default(node, select, null, 2, null);
            switch (WhenMappings.$EnumSwitchMapping$2[node.coercion.ordinal()]) {
                case 1: {
                    rex2 = this.visitRexOpSubqueryScalar(subquery, select.constructor.type);
                    break;
                }
                case 2: {
                    rex2 = this.visitRexOpSubqueryRow(subquery, select.constructor.type);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return rex2;
        }

        private final Rex visitRexOpSubqueryRow(Rex.Op.Subquery subquery, StaticType cons) {
            if (!(cons instanceof StructType)) {
                return PlanTyper.this.rexErr("Subquery with non-SQL SELECT cannot be coerced to a row-value expression. Found constructor type: " + cons);
            }
            ListType type2 = StaticType.LIST;
            Rex.Op.Subquery op = subquery;
            return Plan.rex((StaticType)type2, op);
        }

        private final Rex visitRexOpSubqueryScalar(Rex.Op.Subquery subquery, StaticType cons) {
            if (!(cons instanceof StructType)) {
                return PlanTyper.this.rexErr("Subquery with non-SQL SELECT cannot be coerced to a scalar. Found constructor type: " + cons);
            }
            int n = ((StructType)cons).getFields().size();
            if (n != 1) {
                return PlanTyper.this.rexErr("SELECT constructor with " + n + " attributes cannot be coerced to a scalar. Found constructor type: " + cons);
            }
            StaticType type2 = ((StructType.Field)CollectionsKt.first((List)((StructType)cons).getFields())).getValue();
            Rex.Op.Subquery op = subquery;
            return Plan.rex(type2, op);
        }

        @Override
        @NotNull
        public Rex visitRexOpSelect(@NotNull Rex.Op.Select node, @Nullable StaticType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Rel rel2 = PlanTyper.type$default(PlanTyper.this, node.rel, this.locals, null, 2, null);
            TypeEnv typeEnv = new TypeEnv(rel2.type.schema);
            Rex constructor = PlanTyper.type$default(PlanTyper.this, node.constructor, typeEnv, null, 2, null);
            StaticType constructorType = constructor.type;
            if (constructorType instanceof StructType) {
                constructorType = (StaticType)StructType.copy$default((StructType)((StructType)constructorType), null, (boolean)false, null, (Set)SetsKt.plus((Set)((StructType)constructorType).getConstraints(), (Iterable)SetsKt.setOf((Object)TupleConstraint.Ordered.INSTANCE)), null, (int)23, null);
                constructor = Plan.rex(constructorType, constructor.op);
            }
            CollectionType type2 = PlanTyper.this.isOrdered(rel2) ? (CollectionType)new ListType(constructor.type, null, null, 6, null) : (CollectionType)new BagType(constructor.type, null, null, 6, null);
            return Plan.rex((StaticType)type2, Plan.rexOpSelect(constructor, rel2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Rex visitRexOpTupleUnion(@NotNull Rex.Op.TupleUnion node, @Nullable StaticType ctx) {
            StaticType staticType;
            Collection collection;
            Object[] $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Iterable $this$map$iv = node.args;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                void it;
                Rex rex2 = (Rex)t;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.visitRex((Rex)it, ctx));
            }
            List args = (List)destination$iv$iv;
            if (args.size() == 0) {
                $this$mapTo$iv$iv = new TupleConstraint[]{(TupleConstraint)new TupleConstraint.Open(false), (TupleConstraint)new TupleConstraint.UniqueAttrs(true), (TupleConstraint)TupleConstraint.Ordered.INSTANCE};
                staticType = (StaticType)new StructType(MapsKt.emptyMap(), true, null, SetsKt.setOf((Object[])$this$mapTo$iv$iv), null, 20, null);
            } else {
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2 = args;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    Rex rex3 = (Rex)item$iv$iv;
                    collection = collection2;
                    boolean bl = false;
                    collection.add(it.type);
                }
                List argTypes = (List)collection2;
                Sequence potentialTypes2 = SequencesKt.map(this.buildArgumentPermutations(argTypes), (Function1)((Function1)new Function1<List<? extends StaticType>, StaticType>(this){
                    final /* synthetic */ RexTyper this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final StaticType invoke(@NotNull List<? extends StaticType> argumentList) {
                        Intrinsics.checkNotNullParameter(argumentList, (String)"argumentList");
                        return RexTyper.access$calculateTupleUnionOutputType(this.this$0, argumentList);
                    }
                }));
                staticType = StaticType.Companion.unionOf$default((StaticType.Companion)StaticType.Companion, (Set)SequencesKt.toSet((Sequence)potentialTypes2), null, (int)2, null).flatten();
            }
            StaticType type2 = staticType;
            Rex.Op.TupleUnion op = Plan.rexOpTupleUnion(args);
            return Plan.rex(type2, op);
        }

        @Override
        @NotNull
        public PlanNode visitRexOpErr(@NotNull Rex.Op.Err node, @Nullable StaticType ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            StaticType staticType = ctx;
            if (staticType == null) {
                staticType = (StaticType)StaticType.ANY;
            }
            StaticType type2 = staticType;
            return Plan.rex(type2, node);
        }

        /*
         * Unable to fully structure code
         */
        private final StaticType calculateTupleUnionOutputType(List<? extends StaticType> args) {
            structFields = new ArrayList<E>();
            structAmount = 0;
            structIsClosed = false;
            structIsClosed = true;
            structIsOrdered = false;
            structIsOrdered = true;
            uniqueAttrs = false;
            uniqueAttrs = true;
            possibleOutputTypes = new ArrayList<E>();
            var8_8 = args;
            var9_9 = PlanTyper.this;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                arg = (StaticType)element$iv;
                $i$a$-forEach-PlanTyper$RexTyper$calculateTupleUnionOutputType$1 = false;
                var15_23 = arg;
                if (var15_23 instanceof StructType) {
                    ++structAmount;
                    structFields.addAll(((StructType)arg).getFields());
                    structIsClosed = structIsClosed != false && ((StructType)arg).getConstraints().contains(new TupleConstraint.Open(false)) != false;
                    structIsOrdered = structIsOrdered != false && ((StructType)arg).getConstraints().contains(TupleConstraint.Ordered.INSTANCE) != false;
                    uniqueAttrs = uniqueAttrs != false && ((StructType)arg).getConstraints().contains(new TupleConstraint.UniqueAttrs(true)) != false;
                    continue;
                }
                if (var15_23 instanceof AnyOfType) {
                    PlanTyper.access$getOnProblem$p(var9_9).invoke((Object)new Problem(ProblemKt.getUNKNOWN_PROBLEM_LOCATION(), (ProblemDetails)new PlanningProblemDetails.CompileError("TupleUnion wasn't normalized to exclude union types.")));
                    possibleOutputTypes.add(StaticType.MISSING);
                    continue;
                }
                if (var15_23 instanceof NullType) {
                    return (StaticType)StaticType.NULL;
                }
                return (StaticType)StaticType.MISSING;
            }
            v0 = uniqueAttrs = structIsClosed == false && structAmount > 1 ? false : uniqueAttrs;
            if (!uniqueAttrs) ** GOTO lbl-1000
            $this$forEach$iv = structFields;
            var19_26 = structFields.size();
            $i$f$distinctBy = false;
            set$iv = new HashSet<String>();
            list$iv = new ArrayList<E>();
            for (E e$iv : $this$distinctBy$iv) {
                it = (StructType.Field)e$iv;
                $i$a$-distinctBy-PlanTyper$RexTyper$calculateTupleUnionOutputType$2 = false;
                key$iv = it.getKey();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            var20_27 = list$iv;
            if (var19_26 == var20_27.size()) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            uniqueAttrs = v1;
            $i$f$distinctBy = structIsOrdered;
            if ($i$f$distinctBy) {
                v2 = TupleConstraint.Ordered.INSTANCE;
            } else if (!$i$f$distinctBy) {
                v2 = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            orderedConstraint = v2;
            set$iv = new TupleConstraint[]{(TupleConstraint)new TupleConstraint.Open(structIsClosed == false), (TupleConstraint)new TupleConstraint.UniqueAttrs(uniqueAttrs), (TupleConstraint)orderedConstraint};
            constraints = SetsKt.setOfNotNull((Object[])set$iv);
            $this$map$iv = structFields;
            $i$f$map = false;
            element$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var17_29 = (StructType.Field)item$iv$iv;
                var20_27 = destination$iv$iv;
                $i$a$-map-PlanTyper$RexTyper$calculateTupleUnionOutputType$3 = false;
                var20_27.add(it);
            }
            var21_31 = null;
            var22_32 = 20;
            var23_33 = null;
            var24_34 = constraints;
            var25_35 = null;
            var26_36 = structIsClosed;
            var27_37 = (List)destination$iv$iv;
            return (StaticType)new StructType(var27_37, var26_36, var25_35, var24_34, var23_33, var22_32, var21_31);
        }

        /*
         * WARNING - void declaration
         */
        private final Sequence<List<StaticType>> buildArgumentPermutations(List<? extends StaticType> args) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = args;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StaticType staticType = (StaticType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.flatten().getAllTypes());
            }
            List flattenedArgs = (List)destination$iv$iv;
            return this.buildArgumentPermutations(flattenedArgs, CollectionsKt.emptyList());
        }

        private final Sequence<List<StaticType>> buildArgumentPermutations(List<? extends List<? extends StaticType>> args, List<? extends StaticType> accumulator) {
            if (args.isEmpty()) {
                Object[] objectArray = new List[]{accumulator};
                return SequencesKt.sequenceOf((Object[])objectArray);
            }
            List first = (List)CollectionsKt.first(args);
            List<? extends List<? extends StaticType>> rest = args.size() == 1 ? CollectionsKt.emptyList() : args.subList(1, args.size());
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super List<? extends StaticType>>, Continuation<? super Unit>, Object>((List<? extends StaticType>)first, this, rest, accumulator, null){
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ List<StaticType> $first;
                final /* synthetic */ RexTyper this$0;
                final /* synthetic */ List<List<StaticType>> $rest;
                final /* synthetic */ List<StaticType> $accumulator;
                {
                    this.$first = $first;
                    this.this$0 = $receiver;
                    this.$rest = $rest;
                    this.$accumulator = $accumulator;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            var3_4 = this.$first;
                            var4_5 = this.this$0;
                            var5_6 = this.$rest;
                            var6_7 = this.$accumulator;
                            $i$f$forEach = false;
                            var8_9 = $this$forEach$iv.iterator();
lbl12:
                            // 3 sources

                            while (var8_9.hasNext()) {
                                element$iv = var8_9.next();
                                argSubType = (StaticType)element$iv;
                                $i$a$-forEach-PlanTyper$RexTyper$buildArgumentPermutations$1$1 = false;
                                this.L$0 = $this$sequence;
                                this.L$1 = var4_5;
                                this.L$2 = var5_6;
                                this.L$3 = var6_7;
                                this.L$4 = var8_9;
                                this.label = 1;
                                v0 = $this$sequence.yieldAll(RexTyper.access$buildArgumentPermutations(var4_5, var5_6, CollectionsKt.plus((Collection)var6_7, (Iterable)CollectionsKt.listOf((Object)argSubType))), (Continuation)this);
                                if (v0 != var12_2) continue;
                                return var12_2;
                            }
                            break;
                        }
                        case 1: {
                            $i$f$forEach = false;
                            $i$a$-forEach-PlanTyper$RexTyper$buildArgumentPermutations$1$1 = false;
                            var8_9 = (Iterator<T>)this.L$4;
                            var6_7 = (List<StaticType>)this.L$3;
                            var5_6 = (List)this.L$2;
                            var4_5 = (RexTyper)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
                            ** GOTO lbl12
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<SequenceScope<? super List<? extends StaticType>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super List<? extends StaticType>> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        /*
         * Unable to fully structure code
         */
        private final Pair<StaticType, Identifier.Symbol> inferStructLookup(StructType struct, Identifier.Symbol key) {
            block17: {
                block18: {
                    block15: {
                        block16: {
                            block14: {
                                binding = PlanTyper.access$toBindingName(PlanTyper.this, key);
                                isClosed = struct.getConstraints().contains(new TupleConstraint.Open(false));
                                isOrdered = struct.getConstraints().contains(TupleConstraint.Ordered.INSTANCE);
                                if (!isClosed || !isOrdered) break block15;
                                $this$firstOrNull$iv = struct.getFields();
                                $i$f$firstOrNull = false;
                                for (T element$iv : $this$firstOrNull$iv) {
                                    entry = (StructType.Field)element$iv;
                                    $i$a$-firstOrNull-PlanTyper$RexTyper$inferStructLookup$1 = false;
                                    if (!binding.isEquivalentTo(entry.getKey())) continue;
                                    v0 = element$iv;
                                    break block14;
                                }
                                v0 = null;
                            }
                            if ((v1 = (StructType.Field)v0) == null) break block16;
                            it = v1;
                            $i$a$-let-PlanTyper$RexTyper$inferStructLookup$2 = false;
                            v2 = TuplesKt.to((Object)this.sensitive(it.getKey()), (Object)it.getValue());
                            v1 = v2;
                            if (v2 != null) break block17;
                        }
                        v1 = TuplesKt.to((Object)key, (Object)StaticType.MISSING);
                        break block17;
                    }
                    if (!isClosed) break block18;
                    $this$filter$iv = struct.getFields();
                    $i$f$filter = false;
                    it = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        entry = (StructType.Field)element$iv$iv;
                        $i$a$-filter-PlanTyper$RexTyper$inferStructLookup$matches$1 = false;
                        if (!binding.isEquivalentTo(entry.getKey())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    matches = (List)destination$iv$iv;
                    switch (matches.size()) {
                        case 0: {
                            v1 = TuplesKt.to((Object)key, (Object)StaticType.MISSING);
                            break;
                        }
                        case 1: {
                            it = (StructType.Field)CollectionsKt.first((List)matches);
                            $i$a$-let-PlanTyper$RexTyper$inferStructLookup$3 = false;
                            v1 = TuplesKt.to((Object)this.sensitive(it.getKey()), (Object)it.getValue());
                            break;
                        }
                        default: {
                            firstKey = ((StructType.Field)CollectionsKt.first((List)matches)).getKey();
                            $this$all$iv = matches;
                            $i$f$all = false;
                            if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) ** GOTO lbl58
                            v3 = true;
                            ** GOTO lbl65
lbl58:
                            // 2 sources

                            for (E element$iv : $this$all$iv) {
                                it = (StructType.Field)element$iv;
                                $i$a$-all-PlanTyper$RexTyper$inferStructLookup$sharedKey$1 = false;
                                if (Intrinsics.areEqual((Object)it.getKey(), (Object)firstKey)) continue;
                                v3 = false;
                                ** GOTO lbl65
                            }
                            v3 = $i$a$-let-PlanTyper$RexTyper$inferStructLookup$3 = true;
lbl65:
                            // 3 sources

                            if ($i$a$-let-PlanTyper$RexTyper$inferStructLookup$3) {
                                v4 = this.sensitive(firstKey);
                            } else if (!$i$a$-let-PlanTyper$RexTyper$inferStructLookup$3) {
                                v4 = key;
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            sharedKey = v4;
                            $i$a$-let-PlanTyper$RexTyper$inferStructLookup$3 = matches;
                            var21_34 = StaticType.Companion;
                            var20_35 = sharedKey;
                            $i$f$map = false;
                            $i$f$all = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                var18_36 = (StructType.Field)item$iv$iv;
                                var22_38 = destination$iv$iv;
                                $i$a$-map-PlanTyper$RexTyper$inferStructLookup$4 = false;
                                var22_38.add(it.getValue());
                            }
                            var22_38 = (List)destination$iv$iv;
                            v1 = TuplesKt.to((Object)var20_35, (Object)StaticType.Companion.unionOf$default((StaticType.Companion)var21_34, (Set)CollectionsKt.toSet((Iterable)var22_38), null, (int)2, null).flatten());
                            break;
                        }
                    }
                    break block17;
                }
                v1 = TuplesKt.to((Object)key, (Object)StaticType.ANY);
            }
            var6_39 = v1;
            name = (Identifier.Symbol)var6_39.component1();
            type = (StaticType)var6_39.component2();
            return TuplesKt.to((Object)type, (Object)name);
        }

        private final Identifier.Symbol sensitive(String str) {
            return Plan.identifierSymbol(str, Identifier.CaseSensitivity.SENSITIVE);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<Rel.Op.Aggregate.Call, StaticType> resolveAgg(@NotNull Agg.Unresolved agg, @NotNull List<Rex> arguments) {
            StaticType type2;
            List newArgs;
            Agg.Resolved newAgg;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)agg, (String)"agg");
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            Iterable $this$map$iv = arguments;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Rex rex2 = (Rex)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Rex arg = this.visitRex((Rex)it, it.type);
                collection.add(arg);
            }
            List args = (List)destination$iv$iv;
            FnMatch<FunctionSignature.Aggregation> match = PlanTyper.this.env.resolveAgg$partiql_planner(agg, args);
            if (match instanceof FnMatch.Ok) {
                newAgg = Plan.aggResolved((FunctionSignature.Aggregation)((FnMatch.Ok)match).getSignature());
                newArgs = PlanTyper.this.rewriteFnArgs(((FnMatch.Ok)match).getMapping(), args);
                PartiQLValueType returns = newAgg.signature.returns;
                StaticType staticType = type2 = newAgg.signature.isNullable ? TypeUtilsKt.toStaticType(returns) : TypeUtilsKt.toNonNullStaticType(returns);
                if (((FnMatch.Ok)match).isMissable()) {
                    StaticType[] staticTypeArray = new StaticType[]{type2, (StaticType)StaticType.MISSING};
                    type2 = StaticType.Companion.unionOf$default((StaticType.Companion)StaticType.Companion, (StaticType[])staticTypeArray, null, (int)2, null).flatten();
                }
            } else {
                if (match instanceof FnMatch.Dynamic) {
                    String string = "Dynamic aggregates not yet supported.";
                    throw new NotImplementedError("An operation is not implemented: " + string);
                }
                if (match instanceof FnMatch.Error) {
                    PlanTyper.this.handleUnknownFunction((FnMatch.Error)match);
                    return TuplesKt.to((Object)Plan.relOpAggregateCall(agg, CollectionsKt.listOf((Object)PlanTyper.this.rexErr("MISSING"))), (Object)MissingType.INSTANCE);
                }
                throw new NoWhenBranchMatchedException();
            }
            return TuplesKt.to((Object)Plan.relOpAggregateCall(newAgg, newArgs), (Object)type2);
        }

        public static final /* synthetic */ StaticType access$calculateTupleUnionOutputType(RexTyper $this, List args) {
            return $this.calculateTupleUnionOutputType(args);
        }

        public static final /* synthetic */ Sequence access$buildArgumentPermutations(RexTyper $this, List args, List accumulator) {
            return $this.buildArgumentPermutations(args, accumulator);
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;

            static {
                int[] nArray = new int[Rex.Op.Var.Scope.values().length];
                nArray[Rex.Op.Var.Scope.DEFAULT.ordinal()] = 1;
                nArray[Rex.Op.Var.Scope.LOCAL.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[Identifier.CaseSensitivity.values().length];
                nArray[Identifier.CaseSensitivity.INSENSITIVE.ordinal()] = 1;
                nArray[Identifier.CaseSensitivity.SENSITIVE.ordinal()] = 2;
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[Rex.Op.Subquery.Coercion.values().length];
                nArray[Rex.Op.Subquery.Coercion.SCALAR.ordinal()] = 1;
                nArray[Rex.Op.Subquery.Coercion.ROW.ordinal()] = 2;
                $EnumSwitchMapping$2 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Identifier.CaseSensitivity.values().length];
            nArray[Identifier.CaseSensitivity.SENSITIVE.ordinal()] = 1;
            nArray[Identifier.CaseSensitivity.INSENSITIVE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

