/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.planner.internal.typer;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.planner.internal.ir.Plan;
import org.partiql.planner.internal.ir.Rel;
import org.partiql.planner.internal.ir.Rex;
import org.partiql.planner.internal.typer.TypeEnv;
import org.partiql.spi.BindingCase;
import org.partiql.spi.BindingName;
import org.partiql.spi.BindingPath;
import org.partiql.types.AnyOfType;
import org.partiql.types.AnyType;
import org.partiql.types.StaticType;
import org.partiql.types.StructType;
import org.partiql.types.TupleConstraint;
import org.partiql.value.PartiQL;
import org.partiql.value.PartiQLValue;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001b\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010\u0018\u001a\u00020\t*\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lorg/partiql/planner/internal/typer/TypeEnv;", "", "schema", "", "Lorg/partiql/planner/internal/ir/Rel$Binding;", "(Ljava/util/List;)V", "getSchema", "()Ljava/util/List;", "matchRoot", "Lorg/partiql/planner/internal/ir/Rex;", "name", "Lorg/partiql/spi/BindingName;", "matchStruct", "resolve", "path", "Lorg/partiql/spi/BindingPath;", "toString", "", "containsKey", "", "Lorg/partiql/types/StaticType;", "(Lorg/partiql/types/StaticType;Lorg/partiql/spi/BindingName;)Ljava/lang/Boolean;", "Lorg/partiql/types/StructType;", "(Lorg/partiql/types/StructType;Lorg/partiql/spi/BindingName;)Ljava/lang/Boolean;", "toPath", "steps", "partiql-planner"})
public final class TypeEnv {
    @NotNull
    private final List<Rel.Binding> schema;

    public TypeEnv(@NotNull List<Rel.Binding> schema) {
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        this.schema = schema;
    }

    @NotNull
    public final List<Rel.Binding> getSchema() {
        return this.schema;
    }

    @Nullable
    public final Rex resolve(@NotNull BindingPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        BindingName head = (BindingName)path.getSteps().get(0);
        List tail = CollectionsKt.drop((Iterable)path.getSteps(), (int)1);
        Rex r = this.matchRoot(head);
        if (r == null) {
            Rex rex2 = this.matchStruct(head);
            if (rex2 == null) {
                return null;
            }
            r = rex2;
            tail = path.getSteps();
        }
        return tail.isEmpty() ? r : this.toPath(r, tail);
    }

    @NotNull
    public String toString() {
        return "< " + CollectionsKt.joinToString$default((Iterable)this.schema, null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null) + " >";
    }

    private final Rex matchRoot(BindingName name) {
        Rex r = null;
        int n = this.schema.size();
        for (int i = 0; i < n; ++i) {
            Rel.Binding local = this.schema.get(i);
            StaticType type2 = local.type;
            if (!name.isEquivalentTo(local.name)) continue;
            if (r != null) {
                return null;
            }
            r = Plan.rex(type2, Plan.rexOpVarResolved(i));
        }
        return r;
    }

    private final Rex matchStruct(BindingName name) {
        Rex c = null;
        boolean known = false;
        int n = this.schema.size();
        for (int i = 0; i < n; ++i) {
            Rel.Binding local = this.schema.get(i);
            StaticType type2 = local.type;
            Boolean bl = this.containsKey(type2, name);
            if (Intrinsics.areEqual((Object)bl, (Object)true)) {
                if (c != null && known) {
                    return null;
                }
                c = Plan.rex(type2, Plan.rexOpVarResolved(i));
                known = true;
                continue;
            }
            if (bl == null) {
                if (c != null) {
                    if (known) continue;
                    return null;
                }
                c = Plan.rex(type2, Plan.rexOpVarResolved(i));
                known = false;
                continue;
            }
            if (!Intrinsics.areEqual((Object)bl, (Object)false)) continue;
        }
        return c;
    }

    /*
     * WARNING - void declaration
     */
    private final Rex toPath(Rex $this$toPath, List<BindingName> steps) {
        Iterable $this$fold$iv = steps;
        boolean $i$f$fold = false;
        Rex accumulator$iv = $this$toPath;
        for (Object element$iv : $this$fold$iv) {
            Rex.Op.Path path;
            void step;
            BindingName bindingName = (BindingName)element$iv;
            Rex curr = accumulator$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[step.getBindingCase().ordinal()]) {
                case 1: {
                    path = Plan.rexOpPathKey(curr, Plan.rex((StaticType)StaticType.STRING, Plan.rexOpLit((PartiQLValue)PartiQL.stringValue$default((String)step.getName(), null, (int)2, null))));
                    break;
                }
                case 2: {
                    path = Plan.rexOpPathSymbol(curr, step.getName());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Rex.Op.Path op = path;
            accumulator$iv = Plan.rex((StaticType)StaticType.ANY, op);
        }
        return accumulator$iv;
    }

    private final Boolean containsKey(StructType $this$containsKey, BindingName name) {
        for (StructType.Field f : $this$containsKey.getFields()) {
            if (!name.isEquivalentTo(f.getKey())) continue;
            return true;
        }
        boolean closed = $this$containsKey.getConstraints().contains(new TupleConstraint.Open(false));
        return closed ? Boolean.valueOf(false) : null;
    }

    private final Boolean containsKey(StaticType $this$containsKey, BindingName name) {
        Boolean bl;
        StaticType type2 = $this$containsKey.flatten();
        if (type2 instanceof StructType) {
            bl = this.containsKey((StructType)type2, name);
        } else if (type2 instanceof AnyOfType) {
            boolean anyKnownToContainKey = false;
            boolean anyKnownToNotContainKey = false;
            boolean anyNotKnownToContainKey = false;
            for (StaticType t : type2.getAllTypes()) {
                Boolean containsKey = this.containsKey(t, name);
                anyKnownToContainKey = anyKnownToContainKey || Intrinsics.areEqual((Object)containsKey, (Object)true);
                anyKnownToNotContainKey = anyKnownToNotContainKey || Intrinsics.areEqual((Object)containsKey, (Object)false);
                anyNotKnownToContainKey = anyNotKnownToContainKey || containsKey == null;
            }
            bl = !anyKnownToNotContainKey && !anyNotKnownToContainKey ? Boolean.valueOf(true) : (!anyKnownToContainKey && !anyNotKnownToContainKey ? Boolean.valueOf(false) : null);
        } else {
            bl = type2 instanceof AnyType ? null : Boolean.valueOf(false);
        }
        return bl;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BindingCase.values().length];
            nArray[BindingCase.SENSITIVE.ordinal()] = 1;
            nArray[BindingCase.INSENSITIVE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

