/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.planner.internal;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.plan.Action;
import org.partiql.plan.Operators;
import org.partiql.plan.Plan;
import org.partiql.plan.rex.Rex;
import org.partiql.planner.PartiQLPlanner;
import org.partiql.planner.PartiQLPlannerPass;
import org.partiql.planner.internal.Env;
import org.partiql.planner.internal.PlannerFlag;
import org.partiql.planner.internal.ir.PartiQLPlan;
import org.partiql.planner.internal.ir.Statement;
import org.partiql.planner.internal.transforms.AstToPlan;
import org.partiql.planner.internal.transforms.NormalizeFromSource;
import org.partiql.planner.internal.transforms.NormalizeGroupBy;
import org.partiql.planner.internal.transforms.PlanTransform;
import org.partiql.planner.internal.typer.PlanTyper;
import org.partiql.spi.Context;
import org.partiql.spi.catalog.Session;
import org.partiql.spi.errors.PError;
import org.partiql.spi.errors.PErrorKind;
import org.partiql.spi.errors.PErrorListener;
import org.partiql.spi.errors.PRuntimeException;
import org.partiql.spi.types.PType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\u0014\u001a\u00020\u0011*\u00020\u0011H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/partiql/planner/internal/SqlPlanner;", "Lorg/partiql/planner/PartiQLPlanner;", "passes", "", "Lorg/partiql/planner/PartiQLPlannerPass;", "flags", "", "Lorg/partiql/planner/internal/PlannerFlag;", "(Ljava/util/List;Ljava/util/Set;)V", "catchAll", "Lorg/partiql/planner/PartiQLPlanner$Result;", "ctx", "Lorg/partiql/spi/Context;", "t", "", "plan", "statement", "Lorg/partiql/ast/Statement;", "session", "Lorg/partiql/spi/catalog/Session;", "normalize", "partiql-planner"})
public final class SqlPlanner
implements PartiQLPlanner {
    @NotNull
    private List<? extends PartiQLPlannerPass> passes;
    @NotNull
    private Set<? extends PlannerFlag> flags;

    public SqlPlanner(@NotNull List<? extends PartiQLPlannerPass> passes, @NotNull Set<? extends PlannerFlag> flags) {
        Intrinsics.checkNotNullParameter(passes, (String)"passes");
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        this.passes = passes;
        this.flags = flags;
    }

    @Override
    @NotNull
    public PartiQLPlanner.Result plan(@NotNull org.partiql.ast.Statement statement, @NotNull Session session, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        try {
            PErrorListener pErrorListener = ctx.getErrorListener();
            Intrinsics.checkNotNullExpressionValue((Object)pErrorListener, (String)"getErrorListener(...)");
            Env env = new Env(session, pErrorListener);
            org.partiql.ast.Statement ast = this.normalize(statement);
            Statement root = AstToPlan.apply(ast, env);
            PlanTyper typer = new PlanTyper(env, ctx);
            Statement typed = typer.resolve(root);
            PartiQLPlan internal = new PartiQLPlan(typed);
            PlanTransform planTransform = new PlanTransform(this.flags);
            PErrorListener pErrorListener2 = ctx.getErrorListener();
            Intrinsics.checkNotNullExpressionValue((Object)pErrorListener2, (String)"getErrorListener(...)");
            Plan plan = planTransform.transform(internal, pErrorListener2);
            for (PartiQLPlannerPass partiQLPlannerPass : this.passes) {
                plan = partiQLPlannerPass.apply(plan, ctx);
            }
            return new PartiQLPlanner.Result(plan);
        }
        catch (PRuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            return this.catchAll(ctx, t);
        }
    }

    private final org.partiql.ast.Statement normalize(org.partiql.ast.Statement $this$normalize) {
        org.partiql.ast.Statement ast = $this$normalize;
        ast = NormalizeFromSource.INSTANCE.apply(ast);
        ast = NormalizeGroupBy.INSTANCE.apply(ast);
        return ast;
    }

    private final PartiQLPlanner.Result catchAll(Context ctx, Throwable t) {
        PError error = PError.INTERNAL_ERROR((PErrorKind)PErrorKind.SEMANTIC(), null, (Throwable)t);
        ctx.getErrorListener().report(error);
        Action.Query query = SqlPlanner::catchAll$lambda$0;
        Plan plan = () -> SqlPlanner.catchAll$lambda$1(query);
        return new PartiQLPlanner.Result(plan);
    }

    @Override
    @NotNull
    public PartiQLPlanner.Result plan(@NotNull org.partiql.ast.Statement statement, @NotNull Session session) throws PRuntimeException {
        return PartiQLPlanner.DefaultImpls.plan(this, statement, session);
    }

    private static final Rex catchAll$lambda$0() {
        PType pType = PType.dynamic();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"dynamic(...)");
        return (Rex)Operators.STANDARD.error(pType);
    }

    private static final Action catchAll$lambda$1(Action.Query $query) {
        Intrinsics.checkNotNullParameter((Object)$query, (String)"$query");
        return (Action)$query;
    }
}

