/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.planner.internal.transforms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.Ast;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstRewriter;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.Exclude;
import org.partiql.ast.ExcludePath;
import org.partiql.ast.ExcludeStep;
import org.partiql.ast.From;
import org.partiql.ast.FromExpr;
import org.partiql.ast.FromJoin;
import org.partiql.ast.FromTableRef;
import org.partiql.ast.GroupBy;
import org.partiql.ast.Identifier;
import org.partiql.ast.JoinType;
import org.partiql.ast.Let;
import org.partiql.ast.Literal;
import org.partiql.ast.Nulls;
import org.partiql.ast.Order;
import org.partiql.ast.OrderBy;
import org.partiql.ast.QueryBody;
import org.partiql.ast.Select;
import org.partiql.ast.SelectItem;
import org.partiql.ast.SelectList;
import org.partiql.ast.SelectPivot;
import org.partiql.ast.SelectStar;
import org.partiql.ast.SelectValue;
import org.partiql.ast.SetQuantifier;
import org.partiql.ast.Sort;
import org.partiql.ast.With;
import org.partiql.ast.WithListElement;
import org.partiql.ast.expr.Expr;
import org.partiql.ast.expr.ExprCall;
import org.partiql.ast.expr.ExprQuerySet;
import org.partiql.ast.expr.ExprVarRef;
import org.partiql.planner.internal.Env;
import org.partiql.planner.internal.PErrors;
import org.partiql.planner.internal.ir.Plan;
import org.partiql.planner.internal.ir.Rel;
import org.partiql.planner.internal.ir.Rex;
import org.partiql.planner.internal.transforms.AstToPlan;
import org.partiql.planner.internal.transforms.NormalizeSelect;
import org.partiql.planner.internal.transforms.RexConverter;
import org.partiql.planner.internal.transforms.SubstitutionVisitor;
import org.partiql.planner.internal.typer.CompilerType;
import org.partiql.planner.internal.util.BinderUtils;
import org.partiql.spi.types.PType;
import org.partiql.spi.value.Datum;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001a\u001a\u00020\u0010*\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lorg/partiql/planner/internal/transforms/RelConverter;", "", "()V", "ANY", "Lorg/partiql/planner/internal/typer/CompilerType;", "BAG", "BOOL", "INT", "LIST", "STRING", "STRUCT", "nil", "Lorg/partiql/planner/internal/ir/Rel;", "getNil$partiql_planner", "()Lorg/partiql/planner/internal/ir/Rel;", "apply", "Lorg/partiql/planner/internal/ir/Rex;", "qSet", "Lorg/partiql/ast/expr/ExprQuerySet;", "env", "Lorg/partiql/planner/internal/Env;", "apply$partiql_planner", "syntheticAgg", "", "i", "", "toRex", "Lorg/partiql/ast/expr/Expr;", "AggregationTransform", "ToRel", "partiql-planner"})
@SourceDebugExtension(value={"SMAP\nRelConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelConverter.kt\norg/partiql/planner/internal/transforms/RelConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,791:1\n1549#2:792\n1620#2,3:793\n*S KotlinDebug\n*F\n+ 1 RelConverter.kt\norg/partiql/planner/internal/transforms/RelConverter\n*L\n124#1:792\n124#1:793,3\n*E\n"})
public final class RelConverter {
    @NotNull
    public static final RelConverter INSTANCE = new RelConverter();
    @NotNull
    private static final Rel nil = Plan.rel(Plan.relType(CollectionsKt.emptyList(), SetsKt.emptySet()), Plan.relOpErr("nil"));
    @NotNull
    private static final CompilerType ANY;
    @NotNull
    private static final CompilerType BOOL;
    @NotNull
    private static final CompilerType STRING;
    @NotNull
    private static final CompilerType STRUCT;
    @NotNull
    private static final CompilerType BAG;
    @NotNull
    private static final CompilerType LIST;
    @NotNull
    private static final CompilerType INT;

    private RelConverter() {
    }

    @NotNull
    public final Rel getNil$partiql_planner() {
        return nil;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Rex apply$partiql_planner(@NotNull ExprQuerySet qSet, @NotNull Env env) {
        Rex rex2;
        Rel rel2;
        Intrinsics.checkNotNullParameter((Object)qSet, (String)"qSet");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        ExprQuerySet newQSet = NormalizeSelect.INSTANCE.normalize$partiql_planner(qSet);
        QueryBody queryBody = newQSet.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)queryBody, (String)"getBody(...)");
        QueryBody body = queryBody;
        if (body instanceof QueryBody.SFW) {
            CompilerType type2;
            rel2 = (Rel)newQSet.accept((AstVisitor)new ToRel(env), (Object)nil);
            Select select = ((QueryBody.SFW)body).getSelect();
            Intrinsics.checkNotNullExpressionValue((Object)select, (String)"getSelect(...)");
            Select projection = select;
            if (projection instanceof SelectPivot) {
                Expr expr = ((SelectPivot)projection).getKey();
                Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getKey(...)");
                Rex key = this.toRex(expr, env);
                Expr expr2 = ((SelectPivot)projection).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)expr2, (String)"getValue(...)");
                Rex value = this.toRex(expr2, env);
                type2 = STRUCT;
                Intrinsics.checkNotNull((Object)rel2);
                Rex.Op.Pivot op = Plan.rexOpPivot(key, value, rel2);
                rex2 = Plan.rex(type2, op);
                return rex2;
            }
            if (projection instanceof SelectValue) {
                boolean key;
                boolean bl = key = rel2.type.schema.size() == 1;
                if (_Assertions.ENABLED && !key) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    boolean bl22 = false;
                    Iterable type2 = rel2.type.schema;
                    StringBuilder stringBuilder = new StringBuilder().append("Expected SELECT VALUE's input to have a single binding. However, it contained: ");
                    boolean $i$f$map = false;
                    void var13_17 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator = $this$mapTo$iv$iv.iterator();
                    while (true) {
                        void it;
                        if (!iterator.hasNext()) {
                            String bl22 = stringBuilder.append((List)destination$iv$iv).append('.').toString();
                            throw new AssertionError((Object)bl22);
                        }
                        Object item$iv$iv = iterator.next();
                        Rel.Binding binding = (Rel.Binding)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(it.name);
                    }
                }
                Rex constructor = Plan.rex(ANY, Plan.rexOpVarLocal(0, 0));
                Intrinsics.checkNotNull((Object)rel2);
                Rex.Op.Select op = Plan.rexOpSelect(constructor, rel2);
                type2 = rel2.type.props.contains((Object)Rel.Prop.ORDERED) ? LIST : BAG;
                rex2 = Plan.rex(type2, op);
                return rex2;
            } else {
                if (projection instanceof SelectStar) {
                    throw new IllegalArgumentException("AST not normalized");
                }
                if (!(projection instanceof SelectList)) throw new IllegalStateException(("Unexpected Select type: " + projection).toString());
                throw new IllegalArgumentException("AST not normalized");
            }
        }
        if (!(body instanceof QueryBody.SetOp)) {
            throw new IllegalStateException(("Unexpected QueryBody type: " + newQSet.getBody()).toString());
        }
        rel2 = (Rel)newQSet.accept((AstVisitor)new ToRel(env), (Object)nil);
        Rex constructor = Plan.rex(ANY, Plan.rexOpVarLocal(0, 0));
        Intrinsics.checkNotNull((Object)rel2);
        Rex.Op.Select op = Plan.rexOpSelect(constructor, rel2);
        CompilerType type = rel2.type.props.contains((Object)Rel.Prop.ORDERED) ? LIST : BAG;
        rex2 = Plan.rex(type, op);
        return rex2;
    }

    private final Rex toRex(Expr $this$toRex, Env env) {
        return RexConverter.INSTANCE.apply$partiql_planner($this$toRex, env);
    }

    private final String syntheticAgg(int i) {
        return "$agg_" + i;
    }

    static {
        PType pType = PType.dynamic();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"dynamic(...)");
        ANY = new CompilerType(pType, false, false, 6, null);
        PType pType2 = PType.bool();
        Intrinsics.checkNotNullExpressionValue((Object)pType2, (String)"bool(...)");
        BOOL = new CompilerType(pType2, false, false, 6, null);
        PType pType3 = PType.string();
        Intrinsics.checkNotNullExpressionValue((Object)pType3, (String)"string(...)");
        STRING = new CompilerType(pType3, false, false, 6, null);
        PType pType4 = PType.struct();
        Intrinsics.checkNotNullExpressionValue((Object)pType4, (String)"struct(...)");
        STRUCT = new CompilerType(pType4, false, false, 6, null);
        PType pType5 = PType.bag();
        Intrinsics.checkNotNullExpressionValue((Object)pType5, (String)"bag(...)");
        BAG = new CompilerType(pType5, false, false, 6, null);
        PType pType6 = PType.array();
        Intrinsics.checkNotNullExpressionValue((Object)pType6, (String)"array(...)");
        LIST = new CompilerType(pType6, false, false, 6, null);
        PType pType7 = PType.numeric((int)38, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)pType7, (String)"numeric(...)");
        INT = new CompilerType(pType7, false, false, 6, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t2\u0006\u0010\r\u001a\u00020\nJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0006H\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u00a8\u0006\u001b"}, d2={"Lorg/partiql/planner/internal/transforms/RelConverter$AggregationTransform;", "Lorg/partiql/ast/AstRewriter;", "Lorg/partiql/planner/internal/transforms/RelConverter$AggregationTransform$Context;", "()V", "aggregates", "", "", "getAggregates$annotations", "apply", "Lkotlin/Pair;", "Lorg/partiql/ast/QueryBody$SFW;", "", "Lorg/partiql/ast/expr/ExprCall;", "node", "defaultReturn", "Lorg/partiql/ast/AstNode;", "context", "visitExprCall", "Lorg/partiql/ast/expr/Expr;", "ctx", "visitQueryBodySFW", "visitSelectValue", "Lorg/partiql/ast/SelectValue;", "isAggregateCall", "", "Lorg/partiql/ast/Identifier;", "Context", "partiql-planner"})
    @SourceDebugExtension(value={"SMAP\nRelConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelConverter.kt\norg/partiql/planner/internal/transforms/RelConverter$AggregationTransform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,791:1\n1179#2,2:792\n1253#2,4:794\n*S KotlinDebug\n*F\n+ 1 RelConverter.kt\norg/partiql/planner/internal/transforms/RelConverter$AggregationTransform\n*L\n751#1:792,2\n751#1:794,4\n*E\n"})
    private static final class AggregationTransform
    extends AstRewriter<Context> {
        @NotNull
        public static final AggregationTransform INSTANCE = new AggregationTransform();
        @NotNull
        private static final Set<String> aggregates;

        private AggregationTransform() {
        }

        @JvmStatic
        private static /* synthetic */ void getAggregates$annotations() {
        }

        @NotNull
        public final Pair<QueryBody.SFW, List<ExprCall>> apply(@NotNull QueryBody.SFW node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            List aggs = new ArrayList();
            GroupBy groupBy = node.getGroupBy();
            List list = groupBy != null ? groupBy.getKeys() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List keys = list;
            Context context = new Context(aggs, keys);
            AstNode astNode = super.visitQueryBodySFW(node, (Object)context);
            Intrinsics.checkNotNull((Object)astNode, (String)"null cannot be cast to non-null type org.partiql.ast.QueryBody.SFW");
            QueryBody.SFW select = (QueryBody.SFW)astNode;
            return new Pair((Object)select, (Object)aggs);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public AstNode visitSelectValue(@NotNull SelectValue node, @NotNull Context ctx) {
            void $this$associateTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            AstNode visited = super.visitSelectValue(node, (Object)ctx);
            Iterable $this$associate$iv = ctx.getKeys();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                GroupBy.Key it = (GroupBy.Key)element$iv$iv;
                boolean bl = false;
                Expr expr = it.getExpr();
                Identifier.Simple simple = it.getAsAlias();
                Intrinsics.checkNotNull((Object)simple);
                Identifier identifier = Identifier.regular((String)simple.getText());
                Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"regular(...)");
                Pair pair = TuplesKt.to((Object)expr, (Object)Ast.exprVarRef((Identifier)identifier, (boolean)false));
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map substitutions = destination$iv$iv;
            Object object = SubstitutionVisitor.INSTANCE.visit(visited, substitutions);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"visit(...)");
            return (AstNode)object;
        }

        @NotNull
        public AstNode visitQueryBodySFW(@NotNull QueryBody.SFW node, @NotNull Context ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return (AstNode)node;
        }

        @NotNull
        public Expr visitExprCall(@NotNull ExprCall node, @NotNull Context ctx) {
            Expr expr;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Identifier identifier = node.getFunction();
            Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"getFunction(...)");
            if (this.isAggregateCall(identifier)) {
                Identifier identifier2 = Identifier.delimited((String)INSTANCE.syntheticAgg(ctx.getAggregations().size()));
                Intrinsics.checkNotNullExpressionValue((Object)identifier2, (String)"delimited(...)");
                Identifier id = identifier2;
                ((Collection)ctx.getAggregations()).add(node);
                expr = (Expr)Ast.exprVarRef((Identifier)id, (boolean)false);
            } else {
                expr = (Expr)node;
            }
            return expr;
        }

        private final boolean isAggregateCall(String $this$isAggregateCall) {
            return aggregates.contains($this$isAggregateCall);
        }

        private final boolean isAggregateCall(Identifier $this$isAggregateCall) {
            String string = $this$isAggregateCall.getIdentifier().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return this.isAggregateCall(string2);
        }

        @NotNull
        public AstNode defaultReturn(@NotNull AstNode node, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return node;
        }

        static {
            Object[] objectArray = new String[]{"count", "avg", "sum", "min", "max", "any", "some", "every"};
            aggregates = SetsKt.setOf((Object[])objectArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/partiql/planner/internal/transforms/RelConverter$AggregationTransform$Context;", "", "aggregations", "", "Lorg/partiql/ast/expr/ExprCall;", "keys", "", "Lorg/partiql/ast/GroupBy$Key;", "(Ljava/util/List;Ljava/util/List;)V", "getAggregations", "()Ljava/util/List;", "getKeys", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "partiql-planner"})
        private static final class Context {
            @NotNull
            private final List<ExprCall> aggregations;
            @NotNull
            private final List<GroupBy.Key> keys;

            public Context(@NotNull List<ExprCall> aggregations, @NotNull List<? extends GroupBy.Key> keys) {
                Intrinsics.checkNotNullParameter(aggregations, (String)"aggregations");
                Intrinsics.checkNotNullParameter(keys, (String)"keys");
                this.aggregations = aggregations;
                this.keys = keys;
            }

            @NotNull
            public final List<ExprCall> getAggregations() {
                return this.aggregations;
            }

            @NotNull
            public final List<GroupBy.Key> getKeys() {
                return this.keys;
            }

            @NotNull
            public final List<ExprCall> component1() {
                return this.aggregations;
            }

            @NotNull
            public final List<GroupBy.Key> component2() {
                return this.keys;
            }

            @NotNull
            public final Context copy(@NotNull List<ExprCall> aggregations, @NotNull List<? extends GroupBy.Key> keys) {
                Intrinsics.checkNotNullParameter(aggregations, (String)"aggregations");
                Intrinsics.checkNotNullParameter(keys, (String)"keys");
                return new Context(aggregations, keys);
            }

            public static /* synthetic */ Context copy$default(Context context, List list, List list2, int n, Object object) {
                if ((n & 1) != 0) {
                    list = context.aggregations;
                }
                if ((n & 2) != 0) {
                    list2 = context.keys;
                }
                return context.copy(list, list2);
            }

            @NotNull
            public String toString() {
                return "Context(aggregations=" + this.aggregations + ", keys=" + this.keys + ')';
            }

            public int hashCode() {
                int result = ((Object)this.aggregations).hashCode();
                result = result * 31 + ((Object)this.keys).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Context)) {
                    return false;
                }
                Context context = (Context)other;
                if (!Intrinsics.areEqual(this.aggregations, context.aggregations)) {
                    return false;
                }
                return Intrinsics.areEqual(this.keys, context.keys);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J.\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u001c\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010\u001d\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010\u001f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J \u0010$\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u0017H\u0002J\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00072\u0006\u0010'\u001a\u00020(H\u0002J\u001c\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00072\u0006\u0010'\u001a\u00020*H\u0002J\u001c\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00072\u0006\u0010'\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020/H\u0002J \u00100\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u0017H\u0002J\u001a\u00103\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u00104\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u0018\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u0002092\u0006\u0010\t\u001a\u00020\u0002H\u0016J\"\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;2\u0012\u0010=\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020>0;0;H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020>H\u0002J\u0018\u0010B\u001a\u00020\u00022\u0006\u00108\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0002H\u0016J\u0018\u0010E\u001a\u00020\u00022\u0006\u00108\u001a\u00020F2\u0006\u0010D\u001a\u00020\u0002H\u0016J\u0018\u0010G\u001a\u00020\u00022\u0006\u00108\u001a\u00020H2\u0006\u0010I\u001a\u00020\u0002H\u0016J\u0018\u0010J\u001a\u00020\u00022\u0006\u00108\u001a\u00020K2\u0006\u0010I\u001a\u00020\u0002H\u0016J\u0010\u0010L\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010M\u001a\u00020\u00022\u0006\u00108\u001a\u00020N2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010O\u001a\u00020\u00022\u0006\u00108\u001a\u00020P2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001a\u0010Q\u001a\u00020\u00022\b\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010\t\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lorg/partiql/planner/internal/transforms/RelConverter$ToRel;", "Lorg/partiql/ast/AstVisitor;", "Lorg/partiql/planner/internal/ir/Rel;", "env", "Lorg/partiql/planner/internal/Env;", "(Lorg/partiql/planner/internal/Env;)V", "convertAgg", "Lkotlin/Pair;", "Lorg/partiql/ast/QueryBody$SFW;", "input", "select", "groupBy", "Lorg/partiql/ast/GroupBy;", "convertExclude", "exclude", "Lorg/partiql/ast/Exclude;", "convertHaving", "expr", "Lorg/partiql/ast/expr/Expr;", "convertLet", "let", "Lorg/partiql/ast/Let;", "convertLetBinding", "Lorg/partiql/planner/internal/ir/Rel$Binding;", "Lorg/partiql/planner/internal/ir/Rex;", "binding", "Lorg/partiql/ast/Let$Binding;", "convertLimit", "limit", "convertOffset", "offset", "convertOrderBy", "orderBy", "Lorg/partiql/ast/OrderBy;", "convertScan", "rex", "convertScanIndexed", "index", "convertSelectItem", "item", "Lorg/partiql/ast/SelectItem;", "convertSelectItemExpr", "Lorg/partiql/ast/SelectItem$Expr;", "convertSelectItemStar", "Lorg/partiql/ast/SelectItem$Star;", "convertSetOp", "setExpr", "Lorg/partiql/ast/QueryBody$SetOp;", "convertUnpivot", "k", "v", "convertWhere", "convertWith", "with", "Lorg/partiql/ast/With;", "defaultReturn", "node", "Lorg/partiql/ast/AstNode;", "exclusionsToSteps", "", "Lorg/partiql/planner/internal/ir/Rel$Op$Exclude$Step;", "exclusions", "Lorg/partiql/ast/ExcludeStep;", "stepToExcludeType", "Lorg/partiql/planner/internal/ir/Rel$Op$Exclude$Type;", "step", "visitExprQuerySet", "Lorg/partiql/ast/expr/ExprQuerySet;", "ctx", "visitFrom", "Lorg/partiql/ast/From;", "visitFromExpr", "Lorg/partiql/ast/FromExpr;", "nil", "visitFromJoin", "Lorg/partiql/ast/FromJoin;", "visitIfQuerySet", "visitSelectList", "Lorg/partiql/ast/SelectList;", "visitSelectValue", "Lorg/partiql/ast/SelectValue;", "visitSetQuantifier", "setQuantifier", "Lorg/partiql/ast/SetQuantifier;", "partiql-planner"})
    @SourceDebugExtension(value={"SMAP\nRelConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelConverter.kt\norg/partiql/planner/internal/transforms/RelConverter$ToRel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,791:1\n1855#2,2:792\n1549#2:794\n1620#2,3:795\n1789#2,3:798\n1559#2:802\n1590#2,3:803\n1549#2:806\n1620#2,3:807\n1593#2:810\n1559#2:811\n1590#2,4:812\n1549#2:816\n1620#2,3:817\n1549#2:820\n1620#2,3:821\n1855#2,2:824\n1549#2:826\n1620#2,3:827\n1490#2:830\n1520#2,3:831\n1523#2,3:841\n1747#2,3:848\n1490#2:851\n1520#2,3:852\n1523#2,3:862\n1#3:801\n372#4,7:834\n372#4,7:855\n125#5:844\n152#5,3:845\n125#5:865\n152#5,3:866\n*S KotlinDebug\n*F\n+ 1 RelConverter.kt\norg/partiql/planner/internal/transforms/RelConverter$ToRel\n*L\n243#1:792,2\n264#1:794\n264#1:795,3\n265#1:798,3\n434#1:802\n434#1:803,3\n440#1:806\n440#1:807,3\n434#1:810\n469#1:811\n469#1:812,4\n481#1:816\n481#1:817,3\n562#1:820\n562#1:821,3\n608#1:824,2\n642#1:826\n642#1:827,3\n659#1:830\n659#1:831,3\n659#1:841,3\n670#1:848,3\n676#1:851\n676#1:852,3\n676#1:862,3\n659#1:834,7\n676#1:855,7\n660#1:844\n660#1:845,3\n677#1:865\n677#1:866,3\n*E\n"})
    public static final class ToRel
    extends AstVisitor<Rel, Rel> {
        @NotNull
        private final Env env;

        public ToRel(@NotNull Env env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            this.env = env;
        }

        @NotNull
        public Rel defaultReturn(@NotNull AstNode node, @NotNull Rel input) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            throw new IllegalArgumentException("unsupported rel " + node);
        }

        @NotNull
        public Rel visitExprQuerySet(@NotNull ExprQuerySet node, @NotNull Rel ctx) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            QueryBody queryBody = node.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)queryBody, (String)"getBody(...)");
            QueryBody body = queryBody;
            OrderBy orderBy = node.getOrderBy();
            Expr limit = node.getLimit();
            Expr offset = node.getOffset();
            With with = node.getWith();
            QueryBody queryBody2 = body;
            if (queryBody2 instanceof QueryBody.SFW) {
                Rel rel2;
                QueryBody sel = body;
                From from = ((QueryBody.SFW)sel).getFrom();
                Intrinsics.checkNotNullExpressionValue((Object)from, (String)"getFrom(...)");
                Rel rel3 = this.visitFrom(from, INSTANCE.getNil$partiql_planner());
                rel3 = this.convertWhere(rel3, ((QueryBody.SFW)sel).getWhere());
                Pair<QueryBody.SFW, Rel> pair = this.convertAgg(rel3, (QueryBody.SFW)sel, ((QueryBody.SFW)sel).getGroupBy());
                QueryBody.SFW _sel = (QueryBody.SFW)pair.component1();
                Rel _rel = (Rel)pair.component2();
                sel = (QueryBody)_sel;
                rel3 = _rel;
                rel3 = this.convertHaving(rel3, ((QueryBody.SFW)sel).getHaving());
                rel3 = this.convertOrderBy(rel3, orderBy);
                rel3 = this.convertOffset(rel3, offset);
                rel3 = this.convertLimit(rel3, limit);
                rel3 = this.convertExclude(rel3, ((QueryBody.SFW)sel).getExclude());
                rel3 = this.convertLet(rel3, ((QueryBody.SFW)sel).getLet());
                Select select = ((QueryBody.SFW)sel).getSelect();
                Intrinsics.checkNotNullExpressionValue((Object)select, (String)"getSelect(...)");
                Select projection = select;
                if (projection instanceof SelectValue) {
                    Rel project = this.visitSelectValue((SelectValue)projection, rel3);
                    rel2 = this.visitSetQuantifier(((SelectValue)projection).getSetq(), project);
                } else {
                    if (projection instanceof SelectStar ? true : projection instanceof SelectList) {
                        throw new IllegalStateException(("AST not normalized, found " + projection.getClass().getSimpleName()).toString());
                    }
                    if (projection instanceof SelectPivot) {
                        rel2 = rel3;
                    } else {
                        throw new IllegalStateException(("Unexpected Select type: " + projection).toString());
                    }
                }
                rel3 = rel2;
                rel3 = this.convertWith(rel3, with);
                return rel3;
            }
            if (queryBody2 instanceof QueryBody.SetOp) {
                Rel rel4 = this.convertSetOp((QueryBody.SetOp)body);
                rel4 = this.convertOrderBy(rel4, orderBy);
                rel4 = this.convertOffset(rel4, offset);
                rel4 = this.convertLimit(rel4, limit);
                rel4 = this.convertWith(rel4, node.getWith());
                return rel4;
            }
            throw new IllegalStateException(("Unexpected QueryBody type: " + body).toString());
        }

        private final Rel visitSetQuantifier(SetQuantifier setQuantifier, Rel input) {
            Rel rel2;
            Integer n;
            SetQuantifier setQuantifier2 = setQuantifier;
            Integer n2 = n = setQuantifier2 != null ? Integer.valueOf(setQuantifier2.code()) : null;
            int n3 = 1;
            if (n2 != null && n2 == n3) {
                rel2 = Plan.rel(input.type, Plan.relOpDistinct(input));
            } else {
                Integer n4 = n;
                if (n4 != null && n4 == 0 ? true : n == null) {
                    rel2 = input;
                } else {
                    throw new IllegalStateException(("Unexpected SetQuantifier type: " + setQuantifier).toString());
                }
            }
            return rel2;
        }

        @NotNull
        public Rel visitSelectList(@NotNull SelectList node, @NotNull Rel input) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            List schema = new ArrayList();
            Set<Rel.Prop> props = input.type.props;
            List projections = new ArrayList();
            List list = node.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SelectItem it = (SelectItem)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Pair<Rel.Binding, Rex> pair = this.convertSelectItem(it);
                Rel.Binding binding = (Rel.Binding)pair.component1();
                Rex projection = (Rex)pair.component2();
                schema.add(binding);
                projections.add(projection);
            }
            Rel.Type type = Plan.relType(schema, props);
            Rel.Op.Project op = Plan.relOpProject(input, projections);
            return Plan.rel(type, op);
        }

        @NotNull
        public Rel visitSelectValue(@NotNull SelectValue node, @NotNull Rel input) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Expr expr = node.getConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getConstructor(...)");
            String string = BinderUtils.INSTANCE.toBinder$partiql_planner(expr, 1).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String name = string;
            Expr expr2 = node.getConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)expr2, (String)"getConstructor(...)");
            Rex rex2 = RexConverter.INSTANCE.apply$partiql_planner(expr2, this.env);
            List schema = CollectionsKt.listOf((Object)Plan.relBinding(name, rex2.type));
            Set<Rel.Prop> props = input.type.props;
            Rel.Type type = Plan.relType(schema, props);
            Rel.Op.Project op = Plan.relOpProject(input, CollectionsKt.listOf((Object)rex2));
            return Plan.rel(type, op);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Rel visitFrom(@NotNull From node, @NotNull Rel ctx) {
            void $this$fold$iv;
            Rel it;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            List list = node.getTableRefs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTableRefs(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FromTableRef fromTableRef = (FromTableRef)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((Rel)this.visitFromTableRef((FromTableRef)it, ctx));
            }
            List tableRefs = (List)destination$iv$iv;
            Iterable $i$f$map22 = CollectionsKt.drop((Iterable)tableRefs, (int)1);
            Object initial$iv = CollectionsKt.first((List)tableRefs);
            boolean $i$f$fold = false;
            Object accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void tRef;
                it = (Rel)element$iv;
                Rel acc = (Rel)accumulator$iv;
                boolean bl = false;
                Rel.Op.Join.Type joinType = Rel.Op.Join.Type.INNER;
                CompilerType compilerType = BOOL;
                Datum datum = Datum.bool((boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"bool(...)");
                Rex condition = Plan.rex(compilerType, Plan.rexOpLit(datum));
                List schema = CollectionsKt.plus((Collection)acc.type.schema, (Iterable)tRef.type.schema);
                Set props = SetsKt.emptySet();
                Rel.Type type = Plan.relType(schema, props);
                Intrinsics.checkNotNull((Object)acc);
                Intrinsics.checkNotNull((Object)tRef);
                Rel.Op.Join op = Plan.relOpJoin(acc, (Rel)tRef, condition, joinType);
                accumulator$iv = Plan.rel(type, op);
            }
            Object object = accumulator$iv;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fold(...)");
            return (Rel)object;
        }

        @NotNull
        public Rel visitFromExpr(@NotNull FromExpr node, @NotNull Rel nil) {
            Rel rel2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)nil, (String)"nil");
            Expr expr = node.getExpr();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getExpr(...)");
            Rex rex2 = RexConverter.INSTANCE.applyRel$partiql_planner(expr, this.env);
            Identifier.Simple a = node.getAsAlias();
            if (a == null) {
                throw new IllegalStateException(("AST not normalized, missing AS alias on " + node).toString());
            }
            String string = a.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Rel.Binding binding = Plan.relBinding(string, rex2.type);
            switch (node.getFromType().code()) {
                case 0: {
                    Identifier.Simple i = node.getAtAlias();
                    if (i == null) {
                        rel2 = this.convertScan(rex2, binding);
                        break;
                    }
                    String string2 = i.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                    Rel.Binding index = Plan.relBinding(string2, INT);
                    rel2 = this.convertScanIndexed(rex2, binding, index);
                    break;
                }
                case 1: {
                    Identifier.Simple at = node.getAtAlias();
                    if (at == null) {
                        throw new IllegalStateException(("AST not normalized, missing AT alias on UNPIVOT " + node).toString());
                    }
                    String string3 = at.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                    Rel.Binding atAlias = Plan.relBinding(string3, STRING);
                    rel2 = this.convertUnpivot(rex2, atAlias, binding);
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unexpected FromType type: " + node.getFromType()).toString());
                }
            }
            return rel2;
        }

        @NotNull
        public Rel visitFromJoin(@NotNull FromJoin node, @NotNull Rel nil) {
            Rel.Op.Join.Type type;
            boolean bl;
            boolean bl2;
            Integer n;
            Object object;
            Set props;
            List schema;
            Rel rhs;
            Rel lhs;
            block24: {
                block23: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)nil, (String)"nil");
                    lhs = (Rel)this.visitFromTableRef(node.getLhs(), nil);
                    rhs = (Rel)this.visitFromTableRef(node.getRhs(), nil);
                    schema = CollectionsKt.plus((Collection)lhs.type.schema, (Iterable)rhs.type.schema);
                    props = SetsKt.emptySet();
                    object = node.getCondition();
                    if (object == null) break block23;
                    Expr it = object;
                    boolean bl3 = false;
                    Rex rex2 = RexConverter.INSTANCE.apply$partiql_planner(it, this.env);
                    object = rex2;
                    if (rex2 != null) break block24;
                }
                CompilerType compilerType = BOOL;
                Datum datum = Datum.bool((boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"bool(...)");
                object = Plan.rex(compilerType, Plan.rexOpLit(datum));
            }
            Object condition = object;
            JoinType joinType = node.getJoinType();
            Integer n2 = n = joinType != null ? Integer.valueOf(joinType.code()) : null;
            int n3 = 2;
            if (n2 != null && n2 == n3) {
                bl2 = true;
            } else {
                Integer n4 = n;
                n3 = 1;
                bl2 = n4 != null && n4 == n3;
            }
            if (bl2) {
                bl = true;
            } else {
                Integer n5 = n;
                n3 = 8;
                bl = n5 != null && n5 == n3;
            }
            if (bl) {
                type = Rel.Op.Join.Type.LEFT;
            } else {
                boolean bl4;
                Integer n6 = n;
                n3 = 4;
                if (n6 != null && n6 == n3) {
                    bl4 = true;
                } else {
                    Integer n7 = n;
                    n3 = 3;
                    bl4 = n7 != null && n7 == n3;
                }
                if (bl4) {
                    type = Rel.Op.Join.Type.RIGHT;
                } else {
                    boolean bl5;
                    Integer n8 = n;
                    n3 = 6;
                    if (n8 != null && n8 == n3) {
                        bl5 = true;
                    } else {
                        Integer n9 = n;
                        n3 = 5;
                        bl5 = n9 != null && n9 == n3;
                    }
                    if (bl5) {
                        type = Rel.Op.Join.Type.FULL;
                    } else {
                        boolean bl6;
                        Integer n10 = n;
                        if (n10 != null && n10 == 0) {
                            bl6 = true;
                        } else {
                            Integer n11 = n;
                            n3 = 7;
                            bl6 = n11 != null && n11 == n3;
                        }
                        if (bl6) {
                            type = Rel.Op.Join.Type.INNER;
                        } else if (n == null) {
                            type = Rel.Op.Join.Type.INNER;
                        } else {
                            throw new IllegalStateException(("Unexpected JoinType type: " + node.getJoinType()).toString());
                        }
                    }
                }
            }
            Rel.Op.Join.Type joinType2 = type;
            Rel.Type type2 = Plan.relType(schema, props);
            Intrinsics.checkNotNull((Object)lhs);
            Intrinsics.checkNotNull((Object)rhs);
            Rel.Op.Join op = Plan.relOpJoin(lhs, rhs, (Rex)condition, joinType2);
            return Plan.rel(type2, op);
        }

        private final Rel convertScan(Rex rex2, Rel.Binding binding) {
            List schema = CollectionsKt.listOf((Object)binding);
            Set props = SetsKt.emptySet();
            Rel.Type type = Plan.relType(schema, props);
            Rel.Op.Scan op = Plan.relOpScan(rex2);
            return Plan.rel(type, op);
        }

        private final Rel convertScanIndexed(Rex rex2, Rel.Binding binding, Rel.Binding index) {
            Object[] objectArray = new Rel.Binding[]{binding, index};
            List schema = CollectionsKt.listOf((Object[])objectArray);
            Set props = SetsKt.emptySet();
            Rel.Type type = Plan.relType(schema, props);
            Rel.Op.ScanIndexed op = Plan.relOpScanIndexed(rex2);
            return Plan.rel(type, op);
        }

        private final Rel convertUnpivot(Rex rex2, Rel.Binding k, Rel.Binding v) {
            Object[] objectArray = new Rel.Binding[]{k, v};
            List schema = CollectionsKt.listOf((Object[])objectArray);
            Set props = SetsKt.emptySet();
            Rel.Type type = Plan.relType(schema, props);
            Rel.Op.Unpivot op = Plan.relOpUnpivot(rex2);
            return Plan.rel(type, op);
        }

        private final Pair<Rel.Binding, Rex> convertSelectItem(SelectItem item) {
            Pair<Rel.Binding, Rex> pair;
            SelectItem selectItem = item;
            if (selectItem instanceof SelectItem.Star) {
                pair = this.convertSelectItemStar((SelectItem.Star)item);
            } else if (selectItem instanceof SelectItem.Expr) {
                pair = this.convertSelectItemExpr((SelectItem.Expr)item);
            } else {
                throw new IllegalStateException(("Unexpected SelectItem type: " + item).toString());
            }
            return pair;
        }

        private final Pair<Rel.Binding, Rex> convertSelectItemStar(SelectItem.Star item) {
            throw new IllegalArgumentException("AST not normalized");
        }

        private final Pair<Rel.Binding, Rex> convertSelectItemExpr(SelectItem.Expr item) {
            Identifier.Simple a = item.getAsAlias();
            if (a == null) {
                throw new IllegalStateException(("AST not normalized, missing AS alias on select item " + item).toString());
            }
            String string = a.getText();
            Intrinsics.checkNotNull((Object)string);
            String name = string;
            Expr expr = item.getExpr();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getExpr(...)");
            Rex rex2 = RexConverter.INSTANCE.apply$partiql_planner(expr, this.env);
            Rel.Binding binding = Plan.relBinding(name, rex2.type);
            return TuplesKt.to((Object)binding, (Object)rex2);
        }

        private final Pair<Rel.Binding, Rex> convertLetBinding(Let.Binding binding) {
            String string = binding.getAsAlias().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String name = string;
            Expr expr = binding.getExpr();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getExpr(...)");
            Rex rex2 = RexConverter.INSTANCE.apply$partiql_planner(expr, this.env);
            Rel.Binding newBinding = Plan.relBinding(name, rex2.type);
            return TuplesKt.to((Object)newBinding, (Object)rex2);
        }

        private final Rel convertWhere(Rel input, Expr expr) {
            if (expr == null) {
                return input;
            }
            Rel.Type type = input.type;
            Rex predicate = INSTANCE.toRex(expr, this.env);
            Rel.Op.Filter op = Plan.relOpFilter(input, predicate);
            return Plan.rel(type, op);
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<QueryBody.SFW, Rel> convertAgg(Rel input, QueryBody.SFW select, GroupBy groupBy) {
            Object groupAs;
            Object setq;
            Collection collection;
            void $this$mapIndexedTo$iv$iv;
            Pair<QueryBody.SFW, List<ExprCall>> pair = AggregationTransform.INSTANCE.apply(select);
            QueryBody.SFW sel = (QueryBody.SFW)pair.component1();
            List aggregations = (List)pair.component2();
            if (aggregations.isEmpty() && groupBy == null) {
                return new Pair((Object)select, (Object)input);
            }
            List schema = new ArrayList();
            Set props = SetsKt.emptySet();
            Rel.Op.Aggregate.Strategy strategy = Rel.Op.Aggregate.Strategy.FULL;
            Iterable $this$mapIndexed$iv = aggregations;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                Rel.Op.Aggregate.Call.Unresolved unresolved;
                String name;
                void $this$mapTo$iv$iv;
                void expr;
                void i;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ExprCall exprCall = (ExprCall)item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv;
                boolean bl = false;
                Rel.Binding binding = Plan.relBinding(INSTANCE.syntheticAgg((int)i), ANY);
                schema.add(binding);
                List list = expr.getArgs();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArgs(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    void arg;
                    Expr expr2 = (Expr)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)arg);
                    collection2.add(INSTANCE.toRex((Expr)arg, this.env));
                }
                List args = (List)destination$iv$iv2;
                Identifier identifier = expr.getFunction();
                Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"getFunction(...)");
                org.partiql.spi.catalog.Identifier id = AstToPlan.INSTANCE.convert(identifier);
                if (id.hasQualifier()) {
                    throw new IllegalStateException("Qualified aggregation calls are not supported.".toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)id.getIdentifier().getText().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                if (Intrinsics.areEqual((Object)name, (Object)"count") && expr.getArgs().isEmpty()) {
                    Literal literal = Literal.intNum((int)1);
                    Intrinsics.checkNotNullExpressionValue((Object)literal, (String)"intNum(...)");
                    unresolved = Plan.relOpAggregateCallUnresolved(name, org.partiql.planner.internal.ir.SetQuantifier.ALL, CollectionsKt.listOf((Object)INSTANCE.toRex((Expr)Ast.exprLit((Literal)literal), this.env)));
                } else {
                    org.partiql.planner.internal.ir.SetQuantifier setQuantifier;
                    SetQuantifier setQuantifier2 = expr.getSetq();
                    Object object = destination$iv$iv2 = setQuantifier2 != null ? Integer.valueOf(setQuantifier2.code()) : null;
                    if (destination$iv$iv2 == null) {
                        setQuantifier = org.partiql.planner.internal.ir.SetQuantifier.ALL;
                    } else if ((Integer)destination$iv$iv2 == 0) {
                        setQuantifier = org.partiql.planner.internal.ir.SetQuantifier.ALL;
                    } else {
                        int n3 = 1;
                        if ((Integer)destination$iv$iv2 == n3) {
                            setQuantifier = org.partiql.planner.internal.ir.SetQuantifier.DISTINCT;
                        } else {
                            throw new IllegalStateException(("Unexpected SetQuantifier type: " + expr.getSetq()).toString());
                        }
                    }
                    setq = setQuantifier;
                    unresolved = Plan.relOpAggregateCallUnresolved(name, (org.partiql.planner.internal.ir.SetQuantifier)((Object)setq), args);
                }
                collection.add(unresolved);
            }
            List calls = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            GroupBy groupBy2 = groupBy;
            if (groupBy2 != null) {
                GroupBy gb = groupBy2;
                boolean bl = false;
                Identifier.Simple simple = gb.getAsAlias();
                if (simple != null) {
                    void $this$mapIndexedTo$iv$iv2;
                    groupAs = simple;
                    boolean bl3 = false;
                    String string = groupAs.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    Rel.Binding binding = Plan.relBinding(string, ANY);
                    schema.add(binding);
                    Iterable $this$mapIndexed$iv2 = input.type.schema;
                    boolean $i$f$mapIndexed2 = false;
                    Iterable iterable3 = $this$mapIndexed$iv2;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
                    boolean $i$f$mapIndexedTo2 = false;
                    int index$iv$iv2 = 0;
                    for (Object item$iv$iv : $this$mapIndexedTo$iv$iv2) {
                        void bindingIndex;
                        void currBinding;
                        int n;
                        if ((n = index$iv$iv2++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        setq = (Rel.Binding)item$iv$iv;
                        int destination$iv$iv2 = n;
                        Collection collection3 = destination$iv$iv3;
                        boolean bl4 = false;
                        CompilerType compilerType = STRING;
                        Datum datum = Datum.string((String)currBinding.name);
                        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"string(...)");
                        collection3.add(Plan.rexOpStructField(Plan.rex(compilerType, Plan.rexOpLit(datum)), Plan.rex(ANY, Plan.rexOpVarLocal(0, (int)bindingIndex))));
                    }
                    List fields = (List)destination$iv$iv3;
                    List arg = CollectionsKt.listOf((Object)Plan.rex(ANY, Plan.rexOpStruct(fields)));
                    calls.add(Plan.relOpAggregateCallUnresolved("group_as", org.partiql.planner.internal.ir.SetQuantifier.ALL, arg));
                }
            }
            List groups = CollectionsKt.emptyList();
            if (groupBy != null) {
                Rel.Op.Aggregate.Strategy strategy2;
                void $this$mapTo$iv$iv;
                List list = groupBy.getKeys();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getKeys(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                groupAs = $this$map$iv;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    GroupBy.Key $this$mapIndexedTo$iv$iv2 = (GroupBy.Key)item$iv$iv;
                    collection = destination$iv$iv4;
                    boolean bl = false;
                    if (it.getAsAlias() == null) {
                        throw new IllegalStateException(("not normalized, group key " + it + " missing unique name").toString());
                    }
                    Identifier.Simple simple = it.getAsAlias();
                    Intrinsics.checkNotNull((Object)simple);
                    String string = simple.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    Rel.Binding binding = Plan.relBinding(string, ANY);
                    schema.add(binding);
                    Expr expr = it.getExpr();
                    Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getExpr(...)");
                    collection.add(INSTANCE.toRex(expr, this.env));
                }
                groups = (List)destination$iv$iv4;
                switch (groupBy.getStrategy().code()) {
                    case 0: {
                        strategy2 = Rel.Op.Aggregate.Strategy.FULL;
                        break;
                    }
                    case 1: {
                        strategy2 = Rel.Op.Aggregate.Strategy.PARTIAL;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(("Unexpected GroupByStrategy type: " + groupBy.getStrategy()).toString());
                    }
                }
                strategy = strategy2;
            }
            Rel.Type type = Plan.relType(schema, props);
            Rel.Op.Aggregate op = Plan.relOpAggregate(input, strategy, calls, groups);
            Rel rel2 = Plan.rel(type, op);
            return new Pair((Object)sel, (Object)rel2);
        }

        private final Rel convertHaving(Rel input, Expr expr) {
            if (expr == null) {
                return input;
            }
            Rel.Type type = input.type;
            Rex predicate = INSTANCE.toRex(expr, this.env);
            Rel.Op.Filter op = Plan.relOpFilter(input, predicate);
            return Plan.rel(type, op);
        }

        private final Rel visitIfQuerySet(Expr expr) {
            if (!(expr instanceof ExprQuerySet)) {
                Rex rex2 = RexConverter.INSTANCE.applyRel$partiql_planner(expr, this.env);
                Rel.Op.Scan op = Plan.relOpScan(rex2);
                Rel.Type type = new Rel.Type(CollectionsKt.listOf((Object)new Rel.Binding("_1", ANY)), SetsKt.emptySet());
                return Plan.rel(type, op);
            }
            Object object = this.visit((AstNode)expr, INSTANCE.getNil$partiql_planner());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"visit(...)");
            return (Rel)object;
        }

        private final Rel convertSetOp(QueryBody.SetOp setExpr) {
            Rel.Op op;
            org.partiql.planner.internal.ir.SetQuantifier setQuantifier;
            Integer n;
            Expr expr = setExpr.getLhs();
            Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getLhs(...)");
            Rel lhs = this.visitIfQuerySet(expr);
            Expr expr2 = setExpr.getRhs();
            Intrinsics.checkNotNullExpressionValue((Object)expr2, (String)"getRhs(...)");
            Rel rhs = this.visitIfQuerySet(expr2);
            Rel.Type type = new Rel.Type(CollectionsKt.listOf((Object)new Rel.Binding("_0", ANY)), SetsKt.emptySet());
            SetQuantifier setQuantifier2 = setExpr.getType().getSetq();
            Integer n2 = n = setQuantifier2 != null ? Integer.valueOf(setQuantifier2.code()) : null;
            if (n2 != null && n2 == 0) {
                setQuantifier = org.partiql.planner.internal.ir.SetQuantifier.ALL;
            } else {
                boolean bl;
                Integer n3 = n;
                if (n3 == null) {
                    bl = true;
                } else {
                    int n4 = 1;
                    bl = n3 == n4;
                }
                if (bl) {
                    setQuantifier = org.partiql.planner.internal.ir.SetQuantifier.DISTINCT;
                } else {
                    throw new IllegalStateException(("Unexpected SetQuantifier type: " + setExpr.getType().getSetq()).toString());
                }
            }
            org.partiql.planner.internal.ir.SetQuantifier quantifier = setQuantifier;
            boolean outer = setExpr.isOuter();
            switch (setExpr.getType().getSetOpType().code()) {
                case 0: {
                    op = new Rel.Op.Union(quantifier, outer, lhs, rhs);
                    break;
                }
                case 2: {
                    op = new Rel.Op.Except(quantifier, outer, lhs, rhs);
                    break;
                }
                case 1: {
                    op = new Rel.Op.Intersect(quantifier, outer, lhs, rhs);
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unexpected SetOpType type: " + setExpr.getType().getSetOpType()).toString());
                }
            }
            Rel.Op op2 = op;
            return Plan.rel(type, op2);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final Rel convertOrderBy(Rel input, OrderBy orderBy) {
            void $this$mapTo$iv$iv;
            if (orderBy == null) {
                return input;
            }
            Rel.Type type = Rel.Type.copy$default(input.type, null, SetsKt.setOf((Object)((Object)Rel.Prop.ORDERED)), 1, null);
            List list = orderBy.getSorts();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSorts(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Rel.Op.Sort.Order order;
                int n;
                Integer n2;
                void it;
                Sort sort = (Sort)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Expr expr = it.getExpr();
                Intrinsics.checkNotNullExpressionValue((Object)expr, (String)"getExpr(...)");
                Rex rex2 = INSTANCE.toRex(expr, this.env);
                Order order2 = it.getOrder();
                Integer n3 = order2 != null ? Integer.valueOf(order2.code()) : null;
                int n4 = 1;
                if (n3 != null && n3 == n4) {
                    Nulls nulls = it.getNulls();
                    Integer n5 = n2 = nulls != null ? Integer.valueOf(nulls.code()) : null;
                    n = 1;
                    if (n5 != null && n5 == n) {
                        order = Rel.Op.Sort.Order.DESC_NULLS_LAST;
                    } else {
                        Integer n6 = n2;
                        if (!(n6 != null && n6 == 0 ? true : n2 == null)) throw new IllegalStateException(("Unexpected Nulls type: " + it.getNulls()).toString());
                        order = Rel.Op.Sort.Order.DESC_NULLS_FIRST;
                    }
                } else {
                    Nulls nulls = it.getNulls();
                    Integer n7 = n2 = nulls != null ? Integer.valueOf(nulls.code()) : null;
                    if (n7 != null && n7 == 0) {
                        order = Rel.Op.Sort.Order.ASC_NULLS_FIRST;
                    } else {
                        Integer n8 = n2;
                        n = 1;
                        if (!(n8 != null && n8 == n ? true : n2 == null)) throw new IllegalStateException(("Unexpected Nulls type: " + it.getNulls()).toString());
                        order = Rel.Op.Sort.Order.ASC_NULLS_LAST;
                    }
                }
                Rel.Op.Sort.Order order3 = order;
                collection.add(Plan.relOpSortSpec(rex2, order3));
            }
            List specs = (List)destination$iv$iv;
            Rel.Op.Sort op = Plan.relOpSort(input, specs);
            return Plan.rel(type, op);
        }

        private final Rel convertLimit(Rel input, Expr limit) {
            if (limit == null) {
                return input;
            }
            Rel.Type type = input.type;
            Rex rex2 = RexConverter.INSTANCE.apply$partiql_planner(limit, this.env);
            Rel.Op.Limit op = Plan.relOpLimit(input, rex2);
            return Plan.rel(type, op);
        }

        private final Rel convertLet(Rel input, Let let) {
            if (let == null) {
                return input;
            }
            List schema = CollectionsKt.toMutableList((Collection)input.type.schema);
            Set<Rel.Prop> props = input.type.props;
            List projections = new ArrayList();
            int n = input.type.schema.size();
            int n2 = 0;
            while (n2 < n) {
                int index = n2++;
                boolean bl = false;
                projections.add(Plan.rex(ANY, Plan.rexOpVarLocal(0, index)));
            }
            List list = let.getBindings();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBindings(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Let.Binding it = (Let.Binding)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Pair<Rel.Binding, Rex> pair = this.convertLetBinding(it);
                Rel.Binding newBinding = (Rel.Binding)pair.component1();
                Rex projection = (Rex)pair.component2();
                schema.add(newBinding);
                projections.add(projection);
            }
            Rel.Type type = Plan.relType(schema, props);
            Rel.Op.Project op = Plan.relOpProject(input, projections);
            return Plan.rel(type, op);
        }

        private final Rel convertOffset(Rel input, Expr offset) {
            if (offset == null) {
                return input;
            }
            Rel.Type type = input.type;
            Rex rex2 = RexConverter.INSTANCE.apply$partiql_planner(offset, this.env);
            Rel.Op.Offset op = Plan.relOpOffset(input, rex2);
            return Plan.rel(type, op);
        }

        /*
         * WARNING - void declaration
         */
        private final Rel convertWith(Rel input, With with) {
            void $this$mapTo$iv$iv;
            if (with == null) {
                return input;
            }
            if (with.isRecursive()) {
                this.env.getListener$partiql_planner().report(PErrors.featureNotSupported$partiql_planner$default(PErrors.INSTANCE, "WITH RECURSIVE", null, 2, null));
            }
            Rel.Type type = input.type;
            List list = with.getElements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getElements(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void element;
                WithListElement withListElement = (WithListElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (element.getColumnList() != null) {
                    this.env.getListener$partiql_planner().report(PErrors.featureNotSupported$partiql_planner$default(PErrors.INSTANCE, "WITH clause column list", null, 2, null));
                }
                ExprQuerySet exprQuerySet = element.getAsQuery();
                Intrinsics.checkNotNullExpressionValue((Object)exprQuerySet, (String)"getAsQuery(...)");
                Rex query = RexConverter.INSTANCE.apply$partiql_planner((Expr)exprQuerySet, this.env);
                String string = element.getQueryName().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                collection.add(Plan.relOpWithWithListElement(string, query));
            }
            List elements = (List)destination$iv$iv;
            Rel.Op.With op = Plan.relOpWith(input, elements);
            return Plan.rel(type, op);
        }

        /*
         * WARNING - void declaration
         */
        private final Rel convertExclude(Rel input, Exclude exclude) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            if (exclude == null) {
                return input;
            }
            Rel.Type type = input.type;
            List list = exclude.getExcludePaths();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExcludePaths(...)");
            Iterable iterable = list;
            boolean $i$f$groupBy = false;
            void var7_6 = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it;
                Object object2;
                ExcludePath it2 = (ExcludePath)element$iv$iv;
                boolean $i$a$-groupBy-RelConverter$ToRel$convertExclude$paths$32 = false;
                ExprVarRef key$iv$iv = it2.getRoot();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                ExcludePath $i$a$-groupBy-RelConverter$ToRel$convertExclude$paths$32 = (ExcludePath)element$iv$iv;
                object = list$iv$iv;
                boolean bl = false;
                object.add(it.getExcludeSteps());
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator<Object> iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = (Map.Entry)iterator.next();
                object = destination$iv$iv;
                boolean bl = false;
                ExprVarRef root = (ExprVarRef)entry.getKey();
                List exclusions = (List)entry.getValue();
                Intrinsics.checkNotNull((Object)root);
                Rex.Op op = ((RelConverter)RelConverter.INSTANCE).toRex((Expr)((Expr)root), (Env)this.env).op;
                Intrinsics.checkNotNull((Object)op, (String)"null cannot be cast to non-null type org.partiql.planner.internal.ir.Rex.Op.Var");
                Rex.Op.Var rootVar = (Rex.Op.Var)op;
                List<Rel.Op.Exclude.Step> steps = this.exclusionsToSteps(exclusions);
                object.add(Plan.relOpExcludePath(rootVar, steps));
            }
            List paths = (List)destination$iv$iv;
            Rel.Op.Exclude op = Plan.relOpExclude(input, paths);
            return Plan.rel(type, op);
        }

        /*
         * WARNING - void declaration
         */
        private final List<Rel.Op.Exclude.Step> exclusionsToSteps(List<? extends List<? extends ExcludeStep>> exclusions) {
            void $this$mapTo$iv$iv;
            Object object;
            Map $this$groupByTo$iv$iv;
            boolean bl;
            block8: {
                Iterable $this$any$iv = exclusions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        List it = (List)element$iv;
                        boolean bl2 = false;
                        if (!it.isEmpty()) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$groupBy$iv = exclusions;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object object2;
                Object element$iv$iv = iterator.next();
                List it2 = (List)element$iv$iv;
                boolean $i$a$-groupBy-RelConverter$ToRel$exclusionsToSteps$42 = false;
                ExcludeStep key$iv$iv = (ExcludeStep)CollectionsKt.first((List)it2);
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                List $i$a$-groupBy-RelConverter$ToRel$exclusionsToSteps$42 = (List)element$iv$iv;
                object = list$iv$iv;
                boolean bl4 = false;
                object.add(CollectionsKt.drop((Iterable)((Iterable)it), (int)1));
            }
            Map $this$map$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = (Map.Entry)iterator.next();
                object = destination$iv$iv;
                boolean bl5 = false;
                ExcludeStep head = (ExcludeStep)entry.getKey();
                List steps = (List)entry.getValue();
                Rel.Op.Exclude.Type type = this.stepToExcludeType(head);
                List<Rel.Op.Exclude.Step> substeps = this.exclusionsToSteps(steps);
                object.add(Plan.relOpExcludeStep(type, substeps));
            }
            return (List)destination$iv$iv;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final Rel.Op.Exclude.Type stepToExcludeType(ExcludeStep step) {
            Rel.Op.Exclude.Type type;
            ExcludeStep excludeStep = step;
            if (excludeStep instanceof ExcludeStep.StructField) {
                boolean bl = ((ExcludeStep.StructField)step).getSymbol().isRegular();
                if (bl) {
                    String string = ((ExcludeStep.StructField)step).getSymbol().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    type = Plan.relOpExcludeTypeStructSymbol(string);
                    return type;
                } else {
                    if (bl) throw new NoWhenBranchMatchedException();
                    String string = ((ExcludeStep.StructField)step).getSymbol().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    type = Plan.relOpExcludeTypeStructKey(string);
                }
                return type;
            } else if (excludeStep instanceof ExcludeStep.CollIndex) {
                type = Plan.relOpExcludeTypeCollIndex(((ExcludeStep.CollIndex)step).getIndex());
                return type;
            } else if (excludeStep instanceof ExcludeStep.StructWildcard) {
                type = Plan.relOpExcludeTypeStructWildcard();
                return type;
            } else {
                if (!(excludeStep instanceof ExcludeStep.CollWildcard)) throw new IllegalStateException(("Unexpected ExcludeStep type: " + step).toString());
                type = Plan.relOpExcludeTypeCollWildcard();
            }
            return type;
        }
    }
}

