/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.planner.internal.util;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.DatetimeField;
import org.partiql.ast.IntervalQualifier;
import org.partiql.spi.value.Datum;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020 H\u0002J\f\u0010!\u001a\u00020\u0004*\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/partiql/planner/internal/util/IntervalUtils;", "", "()V", "DEFAULT_INTERVAL_FRACTIONAL_PRECISION", "", "DEFAULT_INTERVAL_PRECISION", "INTERVAL_DAY_HOUR", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "INTERVAL_DAY_MINUTE", "INTERVAL_DAY_SECOND", "INTERVAL_HOUR_MINUTE", "INTERVAL_HOUR_SECOND", "INTERVAL_MINUTE_SECOND", "INTERVAL_SINGLE", "INTERVAL_YEAR_MONTH", "assertNullFractionalSeconds", "", "fractionalSeconds", "field", "Lorg/partiql/ast/DatetimeField;", "(Ljava/lang/Integer;Lorg/partiql/ast/DatetimeField;)V", "parseInterval", "Lorg/partiql/spi/value/Datum;", "input", "", "qualifier", "Lorg/partiql/ast/IntervalQualifier;", "parseInterval$partiql_planner", "parseIntervalRange", "Lorg/partiql/ast/IntervalQualifier$Range;", "parseIntervalSingle", "Lorg/partiql/ast/IntervalQualifier$Single;", "getNanosFromFractionalSeconds", "partiql-planner"})
public final class IntervalUtils {
    @NotNull
    public static final IntervalUtils INSTANCE = new IntervalUtils();
    private static final int DEFAULT_INTERVAL_PRECISION = 2;
    private static final int DEFAULT_INTERVAL_FRACTIONAL_PRECISION = 6;
    private static final Pattern INTERVAL_SINGLE = Pattern.compile("(?<is1>\\d+)(\\.(?<is2>\\d+))?");
    private static final Pattern INTERVAL_YEAR_MONTH = Pattern.compile("(?<y>\\d+)-(?<m>\\d+)");
    private static final Pattern INTERVAL_DAY_HOUR = Pattern.compile("(?<d>\\d+)\\s+(?<h>\\d+)");
    private static final Pattern INTERVAL_DAY_MINUTE = Pattern.compile("(?<d>\\d+)\\s+(?<h>\\d+):(?<m>\\d+)");
    private static final Pattern INTERVAL_DAY_SECOND = Pattern.compile("(?<d>\\d+)\\s+(?<h>\\d+):(?<m>\\d+):(?<s1>\\d+)(\\.(?<s2>\\d+))?");
    private static final Pattern INTERVAL_HOUR_MINUTE = Pattern.compile("(?<h>\\d+):(?<m>\\d+)");
    private static final Pattern INTERVAL_HOUR_SECOND = Pattern.compile("(?<h>\\d+):(?<m>\\d+):(?<s1>\\d+)(\\.(?<s2>\\d+))?");
    private static final Pattern INTERVAL_MINUTE_SECOND = Pattern.compile("(?<m>\\d+):(?<s1>\\d+)(\\.(?<s2>\\d+))?");

    private IntervalUtils() {
    }

    @NotNull
    public final Datum parseInterval$partiql_planner(@NotNull String input, @NotNull IntervalQualifier qualifier) {
        Datum datum;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)qualifier, (String)"qualifier");
        IntervalQualifier intervalQualifier = qualifier;
        if (intervalQualifier instanceof IntervalQualifier.Single) {
            datum = this.parseIntervalSingle(input, (IntervalQualifier.Single)qualifier);
        } else if (intervalQualifier instanceof IntervalQualifier.Range) {
            datum = this.parseIntervalRange(input, (IntervalQualifier.Range)qualifier);
        } else {
            throw new IllegalStateException(("Unexpected IntervalQualifier JVM class: " + qualifier.getClass().getSimpleName()).toString());
        }
        return datum;
    }

    private final Datum parseIntervalSingle(String input, IntervalQualifier.Single qualifier) {
        Datum datum;
        Matcher matcher = INTERVAL_SINGLE.matcher(input);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            throw new IllegalStateException(("Invalid interval string: '" + input + '\'').toString());
        }
        String string = matcher2.group("is1");
        Intrinsics.checkNotNull((Object)string);
        int integral = Integer.parseInt(string);
        String string2 = matcher2.group("is2");
        Integer fractional = string2 != null ? Integer.valueOf(this.getNanosFromFractionalSeconds(string2)) : null;
        Integer n = qualifier.getPrecision();
        if (n == null) {
            n = 2;
        }
        int precision = ((Number)n).intValue();
        switch (qualifier.getField().code()) {
            case 0: {
                DatetimeField datetimeField = qualifier.getField();
                Intrinsics.checkNotNullExpressionValue((Object)datetimeField, (String)"getField(...)");
                this.assertNullFractionalSeconds(fractional, datetimeField);
                Datum datum2 = Datum.intervalYear((int)integral, (int)precision);
                Intrinsics.checkNotNull((Object)datum2);
                datum = datum2;
                break;
            }
            case 1: {
                DatetimeField datetimeField = qualifier.getField();
                Intrinsics.checkNotNullExpressionValue((Object)datetimeField, (String)"getField(...)");
                this.assertNullFractionalSeconds(fractional, datetimeField);
                Datum datum3 = Datum.intervalMonth((int)integral, (int)precision);
                Intrinsics.checkNotNull((Object)datum3);
                datum = datum3;
                break;
            }
            case 2: {
                DatetimeField datetimeField = qualifier.getField();
                Intrinsics.checkNotNullExpressionValue((Object)datetimeField, (String)"getField(...)");
                this.assertNullFractionalSeconds(fractional, datetimeField);
                Datum datum4 = Datum.intervalDay((int)integral, (int)precision);
                Intrinsics.checkNotNull((Object)datum4);
                datum = datum4;
                break;
            }
            case 3: {
                DatetimeField datetimeField = qualifier.getField();
                Intrinsics.checkNotNullExpressionValue((Object)datetimeField, (String)"getField(...)");
                this.assertNullFractionalSeconds(fractional, datetimeField);
                Datum datum5 = Datum.intervalHour((int)integral, (int)precision);
                Intrinsics.checkNotNull((Object)datum5);
                datum = datum5;
                break;
            }
            case 4: {
                DatetimeField datetimeField = qualifier.getField();
                Intrinsics.checkNotNullExpressionValue((Object)datetimeField, (String)"getField(...)");
                this.assertNullFractionalSeconds(fractional, datetimeField);
                Datum datum6 = Datum.intervalMinute((int)integral, (int)precision);
                Intrinsics.checkNotNull((Object)datum6);
                datum = datum6;
                break;
            }
            case 5: {
                Integer n2 = qualifier.getFractionalPrecision();
                if (n2 == null) {
                    n2 = 6;
                }
                int scale = ((Number)n2).intValue();
                Datum datum7 = fractional == null ? Datum.intervalSecond((int)integral, (int)0, (int)precision, (int)scale) : Datum.intervalSecond((int)integral, (int)fractional, (int)precision, (int)scale);
                Intrinsics.checkNotNull((Object)datum7);
                datum = datum7;
                break;
            }
            default: {
                throw new IllegalStateException(("Could not parse interval string: " + input + " with given qualifier: " + qualifier).toString());
            }
        }
        return datum;
    }

    private final Datum parseIntervalRange(String input, IntervalQualifier.Range qualifier) {
        int start = qualifier.getStartField().code();
        int end = qualifier.getEndField().code();
        Pair pair = TuplesKt.to((Object)start, (Object)end);
        if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)0, (Object)1))) {
            Matcher matcher = INTERVAL_YEAR_MONTH.matcher(input);
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
            Matcher matcher2 = matcher;
            if (!matcher2.matches()) {
                throw new IllegalStateException(("Invalid interval string: '" + input + '\'').toString());
            }
            String string = matcher2.group("y");
            Intrinsics.checkNotNull((Object)string);
            int year = Integer.parseInt(string);
            String string2 = matcher2.group("m");
            Intrinsics.checkNotNull((Object)string2);
            int month = Integer.parseInt(string2);
            Integer n = qualifier.getStartFieldPrecision();
            if (n == null) {
                n = 2;
            }
            int precision = ((Number)n).intValue();
            Datum datum = Datum.intervalYearMonth((int)year, (int)month, (int)precision);
            Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"intervalYearMonth(...)");
            return datum;
        }
        if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)2, (Object)3))) {
            Matcher matcher = INTERVAL_DAY_HOUR.matcher(input);
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
            Matcher matcher3 = matcher;
            if (!matcher3.matches()) {
                throw new IllegalStateException(("Invalid interval string: '" + input + '\'').toString());
            }
            String string = matcher3.group("d");
            Intrinsics.checkNotNull((Object)string);
            int day = Integer.parseInt(string);
            String string3 = matcher3.group("h");
            Intrinsics.checkNotNull((Object)string3);
            int hour = Integer.parseInt(string3);
            Integer n = qualifier.getStartFieldPrecision();
            if (n == null) {
                n = 2;
            }
            int precision = ((Number)n).intValue();
            Datum datum = Datum.intervalDayHour((int)day, (int)hour, (int)precision);
            Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"intervalDayHour(...)");
            return datum;
        }
        if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)2, (Object)4))) {
            Matcher matcher = INTERVAL_DAY_MINUTE.matcher(input);
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
            Matcher matcher4 = matcher;
            if (!matcher4.matches()) {
                throw new IllegalStateException(("Invalid interval string: '" + input + '\'').toString());
            }
            String string = matcher4.group("d");
            Intrinsics.checkNotNull((Object)string);
            int day = Integer.parseInt(string);
            String string4 = matcher4.group("h");
            Intrinsics.checkNotNull((Object)string4);
            int hour = Integer.parseInt(string4);
            String string5 = matcher4.group("m");
            Intrinsics.checkNotNull((Object)string5);
            int minute = Integer.parseInt(string5);
            Integer n = qualifier.getStartFieldPrecision();
            if (n == null) {
                n = 2;
            }
            int precision = ((Number)n).intValue();
            Datum datum = Datum.intervalDayMinute((int)day, (int)hour, (int)minute, (int)precision);
            Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"intervalDayMinute(...)");
            return datum;
        }
        if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)2, (Object)5))) {
            Matcher matcher = INTERVAL_DAY_SECOND.matcher(input);
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
            Matcher matcher5 = matcher;
            if (!matcher5.matches()) {
                throw new IllegalStateException(("Invalid interval string: '" + input + '\'').toString());
            }
            String string = matcher5.group("d");
            Intrinsics.checkNotNull((Object)string);
            int day = Integer.parseInt(string);
            String string6 = matcher5.group("h");
            Intrinsics.checkNotNull((Object)string6);
            int hour = Integer.parseInt(string6);
            String string7 = matcher5.group("m");
            Intrinsics.checkNotNull((Object)string7);
            int minute = Integer.parseInt(string7);
            String string8 = matcher5.group("s1");
            Intrinsics.checkNotNull((Object)string8);
            int second = Integer.parseInt(string8);
            String string9 = matcher5.group("s2");
            int nanos = string9 != null ? this.getNanosFromFractionalSeconds(string9) : 0;
            Integer n = qualifier.getStartFieldPrecision();
            if (n == null) {
                n = 2;
            }
            int precision = ((Number)n).intValue();
            Integer n2 = qualifier.getEndFieldFractionalPrecision();
            if (n2 == null) {
                n2 = 6;
            }
            int scale = ((Number)n2).intValue();
            Datum datum = Datum.intervalDaySecond((int)day, (int)hour, (int)minute, (int)second, (int)nanos, (int)precision, (int)scale);
            Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"intervalDaySecond(...)");
            return datum;
        }
        if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)3, (Object)4))) {
            Matcher matcher = INTERVAL_HOUR_MINUTE.matcher(input);
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
            Matcher matcher6 = matcher;
            if (!matcher6.matches()) {
                throw new IllegalStateException(("Invalid interval string: '" + input + '\'').toString());
            }
            String string = matcher6.group("h");
            Intrinsics.checkNotNull((Object)string);
            int hour = Integer.parseInt(string);
            String string10 = matcher6.group("m");
            Intrinsics.checkNotNull((Object)string10);
            int minute = Integer.parseInt(string10);
            Integer n = qualifier.getStartFieldPrecision();
            if (n == null) {
                n = 2;
            }
            int precision = ((Number)n).intValue();
            Datum datum = Datum.intervalHourMinute((int)hour, (int)minute, (int)precision);
            Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"intervalHourMinute(...)");
            return datum;
        }
        if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)3, (Object)5))) {
            Matcher matcher = INTERVAL_HOUR_SECOND.matcher(input);
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
            Matcher matcher7 = matcher;
            if (!matcher7.matches()) {
                throw new IllegalStateException(("Invalid interval string: '" + input + '\'').toString());
            }
            String string = matcher7.group("h");
            Intrinsics.checkNotNull((Object)string);
            int hour = Integer.parseInt(string);
            String string11 = matcher7.group("m");
            Intrinsics.checkNotNull((Object)string11);
            int minute = Integer.parseInt(string11);
            String string12 = matcher7.group("s1");
            Intrinsics.checkNotNull((Object)string12);
            int second = Integer.parseInt(string12);
            String string13 = matcher7.group("s2");
            int nanos = string13 != null ? this.getNanosFromFractionalSeconds(string13) : 0;
            Integer n = qualifier.getStartFieldPrecision();
            if (n == null) {
                n = 2;
            }
            int precision = ((Number)n).intValue();
            Integer n3 = qualifier.getEndFieldFractionalPrecision();
            if (n3 == null) {
                n3 = 6;
            }
            int scale = ((Number)n3).intValue();
            Datum datum = Datum.intervalHourSecond((int)hour, (int)minute, (int)second, (int)nanos, (int)precision, (int)scale);
            Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"intervalHourSecond(...)");
            return datum;
        }
        if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)4, (Object)5))) {
            Matcher matcher = INTERVAL_MINUTE_SECOND.matcher(input);
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
            Matcher matcher8 = matcher;
            if (!matcher8.matches()) {
                throw new IllegalStateException(("Invalid interval string: '" + input + '\'').toString());
            }
            String string = matcher8.group("m");
            Intrinsics.checkNotNull((Object)string);
            int minute = Integer.parseInt(string);
            String string14 = matcher8.group("s1");
            Intrinsics.checkNotNull((Object)string14);
            int second = Integer.parseInt(string14);
            String string15 = matcher8.group("s2");
            int nanos = string15 != null ? this.getNanosFromFractionalSeconds(string15) : 0;
            Integer n = qualifier.getStartFieldPrecision();
            if (n == null) {
                n = 2;
            }
            int precision = ((Number)n).intValue();
            Integer n4 = qualifier.getEndFieldFractionalPrecision();
            if (n4 == null) {
                n4 = 6;
            }
            int scale = ((Number)n4).intValue();
            Datum datum = Datum.intervalMinuteSecond((int)minute, (int)second, (int)nanos, (int)precision, (int)scale);
            Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"intervalMinuteSecond(...)");
            return datum;
        }
        throw new IllegalStateException(("Not a valid interval range: " + qualifier.getStartField() + " TO " + qualifier.getEndField() + '.').toString());
    }

    private final void assertNullFractionalSeconds(Integer fractionalSeconds, DatetimeField field) {
        if (fractionalSeconds != null) {
            throw new IllegalStateException((field + " does not support fractional seconds.").toString());
        }
    }

    private final int getNanosFromFractionalSeconds(String $this$getNanosFromFractionalSeconds) {
        int digits = 9;
        if ($this$getNanosFromFractionalSeconds.length() > digits) {
            throw new IllegalStateException("Fractional seconds cannot be more than 9 digits.".toString());
        }
        BigDecimal fractionalSecondsBigDecimal = new BigDecimal("0." + $this$getNanosFromFractionalSeconds);
        BigDecimal newBigDecimal = fractionalSecondsBigDecimal.movePointRight(digits);
        int intBigDecimal = newBigDecimal.intValue();
        return intBigDecimal;
    }
}

