/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.catalog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002#$B\u001d\b\u0002\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\b\u001a\u00020\u00002\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0004\"\u00020\u0002\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\u001a\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0002\u0018\u00010\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\u0002J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015J\u0011\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\rJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0096\u0002J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\rJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!H\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006%"}, d2={"Lorg/partiql/spi/catalog/Identifier;", "", "Lorg/partiql/spi/catalog/Identifier$Simple;", "qualifier", "", "identifier", "([Lorg/partiql/spi/catalog/Identifier$Simple;Lorg/partiql/spi/catalog/Identifier$Simple;)V", "[Lorg/partiql/spi/catalog/Identifier$Simple;", "append", "parts", "([Lorg/partiql/spi/catalog/Identifier$Simple;)Lorg/partiql/spi/catalog/Identifier;", "other", "equals", "", "", "forEach", "", "action", "Ljava/util/function/Consumer;", "getIdentifier", "getParts", "", "getQualifier", "()[Lorg/partiql/spi/catalog/Identifier$Simple;", "hasQualifier", "hashCode", "", "iterator", "", "matches", "", "ignoreCase", "spliterator", "Ljava/util/Spliterator;", "toString", "Companion", "Simple", "partiql-spi"})
public final class Identifier
implements Iterable<Simple>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Simple[] qualifier;
    @NotNull
    private final Simple identifier;

    private Identifier(Simple[] qualifier, Simple identifier) {
        this.qualifier = qualifier;
        this.identifier = identifier;
    }

    @NotNull
    public final Simple getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public final Simple[] getQualifier() {
        return this.qualifier;
    }

    public final boolean hasQualifier() {
        return !(this.qualifier.length == 0);
    }

    @NotNull
    public final List<Simple> getParts() {
        Simple[] simpleArray = this.qualifier;
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])Arrays.copyOf(simpleArray, simpleArray.length)), (Object)this.identifier);
    }

    @Override
    public void forEach(@Nullable Consumer<? super Simple> action) {
        this.getParts().forEach(action);
    }

    @Override
    @NotNull
    public Iterator<Simple> iterator() {
        return this.getParts().iterator();
    }

    @Override
    @NotNull
    public Spliterator<Simple> spliterator() {
        Spliterator<Simple> spliterator = this.getParts().spliterator();
        Intrinsics.checkNotNullExpressionValue(spliterator, (String)"spliterator(...)");
        return spliterator;
    }

    @NotNull
    public final Identifier append(@NotNull Identifier other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Companion.of(CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)this), (Iterable)CollectionsKt.toList((Iterable)other)));
    }

    @NotNull
    public final Identifier append(Simple ... parts) {
        Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
        return Companion.of(CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)this), (Object[])parts));
    }

    public final boolean matches(@NotNull String other, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.hasQualifier()) {
            return false;
        }
        return ignoreCase ? this.identifier.matches(other) : Intrinsics.areEqual((Object)other, (Object)this.identifier.getText());
    }

    public static /* synthetic */ boolean matches$default(Identifier identifier, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return identifier.matches(string, bl);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        Identifier cfr_ignored_0 = (Identifier)other;
        return Intrinsics.areEqual((Object)this.identifier, (Object)((Identifier)other).identifier) && Arrays.equals(this.qualifier, ((Identifier)other).qualifier);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.qualifier.hashCode();
        result = 31 * result + this.identifier.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!(this.qualifier.length == 0)) {
            $this$toString_u24lambda_u240.append(ArraysKt.joinToString$default((Object[])this.qualifier, (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
            $this$toString_u24lambda_u240.append(".");
        }
        $this$toString_u24lambda_u240.append(this.identifier);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final Identifier regular(@NotNull String text) {
        return Companion.regular(text);
    }

    @JvmStatic
    @NotNull
    public static final Identifier regular(String ... parts) {
        return Companion.regular(parts);
    }

    @JvmStatic
    @NotNull
    public static final Identifier regular(@NotNull List<String> parts) {
        return Companion.regular(parts);
    }

    @JvmStatic
    @NotNull
    public static final Identifier delimited(@NotNull String text) {
        return Companion.delimited(text);
    }

    @JvmStatic
    @NotNull
    public static final Identifier delimited(String ... parts) {
        return Companion.delimited(parts);
    }

    @JvmStatic
    @NotNull
    public static final Identifier delimited(@NotNull List<String> parts) {
        return Companion.delimited(parts);
    }

    @JvmStatic
    @NotNull
    public static final Identifier of(Simple ... parts) {
        return Companion.of(parts);
    }

    @JvmStatic
    @NotNull
    public static final Identifier of(@NotNull List<Simple> parts) {
        return Companion.of(parts);
    }

    public /* synthetic */ Identifier(Simple[] qualifier, Simple identifier, DefaultConstructorMarker $constructor_marker) {
        this(qualifier, identifier);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0007H\u0007J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0007J!\u0010\u000b\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0006\"\u00020\fH\u0007\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\f0\nH\u0007J!\u0010\u000e\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0007H\u0007J\u0016\u0010\u000e\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0007\u00a8\u0006\u000f"}, d2={"Lorg/partiql/spi/catalog/Identifier$Companion;", "", "()V", "delimited", "Lorg/partiql/spi/catalog/Identifier;", "parts", "", "", "([Ljava/lang/String;)Lorg/partiql/spi/catalog/Identifier;", "text", "", "of", "Lorg/partiql/spi/catalog/Identifier$Simple;", "([Lorg/partiql/spi/catalog/Identifier$Simple;)Lorg/partiql/spi/catalog/Identifier;", "regular", "partiql-spi"})
    @SourceDebugExtension(value={"SMAP\nIdentifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Identifier.kt\norg/partiql/spi/catalog/Identifier$Companion\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,238:1\n26#2:239\n26#2:246\n1549#3:240\n1620#3,3:241\n1549#3:247\n1620#3,3:248\n37#4,2:244\n37#4,2:251\n37#4,2:253\n*S KotlinDebug\n*F\n+ 1 Identifier.kt\norg/partiql/spi/catalog/Identifier$Companion\n*L\n193#1:239\n209#1:246\n203#1:240\n203#1:241,3\n219#1:247\n219#1:248,3\n203#1:244,2\n219#1:251,2\n232#1:253,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Identifier regular(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            boolean $i$f$emptyArray = false;
            return new Identifier(new Simple[0], Simple.Companion.regular(text), null);
        }

        @JvmStatic
        @NotNull
        public final Identifier regular(String ... parts) {
            Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
            return this.regular(ArraysKt.toList((Object[])parts));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Identifier regular(@NotNull List<String> parts) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(parts, (String)"parts");
            if (parts.isEmpty()) {
                throw new IllegalStateException("Cannot create an identifier with no parts".toString());
            }
            Iterable $this$map$iv = CollectionsKt.take((Iterable)parts, (int)(parts.size() - 1));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Simple.Companion.regular((String)it));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Simple[] qualifier = thisCollection$iv.toArray(new Simple[0]);
            Simple identifier = Simple.Companion.regular((String)CollectionsKt.last(parts));
            return new Identifier(qualifier, identifier, null);
        }

        @JvmStatic
        @NotNull
        public final Identifier delimited(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            boolean $i$f$emptyArray = false;
            return new Identifier(new Simple[0], Simple.Companion.delimited(text), null);
        }

        @JvmStatic
        @NotNull
        public final Identifier delimited(String ... parts) {
            Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
            return this.delimited(ArraysKt.toList((Object[])parts));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Identifier delimited(@NotNull List<String> parts) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(parts, (String)"parts");
            if (parts.isEmpty()) {
                throw new IllegalStateException("Cannot create an identifier with no parts".toString());
            }
            Iterable $this$map$iv = CollectionsKt.take((Iterable)parts, (int)(parts.size() - 1));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Simple.Companion.delimited((String)it));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Simple[] qualifier = thisCollection$iv.toArray(new Simple[0]);
            Simple identifier = Simple.Companion.delimited((String)CollectionsKt.last(parts));
            return new Identifier(qualifier, identifier, null);
        }

        @JvmStatic
        @NotNull
        public final Identifier of(Simple ... parts) {
            Intrinsics.checkNotNullParameter((Object)parts, (String)"parts");
            return this.of(ArraysKt.toList((Object[])parts));
        }

        @JvmStatic
        @NotNull
        public final Identifier of(@NotNull List<Simple> parts) {
            Intrinsics.checkNotNullParameter(parts, (String)"parts");
            if (parts.isEmpty()) {
                throw new IllegalStateException("Cannot create an identifier with no parts".toString());
            }
            Collection $this$toTypedArray$iv = CollectionsKt.take((Iterable)parts, (int)(parts.size() - 1));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Simple[] qualifier = thisCollection$iv.toArray(new Simple[0]);
            Simple identifier = (Simple)CollectionsKt.last(parts);
            return new Identifier(qualifier, identifier, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0007\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\t\u001a\u00020\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0003J\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/partiql/spi/catalog/Identifier$Simple;", "", "text", "", "regular", "", "(Ljava/lang/String;Z)V", "equals", "other", "getText", "hashCode", "", "isRegular", "matches", "toString", "Companion", "partiql-spi"})
    public static final class Simple {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String text;
        private final boolean regular;

        private Simple(String text, boolean regular) {
            this.text = text;
            this.regular = regular;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final boolean isRegular() {
            return this.regular;
        }

        public final boolean matches(@NotNull String other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return StringsKt.equals((String)this.text, (String)other, (boolean)this.regular);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.text, (Object)((Simple)other).text);
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        @NotNull
        public String toString() {
            String string;
            boolean bl = this.regular;
            if (bl) {
                string = this.text;
            } else if (!bl) {
                string = '\"' + this.text + '\"';
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        @JvmStatic
        @NotNull
        public static final Simple regular(@NotNull String text) {
            return Companion.regular(text);
        }

        @JvmStatic
        @NotNull
        public static final Simple delimited(@NotNull String text) {
            return Companion.delimited(text);
        }

        public /* synthetic */ Simple(String text, boolean regular, DefaultConstructorMarker $constructor_marker) {
            this(text, regular);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lorg/partiql/spi/catalog/Identifier$Simple$Companion;", "", "()V", "delimited", "Lorg/partiql/spi/catalog/Identifier$Simple;", "text", "", "regular", "partiql-spi"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Simple regular(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return new Simple(text, true, null);
            }

            @JvmStatic
            @NotNull
            public final Simple delimited(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return new Simple(text, false, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

