/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.catalog;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.spi.catalog.Catalog;
import org.partiql.spi.catalog.Catalogs;
import org.partiql.spi.catalog.Namespace;
import org.partiql.spi.catalog.Path;
import org.partiql.spi.catalog.System;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\bf\u0018\u0000 \u000e2\u00020\u0001:\u0002\r\u000eJ\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&J\b\u0010\u0007\u001a\u00020\bH&J\b\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\fH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/partiql/spi/catalog/Session;", "", "getCatalog", "", "getCatalogs", "Lorg/partiql/spi/catalog/Catalogs;", "getIdentity", "getNamespace", "Lorg/partiql/spi/catalog/Namespace;", "getPath", "Lorg/partiql/spi/catalog/Path;", "getProperties", "", "Builder", "Companion", "partiql-spi"})
public interface Session {
    @NotNull
    public static final Companion Companion = org.partiql.spi.catalog.Session$Companion.$$INSTANCE;

    @NotNull
    public String getIdentity();

    @NotNull
    public String getCatalog();

    @NotNull
    public Catalogs getCatalogs();

    @NotNull
    public Namespace getNamespace();

    @NotNull
    public Path getPath();

    @NotNull
    public Map<String, String> getProperties();

    @JvmStatic
    @NotNull
    public static Session empty() {
        return Companion.empty();
    }

    @JvmStatic
    @NotNull
    public static Builder builder() {
        return Companion.builder();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u001f\u0010\u0005\u001a\u00020\u00002\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0010\"\u00020\r\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0004J\u001f\u0010\b\u001a\u00020\u00002\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0010\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\b\u001a\u00020\u00002\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\rR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/partiql/spi/catalog/Session$Builder;", "", "()V", "catalog", "", "catalogs", "Lorg/partiql/spi/catalog/Catalogs$Builder;", "identity", "namespace", "Lorg/partiql/spi/catalog/Namespace;", "properties", "", "system", "Lorg/partiql/spi/catalog/Catalog;", "build", "Lorg/partiql/spi/catalog/Session;", "", "([Lorg/partiql/spi/catalog/Catalog;)Lorg/partiql/spi/catalog/Session$Builder;", "levels", "([Ljava/lang/String;)Lorg/partiql/spi/catalog/Session$Builder;", "", "property", "name", "value", "partiql-spi"})
    public static final class Builder {
        @NotNull
        private String identity = "unknown";
        @Nullable
        private String catalog;
        @NotNull
        private Catalog system;
        @NotNull
        private Catalogs.Builder catalogs;
        @NotNull
        private Namespace namespace;
        @NotNull
        private Map<String, String> properties;

        public Builder() {
            System system = System.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)system, (String)"INSTANCE");
            this.system = system;
            this.catalogs = Catalogs.Companion.builder();
            this.namespace = Namespace.Companion.empty();
            this.properties = new LinkedHashMap();
        }

        @NotNull
        public final Builder identity(@NotNull String identity) {
            Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
            this.identity = identity;
            return this;
        }

        @NotNull
        public final Builder catalog(@Nullable String catalog) {
            this.catalog = catalog;
            return this;
        }

        @NotNull
        public final Builder namespace(@NotNull Namespace namespace) {
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            this.namespace = namespace;
            return this;
        }

        @NotNull
        public final Builder namespace(String ... levels) {
            Intrinsics.checkNotNullParameter((Object)levels, (String)"levels");
            this.namespace = Namespace.Companion.of(Arrays.copyOf(levels, levels.length));
            return this;
        }

        @NotNull
        public final Builder namespace(@NotNull List<String> levels) {
            Intrinsics.checkNotNullParameter(levels, (String)"levels");
            this.namespace = Namespace.Companion.of(levels);
            return this;
        }

        @NotNull
        public final Builder property(@NotNull String name, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.properties.put(name, value);
            return this;
        }

        @NotNull
        public final Builder system(@NotNull Catalog catalog) {
            Intrinsics.checkNotNullParameter((Object)catalog, (String)"catalog");
            this.system = catalog;
            return this;
        }

        @NotNull
        public final Builder catalogs(Catalog ... catalogs) {
            Intrinsics.checkNotNullParameter((Object)catalogs, (String)"catalogs");
            for (Catalog catalog : catalogs) {
                this.catalogs.add(catalog);
            }
            return this;
        }

        @NotNull
        public final Session build() {
            return new Session(this){
                @NotNull
                private final Catalogs _catalogs;
                @NotNull
                private final Namespace systemCatalogNamespace;
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = $receiver;
                    String[] stringArray = new String[]{Builder.access$getSystem$p($receiver).getName()};
                    this.systemCatalogNamespace = Namespace.Companion.of(stringArray);
                    if (!(Builder.access$getCatalog$p($receiver) != null)) {
                        boolean bl = false;
                        String string = "Session catalog must be set";
                        throw new IllegalArgumentException(string.toString());
                    }
                    Builder.access$getCatalogs$p($receiver).add(Builder.access$getSystem$p($receiver));
                    this._catalogs = Builder.access$getCatalogs$p($receiver).build();
                }

                @NotNull
                public String getIdentity() {
                    return Builder.access$getIdentity$p(this.this$0);
                }

                @NotNull
                public String getCatalog() {
                    String string = Builder.access$getCatalog$p(this.this$0);
                    Intrinsics.checkNotNull((Object)string);
                    return string;
                }

                @NotNull
                public Catalogs getCatalogs() {
                    return this._catalogs;
                }

                @NotNull
                public Namespace getNamespace() {
                    return Builder.access$getNamespace$p(this.this$0);
                }

                @NotNull
                public Path getPath() {
                    Namespace[] namespaceArray = new SpreadBuilder(2);
                    namespaceArray.add((Object)this.getCatalog());
                    namespaceArray.addSpread((Object)this.getNamespace().getLevels());
                    Namespace currentNamespace = Namespace.Companion.of((String[])namespaceArray.toArray((Object[])new String[namespaceArray.size()]));
                    namespaceArray = new Namespace[]{currentNamespace, this.systemCatalogNamespace};
                    return Path.Companion.of(namespaceArray);
                }

                @NotNull
                public Map<String, String> getProperties() {
                    return Builder.access$getProperties$p(this.this$0);
                }
            };
        }

        public static final /* synthetic */ Catalog access$getSystem$p(Builder $this) {
            return $this.system;
        }

        public static final /* synthetic */ String access$getCatalog$p(Builder $this) {
            return $this.catalog;
        }

        public static final /* synthetic */ Catalogs.Builder access$getCatalogs$p(Builder $this) {
            return $this.catalogs;
        }

        public static final /* synthetic */ String access$getIdentity$p(Builder $this) {
            return $this.identity;
        }

        public static final /* synthetic */ Namespace access$getNamespace$p(Builder $this) {
            return $this.namespace;
        }

        public static final /* synthetic */ Map access$getProperties$p(Builder $this) {
            return $this.properties;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/partiql/spi/catalog/Session$Companion;", "", "()V", "builder", "Lorg/partiql/spi/catalog/Session$Builder;", "empty", "Lorg/partiql/spi/catalog/Session;", "partiql-spi"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Session empty() {
            return this.builder().catalog(System.INSTANCE.getName()).catalogs(new Catalog[0]).build();
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Path getPath(@NotNull Session $this) {
            Namespace[] namespaceArray = new Namespace[1];
            String[] stringArray = new String[]{$this.getCatalog()};
            Namespace namespace = Namespace.Companion.of(stringArray);
            stringArray = $this.getNamespace().getLevels();
            namespaceArray[0] = namespace.append(Arrays.copyOf(stringArray, stringArray.length));
            return Path.Companion.of(namespaceArray);
        }

        @NotNull
        public static Map<String, String> getProperties(@NotNull Session $this) {
            return MapsKt.emptyMap();
        }
    }
}

