/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.catalog.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.spi.catalog.Catalog;
import org.partiql.spi.catalog.Identifier;
import org.partiql.spi.catalog.Name;
import org.partiql.spi.catalog.Session;
import org.partiql.spi.catalog.Table;
import org.partiql.spi.function.AggOverload;
import org.partiql.spi.function.FnOverload;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0003H\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0006H\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/partiql/spi/catalog/impl/StandardCatalog;", "Lorg/partiql/spi/catalog/Catalog;", "name", "", "tables", "", "Lorg/partiql/spi/catalog/Name;", "Lorg/partiql/spi/catalog/Table;", "(Ljava/lang/String;Ljava/util/Map;)V", "getName", "getTable", "session", "Lorg/partiql/spi/catalog/Session;", "resolveTable", "identifier", "Lorg/partiql/spi/catalog/Identifier;", "partiql-spi"})
public final class StandardCatalog
implements Catalog {
    @NotNull
    private final String name;
    @NotNull
    private final Map<Name, Table> tables;

    public StandardCatalog(@NotNull String name, @NotNull Map<Name, ? extends Table> tables) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        this.name = name;
        this.tables = tables;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Table getTable(@NotNull Session session, @NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (name.hasNamespace()) {
            throw new IllegalStateException("This catalog does not support namespaces".toString());
        }
        return this.tables.get(name);
    }

    @Override
    @Nullable
    public Name resolveTable(@NotNull Session session, @NotNull Identifier identifier) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Identifier.Simple first = (Identifier.Simple)CollectionsKt.first((Iterable)identifier);
        Iterator<Map.Entry<Name, Table>> iterator = this.tables.entrySet().iterator();
        while (iterator.hasNext()) {
            Name name = iterator.next().getKey();
            String str = name.getName();
            if (!first.matches(str)) continue;
            return name;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<FnOverload> getFunctions(@NotNull Session session, @NotNull String name) {
        return Catalog.DefaultImpls.getFunctions(this, session, name);
    }

    @Override
    @NotNull
    public Collection<AggOverload> getAggregations(@NotNull Session session, @NotNull String name) {
        return Catalog.DefaultImpls.getAggregations(this, session, name);
    }
}

