/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.errors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.spi.Enum;
import org.partiql.spi.SourceLocation;
import org.partiql.spi.UnsupportedCodeException;
import org.partiql.spi.errors.PErrorKind;
import org.partiql.spi.errors.Severity;

public final class PError
extends Enum {
    @NotNull
    public PErrorKind kind;
    @NotNull
    public Severity severity;
    @Nullable
    public SourceLocation location;
    @NotNull
    private final Map<String, Object> properties;
    public static final int INTERNAL_ERROR = 1;
    public static final int UNRECOGNIZED_TOKEN = 2;
    public static final int UNEXPECTED_TOKEN = 3;
    public static final int PATH_KEY_NEVER_SUCCEEDS = 4;
    public static final int PATH_SYMBOL_NEVER_SUCCEEDS = 5;
    public static final int PATH_INDEX_NEVER_SUCCEEDS = 6;
    public static final int FEATURE_NOT_SUPPORTED = 7;
    public static final int UNDEFINED_CAST = 8;
    public static final int FUNCTION_NOT_FOUND = 9;
    public static final int FUNCTION_TYPE_MISMATCH = 10;
    public static final int VAR_REF_NOT_FOUND = 11;
    public static final int VAR_REF_AMBIGUOUS = 12;
    public static final int TYPE_UNEXPECTED = 13;
    public static final int ALWAYS_MISSING = 14;
    public static final int INVALID_EXCLUDE_PATH = 15;
    public static final int CARDINALITY_VIOLATION = 16;
    public static final int NUMERIC_VALUE_OUT_OF_RANGE = 17;
    public static final int INVALID_CHAR_VALUE_FOR_CAST = 18;
    public static final int DIVISION_BY_ZERO = 19;
    public static final int DEGREE_VIOLATION_SCALAR_SUBQUERY = 20;

    public PError(int code, @NotNull Severity severity, @NotNull PErrorKind kind, @Nullable SourceLocation location, @Nullable Map<String, Object> properties) {
        super(code);
        this.kind = kind;
        this.severity = severity;
        this.location = location;
        this.properties = properties != null ? properties : new HashMap<String, Object>();
    }

    @Nullable
    public <T> T get(@NotNull String key, @NotNull Class<T> clazz) throws ClassCastException {
        Object value = this.properties.get(key);
        if (value == null) {
            return null;
        }
        return clazz.cast(value);
    }

    @Nullable
    public <T> List<T> getList(@NotNull String key, @NotNull Class<T> clazz) throws ClassCastException {
        List values = this.get(key, List.class);
        if (values == null) {
            return null;
        }
        return values.stream().map(clazz::cast).collect(Collectors.toList());
    }

    @Nullable
    public <T> List<T> getListOrNull(@NotNull String key, @NotNull Class<T> clazz) {
        try {
            return this.getList(key, clazz);
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    @Nullable
    public <T> T getOrNull(@NotNull String key, @NotNull Class<T> clazz) {
        try {
            return this.get(key, clazz);
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    @Override
    @NotNull
    public String name() throws UnsupportedCodeException {
        int code = this.code();
        switch (code) {
            case 1: {
                return "INTERNAL_ERROR";
            }
            case 2: {
                return "UNRECOGNIZED_TOKEN";
            }
            case 3: {
                return "UNEXPECTED_TOKEN";
            }
            case 4: {
                return "PATH_KEY_NEVER_SUCCEEDS";
            }
            case 5: {
                return "PATH_SYMBOL_NEVER_SUCCEEDS";
            }
            case 6: {
                return "PATH_INDEX_NEVER_SUCCEEDS";
            }
            case 7: {
                return "FEATURE_NOT_SUPPORTED";
            }
            case 8: {
                return "UNDEFINED_CAST";
            }
            case 9: {
                return "FUNCTION_NOT_FOUND";
            }
            case 10: {
                return "FUNCTION_TYPE_MISMATCH";
            }
            case 11: {
                return "VAR_REF_NOT_FOUND";
            }
            case 12: {
                return "VAR_REF_AMBIGUOUS";
            }
            case 13: {
                return "TYPE_UNEXPECTED";
            }
            case 14: {
                return "ALWAYS_MISSING";
            }
            case 15: {
                return "INVALID_EXCLUDE_PATH";
            }
            case 16: {
                return "CARDINALITY_VIOLATION";
            }
            case 17: {
                return "NUMERIC_VALUE_OUT_OF_RANGE";
            }
            case 18: {
                return "INVALID_CHAR_VALUE_FOR_CAST";
            }
            case 19: {
                return "DIVISION_BY_ZERO";
            }
            case 20: {
                return "DEGREE_VIOLATION_SCALAR_SUBQUERY";
            }
        }
        throw new UnsupportedCodeException(code);
    }

    @Override
    public String toString() {
        String name;
        try {
            name = this.name();
        }
        catch (UnsupportedCodeException e) {
            name = String.valueOf(this.code());
        }
        return "PError{code=" + name + ", severity=" + this.severity + ", kind=" + this.kind + ", location=" + this.location + ", properties=" + this.properties + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PError)) {
            return false;
        }
        PError pError = (PError)o;
        return Objects.equals(this.kind, pError.kind) && Objects.equals(this.severity, pError.severity) && Objects.equals(this.location, pError.location) && Objects.equals(this.properties, pError.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.kind, this.severity, this.location, this.properties);
    }

    public static PError INTERNAL_ERROR(@NotNull PErrorKind kind, @Nullable SourceLocation location, final @Nullable Throwable cause) {
        return new PError(1, Severity.ERROR(), kind, location, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("CAUSE", cause);
            }
        });
    }
}

