/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.errors;

import org.jetbrains.annotations.NotNull;
import org.partiql.spi.errors.PError;
import org.partiql.spi.errors.PRuntimeException;

public interface PErrorListener {
    public void report(@NotNull PError var1) throws PRuntimeException;

    @NotNull
    public static PErrorListener abortOnError() {
        return error -> {
            if (error.severity.code() == 1) {
                throw new PRuntimeException(error);
            }
        };
    }

    @NotNull
    public static PErrorListener chain(final PErrorListener ... listeners) {
        return new PErrorListener(){

            @Override
            public void report(@NotNull PError error) throws PRuntimeException {
                for (PErrorListener listener : listeners) {
                    listener.report(error);
                }
            }
        };
    }
}

