/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.function;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.spi.function.Accumulator;
import org.partiql.spi.function.Agg;
import org.partiql.spi.function.Parameter;
import org.partiql.spi.function.RoutineOverloadSignature;
import org.partiql.spi.function.RoutineSignature;
import org.partiql.spi.types.PType;

public abstract class AggOverload {
    @NotNull
    public abstract RoutineOverloadSignature getSignature();

    @Nullable
    public abstract Agg getInstance(PType[] var1);

    private static class AggImpl
    extends Agg {
        @NotNull
        private final Callable<Accumulator> accumulator;
        @NotNull
        private final RoutineSignature signature;

        public AggImpl(@NotNull Callable<Accumulator> accumulator, @NotNull RoutineSignature signature) {
            this.accumulator = accumulator;
            this.signature = signature;
        }

        @Override
        @NotNull
        public Accumulator getAccumulator() {
            try {
                return this.accumulator.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        @NotNull
        public RoutineSignature getSignature() {
            return this.signature;
        }
    }

    private static class AggOverloadImpl
    extends AggOverload {
        @NotNull
        private final RoutineOverloadSignature signature;
        @NotNull
        private final Agg instance;

        public AggOverloadImpl(@NotNull RoutineOverloadSignature signature, @NotNull Agg instance) {
            this.signature = signature;
            this.instance = instance;
        }

        @Override
        @NotNull
        public RoutineOverloadSignature getSignature() {
            return this.signature;
        }

        @Override
        @Nullable
        public Agg getInstance(PType[] args) {
            return this.instance;
        }
    }

    public static final class Builder {
        @NotNull
        private final String name;
        @NotNull
        private final List<Parameter> parameters = new ArrayList<Parameter>();
        @NotNull
        private PType returns = PType.dynamic();
        @NotNull
        private Callable<Accumulator> body = () -> null;

        public Builder(@NotNull String name) {
            this.name = name;
        }

        @NotNull
        public Builder addParameter(@NotNull PType type) {
            this.parameters.add(new Parameter("arg" + this.parameters.size(), type));
            return this;
        }

        @NotNull
        public Builder addParameters(PType ... types) {
            for (PType type : types) {
                this.addParameter(type);
            }
            return this;
        }

        @NotNull
        public Builder returns(@NotNull PType type) {
            this.returns = type;
            return this;
        }

        @NotNull
        public Builder body(@NotNull Callable<Accumulator> body) {
            this.body = body;
            return this;
        }

        @NotNull
        public AggOverload build() {
            List<PType> parameterTypes = this.parameters.stream().map(Parameter::getType).collect(Collectors.toList());
            RoutineOverloadSignature signature = new RoutineOverloadSignature(this.name, parameterTypes);
            RoutineSignature routineSignature = new RoutineSignature(this.name, this.parameters, this.returns);
            AggImpl instance = new AggImpl(this.body, routineSignature);
            return new AggOverloadImpl(signature, instance);
        }
    }
}

